/*
 * Decompiled with CFR 0.152.
 */
package com.mobgame;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.AppOpsManager;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.provider.Settings;
import android.util.Log;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import com.mobgame.MobGameSDK;
import com.mobgame.R;
import com.mobgame.gui.float18button.NotiOverlayView;
import com.mobgame.gui.floatbutton.MobGameOverlayView;
import com.mobgame.model.Game;
import com.mobgame.model.NtfModel;
import com.mobgame.utils.FloatButtonTimerHelper;
import com.mobgame.utils.Res;
import com.mobgame.utils.Utils;
import java.util.ArrayList;

public class MobGameHelper {
    private static final String TAG = MobGameHelper.class.getSimpleName();
    private static Activity activity = MobGameSDK.activity;
    private static MobGameOverlayView floatButton;
    public static boolean didShowPermissionDialog;
    private static NotiOverlayView notiFloatButton;
    static boolean canDraw;
    static AppOpsManager.OnOpChangedListener onOpChangedListener;

    public static void initFloatButton() {
        Log.e((String)"TAG", (String)("Vao Day init : " + MobGameSDK.getInstance().isGrantedPermission((Context)activity)));
        try {
            if (MobGameSDK.getInstance().isGrantedPermission((Context)activity) && MobGameSDK.isValidationMode) {
                if (floatButton != null) {
                    floatButton.dismiss();
                }
                floatButton = new MobGameOverlayView(activity);
            } else if (!MobGameSDK.isValidationMode && MobGameHelper.checkDrawOverApps()) {
                if (floatButton != null) {
                    floatButton.dismiss();
                }
                floatButton = new MobGameOverlayView(activity);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void initFloatButtonIfNeeded() {
        Log.e((String)"TAG", (String)("Vao Day -1 : " + MobGameSDK.getInstance().isGrantedPermission((Context)activity)));
        if (MobGameHelper.checkDrawOverApps() && floatButton == null) {
            Log.e((String)"TAG", (String)"Vao Day 3");
            floatButton = new MobGameOverlayView(activity);
        }
    }

    public static void showNotiFloatButton(Game.Ex ex) {
        if (notiFloatButton == null) {
            notiFloatButton = new NotiOverlayView(activity, ex);
        }
        notiFloatButton.show();
        Log.e((String)"NotiButton", (String)"Showing");
    }

    public static void hideNotiFloatButton() {
        if (notiFloatButton != null && activity != null && notiFloatButton.isShowing()) {
            activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (notiFloatButton != null) {
                        notiFloatButton.hide();
                    }
                }
            });
        }
        Log.e((String)"NotiButton", (String)"Hiding");
    }

    static boolean isShowingNotiFloatButton() {
        if (notiFloatButton != null) {
            return notiFloatButton.isShowing();
        }
        return false;
    }

    public static void showFloatButton() {
        try {
            if (MobGameSDK.getInstance().isGrantedPermission((Context)activity) && MobGameSDK.isValidationMode) {
                activity.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        MobGameHelper.initFloatButtonIfNeeded();
                        if (!floatButton.isShowing() && !floatButton.isShowingConfirmDialog()) {
                            if (FloatButtonTimerHelper.isEnableFloatButtonTimer((Context)activity)) {
                                MobGameHelper.startFloatButtonTimer();
                            }
                            floatButton.show(FloatButtonTimerHelper.isRuningTimer());
                        }
                        if (floatButton.isShowing() && !floatButton.isShowingConfirmDialog() && FloatButtonTimerHelper.isEnableFloatButtonTimer((Context)activity)) {
                            MobGameHelper.startFloatButtonTimer();
                            floatButton.show(FloatButtonTimerHelper.isRuningTimer());
                        }
                    }
                });
            } else if (!MobGameSDK.isValidationMode && MobGameHelper.checkDrawOverApps()) {
                activity.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        MobGameHelper.initFloatButtonIfNeeded();
                        if (!floatButton.isShowing() && !floatButton.isShowingConfirmDialog()) {
                            if (FloatButtonTimerHelper.isEnableFloatButtonTimer((Context)activity)) {
                                MobGameHelper.startFloatButtonTimer();
                            }
                            floatButton.show(FloatButtonTimerHelper.isRuningTimer());
                        }
                        if (floatButton.isShowing() && !floatButton.isShowingConfirmDialog() && FloatButtonTimerHelper.isEnableFloatButtonTimer((Context)activity)) {
                            MobGameHelper.startFloatButtonTimer();
                            floatButton.show(FloatButtonTimerHelper.isRuningTimer());
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void showFloatButtonCenter() {
        try {
            Log.d((String)TAG, (String)"showFloatButtonCenter");
            if (!MobGameSDK.isValidationMode) {
                if (MobGameHelper.checkDrawOverApps()) {
                    if (floatButton == null) {
                        MobGameHelper.initFloatButtonIfNeeded();
                    }
                    floatButton.showFloatButtonToCenter();
                }
            } else if (MobGameSDK.getInstance().isGrantedPermission((Context)activity) && MobGameSDK.isValidationMode) {
                if (floatButton == null) {
                    MobGameHelper.initFloatButtonIfNeeded();
                }
                floatButton.showFloatButtonToCenter();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void hideFloatButton() {
        if (floatButton != null) {
            activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (floatButton != null && floatButton.isShowing()) {
                        floatButton.hide();
                    }
                }
            });
        }
    }

    public static void notifyFloatButton(ArrayList<NtfModel> listId, boolean isGCM) {
        MobGameHelper.initFloatButtonIfNeeded();
        if (floatButton != null) {
            if (isGCM) {
                floatButton.viberateGCM(listId);
            } else {
                floatButton.viberate(listId);
            }
        }
    }

    public static void showTimer() {
        if (floatButton == null) {
            return;
        }
        if (FloatButtonTimerHelper.canRunTimer()) {
            floatButton.startTimer();
        }
    }

    static void dismissFloatButton() {
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (floatButton != null) {
                    floatButton.dismiss();
                    floatButton = null;
                }
            }
        });
    }

    private static boolean checkDrawOverApps() {
        try {
            Log.e((String)"TAG", (String)("canDrawOverApp : " + Utils.canDrawOverApp(activity)));
            if (!Utils.canDrawOverApp(activity)) {
                if (!didShowPermissionDialog) {
                    AlertDialog.Builder builder = Build.VERSION.SDK_INT >= 21 ? new AlertDialog.Builder((Context)activity, 16974394) : new AlertDialog.Builder((Context)activity);
                    String appName = activity.getApplicationInfo().loadLabel(activity.getPackageManager()).toString();
                    builder.setTitle((CharSequence)Res.string((Context)activity, R.string.warning)).setMessage((CharSequence)String.format(Res.string((Context)activity, R.string.message_warning), appName)).setPositiveButton(17039379, new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            canDraw = Settings.canDrawOverlays((Context)activity);
                            Log.d((String)TAG, (String)("canDraw : " + canDraw));
                            if (Build.VERSION.SDK_INT >= 26) {
                                AppOpsManager opsManager = (AppOpsManager)activity.getSystemService("appops");
                                onOpChangedListener = new AppOpsManager.OnOpChangedListener(){

                                    public void onOpChanged(String op, String packageName) {
                                        PackageManager packageManager = activity.getPackageManager();
                                        String myPackageName = activity.getPackageName();
                                        if (myPackageName.equals(packageName) && "android:system_alert_window".equals(op)) {
                                            canDraw = true;
                                        }
                                    }
                                };
                                opsManager.startWatchingMode("android:system_alert_window", null, onOpChangedListener);
                            }
                            Intent intent = new Intent("android.settings.action.MANAGE_OVERLAY_PERMISSION", Uri.parse((String)("package:" + activity.getPackageName())));
                            activity.startActivityForResult(intent, 1234);
                            dialog.dismiss();
                        }
                    }).setIcon(MobGameHelper.activity.getApplicationInfo().icon).show();
                    didShowPermissionDialog = true;
                    return false;
                }
                return canDraw;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    static void startFloatButtonTimer() {
        if (floatButton == null) {
            return;
        }
        Log.d((String)"TAG", (String)"fuck");
        floatButton.startTimer();
    }

    public static boolean isShowingDashboard() {
        try {
            return floatButton.isShowingDashboard();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void hideKeyboard(Activity activity) {
        InputMethodManager imm = (InputMethodManager)activity.getSystemService("input_method");
        View view = activity.getCurrentFocus();
        if (view == null) {
            view = new View((Context)activity);
        }
        imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
    }

    public static void showDashboard() {
        if (floatButton == null) {
            MobGameHelper.initFloatButtonIfNeeded();
        } else if (!floatButton.isShowingDashboard()) {
            floatButton.showDashboard();
        }
    }

    public static void hideDashboard() {
        try {
            if (floatButton != null) {
                floatButton.hideDashboard();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        didShowPermissionDialog = false;
        onOpChangedListener = null;
    }
}

