package com.mobgame;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.AppOpsManager;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.provider.Settings;
import android.util.Log;
import android.view.View;
import android.view.inputmethod.InputMethodManager;

import com.mobgame.gui.float18button.NotiOverlayView;
import com.mobgame.gui.floatbutton.MobGameOverlayView;
import com.mobgame.model.Game;
import com.mobgame.model.NtfModel;
import com.mobgame.utils.FloatButtonTimerHelper;
import com.mobgame.utils.Res;
import com.mobgame.utils.Utils;

import java.util.ArrayList;

public class MobGameHelper {

	private final static String TAG = MobGameHelper.class.getSimpleName();
	private static Activity activity = MobGameSDK.activity;
	
	private static MobGameOverlayView floatButton;
	public static boolean didShowPermissionDialog = false;
	private static NotiOverlayView notiFloatButton;
	public static void initFloatButton() {
		Log.e("TAG" , "Vao Day init : " + MobGameSDK.getInstance().isGrantedPermission(activity));
		try {
			if (MobGameSDK.getInstance().isGrantedPermission(activity) && MobGameSDK.isValidationMode) {
				if (floatButton != null) {
					floatButton.dismiss();
				}
				floatButton = new MobGameOverlayView(activity);
			} else if (!MobGameSDK.isValidationMode) {
				if (checkDrawOverApps()) {
					if (floatButton != null) {
						floatButton.dismiss();
					}
					floatButton = new MobGameOverlayView(activity);
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}

	}
	
	public static void initFloatButtonIfNeeded() {
		Log.e("TAG" , "Vao Day -1 : " + MobGameSDK.getInstance().isGrantedPermission(activity));
		if (checkDrawOverApps()) {
//		if (MobGameSDK.getInstance().isGrantedPermission(activity)) {
			if (floatButton == null) {
				Log.e("TAG" , "Vao Day 3");
				floatButton = new MobGameOverlayView(activity);
			}
		}
	}

	public static void showNotiFloatButton(Game.Ex ex) {
		if (notiFloatButton == null) notiFloatButton = new NotiOverlayView(activity , ex);
		notiFloatButton.show();
		Log.e("NotiButton","Showing");
	}

	public static void hideNotiFloatButton() {
		if (notiFloatButton != null && activity!=null && notiFloatButton.isShowing()) {
			activity.runOnUiThread(new Runnable() {

				@Override
				public void run() {
					if (notiFloatButton != null) {
						notiFloatButton.hide();
					}
				}
			});
		}
		Log.e("NotiButton","Hiding");
	}

	static boolean isShowingNotiFloatButton() {
		if (notiFloatButton != null) return notiFloatButton.isShowing();
		return false;
	}

	public static void showFloatButton() {
		try{
			//if (checkDrawOverApps()) {
			if (MobGameSDK.getInstance().isGrantedPermission(activity) && MobGameSDK.isValidationMode) {
				activity.runOnUiThread(new Runnable() {

					@Override
					public void run() {
						initFloatButtonIfNeeded();
						if (!floatButton.isShowing()
								&&	!floatButton.isShowingConfirmDialog()) {
							if(FloatButtonTimerHelper.isEnableFloatButtonTimer(activity)){
								startFloatButtonTimer();
							}
							floatButton.show(FloatButtonTimerHelper.isRuningTimer());
						}
						if(floatButton.isShowing()
								&& !floatButton.isShowingConfirmDialog()){
							if(FloatButtonTimerHelper.isEnableFloatButtonTimer(activity)){
								startFloatButtonTimer();
								floatButton.show(FloatButtonTimerHelper.isRuningTimer());
							}
						}
					}
				});
			} else if (!MobGameSDK.isValidationMode) {
				if (checkDrawOverApps()) {
					activity.runOnUiThread(new Runnable() {

						@Override
						public void run() {
							initFloatButtonIfNeeded();
							if (!floatButton.isShowing()
									&&	!floatButton.isShowingConfirmDialog()) {
								if(FloatButtonTimerHelper.isEnableFloatButtonTimer(activity)){
									startFloatButtonTimer();
								}
								floatButton.show(FloatButtonTimerHelper.isRuningTimer());
							}
							if(floatButton.isShowing()
									&& !floatButton.isShowingConfirmDialog()){
								if(FloatButtonTimerHelper.isEnableFloatButtonTimer(activity)){
									startFloatButtonTimer();
									floatButton.show(FloatButtonTimerHelper.isRuningTimer());
								}
							}
						}
					});
				}
			}
		}catch (Exception e){
			e.printStackTrace();
		}
	}

	public static void showFloatButtonCenter(){
		try {
			Log.d(TAG , "showFloatButtonCenter");
			if (!MobGameSDK.isValidationMode) {
				if (checkDrawOverApps()) {
					if(floatButton==null){
						initFloatButtonIfNeeded();
					}
					floatButton.showFloatButtonToCenter();
				}
			} else if (MobGameSDK.getInstance().isGrantedPermission(activity) && MobGameSDK.isValidationMode) {
				if(floatButton==null){
					initFloatButtonIfNeeded();
				}
				floatButton.showFloatButtonToCenter();
			}
		}catch (Exception e){
			e.printStackTrace();
		}
	}

	public static void hideFloatButton() {
		if (floatButton != null) {
			activity.runOnUiThread(new Runnable() {
				
				@Override
				public void run() {
					if (floatButton != null && floatButton.isShowing()) {
						floatButton.hide();
					}
				}
			});
		}
	}

	public static void notifyFloatButton(ArrayList<NtfModel> listId , boolean isGCM) {
		initFloatButtonIfNeeded();
		if (floatButton != null) {
			if(isGCM){
				floatButton.viberateGCM(listId);
			}else{
				floatButton.viberate(listId);
			}
		}
	}

	public static void showTimer(){
		if(floatButton == null){
			return;
		}
		if(FloatButtonTimerHelper.canRunTimer()){
			floatButton.startTimer();
		}
	}

	static void dismissFloatButton() {
		activity.runOnUiThread(new Runnable() {
			
			@Override
			public void run() {
				if (floatButton != null) {
					floatButton.dismiss();
					floatButton = null;
				}
			}
		});
	}


	static boolean canDraw;
	static AppOpsManager.OnOpChangedListener onOpChangedListener = null;
	private static boolean checkDrawOverApps() {
		try {
			Log.e("TAG" , "canDrawOverApp : " + Utils.canDrawOverApp(activity));
			if (!Utils.canDrawOverApp(activity)) {
				if (!didShowPermissionDialog) {
					AlertDialog.Builder builder;
					if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
						builder = new AlertDialog.Builder(activity, android.R.style.Theme_Material_Light_Dialog_Alert);
					} else {
						builder = new AlertDialog.Builder(activity);
					}
					String appName = activity.getApplicationInfo().loadLabel(activity.getPackageManager()).toString();
					builder.setTitle(Res.string(activity , R.string.warning))
							.setMessage(String.format(Res.string(activity , R.string.message_warning), appName))
							.setPositiveButton(android.R.string.yes, new DialogInterface.OnClickListener() {
								public void onClick(DialogInterface dialog, int which) {

									canDraw = Settings.canDrawOverlays(activity);
									Log.d(TAG , "canDraw : " +  canDraw);
									if(Build.VERSION.SDK_INT >= Build.VERSION_CODES.O){
										AppOpsManager opsManager = (AppOpsManager) activity.getSystemService(Context.APP_OPS_SERVICE);
										onOpChangedListener = new AppOpsManager.OnOpChangedListener() {
											@Override
											public void onOpChanged(String op, String packageName) {
												PackageManager packageManager = activity.getPackageManager();
												String myPackageName = activity.getPackageName();
												if(myPackageName.equals(packageName) && AppOpsManager.OPSTR_SYSTEM_ALERT_WINDOW.equals(op)){
													canDraw = true;
												}
											}
										};
										opsManager.startWatchingMode(AppOpsManager.OPSTR_SYSTEM_ALERT_WINDOW , null , onOpChangedListener);
									}


									Intent intent = new Intent("android.settings.action.MANAGE_OVERLAY_PERMISSION", Uri.parse("package:"
											+ activity.getPackageName()));
									activity.startActivityForResult(intent, 1234);
									dialog.dismiss();
								}
							})
							.setIcon(activity.getApplicationInfo().icon)
							.show();
					didShowPermissionDialog = true;
					return false;
				}else{
					if(canDraw){
						return true;
					}else{
						return false;
					}
				}
			}





		}catch (Exception e){
			e.printStackTrace();
		}
		return true;
	}
	static void startFloatButtonTimer(){
		if(floatButton == null){
			return;
		}
		Log.d("TAG", "fuck");
		floatButton.startTimer();
	}

	public static boolean isShowingDashboard(){
		try{
			return floatButton.isShowingDashboard();
		}catch (Exception e){
			e.printStackTrace();
			return false;
		}
	}
	public static void hideKeyboard(Activity activity) {
		InputMethodManager imm = (InputMethodManager) activity.getSystemService(Activity.INPUT_METHOD_SERVICE);
		//Find the currently focused view, so we can grab the correct window token from it.
		View view = activity.getCurrentFocus();
		//If no view currently has focus, create a new one, just so we can grab a window token from it
		if (view == null) {
			view = new View(activity);
		}
		imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
	}

	public static void showDashboard(){
		if(floatButton==null){
			initFloatButtonIfNeeded();
		}else{
			if(!floatButton.isShowingDashboard()){
				floatButton.showDashboard();
			}
		}
	}

	public static void hideDashboard(){
		try {
			if(floatButton!=null){
				floatButton.hideDashboard();
			}
		}catch (Exception e){
			e.printStackTrace();
		}
	}
}
