/*
 * Decompiled with CFR 0.152.
 */
package com.mobgame.gui.dialog;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.DialogFragment;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.RequestOptions;
import com.mobgame.R;
import com.mobgame.gui.floatbutton.MobGameOverlayView;
import com.mobgame.utils.Preference;
import com.mobgame.utils.Res;

@SuppressLint(value={"ValidFragment"})
public class MobGameLogoutDialogWithPopup
extends DialogFragment {
    private static String TAG = MobGameOverlayView.class.getSimpleName();
    private String urlBanner;
    private String urlToOpen;
    Activity activity;
    EventListener eventListener;

    @SuppressLint(value={"ValidFragment"})
    public MobGameLogoutDialogWithPopup(Activity activity, String urlBanner, String urlToOpen, EventListener eventListener) {
        this.activity = activity;
        this.urlBanner = urlBanner;
        this.urlToOpen = urlToOpen;
        this.eventListener = eventListener;
        this.setStyle(1, 0x1030011);
        Preference.save((Context)activity, "shared_pref_show_dashboard", true);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.dialog_logout_popup, container, false);
        this.getDialog().getWindow().getDecorView().setBackgroundResource(17170445);
        this.getDialog().getWindow().setLayout(-1, -1);
        try {
            Button btnGiftcode = (Button)view.findViewById(R.id.btn_giftcode);
            Button btnFanpage = (Button)view.findViewById(R.id.btn_fanpage);
            Button btnLogout = (Button)view.findViewById(R.id.btn_logout);
            ImageButton btnClose = (ImageButton)view.findViewById(R.id.btn_close);
            ImageView ivBanner = (ImageView)view.findViewById(R.id.iv_banner);
            RelativeLayout mainView = (RelativeLayout)view.findViewById(R.id.layout_main_logout);
            if (!this.urlBanner.isEmpty()) {
                RequestOptions fitOptions = new RequestOptions().fitCenter();
                Glide.with((Activity)this.activity).load((Object)this.urlBanner).apply(fitOptions).into(ivBanner);
            }
            ivBanner.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (!MobGameLogoutDialogWithPopup.this.urlToOpen.isEmpty()) {
                        Intent browserIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)MobGameLogoutDialogWithPopup.this.urlToOpen));
                        MobGameLogoutDialogWithPopup.this.startActivity(browserIntent);
                    }
                }
            });
            btnFanpage.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (MobGameLogoutDialogWithPopup.this.eventListener != null) {
                        MobGameLogoutDialogWithPopup.this.eventListener.onFanpageClick(v);
                    }
                }
            });
            btnGiftcode.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (MobGameLogoutDialogWithPopup.this.eventListener != null) {
                        MobGameLogoutDialogWithPopup.this.eventListener.onGiftcodeClick(v);
                    }
                }
            });
            btnLogout.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (MobGameLogoutDialogWithPopup.this.eventListener != null) {
                        MobGameLogoutDialogWithPopup.this.eventListener.onLogoutClick(v);
                    }
                    MobGameLogoutDialogWithPopup.this.dismiss();
                }
            });
            mainView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (MobGameLogoutDialogWithPopup.this.eventListener != null) {
                        MobGameLogoutDialogWithPopup.this.eventListener.onDismiss();
                    }
                    MobGameLogoutDialogWithPopup.this.dismiss();
                }
            });
            btnClose.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    MobGameLogoutDialogWithPopup.this.dismiss();
                }
            });
            btnLogout.setText((CharSequence)Res.string((Context)this.activity, R.string.logout));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return view;
    }

    public void onDismiss(DialogInterface dialog) {
        super.onDismiss(dialog);
        if (this.eventListener != null) {
            this.eventListener.onDismiss();
        }
    }

    public void show() {
        try {
            this.show(this.activity.getFragmentManager(), TAG);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onSaveInstanceState(Bundle outState) {
    }

    public static interface EventListener {
        public void onLogoutClick(View var1);

        public void onFanpageClick(View var1);

        public void onGiftcodeClick(View var1);

        public void onDismiss();
    }
}

