/*
 * Decompiled with CFR 0.152.
 */
package com.mobgame.gui.dialog;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.DialogFragment;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.RequestOptions;
import com.mobgame.R;
import com.mobgame.gui.floatbutton.MobGameOverlayView;
import com.mobgame.utils.Preference;

@SuppressLint(value={"ValidFragment"})
public class MobGameConfirmDialogWithPopup
extends DialogFragment {
    private static String TAG = MobGameOverlayView.class.getSimpleName();
    private final String message;
    private final String strConfirm;
    private final String strCancel;
    private final String urlBanner;
    private final String urlToOpen;
    Activity activity;
    EventListener eventListener;

    @SuppressLint(value={"ValidFragment"})
    public MobGameConfirmDialogWithPopup(Activity activity, String urlBanner, String urlToOpen, String message, String strConfirm, String strCancel, EventListener eventListener) {
        this.activity = activity;
        this.urlBanner = urlBanner;
        this.urlToOpen = urlToOpen;
        this.message = message;
        this.strConfirm = strConfirm;
        this.strCancel = strCancel;
        this.eventListener = eventListener;
        this.setStyle(1, 0);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.confirm_dialog_popup, container, false);
        this.getDialog().getWindow().getDecorView().setBackgroundResource(17170445);
        try {
            Preference.save((Context)this.activity, "shared_pref_show_dashboard", true);
            TextView txtMessage = (TextView)view.findViewById(R.id.txt_message);
            Button btnConfirm = (Button)view.findViewById(R.id.btn_confirm);
            Button btnCancel = (Button)view.findViewById(R.id.btn_cancel);
            btnConfirm.setText((CharSequence)this.strConfirm);
            btnCancel.setText((CharSequence)this.strCancel);
            txtMessage.setText((CharSequence)this.message);
            ImageView ivBanner = (ImageView)view.findViewById(R.id.iv_banner);
            if (!this.urlBanner.isEmpty()) {
                RequestOptions fitOptions = new RequestOptions().fitCenter();
                Glide.with((Activity)this.activity).load((Object)this.urlBanner).apply(fitOptions).into(ivBanner);
            }
            ivBanner.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (!MobGameConfirmDialogWithPopup.this.urlToOpen.isEmpty()) {
                        Intent browserIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)MobGameConfirmDialogWithPopup.this.urlToOpen));
                        MobGameConfirmDialogWithPopup.this.startActivity(browserIntent);
                    }
                }
            });
            btnCancel.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    if (MobGameConfirmDialogWithPopup.this.eventListener != null) {
                        MobGameConfirmDialogWithPopup.this.eventListener.onCancelClick(view);
                    }
                    MobGameConfirmDialogWithPopup.this.dismiss();
                }
            });
            btnConfirm.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    if (MobGameConfirmDialogWithPopup.this.eventListener != null) {
                        MobGameConfirmDialogWithPopup.this.eventListener.onConfirmClick(view);
                    }
                    MobGameConfirmDialogWithPopup.this.dismiss();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return view;
    }

    public void onCancel(DialogInterface dialog) {
        if (this.eventListener != null) {
            this.eventListener.onCancelClick(null);
        }
    }

    public void show() {
        try {
            this.show(this.activity.getFragmentManager(), TAG);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onSaveInstanceState(Bundle outState) {
    }

    public static interface EventListener {
        public void onCancelClick(View var1);

        public void onConfirmClick(View var1);
    }
}

