/*
 * Decompiled with CFR 0.152.
 */
package com.zing.zalo.zalosdk.core.log;

import android.annotation.SuppressLint;
import android.os.Environment;
import com.zing.zalo.zalosdk.core.helper.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Locale;
import javax.crypto.Cipher;

public class Log {
    private static final String LOG_TAG = "ZDK";
    private static final String PUBLIC_KEY_MODULUS = "22637809471279133893662043908391337743321861209177166522382139887120366690347181325323740993526428367790523776457961018573543173640737676514665701744913763386680329240863349614572071570172057469308534604161382559388069108007598833693897264165286612408222028999377279754059762001516757271703748760845179263028592755017468108383398382002571895076918536177439684099514568621095813483329741636069259727526698942740756078781249943534143845930031844773389385252741225287280982154567390133403824680971247664926671770130665294145910038724050332080911921014596236882085134974121100892571602309801279667267357867094093149197047";
    private static final String PUBLIC_KEY_EXPONENT = "65537";
    private static final String PRIVATE_KEY_FILE = Environment.getExternalStorageDirectory().getAbsolutePath() + "/Private.key";
    public static final int VERBOSE = 2;
    public static final int DEBUG = 3;
    public static final int INFO = 4;
    public static final int WARN = 5;
    public static final int ERROR = 6;
    private static int logLevel = 3;
    private static boolean isLogEnabled = false;
    private static boolean isInitalized = false;

    public static void initLogger() {
        if (isInitalized) {
            return;
        }
        isInitalized = true;
        if (Utils.isExternalStorageAvailable() && Utils.isFileExists(PRIVATE_KEY_FILE)) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        String str = "Welcome to ZaloSDK Log !!";
                        byte[] encryptedData = Log.encryptData(str);
                        String decrypt = Log.decryptData(encryptedData);
                        if (decrypt.equals(str)) {
                            isLogEnabled = true;
                            logLevel = 2;
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }).start();
        }
    }

    public static void setLogLevel(int logLevel) {
        Log.logLevel = logLevel;
        if (!isLogEnabled && logLevel < 5) {
            Log.logLevel = 5;
        }
    }

    public static int getLogLevel() {
        return logLevel;
    }

    public static void d(String msg) {
        Log.d(LOG_TAG, msg);
    }

    public static void d(String format, Object ... args) {
        Log.d(LOG_TAG, format, args);
    }

    public static void d(String tag, String msg) {
        Log.log(3, tag, msg);
    }

    public static void d(Class<?> tag, String msg) {
        Log.log(3, tag.getSimpleName(), msg);
    }

    public static void d(String tag, String format, Object ... args) {
        Log.log(3, tag, format, args);
    }

    public static void d(Class<?> tag, String format, Object ... args) {
        Log.log(3, tag.getSimpleName(), format, args);
    }

    public static void e(String msg) {
        Log.e(LOG_TAG, msg);
    }

    public static void e(String format, Object ... args) {
        Log.e(LOG_TAG, format, args);
    }

    public static void e(String tag, String msg) {
        Log.log(6, tag, msg);
    }

    public static void e(Class<?> tag, String msg) {
        Log.log(6, tag.getSimpleName(), msg);
    }

    public static void e(String tag, String format, Object ... args) {
        Log.log(6, tag, format, args);
    }

    public static void e(Class<?> tag, String format, Object ... args) {
        Log.log(6, tag.getSimpleName(), format, args);
    }

    public static void e(Exception ex) {
        Log.e(LOG_TAG, ex);
    }

    public static void e(String tag, Exception ex) {
        String msg = android.util.Log.getStackTraceString((Throwable)ex);
        Log.log(6, tag, msg);
    }

    public static void e(Class<?> tag, Exception ex) {
        String msg = android.util.Log.getStackTraceString((Throwable)ex);
        Log.log(6, tag.getSimpleName(), msg);
    }

    public static void i(String msg) {
        Log.i(LOG_TAG, msg);
    }

    public static void i(String format, Object ... args) {
        Log.i(LOG_TAG, format, args);
    }

    public static void i(String tag, String msg) {
        Log.log(4, tag, msg);
    }

    public static void i(Class<?> tag, String msg) {
        Log.log(4, tag.getSimpleName(), msg);
    }

    public static void i(String tag, String format, Object ... args) {
        Log.log(4, tag, format, args);
    }

    public static void i(Class<?> tag, String format, Object ... args) {
        Log.log(4, tag.getSimpleName(), format, args);
    }

    public static void v(String msg) {
        Log.v(LOG_TAG, msg);
    }

    public static void v(String format, Object ... args) {
        Log.v(LOG_TAG, format, args);
    }

    public static void v(String tag, String msg) {
        Log.log(2, tag, msg);
    }

    public static void v(Class<?> tag, String msg) {
        Log.log(2, tag.getSimpleName(), msg);
    }

    public static void v(String tag, String format, Object ... args) {
        Log.log(2, tag, format, args);
    }

    public static void v(Class<?> tag, String format, Object ... args) {
        Log.log(2, tag.getSimpleName(), format, args);
    }

    public static void w(String msg) {
        Log.w(LOG_TAG, msg);
    }

    public static void w(String format, Object ... args) {
        Log.w(LOG_TAG, format, args);
    }

    public static void w(String tag, String msg) {
        Log.log(5, tag, msg);
    }

    public static void w(Class<?> tag, String msg) {
        Log.log(5, tag.getSimpleName(), msg);
    }

    public static void w(String tag, String format, Object ... args) {
        Log.log(5, tag, format, args);
    }

    public static void w(Class<?> tag, String format, Object ... args) {
        Log.log(5, tag.getSimpleName(), format, args);
    }

    private static void log(int priority, String tag, String format, Object ... args) {
        if (format == null) {
            return;
        }
        String msg = String.format(Locale.getDefault(), format, args);
        Log.log(priority, tag, msg);
    }

    private static void log(int priority, String tag, String msg) {
        if (priority < logLevel) {
            return;
        }
        android.util.Log.println((int)priority, (String)tag, (String)msg);
    }

    @SuppressLint(value={"TrulyRandom"})
    private static byte[] encryptData(String data) throws IOException {
        byte[] dataToEncrypt = data.getBytes();
        byte[] encryptedData = null;
        try {
            BigInteger modulus = new BigInteger(PUBLIC_KEY_MODULUS);
            BigInteger exponent = new BigInteger(PUBLIC_KEY_EXPONENT);
            RSAPublicKeySpec rsaPublicKeySpec = new RSAPublicKeySpec(modulus, exponent);
            KeyFactory fact = KeyFactory.getInstance("RSA");
            PublicKey pubKey = fact.generatePublic(rsaPublicKeySpec);
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(1, pubKey);
            encryptedData = cipher.doFinal(dataToEncrypt);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return encryptedData;
    }

    public static String decryptData(byte[] data) throws IOException {
        byte[] descryptedData = null;
        String result = "";
        try {
            PrivateKey privateKey = Log.readPrivateKeyFromFile(PRIVATE_KEY_FILE);
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(2, privateKey);
            descryptedData = cipher.doFinal(data);
            result = new String(descryptedData);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PrivateKey readPrivateKeyFromFile(String fileName) throws IOException {
        FileInputStream fis = null;
        ObjectInputStream ois = null;
        try {
            PrivateKey privateKey;
            fis = new FileInputStream(new File(fileName));
            ois = new ObjectInputStream(fis);
            BigInteger modulus = (BigInteger)ois.readObject();
            BigInteger exponent = (BigInteger)ois.readObject();
            RSAPrivateKeySpec rsaPrivateKeySpec = new RSAPrivateKeySpec(modulus, exponent);
            KeyFactory fact = KeyFactory.getInstance("RSA");
            PrivateKey privateKey2 = privateKey = fact.generatePrivate(rsaPrivateKeySpec);
            return privateKey2;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (ois != null) {
                ois.close();
                if (fis != null) {
                    fis.close();
                }
            }
        }
        return null;
    }
}

