/*
 * Decompiled with CFR 0.152.
 */
package com.zing.zalo.zalosdk.core.http;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.text.TextUtils;
import com.zing.zalo.zalosdk.core.log.Log;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class HttpClientRequest {
    private static final String LINE_END = "\r\n";
    private static final String TWO_HYPHENS = "--";
    private static final String BOUNDARY = "*****";
    private Type mType;
    private String mUrl;
    private Map<String, String> mParams;
    private Map<String, String> mHeader;
    private String fileName;
    private String fileKey;
    private byte[] data;

    public HttpClientRequest(Type type, String url) {
        this.mType = type;
        this.mUrl = url;
        this.mHeader = new HashMap<String, String>();
        this.mParams = new HashMap<String, String>();
    }

    public void addHeader(String name, String value) {
        this.mHeader.put(name, value);
    }

    public void addParams(String name, String value) {
        this.mParams.put(name, value);
    }

    public void setMultipartFile(String fileName, String fileKey, byte[] data) {
        this.fileName = fileName;
        this.fileKey = fileKey;
        this.data = data;
    }

    private String getQueryString() {
        StringBuilder sb = new StringBuilder("");
        if (this.mParams != null) {
            for (String key : this.mParams.keySet()) {
                try {
                    sb.append(URLEncoder.encode(key, "UTF-8"));
                    sb.append("=");
                    sb.append(URLEncoder.encode(this.mParams.get(key), "UTF-8"));
                    sb.append("&");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return sb.toString();
    }

    public String getParamsString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.mParams != null) {
            for (String key : this.mParams.keySet()) {
                try {
                    sb.append(key);
                    sb.append("=");
                    sb.append(this.mParams.get(key));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        sb.append("}");
        return sb.toString();
    }

    public InputStream getResponse() {
        try {
            if (this.mType == Type.POST) {
                HttpURLConnection connection = (HttpURLConnection)new URL(this.mUrl).openConnection();
                connection.setDoOutput(true);
                connection.setRequestProperty("Accept-Charset", "UTF-8");
                connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8");
                for (String string : this.mHeader.keySet()) {
                    connection.setRequestProperty(string, this.mHeader.get(string));
                }
                OutputStream output = connection.getOutputStream();
                output.write(this.getQueryString().getBytes("UTF-8"));
                output.flush();
                output.close();
                return connection.getInputStream();
            }
            if (this.mType == Type.POST_MULIIPART) {
                HttpURLConnection connection = (HttpURLConnection)new URL(this.mUrl).openConnection();
                connection.setDoInput(true);
                connection.setDoOutput(true);
                connection.setUseCaches(false);
                connection.setConnectTimeout(120000);
                connection.setRequestMethod("POST");
                connection.setRequestProperty("Connection", "Keep-Alive");
                connection.setRequestProperty("ENCTYPE", "multipart/form-data");
                connection.setRequestProperty("Content-Type", "multipart/form-data;boundary=*****");
                connection.setRequestProperty("uploaded_file", this.fileName);
                for (String string : this.mHeader.keySet()) {
                    connection.setRequestProperty(string, this.mHeader.get(string));
                }
                DataOutputStream dos = new DataOutputStream(connection.getOutputStream());
                for (String key : this.mParams.keySet()) {
                    dos.writeBytes("--*****\r\n");
                    dos.writeBytes("Content-Disposition: form-data; name=\"" + key + "\"" + LINE_END);
                    dos.writeBytes("Content-Type: text/plain; charset=UTF-8\r\n");
                    dos.writeBytes(LINE_END);
                    dos.write(this.mParams.get(key).getBytes("UTF-8"));
                    dos.writeBytes(LINE_END);
                }
                dos.writeBytes("--*****\r\n");
                dos.writeBytes("Content-Disposition: form-data; name=" + this.fileKey + ";filename=" + this.fileName + "" + LINE_END);
                dos.writeBytes(LINE_END);
                dos.write(this.data);
                dos.writeBytes(LINE_END);
                dos.writeBytes("--*****--\r\n");
                dos.flush();
                dos.close();
                int n = connection.getResponseCode();
                Log.i("debuglog", "connect server POST_MULTIPART " + n);
                if (n >= 300) {
                    String line;
                    String newLine = System.getProperty("line.separator");
                    BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getErrorStream()));
                    StringBuilder result = new StringBuilder();
                    boolean flag = false;
                    while ((line = reader.readLine()) != null) {
                        result.append(flag ? newLine : "").append(line);
                        flag = true;
                    }
                    Log.i("debuglog", result.toString());
                    return null;
                }
                return connection.getInputStream();
            }
            StringBuilder sb = new StringBuilder(this.mUrl);
            if (sb.toString().contains("?")) {
                sb.append("&platform=android");
            } else {
                sb.append("?platform=android");
            }
            for (String string : this.mParams.keySet()) {
                try {
                    sb.append("&");
                    sb.append(URLEncoder.encode(string, "UTF-8"));
                    sb.append("=");
                    sb.append(URLEncoder.encode(this.mParams.get(string), "UTF-8").replace("+", "%20"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            HttpURLConnection connection = (HttpURLConnection)new URL(sb.toString()).openConnection();
            for (String key : this.mHeader.keySet()) {
                connection.setRequestProperty(key, this.mHeader.get(key));
            }
            return connection.getInputStream();
        }
        catch (Exception ex) {
            Log.e(ex);
            return null;
        }
    }

    public String getText() {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.getResponse()));
            StringBuilder result = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                result.append(line);
                result.append("\n");
            }
            reader.close();
            Log.i("debuglog", "connect server RESPONSE getText() : " + result.toString());
            return result.toString();
        }
        catch (Exception ex) {
            Log.e(this.getClass().getName(), ex.getMessage(), ex);
            return null;
        }
    }

    public JSONObject getJSON() {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.getResponse()));
            StringBuilder result = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                result.append(line);
                result.append("\n");
            }
            reader.close();
            Log.i("debuglog", "connect server RESPONSE getJSON() : " + result.toString());
            return new JSONObject(result.toString());
        }
        catch (Exception ex) {
            Log.e(this.getClass().getName(), ex.getMessage(), ex);
            return null;
        }
    }

    public Bitmap getImage() {
        try {
            InputStream inputStream = this.getResponse();
            Bitmap image = null;
            if (inputStream != null) {
                image = BitmapFactory.decodeStream((InputStream)inputStream);
                inputStream.close();
            }
            return image;
        }
        catch (Exception ex) {
            Log.e(this.getClass().getName(), ex.getMessage(), ex);
            return null;
        }
    }

    public static byte[] getByteArray(String url) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            return null;
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            int bytesRead;
            URL toDownload = new URL(url);
            byte[] chunk = new byte[4096];
            InputStream stream = toDownload.openStream();
            while ((bytesRead = stream.read(chunk)) > 0) {
                outputStream.write(chunk, 0, bytesRead);
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return outputStream.toByteArray();
    }

    public int getResponseCode() {
        try {
            HttpURLConnection c = (HttpURLConnection)new URL(this.mUrl).openConnection();
            return c.getResponseCode();
        }
        catch (Exception ex) {
            Log.e(this.getClass().getName(), ex.getMessage(), ex);
            return 0;
        }
    }

    public static enum Type {
        GET,
        POST,
        POST_MULIIPART;

    }
}

