/*
 * Decompiled with CFR 0.152.
 */
package com.zing.zalo.zalosdk.core.helper;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.SharedPreferences;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import com.zing.zalo.devicetrackingsdk.ZPermissionManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.UUID;

public class DeviceHelper {
    public static final String UNKNOWN = "unknown";

    private static String wrapperGetUDID(Context owner) {
        SharedPreferences pref;
        TelephonyManager telephonyManager = (TelephonyManager)owner.getSystemService("phone");
        String uuid = telephonyManager.getDeviceId();
        if (uuid == null && TextUtils.isEmpty((CharSequence)(uuid = (pref = owner.getSharedPreferences("zacPref", 0)).getString("zalosdk_payment_uuid", null)))) {
            uuid = UUID.randomUUID().toString();
            SharedPreferences.Editor edit = pref.edit();
            edit.putString("zalosdk_payment_uuid", uuid);
            edit.commit();
        }
        return uuid;
    }

    public static String getUDID(Context owner) {
        if (ZPermissionManager.isAndroidMOrHigher()) {
            if (ZPermissionManager.isPermissionGranted(owner, "android.permission.READ_PHONE_STATE")) {
                return DeviceHelper.wrapperGetUDID(owner);
            }
            SharedPreferences pref = owner.getSharedPreferences("zacPref", 0);
            String uuid = pref.getString("zalosdk_payment_uuid", null);
            if (TextUtils.isEmpty((CharSequence)uuid)) {
                uuid = UUID.randomUUID().toString();
                SharedPreferences.Editor edit = pref.edit();
                edit.putString("zalosdk_payment_uuid", uuid);
                edit.commit();
            }
            return uuid;
        }
        return DeviceHelper.wrapperGetUDID(owner);
    }

    public static boolean isFullScreen(Activity activity) {
        return (activity.getWindow().getAttributes().flags & 0x400) != 0;
    }

    public static boolean isTablet(Context context) {
        return (context.getResources().getConfiguration().screenLayout & 0xF) >= 3;
    }

    public static float dpFromPx(Context context, float px) {
        return px / context.getResources().getDisplayMetrics().density;
    }

    public static float pxFromDp(Context context, float dp) {
        return dp * context.getResources().getDisplayMetrics().density;
    }

    public static boolean isScreenPortrait(Activity activity) {
        boolean isPortrait;
        int rotation = activity.getWindowManager().getDefaultDisplay().getRotation();
        DisplayMetrics dm = new DisplayMetrics();
        activity.getWindowManager().getDefaultDisplay().getMetrics(dm);
        int width = dm.widthPixels;
        int height = dm.heightPixels;
        if ((rotation == 0 || rotation == 2) && height > width || (rotation == 1 || rotation == 3) && width > height) {
            switch (rotation) {
                case 0: {
                    isPortrait = true;
                    break;
                }
                case 1: {
                    isPortrait = false;
                    break;
                }
                case 2: {
                    isPortrait = true;
                    break;
                }
                case 3: {
                    isPortrait = false;
                    break;
                }
                default: {
                    isPortrait = true;
                    break;
                }
            }
        } else {
            switch (rotation) {
                case 0: {
                    isPortrait = false;
                    break;
                }
                case 1: {
                    isPortrait = true;
                    break;
                }
                case 2: {
                    isPortrait = false;
                    break;
                }
                case 3: {
                    isPortrait = true;
                    break;
                }
                default: {
                    isPortrait = false;
                }
            }
        }
        return isPortrait;
    }

    public static String getScreenSize(Context context) {
        int screenLayout = context.getResources().getConfiguration().screenLayout;
        int screenSize = screenLayout & 0xF;
        switch (screenSize) {
            case 1: {
                return "small";
            }
            case 2: {
                return "normal";
            }
            case 3: {
                return "large";
            }
            case 4: {
                return "xlarge";
            }
        }
        return UNKNOWN;
    }

    private static String getDisplayWidth(DisplayMetrics displayMetrics) {
        String displayWidth = String.valueOf(displayMetrics.widthPixels);
        return DeviceHelper.sanitizeString(displayWidth);
    }

    private static String getDisplayHeight(DisplayMetrics displayMetrics) {
        String displayHeight = String.valueOf(displayMetrics.heightPixels);
        return DeviceHelper.sanitizeString(displayHeight);
    }

    private static String sanitizeString(String string) {
        return DeviceHelper.sanitizeString(string, UNKNOWN);
    }

    private static String sanitizeString(String string, String defaultString) {
        String result = string;
        if (TextUtils.isEmpty((CharSequence)result)) {
            result = defaultString;
        }
        if (TextUtils.isEmpty((CharSequence)(result = result.replaceAll("\\s", "")))) {
            result = defaultString;
        }
        return result;
    }

    protected static String loadAddress(String interfaceName) {
        try {
            int numRead;
            String filePath = "/sys/class/net/" + interfaceName + "/address";
            StringBuilder fileData = new StringBuilder(1000);
            BufferedReader reader = new BufferedReader(new FileReader(filePath), 1024);
            char[] buf = new char[1024];
            while ((numRead = reader.read(buf)) != -1) {
                String readData = String.valueOf(buf, 0, numRead);
                fileData.append(readData);
            }
            reader.close();
            return fileData.toString();
        }
        catch (IOException e) {
            return null;
        }
    }

    protected static String getAndroidId(Context context) {
        return Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
    }

    protected static String getDeviceId(Context context) {
        if (ZPermissionManager.isAndroidMOrHigher()) {
            if (ZPermissionManager.isPermissionGranted(context, "android.permission.READ_PHONE_STATE")) {
                TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
                return tm == null ? "" : tm.getDeviceId();
            }
            return null;
        }
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        return tm == null ? "" : tm.getDeviceId();
    }

    protected static String getModel() {
        return Build.MODEL;
    }

    protected static String getOSName() {
        Field[] fields;
        String fieldName = null;
        for (Field field : fields = Build.VERSION_CODES.class.getFields()) {
            int fieldValue = -1;
            try {
                fieldValue = field.getInt(new Object());
                if (fieldValue != Build.VERSION.SDK_INT) continue;
                fieldName = field.getName();
                return fieldName;
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return fieldName;
    }

    protected static String getOSVersion() {
        return Build.VERSION.RELEASE;
    }

    protected static String getBrand() {
        return Build.BRAND;
    }

    protected static String getManufacturer() {
        return Build.MANUFACTURER;
    }

    protected static String getProduct() {
        return Build.PRODUCT;
    }

    protected static String getScreenWidth(Context context) {
        DisplayMetrics dm = context.getResources().getDisplayMetrics();
        return DeviceHelper.getDisplayWidth(dm);
    }

    protected static String getScreenHeight(Context context) {
        DisplayMetrics dm = context.getResources().getDisplayMetrics();
        return DeviceHelper.getDisplayHeight(dm);
    }

    public static String getCarrierCode(Context context) {
        if (ZPermissionManager.isAndroidMOrHigher()) {
            if (ZPermissionManager.isPermissionGranted(context, "android.permission.READ_PHONE_STATE")) {
                TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
                return tm == null ? null : tm.getNetworkOperator();
            }
            return null;
        }
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        return tm == null ? null : tm.getNetworkOperator();
    }

    public static String getConnection(Context context) {
        ConnectivityManager mConnectivity = (ConnectivityManager)context.getSystemService("connectivity");
        if (mConnectivity == null) {
            return null;
        }
        NetworkInfo info = mConnectivity.getActiveNetworkInfo();
        if (info != null) {
            int type = info.getType();
            if (type == 1) {
                return "wifi";
            }
            if (type == 0) {
                return "carrier";
            }
        }
        return null;
    }

    protected static String sha1(String text) {
        return DeviceHelper.hash(text, "sha1");
    }

    protected static String md5(String text) {
        return DeviceHelper.hash(text, "md5");
    }

    @TargetApi(value=9)
    private static String hash(String text, String method) {
        try {
            byte[] bytes = null;
            bytes = Build.VERSION.SDK_INT > 8 ? text.getBytes(Charset.forName("UTF-8")) : text.getBytes("UTF-8");
            MessageDigest mesd = MessageDigest.getInstance(method);
            mesd.update(bytes, 0, bytes.length);
            byte[] hash = mesd.digest();
            return DeviceHelper.convertToHex(hash);
        }
        catch (Exception e) {
            return "";
        }
    }

    private static String convertToHex(byte[] bytes) {
        BigInteger bigInt = new BigInteger(1, bytes);
        String formatString = "%0" + (bytes.length << 1) + "x";
        return String.format(formatString, bigInt);
    }

    public static boolean isDeviceRooted() {
        return DeviceHelper.checkRootMethod1() || DeviceHelper.checkRootMethod2() || DeviceHelper.checkRootMethod3();
    }

    private static boolean checkRootMethod1() {
        String buildTags = Build.TAGS;
        return buildTags != null && buildTags.contains("test-keys");
    }

    private static boolean checkRootMethod2() {
        try {
            File file = new File("/system/app/Superuser.apk");
            return file.exists();
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static boolean checkRootMethod3() {
        return new ExecShell().executeCommand(ExecShell.SHELL_CMD.check_su_binary) != null;
    }

    protected static int parseInt(String str, int def) {
        int res = def;
        try {
            res = Integer.parseInt(str);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return res;
    }

    protected static String randString128() {
        SecureRandom rand = new SecureRandom();
        return new BigInteger(128, rand).toString(16);
    }

    protected static boolean isRunningOnEmulator() {
        return Build.PRODUCT != null && (Build.PRODUCT.contains("sdk") || Build.PRODUCT.contains("vbox86p")) || Build.MODEL != null && Build.MODEL.contains("sdk") || Build.HARDWARE != null && (Build.HARDWARE.equalsIgnoreCase("goldfish") || Build.HARDWARE.equalsIgnoreCase("goldfish")) || Build.FINGERPRINT != null && Build.FINGERPRINT.startsWith("generic");
    }

    protected static long clampTimestampToNearestHour(long timestamp) {
        Date date1 = new Date(timestamp);
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date1);
        Calendar cal2 = Calendar.getInstance();
        cal2.set(cal1.get(1), cal1.get(2), cal1.get(5), cal1.get(11), 0, 0);
        cal2.set(14, 0);
        return cal2.getTimeInMillis();
    }

    private static class ExecShell {
        private ExecShell() {
        }

        public ArrayList<String> executeCommand(SHELL_CMD shellCmd) {
            String line = null;
            ArrayList<String> fullResponse = new ArrayList<String>();
            Process localProcess = null;
            try {
                localProcess = Runtime.getRuntime().exec(shellCmd.command);
            }
            catch (Exception e) {
                return null;
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(localProcess.getInputStream()));
            try {
                while ((line = in.readLine()) != null) {
                    fullResponse.add(line);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return fullResponse;
        }

        public static enum SHELL_CMD {
            check_su_binary(new String[]{"/system/xbin/which", "su"});

            String[] command;

            private SHELL_CMD(String[] command) {
                this.command = command;
            }
        }
    }

    public static class ScreenDensity {
        public static final String LOW = "low";
        public static final String HIGH = "high";
        public static final String MEDIUM = "medium";
    }

    public static class ScreenFormat {
        public static final String LONG = "long";
        public static final String NORMAL = "normal";
    }

    public static class ScreenSize {
        public static final String SMALL = "small";
        public static final String NORMAL = "normal";
        public static final String LARGE = "large";
        public static final String XLARGE = "xlarge";
    }
}

