/*
 * Decompiled with CFR 0.152.
 */
package com.zing.zalo.zalosdk.core.helper;

import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.media.ExifInterface;
import android.net.Uri;
import android.util.Base64;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class BitmapHelper {
    public static Bitmap b64ToImage(String encodedImage) {
        byte[] decodedString = Base64.decode((String)encodedImage, (int)0);
        Bitmap decodedByte = BitmapFactory.decodeByteArray((byte[])decodedString, (int)0, (int)decodedString.length);
        return decodedByte;
    }

    public static void deleteFilePhoto(String filePath) {
        try {
            File f = new File(filePath);
            if (f != null && f.exists()) {
                f.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Bitmap rotateImage(Bitmap source, float angle) {
        Bitmap bitmap = null;
        Matrix matrix = new Matrix();
        matrix.postRotate(angle);
        try {
            bitmap = Bitmap.createBitmap((Bitmap)source, (int)0, (int)0, (int)source.getWidth(), (int)source.getHeight(), (Matrix)matrix, (boolean)true);
        }
        catch (OutOfMemoryError err) {
            err.printStackTrace();
        }
        return bitmap;
    }

    public static Bitmap getDownsampledBitmap(Bitmap image, int max_size) {
        if (image == null || image.getWidth() == 0 || image.getHeight() == 0 || max_size < 16) {
            return image;
        }
        int shifts = 0;
        for (int size = BitmapHelper.getBitmapSize(image); size > max_size; size /= 4) {
            ++shifts;
        }
        Bitmap ret = Bitmap.createScaledBitmap((Bitmap)image, (int)(image.getWidth() >> shifts), (int)(image.getHeight() >> shifts), (boolean)true);
        if (ret == null) {
            return null;
        }
        if (BitmapHelper.getBitmapSize(ret) > max_size) {
            return Bitmap.createScaledBitmap((Bitmap)ret, (int)(ret.getWidth() >> 1), (int)(ret.getHeight() >> 1), (boolean)true);
        }
        return ret;
    }

    public static Bitmap getBitmapReSampleSize(byte[] data, int img_max_size) {
        try {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length, (BitmapFactory.Options)options);
            int scale = 1;
            while ((double)(options.outWidth * options.outHeight) * (1.0 / Math.pow(scale, 2.0)) > (double)img_max_size) {
                ++scale;
            }
            Bitmap pic = null;
            if (scale > 1) {
                options = new BitmapFactory.Options();
                options.inSampleSize = --scale;
                pic = BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length, (BitmapFactory.Options)options);
                int width = options.outWidth;
                int height = options.outHeight;
                double y = Math.sqrt((double)img_max_size / ((double)width / (double)height));
                double x = y / (double)height * (double)width;
                Bitmap scaledBitmap = Bitmap.createScaledBitmap((Bitmap)pic, (int)((int)x), (int)((int)y), (boolean)true);
                pic.recycle();
                pic = scaledBitmap;
            } else {
                pic = BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length);
            }
            return pic;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static int getBitmapSize(Bitmap bmap) {
        return bmap.getRowBytes() * bmap.getHeight();
    }

    public static Bitmap handleSamplingAndRotationBitmap(Context context, Uri selectedImage, int maxWidth, int maxHeight) throws IOException {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        InputStream imageStream = context.getContentResolver().openInputStream(selectedImage);
        BitmapFactory.decodeStream((InputStream)imageStream, null, (BitmapFactory.Options)options);
        imageStream.close();
        options.inSampleSize = BitmapHelper.calculateInSampleSize(options, maxWidth, maxHeight);
        options.inJustDecodeBounds = false;
        imageStream = context.getContentResolver().openInputStream(selectedImage);
        Bitmap img = BitmapFactory.decodeStream((InputStream)imageStream, null, (BitmapFactory.Options)options);
        img = BitmapHelper.rotateImageIfRequired(img, BitmapHelper.getRealPathFromURI(context, selectedImage));
        return img;
    }

    static int calculateInSampleSize(BitmapFactory.Options options, int reqWidth, int reqHeight) {
        int height = options.outHeight;
        int width = options.outWidth;
        int inSampleSize = 1;
        if (height > reqHeight || width > reqWidth) {
            int widthRatio;
            int heightRatio = Math.round((float)height / (float)reqHeight);
            inSampleSize = heightRatio < (widthRatio = Math.round((float)width / (float)reqWidth)) ? heightRatio : widthRatio;
            float totalPixels = width * height;
            float totalReqPixelsCap = reqWidth * reqHeight * 2;
            while (totalPixels / (float)(inSampleSize * inSampleSize) > totalReqPixelsCap) {
                ++inSampleSize;
            }
        }
        return inSampleSize;
    }

    static Bitmap rotateImageIfRequired(Bitmap img, String path) throws IOException {
        ExifInterface ei = new ExifInterface(path);
        int orientation = ei.getAttributeInt("Orientation", 1);
        switch (orientation) {
            case 6: {
                return BitmapHelper.rotateImage(img, 90);
            }
            case 3: {
                return BitmapHelper.rotateImage(img, 180);
            }
            case 8: {
                return BitmapHelper.rotateImage(img, 270);
            }
        }
        return img;
    }

    private static Bitmap rotateImage(Bitmap img, int degree) {
        Matrix matrix = new Matrix();
        matrix.postRotate((float)degree);
        Bitmap rotatedImg = Bitmap.createBitmap((Bitmap)img, (int)0, (int)0, (int)img.getWidth(), (int)img.getHeight(), (Matrix)matrix, (boolean)true);
        img.recycle();
        return rotatedImg;
    }

    public static String getRealPathFromURI(Context ctx, Uri contentURI) {
        String result;
        Cursor cursor = ctx.getContentResolver().query(contentURI, null, null, null, null);
        if (cursor == null) {
            result = contentURI.getPath();
        } else {
            cursor.moveToFirst();
            int idx = cursor.getColumnIndex("_data");
            result = cursor.getString(idx);
            cursor.close();
        }
        return result;
    }

    public static byte[] toByteArray(Bitmap bitmap) {
        if (bitmap == null) {
            return new byte[0];
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.JPEG, 80, (OutputStream)stream);
        return stream.toByteArray();
    }
}

