/*
 * Decompiled with CFR 0.152.
 */
package com.zing.zalo.zalosdk.core.helper;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.net.Uri;
import android.util.Base64;
import com.zing.zalo.zalosdk.core.log.Log;
import java.security.MessageDigest;

public class AppInfo {
    private static String versionName;
    private static int versionCode;
    private static String packageName;
    private static String applicationHashKey;

    public static String getVersionName(Context ctx) {
        if (versionName != null) {
            return versionName;
        }
        AppInfo.extractBasicAppInfo(ctx);
        return versionName;
    }

    public static int getVersionCode(Context ctx) {
        if (versionCode != 0) {
            return versionCode;
        }
        AppInfo.extractBasicAppInfo(ctx);
        return versionCode;
    }

    public static String getPackageName(Context ctx) {
        if (packageName != null) {
            return packageName;
        }
        AppInfo.extractBasicAppInfo(ctx);
        return packageName;
    }

    public static String getApplicationHashKey(Context ctx) {
        if (applicationHashKey != null) {
            return applicationHashKey;
        }
        try {
            PackageInfo info = ctx.getPackageManager().getPackageInfo(ctx.getPackageName(), 64);
            for (Signature signature : info.signatures) {
                MessageDigest md = MessageDigest.getInstance("SHA");
                md.update(signature.toByteArray());
                applicationHashKey = Base64.encodeToString((byte[])md.digest(), (int)0).trim();
            }
        }
        catch (Exception e) {
            Log.e(e);
        }
        return applicationHashKey;
    }

    private static void extractBasicAppInfo(Context ctx) {
        try {
            PackageManager pm = ctx.getPackageManager();
            packageName = ctx.getPackageName();
            PackageInfo pInfo = pm.getPackageInfo(packageName, 0);
            versionName = pInfo.versionName;
            versionCode = pInfo.versionCode;
        }
        catch (Exception ex) {
            Log.e(ex);
        }
    }

    public static void launchMarketApp(Context context, String targetPackage) {
        try {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.addFlags(0x10000000);
            intent.setData(Uri.parse((String)("market://details?id=" + targetPackage)));
            context.startActivity(intent);
        }
        catch (ActivityNotFoundException e) {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)("https://play.google.com/store/apps/details?id=" + targetPackage)));
            intent.addFlags(0x10000000);
            context.startActivity(intent);
        }
    }

    public static boolean isPackageExists(Context context, String targetPackage) {
        PackageManager pm = context.getPackageManager();
        try {
            pm.getPackageInfo(targetPackage, 128);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static void launchApp(Context context, String targetPackage) {
        Intent intent = context.getPackageManager().getLaunchIntentForPackage(targetPackage);
        if (intent != null) {
            intent.addFlags(0x10000000);
            context.startActivity(intent);
        }
    }
}

