/*
 * Decompiled with CFR 0.152.
 */
package com.zing.zalo.zalosdk.common;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Base64;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;
import com.zing.zalo.zalosdk.core.log.Log;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.json.JSONArray;

public class UtilsCore {
    public static String loadStringAssets(Context mContext, String fileName) {
        String a = "";
        try {
            InputStream json = mContext.getAssets().open(fileName);
            if (json != null) {
                InputStreamReader inputStreamReader = new InputStreamReader(json);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                String receiveString = "";
                StringBuilder stringBuilder = new StringBuilder();
                while ((receiveString = bufferedReader.readLine()) != null) {
                    stringBuilder.append(receiveString);
                }
                json.close();
                a = stringBuilder.toString();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return a;
    }

    public static Intent getBrowserIntent(Context ctx, String url) {
        Intent i = new Intent("android.intent.action.VIEW");
        i.setData(Uri.parse((String)url));
        i.setFlags(0x40000000);
        i.addFlags(0x20000000);
        i.addFlags(4);
        ComponentName componentName = null;
        PackageManager pm = ctx.getPackageManager();
        ResolveInfo browser_ri = null;
        List rList = pm.queryIntentActivities(i, 0);
        for (ResolveInfo ri : rList) {
            if ("com.android.chrome".equals(ri.activityInfo.packageName) || "com.chrome.beta".equals(ri.activityInfo.packageName)) {
                browser_ri = ri;
                break;
            }
            if (!"com.android.browser".equals(ri.activityInfo.packageName)) continue;
            browser_ri = ri;
            break;
        }
        if (browser_ri != null) {
            componentName = UtilsCore.ri2cn(browser_ri);
        }
        if (componentName != null) {
            i.setComponent(componentName);
        }
        return i;
    }

    private static ComponentName ri2cn(ResolveInfo ri) {
        return new ComponentName(ri.activityInfo.packageName, ri.activityInfo.name);
    }

    public static boolean isCableOfSendingSMS(Context context) {
        String defApp = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"sms_default_application");
        Uri smsUri = Uri.parse((String)"smsto:1111");
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setPackage(defApp);
        intent.putExtra("sms_body", "");
        intent.putExtra("address", "");
        intent.putExtra("android.intent.extra.TEXT", "");
        intent.setData(smsUri);
        PackageManager packageManager = context.getPackageManager();
        List activities = packageManager.queryIntentActivities(intent, 0);
        boolean isIntentSafe = activities.size() > 0;
        return isIntentSafe;
    }

    public static int getAppVersion(Context context) {
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            return packageInfo.versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new RuntimeException("Could not get package name: " + (Object)((Object)e));
        }
    }

    public static void showKeyboard(Context context, View v) {
        InputMethodManager keyboard = (InputMethodManager)context.getSystemService("input_method");
        keyboard.showSoftInput(v, 1);
    }

    public static Bitmap getRoundedCornerBitmap(Bitmap bitmap) {
        if (bitmap == null) {
            return null;
        }
        Bitmap output = Bitmap.createBitmap((int)bitmap.getWidth(), (int)bitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(output);
        int color = -12434878;
        Paint paint = new Paint();
        Rect rect = new Rect(0, 0, bitmap.getWidth(), bitmap.getHeight());
        RectF rectF = new RectF(rect);
        float roundPx = 12.0f;
        paint.setAntiAlias(true);
        canvas.drawARGB(0, 0, 0, 0);
        paint.setColor(-12434878);
        canvas.drawRoundRect(rectF, 12.0f, 12.0f, paint);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(bitmap, rect, rect, paint);
        return output;
    }

    public static Bitmap drawableToBitmap(Drawable drawable) {
        if (drawable == null) {
            return null;
        }
        if (drawable instanceof BitmapDrawable) {
            return ((BitmapDrawable)drawable).getBitmap();
        }
        int width = drawable.getIntrinsicWidth();
        width = width > 0 ? width : 1;
        int height = drawable.getIntrinsicHeight();
        height = height > 0 ? height : 1;
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        drawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable.draw(canvas);
        return bitmap;
    }

    public static void setImageViewContent(Activity owner, int id, Drawable drawable) {
        try {
            ImageView view = (ImageView)owner.findViewById(id);
            if (view != null) {
                view.setBackgroundDrawable(drawable);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setTextViewContent(Activity owner, int id, String text) {
        try {
            TextView view = (TextView)owner.findViewById(id);
            if (view != null) {
                view.setText((CharSequence)text);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setViewVisible(Activity owner, int id, int visible) {
        try {
            View view = owner.findViewById(id);
            if (view != null) {
                view.setVisibility(visible);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean filterAmount(int min, int max, long value) {
        if (min == -1 && max == -1) {
            return true;
        }
        if (min == -1 && value <= (long)max) {
            return true;
        }
        if (max == -1 && value >= (long)min) {
            return true;
        }
        return value >= (long)min && value <= (long)max;
    }

    public static boolean isFileExists(String path) {
        return new File(path).exists();
    }

    public static JSONArray remove(int idx, JSONArray from) {
        List<Object> objs = UtilsCore.asList(from);
        objs.remove(idx);
        JSONArray ja = new JSONArray();
        for (Object obj : objs) {
            ja.put(obj);
        }
        return ja;
    }

    public static List<Object> asList(JSONArray ja) {
        int len = ja.length();
        ArrayList<Object> result = new ArrayList<Object>(len);
        for (int i = 0; i < len; ++i) {
            Object obj = ja.opt(i);
            if (obj == null) continue;
            result.add(obj);
        }
        return result;
    }

    public static String join(List<String> list, String delim) {
        StringBuilder sb = new StringBuilder();
        String loopDelim = "";
        for (String s : list) {
            sb.append(loopDelim);
            sb.append(s);
            loopDelim = delim;
        }
        return sb.toString();
    }

    public static void enableDisableViewGroup(ViewGroup viewGroup, boolean enabled) {
        int childCount = viewGroup.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View view = viewGroup.getChildAt(i);
            view.setEnabled(enabled);
            if (!(view instanceof ViewGroup)) continue;
            UtilsCore.enableDisableViewGroup((ViewGroup)view, enabled);
        }
    }

    static void DeleteRecursive(File fileOrDirectory) {
        if (fileOrDirectory.isDirectory()) {
            for (File child : fileOrDirectory.listFiles()) {
                UtilsCore.DeleteRecursive(child);
            }
        }
        fileOrDirectory.delete();
    }

    public static String getSimOperator(Context context) {
        try {
            if (!UtilsCore.isPermissionGranted(context, "android.permission.READ_PHONE_STATE")) {
                throw new Exception("Missing permission");
            }
            TelephonyManager tel = (TelephonyManager)context.getSystemService("phone");
            return tel.getSimOperator();
        }
        catch (Exception ex) {
            return "unknown";
        }
    }

    public static String getConnectionType(Context context) {
        if (!UtilsCore.isPermissionGranted(context, "android.permission.ACCESS_NETWORK_STATE")) {
            return "unknown";
        }
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo info = cm.getActiveNetworkInfo();
        if (info != null && info.isConnected()) {
            if (info.getType() == 1) {
                return "wifi";
            }
            if (info.getType() == 0) {
                return "mobile";
            }
        }
        return "";
    }

    public static String getDeviceModel() {
        try {
            return Build.MODEL;
        }
        catch (Exception ex) {
            return "unknown";
        }
    }

    public static String getHeapSize() {
        try {
            Runtime runtime = Runtime.getRuntime();
            return String.valueOf(runtime.maxMemory());
        }
        catch (Exception ex) {
            return "unknown";
        }
    }

    public static String getIMEI(Context context) {
        try {
            if (!UtilsCore.isPermissionGranted(context, "android.permission.READ_PHONE_STATE")) {
                throw new Exception("Missing permission");
            }
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            return telephonyManager.getDeviceId();
        }
        catch (Exception ex) {
            return "unknwon";
        }
    }

    public static String getCPUInfo() {
        try {
            StringBuffer sb = new StringBuffer();
            if (Build.VERSION.SDK_INT > 20) {
                sb.append("abi: ").append(TextUtils.join((CharSequence)",", (Object[])Build.SUPPORTED_ABIS)).append("\n");
            }
            if (new File("/proc/cpuinfo").exists()) {
                try {
                    String aLine;
                    BufferedReader br = new BufferedReader(new FileReader(new File("/proc/cpuinfo")));
                    while ((aLine = br.readLine()) != null) {
                        sb.append(aLine + "\n");
                    }
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return sb.toString();
        }
        catch (Exception ex) {
            return "unknown";
        }
    }

    public static String getBatteryInfo() {
        return "unknown";
    }

    public static String getTimeZoneString() {
        try {
            Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"), Locale.getDefault());
            String timeZone = new SimpleDateFormat("Z").format(calendar.getTime());
            return timeZone.substring(0, 3) + ":" + timeZone.substring(3, 5);
        }
        catch (Exception ex) {
            return "unknown";
        }
    }

    public static void decompress(byte[] compressed, String location) throws IOException {
        ZipEntry ze;
        ByteArrayInputStream is = new ByteArrayInputStream(compressed);
        ZipInputStream zis = new ZipInputStream(new BufferedInputStream(is));
        byte[] buffer = new byte[1024];
        while ((ze = zis.getNextEntry()) != null) {
            int count;
            String filename = ze.getName();
            if (ze.isDirectory()) {
                String path = location + File.separator + filename;
                File fmd = new File(path);
                fmd.mkdirs();
                UtilsCore.hideImageFromGallery(path + File.separator);
                continue;
            }
            FileOutputStream fout = new FileOutputStream(location + File.separator + filename);
            while ((count = zis.read(buffer)) != -1) {
                fout.write(buffer, 0, count);
            }
            fout.close();
            zis.closeEntry();
        }
        zis.close();
    }

    public static void decompress(String zipText, String location) throws IOException {
        ZipEntry ze;
        byte[] compressed = Base64.decode((String)zipText, (int)0);
        ByteArrayInputStream is = new ByteArrayInputStream(compressed);
        ZipInputStream zis = new ZipInputStream(new BufferedInputStream(is));
        byte[] buffer = new byte[1024];
        while ((ze = zis.getNextEntry()) != null) {
            int count;
            String filename = ze.getName();
            if (ze.isDirectory()) {
                String path = location + File.separator + filename;
                File fmd = new File(path);
                fmd.mkdirs();
                UtilsCore.hideImageFromGallery(path + File.separator);
                continue;
            }
            FileOutputStream fout = new FileOutputStream(location + File.separator + filename);
            while ((count = zis.read(buffer)) != -1) {
                fout.write(buffer, 0, count);
            }
            fout.close();
            zis.closeEntry();
        }
        zis.close();
    }

    public static void hideImageFromGallery(String path) throws IOException {
        String NOMEDIA = ".nomedia";
        File nomediaFile = new File(path + NOMEDIA);
        if (!nomediaFile.exists()) {
            nomediaFile.createNewFile();
        }
    }

    public static boolean isExternalStorageAvailable() {
        String state = Environment.getExternalStorageState();
        return "mounted".equals(state);
    }

    public static String getCookieValue(String cookie, String key) {
        String[] temp = cookie.split(";");
        String value = null;
        for (String a : temp) {
            if (!a.contains(key)) continue;
            value = a.split("=")[1];
            break;
        }
        return value;
    }

    public static boolean isPermissionGranted(Context context, String permission2) {
        int permissionCheck;
        block5: {
            permissionCheck = -1;
            if (Build.VERSION.SDK_INT >= 23) {
                try {
                    Method method = context.getClass().getMethod("checkSelfPermission", String.class);
                    if (method != null) {
                        permissionCheck = (Integer)method.invoke((Object)context, permission2);
                        break block5;
                    }
                    permissionCheck = context.getPackageManager().checkPermission(permission2, context.getPackageName());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                permissionCheck = context.getPackageManager().checkPermission(permission2, context.getPackageName());
            }
        }
        return permissionCheck == 0;
    }

    @SuppressLint(value={"TrulyRandom"})
    public static byte[] encrypt(String keyInStr, String dataToEncrypt) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException, NoSuchProviderException {
        byte[] keyInBinary = keyInStr.getBytes();
        byte[] vector_bytes = new byte[16];
        for (int i = 0; i < 16; ++i) {
            vector_bytes[i] = 0;
        }
        SecretKeySpec secretKeySpec = new SecretKeySpec(keyInBinary, "AES");
        IvParameterSpec ivspec = new IvParameterSpec(vector_bytes);
        Cipher c = Cipher.getInstance("AES/CBC/PKCS5Padding");
        c.init(1, (Key)secretKeySpec, ivspec);
        return c.doFinal(dataToEncrypt.getBytes("UTF-8"));
    }

    public static String postFile(String URL2, String fileName, String fileKey, byte[] data, Map<String, String> otherParams) throws Exception {
        HttpURLConnection conn = null;
        DataOutputStream dos = null;
        InputStreamReader isr = null;
        BufferedReader br = null;
        String lineEnd = "\r\n";
        String twoHyphens = "--";
        String boundary = "*****";
        try {
            String tmp;
            URL url = new URL(URL2);
            conn = (HttpURLConnection)url.openConnection();
            conn.setDoInput(true);
            conn.setDoOutput(true);
            conn.setUseCaches(false);
            conn.setConnectTimeout(120000);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Connection", "Keep-Alive");
            conn.setRequestProperty("ENCTYPE", "multipart/form-data");
            conn.setRequestProperty("Content-Type", "multipart/form-data;boundary=" + boundary);
            conn.setRequestProperty("uploaded_file", fileName);
            dos = new DataOutputStream(conn.getOutputStream());
            if (otherParams != null) {
                for (String key : otherParams.keySet()) {
                    dos.writeBytes(twoHyphens + boundary + lineEnd);
                    dos.writeBytes("Content-Disposition: form-data; name=\"" + key + "\"" + lineEnd);
                    dos.writeBytes("Content-Type: text/plain; charset=UTF-8" + lineEnd);
                    dos.writeBytes(lineEnd);
                    dos.writeBytes(otherParams.get(key));
                    dos.writeBytes(lineEnd);
                }
            }
            dos.writeBytes(twoHyphens + boundary + lineEnd);
            dos.writeBytes("Content-Disposition: form-data; name=" + fileKey + ";filename=" + fileName + "" + lineEnd);
            dos.writeBytes(lineEnd);
            dos.write(data);
            dos.writeBytes(lineEnd);
            dos.writeBytes(twoHyphens + boundary + twoHyphens + lineEnd);
            int rcode = conn.getResponseCode();
            isr = rcode >= 200 && rcode <= 299 ? new InputStreamReader(conn.getInputStream()) : new InputStreamReader(conn.getErrorStream());
            br = new BufferedReader(isr);
            StringBuilder sb = new StringBuilder();
            while ((tmp = br.readLine()) != null) {
                sb.append(tmp);
            }
            String string = sb.toString();
            return string;
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            if (dos != null) {
                dos.flush();
                dos.close();
            }
            if (isr != null) {
                isr.close();
            }
            if (br != null) {
                br.close();
            }
        }
    }

    public static String longToStringNoDecimal(long d) {
        return NumberFormat.getNumberInstance(Locale.US).format(d);
    }

    public static String formatDigit(String[] indexOfDashChar, String source, String seperateChar) {
        char[] cs = source.toCharArray();
        int l = cs.length;
        StringBuilder sb = new StringBuilder();
        int j = 1;
        int lengthOfIndexJ = Integer.parseInt(indexOfDashChar[j]);
        for (int i = 0; i < l; ++i) {
            sb.append(cs[i]);
            if (--lengthOfIndexJ != 0 || j >= indexOfDashChar.length - 1) continue;
            sb.append(seperateChar);
            if (++j >= indexOfDashChar.length - 1) continue;
            lengthOfIndexJ = Integer.parseInt(indexOfDashChar[j]);
        }
        String result = sb.toString();
        if (result.lastIndexOf(seperateChar) + 1 == result.length() && !TextUtils.isEmpty((CharSequence)result)) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    public static void hideSoftKeyboard(Activity activity) {
        InputMethodManager inputMethodManager;
        if (activity != null && (inputMethodManager = (InputMethodManager)activity.getSystemService("input_method")) != null) {
            View focus = activity.getCurrentFocus();
            if (focus != null) {
                inputMethodManager.hideSoftInputFromWindow(focus.getWindowToken(), 2);
            } else {
                activity.getWindow().setSoftInputMode(3);
            }
        }
    }

    public static void setupUIHideKeyBoard(final Activity activity, View view) {
        if (!(view instanceof EditText)) {
            view.setOnTouchListener(new View.OnTouchListener(){

                @SuppressLint(value={"ClickableViewAccessibility"})
                public boolean onTouch(View v, MotionEvent event) {
                    UtilsCore.hideSoftKeyboard(activity);
                    return false;
                }
            });
        }
        if (view instanceof ViewGroup) {
            for (int i = 0; i < ((ViewGroup)view).getChildCount(); ++i) {
                View innerView = ((ViewGroup)view).getChildAt(i);
                UtilsCore.setupUIHideKeyBoard(activity, innerView);
            }
        }
    }

    public static int getScreenWidth(Context context) {
        DisplayMetrics metrics = context.getResources().getDisplayMetrics();
        return metrics.widthPixels;
    }

    public static int getScreenHeight(Context context) {
        DisplayMetrics metrics = context.getResources().getDisplayMetrics();
        return metrics.heightPixels;
    }

    public static boolean isOnline(Context ctx) {
        try {
            if (!UtilsCore.isPermissionGranted(ctx, "android.permission.ACCESS_WIFI_STATE")) {
                return true;
            }
            ConnectivityManager cm = (ConnectivityManager)ctx.getSystemService("connectivity");
            NetworkInfo netInfo = cm.getActiveNetworkInfo();
            if (netInfo != null && netInfo.isConnectedOrConnecting()) {
                return true;
            }
        }
        catch (Exception e) {
            return true;
        }
        return false;
    }

    public static boolean isConnectedWifi(Context ctx) {
        if (!UtilsCore.isPermissionGranted(ctx, "android.permission.ACCESS_WIFI_STATE")) {
            return true;
        }
        ConnectivityManager cm = (ConnectivityManager)ctx.getSystemService("connectivity");
        NetworkInfo info = cm.getActiveNetworkInfo();
        return info != null && info.isConnected() && info.getType() == 1;
    }

    public static boolean isConnectedMobile(Context ctx) {
        if (!UtilsCore.isPermissionGranted(ctx, "android.permission.ACCESS_WIFI_STATE")) {
            return true;
        }
        ConnectivityManager cm = (ConnectivityManager)ctx.getSystemService("connectivity");
        NetworkInfo info = cm.getActiveNetworkInfo();
        return info != null && info.isConnected() && info.getType() == 0;
    }

    public static final String md5(String s) {
        String MD5 = "MD5";
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            digest.update(s.getBytes());
            byte[] messageDigest = digest.digest();
            StringBuilder hexString = new StringBuilder();
            for (byte aMessageDigest : messageDigest) {
                String h = Integer.toHexString(0xFF & aMessageDigest);
                while (h.length() < 2) {
                    h = "0" + h;
                }
                hexString.append(h);
            }
            return hexString.toString();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] fileToByArray(File file) throws IOException {
        ByteArrayOutputStream ous = null;
        InputStream ios = null;
        try {
            byte[] buffer = new byte[4096];
            ous = new ByteArrayOutputStream();
            ios = new FileInputStream(file);
            int read = 0;
            while ((read = ios.read(buffer)) != -1) {
                ous.write(buffer, 0, read);
            }
        }
        finally {
            try {
                if (ous != null) {
                    ous.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (ios != null) {
                    ios.close();
                }
            }
            catch (IOException iOException) {}
        }
        return ous.toByteArray();
    }

    public static int getScreenOrientation(WindowManager wmgr) {
        int orientation;
        int rotation = wmgr.getDefaultDisplay().getRotation();
        DisplayMetrics dm = new DisplayMetrics();
        wmgr.getDefaultDisplay().getMetrics(dm);
        int width = dm.widthPixels;
        int height = dm.heightPixels;
        if ((rotation == 0 || rotation == 2) && height > width || (rotation == 1 || rotation == 3) && width > height) {
            switch (rotation) {
                case 0: {
                    orientation = 1;
                    break;
                }
                case 1: {
                    orientation = 0;
                    break;
                }
                case 2: {
                    orientation = Build.VERSION.SDK_INT >= 9 ? 9 : 1;
                    break;
                }
                case 3: {
                    orientation = Build.VERSION.SDK_INT >= 9 ? 8 : 0;
                    break;
                }
                default: {
                    orientation = 1;
                    break;
                }
            }
        } else {
            switch (rotation) {
                case 0: {
                    orientation = 0;
                    break;
                }
                case 1: {
                    orientation = 1;
                    break;
                }
                case 2: {
                    orientation = Build.VERSION.SDK_INT >= 9 ? 8 : 0;
                    break;
                }
                case 3: {
                    orientation = Build.VERSION.SDK_INT >= 9 ? 9 : 1;
                    break;
                }
                default: {
                    orientation = 0;
                }
            }
        }
        return orientation;
    }

    public static void showConfirmDialog(Context context, String title, String message, String leftText, String rightText, DialogInterface.OnClickListener leftListener, DialogInterface.OnClickListener righClickListener) {
        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        if (title != null) {
            builder.setTitle((CharSequence)title);
        }
        builder.setMessage((CharSequence)message);
        if (!TextUtils.isEmpty((CharSequence)leftText)) {
            builder.setPositiveButton((CharSequence)leftText, leftListener);
        }
        if (!TextUtils.isEmpty((CharSequence)rightText)) {
            builder.setNegativeButton((CharSequence)rightText, righClickListener);
        }
        builder.show();
    }

    public static boolean isGingerBread() {
        Log.i("shareerror", "SDK_INT: " + Build.VERSION.SDK_INT);
        return Build.VERSION.SDK_INT <= 10;
    }

    public static boolean isKitKat() {
        Log.i("shareerror", "SDK_INT: " + Build.VERSION.SDK_INT);
        return Build.VERSION.SDK_INT == 19;
    }

    public static float convertDpToPixel(float dp, Context context) {
        Resources resources = context.getResources();
        DisplayMetrics metrics = resources.getDisplayMetrics();
        float px = dp * ((float)metrics.densityDpi / 160.0f);
        return px;
    }

    public static float convertPixelsToDp(float px, Context context) {
        Resources resources = context.getResources();
        DisplayMetrics metrics = resources.getDisplayMetrics();
        float dp = px / ((float)metrics.densityDpi / 160.0f);
        return dp;
    }

    public static int getResourceId(Context context, String variableName, String resourcename) {
        try {
            int id = context.getResources().getIdentifier(variableName, resourcename, context.getPackageName());
            return id;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public static String getFormatStringPhoneNumber(String phoneNumber, String countryCode) {
        StringBuffer bf = new StringBuffer();
        if ("84".equalsIgnoreCase(countryCode) && "0".equalsIgnoreCase(phoneNumber.substring(0, 1))) {
            phoneNumber = phoneNumber.substring(1);
        }
        int loop = phoneNumber.length() / 3;
        for (int i = 0; i < loop - 1; ++i) {
            bf.append(phoneNumber.substring(i * 3, i * 3 + 3)).append(" ");
        }
        bf.append(phoneNumber.substring((loop - 1) * 3, phoneNumber.length()));
        return bf.toString();
    }
}

