/*
 * Decompiled with CFR 0.152.
 */
package com.zing.zalo.libevenbus;

import com.zing.zalo.libevenbus.PendingPost;

final class PendingPostQueue {
    private PendingPost head;
    private PendingPost tail;

    PendingPostQueue() {
    }

    synchronized void enqueue(PendingPost pendingPost) {
        if (pendingPost == null) {
            throw new NullPointerException("null cannot be enqueued");
        }
        if (this.tail != null) {
            this.tail.next = pendingPost;
            this.tail = pendingPost;
        } else if (this.head == null) {
            this.head = this.tail = pendingPost;
        } else {
            throw new IllegalStateException("Head present, but no tail");
        }
        this.notifyAll();
    }

    synchronized PendingPost poll() {
        PendingPost pendingPost = this.head;
        if (this.head != null) {
            this.head = this.head.next;
            if (this.head == null) {
                this.tail = null;
            }
        }
        return pendingPost;
    }

    synchronized PendingPost poll(int maxMillisToWait) throws InterruptedException {
        if (this.head == null) {
            this.wait(maxMillisToWait);
        }
        return this.poll();
    }
}

