/*
 * Decompiled with CFR 0.152.
 */
package com.zing.zalo.libevenbus;

import com.zing.zalo.libevenbus.EventBus;
import com.zing.zalo.libevenbus.PendingPost;
import com.zing.zalo.libevenbus.PendingPostQueue;
import com.zing.zalo.libevenbus.Subscription;

class AsyncPoster
implements Runnable {
    private final PendingPostQueue queue;
    private final EventBus eventBus;

    AsyncPoster(EventBus eventBus) {
        this.eventBus = eventBus;
        this.queue = new PendingPostQueue();
    }

    public void enqueue(Subscription subscription, Object event) {
        PendingPost pendingPost = PendingPost.obtainPendingPost(subscription, event);
        this.queue.enqueue(pendingPost);
        this.eventBus.getExecutorService().execute(this);
    }

    @Override
    public void run() {
        PendingPost pendingPost = this.queue.poll();
        if (pendingPost == null) {
            throw new IllegalStateException("No pending post available");
        }
        this.eventBus.invokeSubscriber(pendingPost);
    }
}

