/*
 * Decompiled with CFR 0.152.
 */
package com.zing.zalo.devicetrackingsdk;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class ZPermissionManager {
    public static boolean isClassExist(String clssName) {
        try {
            Class.forName(clssName);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return true;
    }

    public static boolean isAbleRun() {
        String className = "android.support.v4.content.ContextCompat";
        if (ZPermissionManager.isClassExist(className)) {
            try {
                boolean isMethodExist = ZPermissionManager.methodExists(Class.forName(className), "checkSelfPermission");
                if (isMethodExist) {
                    String classNameActivity = "android.support.v4.app.ActivityCompat";
                    if (ZPermissionManager.isClassExist(classNameActivity)) {
                        try {
                            boolean isMethodExistActivityCompat = ZPermissionManager.methodExists(Class.forName(classNameActivity), "requestPermissions");
                            return isMethodExistActivityCompat;
                        }
                        catch (ClassNotFoundException e) {
                            return false;
                        }
                    }
                    return false;
                }
                return false;
            }
            catch (ClassNotFoundException e) {
                return false;
            }
        }
        return false;
    }

    public static boolean methodExists(Class clazz, String methodName) {
        boolean result = false;
        for (Method method : clazz.getDeclaredMethods()) {
            if (!method.getName().equals(methodName)) continue;
            result = true;
            break;
        }
        return result;
    }

    public static boolean isPermissionGranted(Context context, String permission2) {
        if (!ZPermissionManager.isAbleRun()) {
            return true;
        }
        try {
            int permissionCheck = ContextCompat.checkSelfPermission((Context)context, (String)permission2);
            if (permissionCheck == 0) {
                return true;
            }
        }
        catch (Exception ex) {
            return true;
        }
        return false;
    }

    public static boolean shouldShowRequestPermissionRationale(Activity activity, String permission2) {
        if (!ZPermissionManager.isAbleRun()) {
            return false;
        }
        try {
            if (ContextCompat.checkSelfPermission((Context)activity, (String)permission2) != 0 && ActivityCompat.shouldShowRequestPermissionRationale((Activity)activity, (String)permission2)) {
                return true;
            }
        }
        catch (Exception ex) {
            return false;
        }
        return false;
    }

    public static void requestPermission(Activity activity, String permission2, int requestCode) {
        if (!ZPermissionManager.isAbleRun()) {
            return;
        }
        try {
            if (ContextCompat.checkSelfPermission((Context)activity, (String)permission2) != 0) {
                ActivityCompat.requestPermissions((Activity)activity, (String[])new String[]{permission2}, (int)requestCode);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void requestPermission(Activity activity, String[] permissions, int requestCode) {
        if (!ZPermissionManager.isAbleRun()) {
            return;
        }
        try {
            ArrayList<String> arrPermission = new ArrayList<String>();
            for (int i = 0; i < permissions.length; ++i) {
                if (ContextCompat.checkSelfPermission((Context)activity, (String)permissions[i]) == 0) continue;
                arrPermission.add(permissions[i]);
            }
            if (arrPermission.size() > 0) {
                ActivityCompat.requestPermissions((Activity)activity, (String[])arrPermission.toArray(new String[arrPermission.size()]), (int)requestCode);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isAndroidMOrHigher() {
        return Build.VERSION.SDK_INT >= 23;
    }

    public static interface OnRequestPermissionListener {
        public void OnRequestPermissionCallback(int var1, String[] var2, int[] var3);
    }
}

