/*
 * Decompiled with CFR 0.152.
 */
package com.zing.zalo.devicetrackingsdk;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Environment;
import android.text.TextUtils;
import com.zing.zalo.devicetrackingsdk.ZPermissionManager;
import com.zing.zalo.devicetrackingsdk.model.DeviceId4AdsInfo;
import com.zing.zalo.devicetrackingsdk.model.DeviceIdInfo;
import com.zing.zalo.devicetrackingsdk.model.SDKIDInfo;
import com.zing.zalo.zalosdk.core.helper.Storage;
import com.zing.zalo.zalosdk.core.log.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.Date;
import org.json.JSONException;
import org.json.JSONObject;

public class BaseAppInfoStorage
extends Storage {
    private final String PREF_OAUTH_CODE = "PREFERECE_ZALO_SDK_OAUTH_CODE";
    private final String PREF_OAUTH_CODE_CHANNEL = "PREFERECE_ZALO_SDK_OAUTH_CODE_CHANNEL";
    private final String PREF_ZALO_ID = "PREFERECE_ZALO_SDK_ZALO_ID";
    private final String PREF_ZALO_ID_NOTI = "PREFERECE_ZALO_SDK_ZALO_ID_NOTI";
    private final String PREF_ZALO_DISPLAY_NAME = "PREFERECE_ZALO_SDK_ZALO_DISPLAY_NAME";
    private final String PREF_ACESS_TOKEN = "PREF_ACESS_TOKEN";
    private final String PREF_SDK_ID = "PREF_SDK_ID";
    private final String PREF_PRIVATE_KEY = "PREF_PRIVATE_KEY";
    private final String PREF_GUEST_DEVICE_ID = "PREF_GUEST_DEVICE_ID";
    private final String PREF_GUEST_IS_CERT = "PREF_GUEST_IS_CERTIFICATE";
    private final String PREF_IS_PROTECTED = "PREF_IS_PROTECTED";
    private final String PREF_GCM_TOKEN = "PREF_GCM_TOKEN";
    private final String PREF_APP_VERSION_NOTI = "PREF_APP_VERSION_NOTI";
    private final String PREF_OSV = "PREF_APP_VERSION";
    private final String PREF_APP_USER = "PREF_APP_USER";
    private final String PREF_LOGIN_CHANNEL = "PREF_LOGIN_CHANNEL";
    private final String PREF_DISTRIBUTION_RESOURCE = "PREF_DISTRIBUTION_RESOURCE";
    private final String PREF_APP_UTM_SOURCE = "PREF_APP_UTM_SOURCE";
    private final String PREF_TRACKING_APP_INSTALL_EXP_TIME = "PREF_TRACKING_APP_INSTALL_EXP_TIME";
    private static final String DID_FILE_NAME = "ddinfo2";
    private static final String DID4ADS_FILE_NAME = "ddinfo4ads";
    private static final String SELF_ID_FILE = "self_id_file";
    private DeviceIdInfo deviceIdInfo = new DeviceIdInfo();
    private DeviceId4AdsInfo deviceId4AdsInfo = new DeviceId4AdsInfo();
    private SDKIDInfo sdkIdInfo = new SDKIDInfo();
    private String sdkVersion = "1.1.0826";
    private String self_id = this.readFromFile(this.context, "self_id_file");

    public BaseAppInfoStorage(Context c) {
        super(c);
        if (TextUtils.isEmpty((CharSequence)this.self_id)) {
            this.self_id = String.valueOf(new Date().getTime());
            this.writeToFile(this.context, this.self_id, SELF_ID_FILE);
        }
    }

    public void loadDeviceId() {
        this.deviceIdInfo = new DeviceIdInfo();
        String obj = this.readFromFile(this.context, DID_FILE_NAME);
        if (!TextUtils.isEmpty((CharSequence)obj)) {
            try {
                JSONObject data = new JSONObject(obj);
                this.deviceIdInfo.setDeviceId(data.optString("deviceId"));
                this.deviceIdInfo.setDeviceIdExpiredTime(data.optLong("expiredTime"));
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        Log.v("Loaded device info: " + this.deviceIdInfo.toString());
    }

    public void loadDeviceId4Ads() {
        this.deviceId4AdsInfo = new DeviceId4AdsInfo();
        String obj = this.readFromFile(this.context, DID4ADS_FILE_NAME);
        if (!TextUtils.isEmpty((CharSequence)obj)) {
            try {
                JSONObject data = new JSONObject(obj);
                this.deviceId4AdsInfo.setDeviceId4Ads(data.optString("zaId"));
                this.deviceId4AdsInfo.setDeviceId4AdsExpiredTime(data.optLong("expiredTime"));
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        Log.v("Loaded device4Ads info: " + this.deviceId4AdsInfo.toString());
    }

    public void loadSDKId() {
        if (this.sdkIdInfo == null) {
            this.sdkIdInfo = new SDKIDInfo();
        }
        this.sdkIdInfo.setSdkId(this.localPref.getString("PREF_SDK_ID", ""));
        this.sdkIdInfo.setPrivateKey(this.localPref.getString("PREF_PRIVATE_KEY", ""));
        Log.v("Loaded sdk info: " + this.sdkIdInfo.toString());
    }

    public String getSDKId() {
        return this.sdkIdInfo.getSdkId();
    }

    public String getPrivateKey() {
        return this.sdkIdInfo.getPrivateKey();
    }

    public String getDeviceId() {
        return this.deviceIdInfo.getDeviceId();
    }

    public long getDeviceIdExpiredTime() {
        return this.deviceIdInfo.getDeviceIdExpiredTime();
    }

    public String getDeviceId4Ads() {
        return this.deviceId4AdsInfo.getDeviceId4Ads();
    }

    public long getDeviceId4AdsExpiredTime() {
        return this.deviceId4AdsInfo.getDeviceIdExpiredTime();
    }

    public void setDeviceId(String deviceId, long expiredTime) {
        this.deviceIdInfo.setDeviceId(deviceId);
        this.deviceIdInfo.setDeviceIdExpiredTime(expiredTime);
        this.writeToFile(this.context, "{\"deviceId\":\"" + deviceId + "\",\"expiredTime\":\"" + expiredTime + "\"}", DID_FILE_NAME);
        Log.v("write device info: " + this.deviceIdInfo.toString());
    }

    public void setDeviceId4Ads(String deviceId4Ads, long expiredTime) {
        this.deviceId4AdsInfo.setDeviceId4Ads(deviceId4Ads);
        this.deviceId4AdsInfo.setDeviceId4AdsExpiredTime(expiredTime);
        this.writeToFile(this.context, "{\"zaId\":\"" + deviceId4Ads + "\",\"expiredTime\":\"" + expiredTime + "\"}", DID4ADS_FILE_NAME);
        Log.v("write device4Ads info: " + this.deviceId4AdsInfo.toString());
    }

    public void setAppUser(String appUser) {
        this.setString("PREF_APP_USER", appUser);
    }

    public String getAppUser() {
        return this.getString("PREF_APP_USER");
    }

    public void setLoginChannel(String loginChannel) {
        this.setString("PREF_LOGIN_CHANNEL", loginChannel);
    }

    public String getLoginChannel() {
        return this.localPref.getString("PREF_LOGIN_CHANNEL", "");
    }

    public String getAppUTMSource() {
        return this.localPref.getString("PREF_APP_UTM_SOURCE", "");
    }

    public void setAppUTMSource(String appUTMSource) {
        this.setString("PREF_APP_UTM_SOURCE", appUTMSource);
    }

    public String getDistributionSource() {
        return this.getString("PREF_DISTRIBUTION_RESOURCE");
    }

    public void setDistributionSource(String distributionSource) {
        this.setString("PREF_DISTRIBUTION_RESOURCE", distributionSource);
    }

    public void setSDKId(String sdkId, String privateKey) {
        this.setString("PREF_SDK_ID", sdkId);
        this.setString("PREF_PRIVATE_KEY", privateKey);
        this.loadSDKId();
        Log.v("write sdkid info: " + this.sdkIdInfo.toString());
    }

    public String getGuestDeviceId() {
        return this.getString("PREF_GUEST_DEVICE_ID");
    }

    public void setGuestDeviceId(String id) {
        this.setString("PREF_GUEST_DEVICE_ID", id);
    }

    public int getIsProtected() {
        return this.getInt("PREF_IS_PROTECTED");
    }

    public void setIsProtected(int isProtected) {
        this.setInt("PREF_IS_PROTECTED", isProtected);
    }

    public String getGCMToken() {
        return this.localPref.getString("PREF_GCM_TOKEN", "");
    }

    public int getAppVersion() {
        return this.localPref.getInt("PREF_APP_VERSION_NOTI", Integer.MIN_VALUE);
    }

    public String getOSV() {
        return this.localPref.getString("PREF_APP_VERSION", "");
    }

    public void storeRegistrationId(String token, int appVer, String osv, long zaloId) {
        SharedPreferences.Editor edit = this.localPref.edit();
        edit.putString("PREF_GCM_TOKEN", token);
        edit.putInt("PREF_APP_VERSION_NOTI", appVer);
        edit.putString("PREF_APP_VERSION", osv);
        edit.putLong("PREFERECE_ZALO_SDK_ZALO_ID_NOTI", zaloId);
        edit.commit();
    }

    public int getIsGuestCertificated() {
        return this.getInt("PREF_GUEST_IS_CERTIFICATE");
    }

    public void setIsGuestCertificated(int isCert) {
        this.setInt("PREF_GUEST_IS_CERTIFICATE", isCert);
    }

    public long getTrackingAppInstallExpireTime() {
        return this.getLong("PREF_TRACKING_APP_INSTALL_EXP_TIME");
    }

    public void setTrackingAppInstallExpireTime(long expiredTime) {
        this.setLong("PREF_TRACKING_APP_INSTALL_EXP_TIME", expiredTime);
    }

    private File prepareFileInExternalStore(String fileName, boolean clearIfExists) {
        String path = Environment.getExternalStorageDirectory().getAbsolutePath() + "/Android/data/com.google.android.zdt.data/" + fileName;
        File f = new File(path);
        f.getParentFile().mkdirs();
        if (clearIfExists && f.exists()) {
            f.delete();
        }
        return f;
    }

    private void writeToFile(Context context, String content, String filename) {
        try {
            if (this.isExternalStorageWritable()) {
                File f = this.prepareFileInExternalStore(filename, true);
                f.createNewFile();
                FileOutputStream fos = new FileOutputStream(f);
                OutputStreamWriter streamWriter = new OutputStreamWriter(fos);
                streamWriter.write(content);
                streamWriter.close();
                fos.close();
                Log.v("write file " + filename + " to external storage");
                return;
            }
        }
        catch (Exception e) {
            Log.e(e);
        }
        try {
            FileOutputStream fos = context.openFileOutput(filename, 0);
            OutputStreamWriter streamWriter = new OutputStreamWriter(fos);
            streamWriter.write(content);
            streamWriter.close();
            fos.close();
            Log.v("write file " + filename + " to internal storage");
            return;
        }
        catch (Exception e) {
            Log.e(e);
            Log.v("can't write file " + filename);
            return;
        }
    }

    public boolean ispreInstalled() {
        try {
            if (this.isExternalStorageReadable()) {
                File file = this.prepareFileInExternalStore(this.context.getPackageName(), false);
                if (file.exists()) {
                    return true;
                }
                file.createNewFile();
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    private String readFromFile(Context context, String filename) {
        try {
            File file;
            if (this.isExternalStorageReadable() && (file = this.prepareFileInExternalStore(filename, false)).exists()) {
                FileInputStream fis = new FileInputStream(file);
                InputStreamReader inputStreamReader = new InputStreamReader(fis);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                String receiveString = "";
                StringBuilder stringBuilder = new StringBuilder(256);
                while ((receiveString = bufferedReader.readLine()) != null) {
                    stringBuilder.append(receiveString);
                }
                fis.close();
                Log.v("read file " + filename + " from external storage");
                return stringBuilder.toString();
            }
        }
        catch (Exception e) {
            Log.e(e);
        }
        try {
            FileInputStream fis = context.openFileInput(filename);
            InputStreamReader inputStreamReader = new InputStreamReader(fis);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String receiveString = "";
            StringBuilder stringBuilder = new StringBuilder(256);
            while ((receiveString = bufferedReader.readLine()) != null) {
                stringBuilder.append(receiveString);
            }
            fis.close();
            Log.v("read file " + filename + " from internal storage");
            return stringBuilder.toString();
        }
        catch (FileNotFoundException ex) {
            Log.v("ZDK", "file %s not found in internal storage", filename);
        }
        catch (Exception e) {
            Log.e(e);
        }
        Log.v("can't read file " + filename);
        return null;
    }

    public boolean isExternalStorageWritable() {
        boolean hasPermission = ZPermissionManager.isPermissionGranted(this.context, "android.permission.WRITE_EXTERNAL_STORAGE");
        if (!hasPermission) {
            return false;
        }
        String state = Environment.getExternalStorageState();
        return "mounted".equals(state);
    }

    public boolean isExternalStorageReadable() {
        boolean hasPermission = ZPermissionManager.isPermissionGranted(this.context, "android.permission.WRITE_EXTERNAL_STORAGE");
        if (!hasPermission) {
            return false;
        }
        String state = Environment.getExternalStorageState();
        return "mounted".equals(state) || "mounted_ro".equals(state);
    }

    public String getOAuthCode() {
        return this.getString("PREFERECE_ZALO_SDK_OAUTH_CODE");
    }

    public String getLastestLoginChannel() {
        return this.getString("PREFERECE_ZALO_SDK_OAUTH_CODE_CHANNEL");
    }

    public void setOAuthCode(String channel, String code) {
        this.setString("PREFERECE_ZALO_SDK_OAUTH_CODE_CHANNEL", channel);
        this.setString("PREFERECE_ZALO_SDK_OAUTH_CODE", code);
    }

    public String getZMOAuthCode() {
        SharedPreferences preferences = this.context.getSharedPreferences("zacPref", 0);
        String zmoauth = preferences.getString("zmoauth", "");
        return zmoauth;
    }

    public long getZaloIdNoti() {
        return this.getLong("PREFERECE_ZALO_SDK_ZALO_ID_NOTI");
    }

    public long getZaloId() {
        return this.getLong("PREFERECE_ZALO_SDK_ZALO_ID");
    }

    public void setZaloId(long id) {
        this.setLong("PREFERECE_ZALO_SDK_ZALO_ID", id);
    }

    public String getZaloDisplayName() {
        return this.getString("PREFERECE_ZALO_SDK_ZALO_DISPLAY_NAME");
    }

    public void setZaloDisplayName(String displayname) {
        this.setString("PREFERECE_ZALO_SDK_ZALO_DISPLAY_NAME", displayname);
    }

    public String getAccessToken() {
        return this.getString("PREF_ACESS_TOKEN");
    }

    public void setAccessToken(String token) {
        this.setString("PREF_ACESS_TOKEN", token);
    }

    public String getSDKVersion() {
        return this.sdkVersion;
    }

    public void setSDKVersion(String sdkVersion) {
        this.sdkVersion = sdkVersion;
    }

    public String getSelfId() {
        return this.self_id;
    }
}

