/*
 * Decompiled with CFR 0.152.
 */
package com.zing.zalo.devicetrackingsdk;

import android.annotation.TargetApi;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.Point;
import android.location.Location;
import android.location.LocationManager;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.view.Display;
import android.view.WindowManager;
import com.zing.zalo.devicetrackingsdk.AppTracker;
import com.zing.zalo.devicetrackingsdk.AppUserDataCallback;
import com.zing.zalo.devicetrackingsdk.BaseAppInfoStorage;
import com.zing.zalo.devicetrackingsdk.ZPermissionManager;
import com.zing.zalo.zalosdk.core.helper.Utils;
import com.zing.zalo.zalosdk.core.http.HttpClientRequest;
import com.zing.zalo.zalosdk.core.log.Log;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.json.JSONException;
import org.json.JSONObject;

public class BaseAppInfo
implements Handler.Callback {
    private static final int ACT_LOAD = 16384;
    private static final int ACT_GEN = 16385;
    private static final int ACT_GEN_SDK_ID = 16386;
    private static final int ACT_GEN_DEVICE_ID_4ADS = 16387;
    private BaseAppInfoStorage storage;
    private Context context;
    private String pl;
    private String osv;
    private String conn;
    private String an;
    private String av;
    private String mno;
    private String dId;
    private String aId;
    private String ser;
    private String mod;
    private String ss;
    private String mac;
    private String pkg;
    private String adId;
    private String ins_pkg;
    private String ref;
    private String ins_dte;
    private String fst_ins_dte;
    private String lst_ins_dte;
    private String fst_run_dte;
    private String avc;
    private String was_ins;
    private String lat;
    private String lng;
    private String ap;
    HandlerThread thread;
    Handler handler;
    private boolean isInitialized;
    private boolean isGeneratingDeviceId4Ads;
    private boolean isGeneratingDeviceId;
    private boolean isGeneratingSDKId;
    private boolean isSubmitingOauthStat;
    List<GetInfoListener> infoListeners;
    String appID;

    public String getAn() {
        return this.an;
    }

    public String getAv() {
        return this.av;
    }

    public BaseAppInfo(Context context, BaseAppInfoStorage storage, String _appID) {
        this.storage = storage;
        this.context = context;
        this.appID = _appID;
        this.infoListeners = new ArrayList<GetInfoListener>();
        this.fst_run_dte = String.valueOf(System.currentTimeMillis());
        this.sendMessage(16384);
    }

    public String getSDKId() {
        return this.storage.getSDKId();
    }

    public String getPrivateKey() {
        String privateKey = this.storage.getPrivateKey();
        if (!TextUtils.isEmpty((CharSequence)privateKey)) {
            return privateKey;
        }
        if (!this.isGeneratingSDKId) {
            this.isGeneratingSDKId = true;
            this.sendMessage(16386);
        }
        return null;
    }

    public String getDeviceId() {
        if (this.isDeviceIdValid()) {
            Log.v("device id still valid " + this.storage.getDeviceId());
            return this.storage.getDeviceId();
        }
        if (this.isInitialized && !this.isGeneratingDeviceId) {
            this.sendMessage(16385);
        }
        return null;
    }

    public void generateSDKID() {
        this.storage.setSDKId("", "");
        this.sendMessage(16384);
    }

    public String getDeviceId(GetInfoListener getDeviceIdListener) {
        if (this.isDeviceIdValid()) {
            Log.v("device id still valid " + this.storage.getDeviceId());
            return this.storage.getDeviceId();
        }
        if (this.infoListeners != null) {
            this.infoListeners.add(getDeviceIdListener);
        }
        if (this.isInitialized && !this.isGeneratingDeviceId) {
            this.sendMessage(16385);
        }
        return null;
    }

    public JSONObject prepareDeviceIdData() {
        JSONObject data = new JSONObject();
        try {
            data.put("dId", (Object)this.dId);
            data.put("aId", (Object)this.aId);
            data.put("ser", (Object)this.ser);
            data.put("mod", (Object)this.mod);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return data;
    }

    public JSONObject prepareTrackingData() {
        JSONObject data = new JSONObject();
        try {
            this.conn = Utils.getConnectionType(this.context);
            data.put("pkg", (Object)this.pkg);
            data.put("pl", (Object)this.pl);
            data.put("osv", (Object)this.osv);
            data.put("sdkv", (Object)this.storage.getSDKVersion());
            data.put("an", (Object)this.an);
            data.put("av", (Object)this.av);
            data.put("dId", (Object)this.dId);
            data.put("aId", (Object)this.aId);
            data.put("ser", (Object)this.ser);
            data.put("mod", (Object)this.mod);
            data.put("ss", (Object)this.ss);
            data.put("mac", (Object)this.mac);
            data.put("conn", (Object)this.conn);
            data.put("mno", (Object)this.mno);
            data.put("sId", (Object)this.storage.getDeviceId());
            data.put("adId", (Object)this.adId);
            data.put("ins_pkg", (Object)this.ins_pkg);
            data.put("ref", (Object)this.ref);
            data.put("ins_dte", (Object)this.ins_dte);
            data.put("fst_ins_dte", (Object)this.fst_ins_dte);
            data.put("lst_ins_dte", (Object)this.lst_ins_dte);
            data.put("fst_run_dte", (Object)this.fst_run_dte);
            data.put("dist_src", (Object)this.storage.getDistributionSource());
            data.put("ts", (Object)String.valueOf(new Date().getTime()));
            data.put("brd", (Object)Build.BRAND);
            data.put("dev", (Object)Build.DEVICE);
            data.put("prd", (Object)Build.PRODUCT);
            data.put("adk_ver", Build.VERSION.SDK_INT);
            data.put("mnft", (Object)Build.MANUFACTURER);
            data.put("dev_type", (Object)Build.TYPE);
            data.put("avc", (Object)this.avc);
            data.put("was_ins", (Object)this.was_ins);
            data.put("lang", (Object)Locale.getDefault().toString());
            data.put("tz", (Object)TimeZone.getDefault().getDisplayName(Locale.getDefault()));
            data.put("lat", (Object)this.lat);
            data.put("lng", (Object)this.lng);
            data.put("dpi", (double)this.context.getResources().getDisplayMetrics().density);
            data.put("lc", (Object)this.storage.getLoginChannel());
            data.put("utm_src", (Object)this.storage.getAppUTMSource());
            data.put("ap", (Object)this.ap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return data;
    }

    private boolean isDeviceIdValid() {
        if (!this.isInitialized) {
            return false;
        }
        String deviceId = this.storage.getDeviceId();
        long expiredTime = this.storage.getDeviceIdExpiredTime();
        return expiredTime > System.currentTimeMillis() && !deviceId.equals("");
    }

    private synchronized void sendMessage(int what) {
        if (this.handler == null) {
            this.thread = new HandlerThread("zdt-device-tracker", 5);
            this.thread.start();
            this.handler = new Handler(this.thread.getLooper(), (Handler.Callback)this);
            Log.v("start device tracker thread");
        }
        Message msg = new Message();
        msg.what = what;
        this.handler.sendMessage(msg);
    }

    public boolean handleMessage(Message msg) {
        switch (msg.what) {
            case 16384: {
                this.loadDeviceId();
                this.loadSDKId();
                String sdkId = this.storage.getSDKId();
                String privateKey = this.storage.getPrivateKey();
                if (TextUtils.isEmpty((CharSequence)sdkId) || TextUtils.isEmpty((CharSequence)privateKey)) {
                    this.generateSDKId();
                }
                AppTracker tracker = new AppTracker(this.context, this.storage, this.appID, this);
                break;
            }
            case 16385: {
                this.generateDeviceId();
                break;
            }
            case 16386: {
                this.generateSDKId();
                break;
            }
            case 16387: {
                this.generateDeviceId4Ads();
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private void loadSDKId() {
        this.storage.loadSDKId();
    }

    private void loadDeviceId() {
        this.storage.loadDeviceId();
        this.storage.loadDeviceId4Ads();
        this.prepareDeviceInfo();
        this.isInitialized = true;
        this.getDeviceId();
        this.getDeviceId4Ads();
    }

    @TargetApi(value=13)
    private void prepareDeviceInfo() {
        try {
            PackageManager pm = this.context.getPackageManager();
            String packageName = this.context.getPackageName();
            ApplicationInfo ai = pm.getApplicationInfo(packageName, 0);
            PackageInfo pInfo = pm.getPackageInfo(packageName, 0);
            this.pkg = packageName;
            this.pl = "android";
            this.osv = Build.VERSION.RELEASE;
            this.an = URLEncoder.encode(String.valueOf(ai.loadLabel(pm)), "UTF-8");
            this.av = pInfo.versionName;
            this.aId = Settings.Secure.getString((ContentResolver)this.context.getContentResolver(), (String)"android_id");
            if (Build.VERSION.SDK_INT >= 9) {
                this.ser = Build.SERIAL;
            }
            this.mod = Build.MODEL;
            WindowManager wm = (WindowManager)this.context.getSystemService("window");
            Display display = wm.getDefaultDisplay();
            if (Build.VERSION.SDK_INT >= 13) {
                Point point = new Point();
                display.getSize(point);
                this.ss = point.x + "x" + point.y;
            } else {
                this.ss = display.getWidth() + "x" + display.getHeight();
            }
            this.mac = Utils.getWLANMACAddress(this.context);
            this.conn = Utils.getConnectionType(this.context);
            this.adId = Utils.getAdvertiseID(this.context);
            this.ins_pkg = pm.getInstallerPackageName(this.context.getPackageName());
            if (Build.VERSION.SDK_INT >= 9) {
                this.ins_dte = String.valueOf(pInfo.firstInstallTime);
                this.fst_ins_dte = String.valueOf(pInfo.firstInstallTime);
                this.lst_ins_dte = String.valueOf(pInfo.lastUpdateTime);
            } else {
                this.ins_dte = "";
                this.fst_ins_dte = "";
                this.lst_ins_dte = "";
            }
            this.avc = String.valueOf(pInfo.versionCode);
            this.was_ins = String.valueOf(this.storage.ispreInstalled());
            this.ap = "";
            PackageInfo lst = this.context.getPackageManager().getPackageInfo(this.context.getPackageName(), 4096);
            for (int i = 0; i < lst.requestedPermissions.length; ++i) {
                this.ap = this.ap + lst.requestedPermissions[i] + ";";
                if (!lst.requestedPermissions[i].equalsIgnoreCase("android.permission.ACCESS_FINE_LOCATION") && !lst.requestedPermissions[i].equalsIgnoreCase("android.permission.ACCESS_COARSE_LOCATION")) continue;
                try {
                    Location location;
                    LocationManager locationManager = (LocationManager)this.context.getSystemService("location");
                    if (locationManager == null || (location = locationManager.getLastKnownLocation("network")) == null) continue;
                    this.lat = String.valueOf(location.getLatitude());
                    this.lng = String.valueOf(location.getLongitude());
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (ZPermissionManager.isPermissionGranted(this.context, "android.permission.READ_PHONE_STATE")) {
                TelephonyManager tel = (TelephonyManager)this.context.getSystemService("phone");
                this.dId = tel.getDeviceId();
                this.mno = tel.getSimOperator();
            } else {
                this.dId = this.adId;
                this.mno = "unknown";
            }
            if (TextUtils.isEmpty((CharSequence)this.dId)) {
                this.dId = "unknown";
            }
        }
        catch (Exception e) {
            Log.e(e);
        }
    }

    private void generateSDKId() {
        this.isGeneratingSDKId = true;
        try {
            String referer;
            JSONObject deviceIdData = this.prepareDeviceIdData();
            String url = "https://centralized.zaloapp.com/sdk/mobile/android";
            HttpClientRequest request = new HttpClientRequest(HttpClientRequest.Type.POST, url);
            request.addParams("appId", this.appID);
            request.addParams("sdkv", this.storage.getSDKVersion());
            request.addParams("pl", "android");
            request.addParams("osv", this.osv);
            request.addParams("model", this.mod);
            request.addParams("screenSize", this.ss);
            request.addParams("device", deviceIdData.toString());
            this.ref = referer = this.context.getSharedPreferences("zacCookie", 0).getString("referrer", "");
            request.addParams("ref", referer);
            Log.v("Referer generateSDKId: " + referer);
            JSONObject jsonObject = request.getJSON();
            String sdkId = null;
            String privateKey = null;
            if (jsonObject != null) {
                Log.v("gen sdk id response " + jsonObject.toString());
                int errorCode = jsonObject.getInt("error");
                if (errorCode == 0) {
                    JSONObject data = jsonObject.getJSONObject("data");
                    sdkId = data.optString("sdkId");
                    privateKey = data.optString("privateKey");
                    this.storage.setSDKId(sdkId, privateKey);
                }
            } else {
                Log.v("gen sdk id resp null");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.isGeneratingSDKId = false;
    }

    private void generateDeviceId() {
        this.isGeneratingDeviceId = true;
        try {
            JSONObject deviceIdData = this.prepareDeviceIdData();
            JSONObject trackingData = this.prepareTrackingData();
            Date date = new Date();
            String appId = this.appID;
            String oauthCode = this.storage.getOAuthCode();
            String sdkId = this.getSDKId();
            if (sdkId == null) {
                sdkId = "";
            }
            String[] params = new String[]{"pl", "appId", "oauthCode", "device", "data", "ts", "sdkId"};
            String[] values = new String[]{"android", appId, oauthCode, deviceIdData.toString(), trackingData.toString(), "" + date.getTime(), sdkId};
            String sig = Utils.getSignature("https://centralized.zaloapp.com", "/id/mobile/android", params, values, "@#centralize#@");
            Log.v("Liem", "sig: " + sig);
            String url = "https://centralized.zaloapp.com/id/mobile/android";
            HttpClientRequest request = new HttpClientRequest(HttpClientRequest.Type.POST, url);
            request.addParams("pl", "android");
            request.addParams("appId", appId);
            request.addParams("oauthCode", oauthCode);
            request.addParams("device", deviceIdData.toString());
            request.addParams("data", trackingData.toString());
            request.addParams("ts", "" + date.getTime());
            request.addParams("sig", sig);
            request.addParams("sdkId", sdkId);
            Log.v("ZDK", "gen device id %s %s ", deviceIdData.toString(), trackingData.toString());
            JSONObject jsonObject = request.getJSON();
            String deviceId = null;
            long expiredTime = 0L;
            if (jsonObject != null) {
                Log.v("gen device id response " + jsonObject.toString());
                int errorCode = jsonObject.getInt("error");
                if (errorCode == 0) {
                    JSONObject data = jsonObject.getJSONObject("data");
                    deviceId = data.optString("deviceId");
                    expiredTime = data.optLong("expiredTime") + System.currentTimeMillis();
                    this.storage.setDeviceId(deviceId, expiredTime);
                    if (this.infoListeners != null) {
                        Iterator<GetInfoListener> i = this.infoListeners.iterator();
                        while (i.hasNext()) {
                            GetInfoListener getDeviceIdListener = i.next();
                            if (getDeviceIdListener == null) continue;
                            getDeviceIdListener.onGetDeviceIdComplete(deviceId);
                            i.remove();
                        }
                    }
                    this.getDeviceId4Ads();
                }
            } else {
                Log.v("gen device id resp null");
            }
        }
        catch (Exception ex) {
            Log.e(ex);
        }
        this.isGeneratingDeviceId = false;
    }

    private void generateDeviceId4Ads() {
        this.isGeneratingDeviceId4Ads = true;
        try {
            Date date = new Date();
            long genTime = date.getTime();
            JSONObject trackingData = this.prepareTrackingData4Ads();
            String[] params = new String[]{"pl", "data", "ts"};
            String[] values = new String[]{"android", trackingData.toString(), String.valueOf(genTime)};
            String sig = Utils.getSignature("https://centralized.zaloapp.com", "/zaid/mobile/android", params, values, "@#centralize#@");
            Log.i("debuglog", "sig: " + sig);
            String url = "https://centralized.zaloapp.com/zaid/mobile/android";
            HttpClientRequest request = new HttpClientRequest(HttpClientRequest.Type.POST, url);
            request.addParams("pl", "android");
            request.addParams("data", trackingData.toString());
            request.addParams("ts", "" + genTime);
            request.addParams("sig", sig);
            Log.i("debuglog", "gen device id 4Ads url: %s ", url);
            Log.i("debuglog", "gen device id 4Ads data: %s ", trackingData.toString());
            JSONObject jsonObject = request.getJSON();
            String deviceId4Ads = null;
            long expiredTime = 0L;
            if (jsonObject != null) {
                Log.i("debuglog", "gen device id 4Ads response " + jsonObject.toString());
                int errorCode = jsonObject.getInt("error");
                if (errorCode == 0) {
                    JSONObject data = jsonObject.getJSONObject("data");
                    deviceId4Ads = data.optString("zaId");
                    expiredTime = data.optLong("expiredTime") + System.currentTimeMillis();
                    this.storage.setDeviceId4Ads(deviceId4Ads, expiredTime);
                    if (this.infoListeners != null) {
                        Iterator<GetInfoListener> i = this.infoListeners.iterator();
                        while (i.hasNext()) {
                            GetInfoListener getDeviceIdListener = i.next();
                            if (getDeviceIdListener == null) continue;
                            getDeviceIdListener.onGetDeviceIdComplete(deviceId4Ads);
                            i.remove();
                        }
                    }
                }
            } else {
                Log.i("debuglog", "gen device id 4Ads resp null");
            }
        }
        catch (Exception ex) {
            Log.i("debuglog", "gen device id 4Ads exception====");
            ex.printStackTrace();
            Log.e(ex);
        }
        this.isGeneratingDeviceId4Ads = false;
    }

    public void submitAppUserData(final String appUser, final String loginChannel, final String distributionSource, final String appUTMSource, final AppUserDataCallback callback) {
        if (this.storage.getAppUser().equals(appUser) && this.storage.getLoginChannel().equals(loginChannel) && this.storage.getDistributionSource().equals(distributionSource) && this.storage.getAppUTMSource().equals(appUTMSource)) {
            return;
        }
        if (this.isSubmitingOauthStat) {
            return;
        }
        this.isSubmitingOauthStat = true;
        this.storage.setDistributionSource(distributionSource);
        this.storage.setLoginChannel(loginChannel);
        this.storage.setAppUser(appUser);
        this.storage.setAppUTMSource(appUTMSource);
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    String sdkId;
                    String url = "https://centralized.zaloapp.com/oauth/mobile/android";
                    HttpClientRequest request = new HttpClientRequest(HttpClientRequest.Type.POST, url);
                    request.addParams("appId", BaseAppInfo.this.appID);
                    request.addParams("pl", "android");
                    request.addParams("oauthCode", BaseAppInfo.this.storage.getOAuthCode());
                    String deviceId = BaseAppInfo.this.getDeviceId();
                    if (!TextUtils.isEmpty((CharSequence)deviceId)) {
                        request.addParams("zdId", deviceId);
                    }
                    if (!TextUtils.isEmpty((CharSequence)(sdkId = BaseAppInfo.this.getSDKId()))) {
                        request.addParams("sdkId", sdkId);
                    }
                    request.addParams("appUser", appUser);
                    request.addParams("distrSrc", distributionSource);
                    request.addParams("loginChannel", loginChannel);
                    request.addParams("utmSrc", appUTMSource);
                    JSONObject object = request.getJSON();
                    Log.d(object.toString());
                    int errorCode = object.getInt("error");
                    String errorMsg = object.getString("errorMsg");
                    if (callback != null) {
                        callback.onResult(errorCode, errorMsg);
                    }
                }
                catch (Exception exception) {
                }
                finally {
                    BaseAppInfo.this.isSubmitingOauthStat = false;
                }
            }
        }).start();
    }

    private boolean isDeviceId4AdsValid() {
        if (!this.isInitialized) {
            return false;
        }
        String deviceId4Ads = this.storage.getDeviceId4Ads();
        long expiredTime = this.storage.getDeviceId4AdsExpiredTime();
        return expiredTime > System.currentTimeMillis() && !deviceId4Ads.equals("");
    }

    public String getDeviceId4Ads() {
        if (this.isDeviceId4AdsValid()) {
            Log.v("device id 4Ads still valid " + this.storage.getDeviceId4Ads());
            return this.storage.getDeviceId4Ads();
        }
        if (this.isInitialized && !this.isGeneratingDeviceId4Ads && !TextUtils.isEmpty((CharSequence)this.storage.getDeviceId())) {
            this.sendMessage(16387);
        }
        return null;
    }

    public String getDeviceId4Ads(GetInfoListener listener) {
        if (this.isDeviceId4AdsValid()) {
            Log.v("device id 4Ads still valid " + this.storage.getDeviceId4Ads());
            return this.storage.getDeviceId4Ads();
        }
        if (this.isInitialized) {
            if (TextUtils.isEmpty((CharSequence)this.storage.getDeviceId())) {
                if (listener != null) {
                    listener.onGetDeviceIdComplete(null);
                }
                return null;
            }
            if (this.infoListeners != null && listener != null) {
                this.infoListeners.add(listener);
            }
            if (!this.isGeneratingDeviceId4Ads) {
                this.sendMessage(16387);
            }
        }
        return null;
    }

    public JSONObject prepareTrackingData4Ads() {
        JSONObject data = new JSONObject();
        try {
            data.put("ad_id", (Object)this.adId);
            data.put("android_id", (Object)this.aId);
            data.put("self_id", (Object)this.storage.getSelfId());
            data.put("device_id", (Object)this.dId);
            String cen_did = this.getDeviceId();
            if (cen_did == null) {
                cen_did = "";
            }
            data.put("centralize_id", (Object)cen_did);
            String sdkId = this.getSDKId();
            if (sdkId == null) {
                sdkId = "";
            }
            data.put("sdk_id", (Object)sdkId);
            data.put("mac", (Object)this.mac);
            data.put("ss", (Object)this.ss);
            data.put("osv", (Object)this.osv);
            data.put("sdkv", (Object)this.storage.getSDKVersion());
            data.put("brd", (Object)Build.BRAND);
            data.put("dev", (Object)Build.DEVICE);
            data.put("prd", (Object)Build.PRODUCT);
            data.put("adk_ver", Build.VERSION.SDK_INT);
            data.put("mod", (Object)Build.MODEL);
            data.put("mnft", (Object)Build.MANUFACTURER);
            if (Build.VERSION.SDK_INT >= 9) {
                data.put("ser", (Object)Build.SERIAL);
            }
            data.put("dev_type", (Object)Build.TYPE);
            data.put("dpi", (double)this.context.getResources().getDisplayMetrics().density);
            data.put("pkg", (Object)this.pkg);
            data.put("av", (Object)this.av);
            data.put("avc", (Object)this.avc);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return data;
    }

    public String getVersion() {
        return this.storage == null ? "1.1.0826" : this.storage.getSDKVersion();
    }

    public int getIsGuestCertificated() {
        return this.storage.getIsGuestCertificated();
    }

    public int getIsProtected() {
        return this.storage.getIsProtected();
    }

    public String getGuestDeviceId() {
        return this.storage.getGuestDeviceId();
    }

    public String getDistributionSource() {
        return this.storage.getDistributionSource();
    }

    public String getAppUser() {
        return this.storage.getAppUser();
    }

    public String getLoginChannel() {
        return this.storage.getLoginChannel();
    }

    public static interface GetInfoListener {
        public void onGetDeviceIdComplete(String var1);
    }
}

