/*
 * Decompiled with CFR 0.152.
 */
package com.zing.zalo.devicetrackingsdk;

import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.text.TextUtils;
import com.zing.zalo.devicetrackingsdk.BaseAppInfo;
import com.zing.zalo.devicetrackingsdk.BaseAppInfoStorage;
import com.zing.zalo.zalosdk.core.helper.Utils;
import com.zing.zalo.zalosdk.core.http.HttpClientRequest;
import com.zing.zalo.zalosdk.core.log.Log;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AppTracker {
    private BaseAppInfoStorage storage;
    private BaseAppInfo deviceTracker;
    private HandlerThread thread;
    private Handler handler;
    private Context context;
    private String appId;
    int submitRetry = 0;
    List<String> packageNames;
    List<String> installedPackagedNames;
    long expiredTime;
    String scanId;

    public AppTracker(Context context, BaseAppInfoStorage storage, String appId, BaseAppInfo deviceTracker) {
        this.storage = storage;
        this.context = context.getApplicationContext();
        this.deviceTracker = deviceTracker;
        this.appId = appId;
        this.thread = new HandlerThread("zdt-app-tracker", 1);
        this.thread.start();
        this.handler = new Handler(this.thread.getLooper());
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                try {
                    if (AppTracker.this.needToScanInstalledApp() && AppTracker.this.downloadPackageNames() && AppTracker.this.scanInstalledApp() && AppTracker.this.submitInstalledApp()) {
                        AppTracker.this.cleanUp();
                    }
                }
                catch (Exception ex) {
                    Log.e(ex);
                    AppTracker.this.cleanUp();
                }
            }
        });
        Log.v("start app tracker thread");
    }

    private boolean needToScanInstalledApp() {
        long expiredTime = this.storage.getTrackingAppInstallExpireTime();
        return expiredTime <= System.currentTimeMillis();
    }

    private boolean downloadPackageNames() throws JSONException {
        Log.v("downloading package name");
        String url = "https://centralized.zaloapp.com/apps/mobile/android";
        HttpClientRequest request = new HttpClientRequest(HttpClientRequest.Type.GET, url);
        request.addParams("pl", "android");
        JSONObject jsonObject = request.getJSON();
        if (jsonObject == null) {
            this.cleanUp();
            return false;
        }
        int errorCode = jsonObject.getInt("error");
        if (errorCode < 0) {
            this.cleanUp();
            return false;
        }
        JSONObject data = jsonObject.getJSONObject("data");
        JSONArray japps = data.optJSONArray("apps");
        ArrayList<String> packagedNames = new ArrayList<String>();
        for (int i = 0; i < japps.length(); ++i) {
            packagedNames.add(japps.getString(i));
        }
        this.expiredTime = data.optLong("expiredTime") + System.currentTimeMillis();
        this.scanId = data.optString("scanId", "");
        this.packageNames = packagedNames;
        Log.v("ZDK", "downloaded %d packaged name %d scanId %s", packagedNames.size(), this.expiredTime, this.scanId);
        return true;
    }

    private boolean scanInstalledApp() {
        if (this.packageNames == null || this.packageNames.size() == 0) {
            this.cleanUp();
            return false;
        }
        this.installedPackagedNames = new ArrayList<String>();
        Log.v("scaning package name");
        for (int i = 0; i < this.packageNames.size(); ++i) {
            String str = this.packageNames.get(i);
            if (!Utils.isPackageExisted(this.context, str)) continue;
            this.installedPackagedNames.add(str);
            Log.v("found installed app " + str);
        }
        this.packageNames.clear();
        return true;
    }

    private boolean submitInstalledApp() throws Exception {
        if (this.installedPackagedNames == null || this.installedPackagedNames.size() == 0 || TextUtils.isEmpty((CharSequence)this.scanId) || this.submitRetry >= 5) {
            this.cleanUp();
            return false;
        }
        JSONArray appData = Utils.listToJSONObject(this.installedPackagedNames);
        String zdId = this.deviceTracker.getDeviceId();
        String sdkId = this.deviceTracker.getSDKId();
        String privateKey = this.deviceTracker.getPrivateKey();
        if (TextUtils.isEmpty((CharSequence)sdkId) || TextUtils.isEmpty((CharSequence)privateKey)) {
            ++this.submitRetry;
            this.handler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    try {
                        AppTracker.this.submitInstalledApp();
                    }
                    catch (Exception ex) {
                        Log.e(ex);
                    }
                }
            }, 5000L);
            return false;
        }
        String url = "https://centralized.zaloapp.com/apps/mobile/explore/android";
        url = url + "?et=1&sdkId=" + sdkId + "&gzip=0";
        JSONObject jsonData = new JSONObject();
        jsonData.put("pl", (Object)"android");
        jsonData.put("appId", (Object)this.appId);
        jsonData.put("an", (Object)this.deviceTracker.getAn());
        jsonData.put("av", (Object)this.deviceTracker.getAv());
        jsonData.put("oauthCode", (Object)this.storage.getOAuthCode());
        jsonData.put("osv", (Object)Build.VERSION.RELEASE);
        jsonData.put("sdkv", (Object)this.deviceTracker.getVersion());
        jsonData.put("zdId", (Object)zdId);
        jsonData.put("scanId", (Object)this.scanId);
        jsonData.put("apps", (Object)appData);
        String str = jsonData.toString();
        Log.v("submit app data: " + str);
        byte[] encodeData = Utils.encrypt(privateKey, str);
        String result = Utils.postFile(url, "data.dat", "zce", encodeData, null);
        JSONObject jsonObject = null;
        if (result != null) {
            jsonObject = new JSONObject(result);
        }
        if (jsonObject != null) {
            Log.v("submit app tracking to server with result " + jsonObject.toString());
            int error_code = jsonObject.getInt("error");
            if (error_code == 0) {
                this.storage.setTrackingAppInstallExpireTime(this.expiredTime);
            }
        }
        return true;
    }

    private void cleanUp() {
        if (this.thread != null) {
            this.thread.quit();
            this.thread = null;
            this.handler = null;
        }
    }
}

