/*
 * Decompiled with CFR 0.152.
 */
package com.mobgame.js;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.support.v4.content.LocalBroadcastManager;
import android.text.TextUtils;
import android.util.Log;
import android.widget.Toast;
import com.facebook.AccessToken;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.mobgame.MobGameHelper;
import com.mobgame.MobGameSDK;
import com.mobgame.R;
import com.mobgame.api.LoginZaloTask;
import com.mobgame.api.PostTask;
import com.mobgame.component.FacebookManager;
import com.mobgame.component.GameConfigManager;
import com.mobgame.component.GoogleAuthManager;
import com.mobgame.gui.MobGameWebFragment;
import com.mobgame.gui.dialog.MobGameDialogWebviewFragment;
import com.mobgame.js.JsHandler;
import com.mobgame.model.MobAccessToken;
import com.mobgame.utils.Constants;
import com.mobgame.utils.DeviceUtils;
import com.mobgame.utils.Res;
import com.mobgame.utils.Utils;
import com.zing.zalo.zalosdk.oauth.OAuthCompleteListener;
import com.zing.zalo.zalosdk.oauth.OauthResponse;
import com.zing.zalo.zalosdk.oauth.ValidateOAuthCodeCallback;
import com.zing.zalo.zalosdk.oauth.ZaloSDK;
import java.util.HashMap;
import java.util.Set;

final class CmdLogin {
    private static final String TAG = CmdLogin.class.getSimpleName();
    private static CmdLogin INSTANCE;

    private CmdLogin() {
    }

    public static CmdLogin getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CmdLogin();
        }
        return INSTANCE;
    }

    void mobLoginSuccess(Activity activity, MobGameWebFragment webFragment, MobGameDialogWebviewFragment dialogWebviewFragment, String params) {
        try {
            Log.i((String)TAG, (String)"mobLoginSuccess");
            Utils.hideLoading();
            MobAccessToken accessToken = MobAccessToken.parse(params);
            GameConfigManager.getInstance().setAccessToken(accessToken.getToken());
            if (MobGameHelper.isShowingDashboard()) {
                MobGameHelper.hideDashboard();
            }
            if (dialogWebviewFragment != null) {
                dialogWebviewFragment.dismiss();
            }
            Intent intent = new Intent("com.mobgame.broadcast");
            intent.putExtra("category", "login");
            LocalBroadcastManager.getInstance((Context)activity).sendBroadcast(intent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void mobLoginGuest(final Activity activity, MobGameWebFragment webFragment, String params) {
        Log.i((String)TAG, (String)"mobLoginGuest");
        try {
            Utils.showLoading(activity, Res.string((Context)activity, R.string.logging_in));
            String mac_address = DeviceUtils.getUniqueDeviceID((Context)activity);
            String key = Utils.getSHACheckSum(mac_address + "abc");
            HashMap<String, String> postParams = new HashMap<String, String>();
            postParams.put("mac_address", mac_address);
            postParams.put("key", key);
            webFragment.postUrlWithMobHeaders(Constants.URL_RECEIVE_MAC_ADDRESS, postParams, new PostTask.Callback(){

                @Override
                public void onSuccess(String response) {
                    Utils.hideLoading();
                }

                @Override
                public void onFailure(Throwable e) {
                    e.printStackTrace();
                    CmdLogin.this.handleException(activity, Res.string((Context)activity, R.string.something_went_wrong));
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            this.handleException(activity, Res.string((Context)activity, R.string.something_went_wrong));
        }
    }

    void mobLoginFacebook(final Activity activity, final MobGameWebFragment webFragment, String params) {
        Log.i((String)TAG, (String)("mobLoginStartFb:" + params));
        Utils.showLoading(activity, "", Res.string((Context)activity, R.string.connecting_facebook), false);
        FacebookManager.getInstance().login(activity, new FacebookManager.LoginCallback(){

            @Override
            public void onSuccess(AccessToken accessToken, Set<String> recentlyGrantedPermissions, Set<String> recentlyDeniedPermissions) {
                try {
                    HashMap<String, String> postParams = new HashMap<String, String>();
                    postParams.put("access_token", accessToken.getToken());
                    webFragment.postUrlWithMobHeaders(Constants.URL_RECEIVE_ACCESS_TOKEN, postParams, new PostTask.Callback(){

                        @Override
                        public void onSuccess(String response) {
                            Utils.hideLoading();
                        }

                        @Override
                        public void onFailure(Throwable e) {
                            Utils.hideLoading();
                        }
                    });
                }
                catch (Exception e) {
                    CmdLogin.this.handleException(activity, Res.string((Context)activity, R.string.something_went_wrong));
                    Utils.hideLoading();
                }
            }

            @Override
            public void onCancel() {
                Utils.hideLoading();
            }

            @Override
            public void onError(Throwable t) {
                Utils.hideLoading();
                CmdLogin.this.handleException(activity, Res.string((Context)activity, R.string.something_went_wrong));
            }
        });
    }

    void mobUpgradeFacebook(final Activity activity, final MobGameDialogWebviewFragment webFragment, String params) {
        Log.i((String)TAG, (String)("mobFacebookForUpdate:" + params));
        Utils.showLoading(activity, Res.string((Context)activity, R.string.connecting_facebook));
        FacebookManager.getInstance().login(activity, new FacebookManager.LoginCallback(){

            @Override
            public void onSuccess(AccessToken accessToken, Set<String> recentlyGrantedPermissions, Set<String> recentlyDeniedPermissions) {
                Utils.hideLoading();
                try {
                    HashMap<String, String> postParams = new HashMap<String, String>();
                    postParams.put("token", accessToken.getToken());
                    webFragment.postUrlWithMobHeaders(Constants.URL_UPDATE_FROM_FACEBOOK, postParams);
                }
                catch (Exception e) {
                    CmdLogin.this.handleException(activity, Res.string((Context)activity, R.string.something_went_wrong));
                }
            }

            @Override
            public void onCancel() {
                Utils.hideLoading();
            }

            @Override
            public void onError(Throwable t) {
                Utils.hideLoading();
            }
        });
    }

    void mobLoginGooglePlay(final Activity activity, final MobGameWebFragment webFragment, String params) {
        Log.i((String)TAG, (String)"mobLoginGooglePlay");
        if (!Utils.isOnline((Context)activity)) {
            this.handleException(activity, Res.string((Context)activity, R.string.connection_lost));
            return;
        }
        if (!GoogleAuthManager.getInstance().isGoogleServiceAvailable(activity)) {
            Log.d((String)TAG, (String)"Google Play Service is out of date. Request update...");
            return;
        }
        Utils.showLoading(activity, "", Res.string((Context)activity, R.string.connecting_google_play), true);
        GoogleAuthManager.getInstance().login(activity, new GoogleAuthManager.GooglePlusResultCallback(){

            @Override
            public void onLoginSuccess(GoogleSignInAccount account, String mToken) {
                Log.d((String)TAG, (String)("Google Token: " + mToken));
                try {
                    HashMap<String, String> postParams = new HashMap<String, String>();
                    postParams.put("id_token", mToken);
                    webFragment.postUrlWithMobHeaders(Constants.URL_LOGIN_GOOGLE_ACCOUNT, postParams, new PostTask.Callback(){

                        @Override
                        public void onSuccess(String response) {
                            Log.d((String)TAG, (String)"Google Login Success");
                            CmdLogin.this.getFullResponse(response);
                            Utils.hideLoading();
                        }

                        @Override
                        public void onFailure(Throwable e) {
                            Log.wtf((String)"onFailure", (String)e.getLocalizedMessage());
                            Utils.hideLoading();
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                    CmdLogin.this.handleException(activity, Res.string((Context)activity, R.string.something_went_wrong));
                    e.printStackTrace();
                    Utils.hideLoading();
                }
                Log.wtf((String)"mobLoginGooglePlay", (String)("onLoginSuccess: Token: " + mToken + " Email: " + account.getEmail()));
            }

            @Override
            public void onLoginError(String mess) {
                Log.e((String)TAG, (String)"Sign in google error");
                if (!TextUtils.isEmpty((CharSequence)mess)) {
                    CmdLogin.this.handleException(activity, mess);
                }
                Utils.hideLoading();
            }
        });
    }

    private void getFullResponse(String sb) {
        try {
            if (sb.length() > 4000) {
                Log.wtf((String)"onResponse", (String)("sb.length = " + sb.length()));
                int chunkCount = sb.length() / 4000;
                for (int i = 0; i <= chunkCount; ++i) {
                    int max = 4000 * (i + 1);
                    if (max >= sb.length()) {
                        Log.wtf((String)"onResponse", (String)("chunk " + i + " of " + chunkCount + ":" + sb.substring(4000 * i)));
                        continue;
                    }
                    Log.wtf((String)"onResponse", (String)("chunk " + i + " of " + chunkCount + ":" + sb.substring(4000 * i, max)));
                }
            } else {
                Log.wtf((String)TAG, (String)sb.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void mobLoginGoogleAccount(Activity activity, MobGameWebFragment webFragment, String params) {
        Log.i((String)TAG, (String)"mobLoginGoogleAccount");
    }

    private void handleException(final Activity activity, final String message) {
        Utils.hideLoading();
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                Toast.makeText((Context)activity, (CharSequence)message, (int)1).show();
            }
        });
        Intent intent = new Intent("com.mobgame.broadcast");
        intent.putExtra("category", "login");
        intent.putExtra("status", false);
        intent.putExtra("message", message);
        LocalBroadcastManager.getInstance((Context)activity).sendBroadcast(intent);
    }

    void mobLoginZalo(Activity activity, MobGameWebFragment webFragment, String params) {
        try {
            Log.i((String)TAG, (String)("mobLoginZalo:" + params));
            if (DeviceUtils.isAppInstalled(activity, "com.zing.zalo")) {
                Utils.showLoading(activity, "", Res.string((Context)activity, R.string.connecting_zalo), false);
                ZaloSDK.Instance.authenticate(activity, (OAuthCompleteListener)new LoginListener(activity));
            } else {
                Toast.makeText((Context)activity, (CharSequence)activity.getString(R.string.zalo_require_install), (int)0).show();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static class LoginListener
    extends OAuthCompleteListener
    implements ValidateOAuthCodeCallback {
        Activity activity;

        public void onValidateComplete(boolean b, int i, long l, String s) {
            try {
                MobGameSDK.getInstance().close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public LoginListener(Activity _activity) {
            this.activity = _activity;
        }

        public void onAuthenError(int errorCode, String message) {
            try {
                Log.d((String)TAG, (String)("Debug 1 : " + message + " , errorCode : " + errorCode));
                if (errorCode != -1111 && errorCode != 2 && errorCode != -1114) {
                    Toast.makeText((Context)this.activity, (CharSequence)"C\u00f3 l\u1ed7i x\u1ea3y ra !!!", (int)0).show();
                }
                Utils.hideLoading();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void onGetOAuthComplete(OauthResponse response) {
            super.onGetOAuthComplete(response);
            try {
                Log.d((String)TAG, (String)("Debug 2: " + response.getuId()));
                Log.d((String)TAG, (String)("Debug :" + response.getOauthCode()));
                new LoginZaloTask(new LoginZaloTask.Listener(){

                    @Override
                    public void onSuccess(String str) {
                        Utils.hideLoading();
                        Log.d((String)TAG, (String)("Debug 3 :" + str));
                        JsHandler jsHandler = new JsHandler(activity);
                        jsHandler.mobAppSDKexecute("mobLoginSuccess", str);
                    }

                    @Override
                    public void onFailure(Throwable t) {
                        Utils.hideLoading();
                        Toast.makeText((Context)activity, (CharSequence)"C\u00f3 l\u1ed7i x\u1ea3y ra !!!", (int)0).show();
                        Log.d((String)TAG, (String)"Debug 4");
                    }
                }).execute(new String[]{response.getOauthCode()});
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

