/*
 * Decompiled with CFR 0.152.
 */
package com.mobgame.gui.floatbutton;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.DialogFragment;
import android.app.FragmentManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.OvershootInterpolator;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.google.gson.Gson;
import com.mobgame.MobGameHelper;
import com.mobgame.MobGameSDK;
import com.mobgame.R;
import com.mobgame.component.GameConfigManager;
import com.mobgame.gui.CountdownChronometer;
import com.mobgame.gui.dialog.MobGameDashboardDialog;
import com.mobgame.gui.dialog.MobGameFloatConfirmDialog;
import com.mobgame.gui.floatbutton.MobGameFloatGestureView;
import com.mobgame.model.MobMenuItem;
import com.mobgame.model.NtfModel;
import com.mobgame.model.TimerData;
import com.mobgame.model.TimerObject;
import com.mobgame.utils.DeviceUtils;
import com.mobgame.utils.FloatButtonTimerHelper;
import com.mobgame.utils.NotificationUtils;
import com.mobgame.utils.Preference;
import com.mobgame.utils.Res;
import java.util.ArrayList;
import java.util.Calendar;

@SuppressLint(value={"InflateParams", "ClickableViewAccessibility"})
public class MobGameOverlayView {
    private static final String TAG = MobGameOverlayView.class.getSimpleName();
    private static final int ANIMAION_TIME_FADE_OUT = 300;
    private static final int ANIMAION_TIME_FADE_IN = 200;
    private static final int IDLE_TIME = 3000;
    private static final int IDLE_TIME2 = 1000;
    private static Activity activity;
    private View rootView;
    private View layoutBottom;
    private View layoutFloat;
    private TextView txtDismiss;
    private Handler idleHandler = new Handler();
    private MobGameFloatGestureView floatArea;
    private ImageView floatButton;
    private static ImageView floatButtonNtf;
    private View animationLayout;
    private View timerLayoutBottom;
    private CountdownChronometer countdownTimer;
    private boolean isHideFloatButton = false;
    private MobGameDashboardDialog dialogDashboard;
    private boolean isInit;
    private boolean isShowingMenu;
    private boolean isOutsideBottomArea;
    private int boundWidth;
    private int boundHeight;
    private int relativePositionOnScreen;
    private int statusBarHeight;
    private float density;
    private boolean fadeOuted;
    private boolean isShowingDashboard = false;
    private boolean isScrolling = false;
    private Runnable mIdleRunnable = new Runnable(){

        @Override
        public void run() {
            try {
                if (!MobGameOverlayView.this.isScrolling) {
                    MobGameOverlayView.this.fadeOut(true);
                    MobGameOverlayView.this.showCountdownTimer(0);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };
    private Runnable mIdleRunnable2 = new Runnable(){

        @Override
        public void run() {
            MobGameOverlayView.this.fadeOut2(true);
        }
    };
    private static boolean doTouchDown;
    private MobGameFloatGestureView.EventListener mButtonEventListener = new MobGameFloatGestureView.EventListener(){
        int x = 0;
        int y = MobGameOverlayView.access$200(MobGameOverlayView.this) / 2;
        boolean onTouchMove = false;

        @Override
        public void onTouchDown(MotionEvent event) {
            MobGameOverlayView.this.isOutsideBottomArea = true;
            MobGameOverlayView.this.fadeIn(true);
            this.x = MobGameOverlayView.this.floatArea.getX();
            this.y = MobGameOverlayView.this.floatArea.getY();
            doTouchDown = true;
        }

        @Override
        public void onTouchMove(MotionEvent event) {
            try {
                this.onTouchMove = true;
                if (MobGameOverlayView.this.isOutsideBottomArea) {
                    MobGameOverlayView.this.showLayoutBottom();
                }
                MobGameOverlayView.this.isOutsideBottomArea = false;
                if (MobGameOverlayView.this.isInDismissArea(event.getRawX(), event.getRawY())) {
                    MobGameOverlayView.this.txtDismiss.setCompoundDrawablesWithIntrinsicBounds(0, R.drawable.float_hide_active, 0, 0);
                    MobGameOverlayView.this.txtDismiss.setTextColor(Color.rgb((int)194, (int)39, (int)45));
                } else {
                    MobGameOverlayView.this.txtDismiss.setCompoundDrawablesWithIntrinsicBounds(0, R.drawable.float_hide_normal, 0, 0);
                    MobGameOverlayView.this.txtDismiss.setTextColor(Color.rgb((int)255, (int)255, (int)255));
                }
                MobGameOverlayView.this.haveShowNotification = false;
                MobGameOverlayView.this.sizeListNtf = 1;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void onTouchUp(MotionEvent event) {
            try {
                doTouchDown = false;
                this.onTouchMove = false;
                MobGameOverlayView.this.idleHandler.removeCallbacksAndMessages(null);
                if (MobGameOverlayView.this.haveShowNotification) {
                    Log.e((String)TAG, (String)"HAVAHVAHVAHVAH");
                    MobGameOverlayView.this.handlerFadeOut();
                    MobGameOverlayView.this.haveShowNotification = false;
                    MobGameOverlayView.this.sizeListNtf = 1;
                } else {
                    Log.e((String)TAG, (String)"HAVAHVAHVAHVAH 2");
                    MobGameOverlayView.this.handlerFadeOut();
                }
                MobGameOverlayView.this.hideLayoutBottom();
                MobGameOverlayView.this.isOutsideBottomArea = true;
                MobGameOverlayView.this.floatArea.moveToEdge(true);
                if (event != null && MobGameOverlayView.this.isInDismissArea(event.getRawX(), event.getRawY())) {
                    MobGameOverlayView.this.showConfirmDialog(this.x, this.y);
                    MobGameOverlayView.this.layoutFloat.setVisibility(8);
                    MobGameOverlayView.this.floatArea.hide();
                    long dismissTime = Calendar.getInstance().getTimeInMillis();
                    Preference.save((Context)activity, "shared_pref_float_button_dismiss_time", dismissTime);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void onClick(MotionEvent event) {
            try {
                if (!this.onTouchMove) {
                    MobGameOverlayView.this.showDashboard();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                MobGameOverlayView.this.isShowingDashboard = false;
            }
        }

        @Override
        public void onMove(int x, int y) {
            try {
                x = Math.max(0, Math.min(MobGameOverlayView.this.boundWidth - MobGameOverlayView.this.floatArea.getSizeInPixels(), x));
                y = Math.max(0, Math.min(MobGameOverlayView.this.boundHeight - MobGameOverlayView.this.floatButton.getHeight(), y));
                y = MobGameOverlayView.this.countdownTimer != null && MobGameOverlayView.this.countdownTimer.getVisibility() == 0 ? Math.max(0, Math.min(MobGameOverlayView.this.boundHeight - MobGameOverlayView.this.floatButton.getHeight() - MobGameOverlayView.this.timerLayoutBottom.getHeight(), y)) : Math.max(0, Math.min(MobGameOverlayView.this.boundHeight - MobGameOverlayView.this.floatButton.getHeight(), y));
                MobGameOverlayView.this.layoutFloat.setX((float)x);
                MobGameOverlayView.this.layoutFloat.setY((float)y);
                if (MobGameOverlayView.this.animationLayout != null && MobGameOverlayView.this.fadeOuted) {
                    MobGameOverlayView.this.animationLayout.setX(0.0f);
                    MobGameOverlayView.this.fadeOuted = false;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };
    private BroadcastReceiver receiver = new BroadcastReceiver(){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void onReceive(Context context, Intent intent) {
            Log.d((String)TAG, (String)"BroadcastReceiver::onReceive");
            try {
                String data;
                String category = intent.getStringExtra("category");
                Log.e((String)TAG, (String)("category:" + category));
                if (category != null && "dashboard".equalsIgnoreCase(category) && TextUtils.isEmpty((CharSequence)(data = intent.getStringExtra("data")))) return;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };
    DialogFragment dialog = null;
    private boolean haveShowNotification = false;
    private boolean haveNotiGCM = false;
    private int sizeListNtf = 1;
    long startTime;
    long endTime;
    int id;
    ArrayList<TimerObject> listTimers = new ArrayList();

    public MobGameOverlayView(Activity a) {
        activity = a;
        this.enableTimer();
        this.floatArea = new MobGameFloatGestureView(activity);
        this.density = DeviceUtils.getDensity((Context)a);
        this.statusBarHeight = DeviceUtils.getStatusBarHeightInPixels((Context)activity);
        this.attachView();
        this.initView();
        this.hide();
    }

    public void enableTimer() {
        TimerData timerData = FloatButtonTimerHelper.getFloatButtonTimerData((Context)activity);
        if (timerData != null) {
            long now = Calendar.getInstance().getTimeInMillis();
            ArrayList<Object> listTimerObj = new ArrayList();
            listTimerObj = timerData.getListTimerObject();
            for (int i = 0; i < listTimerObj.size(); ++i) {
                TimerObject timerObject = new TimerObject();
                timerObject = (TimerObject)listTimerObj.get(i);
                if (timerObject.getStartTime() <= now && timerObject.getEndTime() > now) {
                    FloatButtonTimerHelper.setisRuningTimer(true);
                    break;
                }
                FloatButtonTimerHelper.setisRuningTimer(false);
            }
        } else {
            FloatButtonTimerHelper.setisRuningTimer(false);
        }
    }

    public void attachView() {
        try {
            this.rootView = LayoutInflater.from((Context)activity).inflate(R.layout.float_overlay_view, null);
            WindowManager windowManager = (WindowManager)activity.getApplicationContext().getSystemService("window");
            WindowManager.LayoutParams params = new WindowManager.LayoutParams(-1, -1, 2002, 8, -2);
            params.gravity = 51;
            params.flags = 56;
            windowManager.addView(this.rootView, (ViewGroup.LayoutParams)params);
            this.rootView.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                @SuppressLint(value={"NewApi"})
                public void onGlobalLayout() {
                    if (MobGameOverlayView.this.rootView != null) {
                        int[] locations = new int[2];
                        MobGameOverlayView.this.rootView.getLocationOnScreen(locations);
                        MobGameOverlayView.this.relativePositionOnScreen = locations[1];
                        if (MobGameOverlayView.this.relativePositionOnScreen == 0) {
                            MobGameOverlayView.this.boundHeight = MobGameOverlayView.this.rootView.getHeight();
                        } else {
                            MobGameOverlayView.this.boundHeight = MobGameOverlayView.this.rootView.getHeight() + MobGameOverlayView.this.relativePositionOnScreen;
                        }
                        MobGameOverlayView.this.boundWidth = MobGameOverlayView.this.rootView.getWidth();
                        MobGameOverlayView.this.floatArea.setMovableWidth(MobGameOverlayView.this.boundWidth);
                        MobGameOverlayView.this.floatArea.setMovableHeight(MobGameOverlayView.this.boundHeight);
                        if (!MobGameOverlayView.this.isInit) {
                            MobGameOverlayView.this.isInit = true;
                            int x = Preference.getInt((Context)activity, "shared_float_area_x", 0);
                            int y = Preference.getInt((Context)activity, "shared_float_area_y", MobGameOverlayView.this.boundHeight / 2 - 50);
                            MobGameOverlayView.this.floatArea.moveTo(x, y);
                            MobGameOverlayView.this.floatArea.setIsLeft(true);
                        }
                        if (Build.VERSION.SDK_INT < 16) {
                            MobGameOverlayView.this.rootView.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                        } else {
                            MobGameOverlayView.this.rootView.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void initView() {
        try {
            Log.d((String)TAG, (String)"initView");
            this.layoutBottom = this.rootView.findViewById(R.id.layout_bottom);
            this.layoutFloat = this.rootView.findViewById(R.id.layout_float);
            this.txtDismiss = (TextView)this.rootView.findViewById(R.id.txt_dismiss);
            this.floatButton = (ImageView)this.rootView.findViewById(R.id.img_float);
            floatButtonNtf = (ImageView)this.rootView.findViewById(R.id.img_float_ntf);
            this.animationLayout = this.rootView.findViewById(R.id.animation_layout);
            this.timerLayoutBottom = this.rootView.findViewById(R.id.timer_layouts_bottom);
            int imgRes = Res.drawableResource((Context)activity, R.drawable.float_button);
            this.floatButton.setImageResource(imgRes);
            this.floatArea.setEventListener(this.mButtonEventListener);
            int x = Preference.getInt((Context)activity, "shared_float_area_x", 0);
            int y = Preference.getInt((Context)activity, "shared_float_area_y", this.boundHeight / 2 - 50);
            this.floatArea.moveTo(x, y);
            this.txtDismiss.setText((CharSequence)Res.string((Context)activity, R.string.dismiss));
            this.layoutBottom.setY((float)(this.boundHeight + this.statusBarHeight - this.relativePositionOnScreen) - 125.0f * this.density);
            this.countdownTimer = (CountdownChronometer)this.rootView.findViewById(R.id.countdown_timer);
            if (!FloatButtonTimerHelper.isRuningTimer()) {
                this.timerLayoutBottom.setVisibility(8);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void fadeOut(boolean isAnimated) {
        Log.d((String)TAG, (String)"fadeOut 1");
        Log.e((String)TAG, (String)"------------------------------------------------------");
        try {
            int newX = this.updateFloatButtonNotf();
            if (isAnimated) {
                Log.d((String)TAG, (String)"GO HERE 1 ");
                this.animationLayout.clearAnimation();
                this.animationLayout.animate().setDuration(300L).setInterpolator((TimeInterpolator)new OvershootInterpolator(1.0f)).x((float)newX).setListener(new Animator.AnimatorListener(){

                    public void onAnimationStart(Animator arg0) {
                    }

                    public void onAnimationRepeat(Animator arg0) {
                    }

                    public void onAnimationEnd(Animator arg0) {
                        Log.d((String)TAG, (String)("AnimationLayout X: " + MobGameOverlayView.this.animationLayout.getX()));
                        Log.d((String)TAG, (String)String.format("float layout: %sx%s - animate: %sx%s", Float.valueOf(MobGameOverlayView.this.layoutFloat.getX()), Float.valueOf(MobGameOverlayView.this.layoutFloat.getY()), Float.valueOf(MobGameOverlayView.this.animationLayout.getX()), Float.valueOf(MobGameOverlayView.this.animationLayout.getY())));
                        MobGameOverlayView.this.layoutFloat.clearAnimation();
                        MobGameOverlayView.this.animationLayout.clearAnimation();
                        MobGameOverlayView.this.layoutFloat.refreshDrawableState();
                    }

                    public void onAnimationCancel(Animator arg0) {
                    }
                }).alpha(0.5f);
                this.timerLayoutBottom.setAlpha(0.5f);
                floatButtonNtf.setAlpha(0.5f);
            } else {
                Log.d((String)TAG, (String)"GO HERE 2 ");
                this.animationLayout.setX((float)newX);
            }
            this.fadeOuted = true;
            this.idleHandler.postDelayed(this.mIdleRunnable2, 1000L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int updateFloatButtonNotf() {
        int newX = 0;
        try {
            int buttonSize = this.floatArea.getSizeInPixels();
            newX = this.boundWidth - buttonSize / 2;
            float currentX = this.layoutFloat.getX();
            if (currentX <= (float)(this.boundWidth / 2)) {
                RelativeLayout.LayoutParams lp = (RelativeLayout.LayoutParams)floatButtonNtf.getLayoutParams();
                lp.addRule(9, 0);
                lp.addRule(11, -1);
                if (DeviceUtils.isTablet((Context)activity)) {
                    lp.setMargins(0, 2, 2, 0);
                } else {
                    lp.setMargins(0, 5, 5, 0);
                }
                floatButtonNtf.setLayoutParams((ViewGroup.LayoutParams)lp);
                newX = 0;
            } else {
                RelativeLayout.LayoutParams lp = (RelativeLayout.LayoutParams)floatButtonNtf.getLayoutParams();
                lp.addRule(9, -1);
                lp.addRule(11, 0);
                if (DeviceUtils.isTablet((Context)activity)) {
                    lp.setMargins(0, 2, 2, 0);
                } else {
                    lp.setMargins(5, 5, 0, 0);
                }
                floatButtonNtf.setLayoutParams((ViewGroup.LayoutParams)lp);
                newX = 0;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Log.d((String)TAG, (String)("newX : " + newX));
        return newX;
    }

    private int updateFloatButtonNotf2() {
        int newX = 0;
        try {
            int buttonSize = this.floatArea.getSizeInPixels();
            newX = this.boundWidth - buttonSize / 2;
            float currentX = this.layoutFloat.getX();
            if (currentX <= (float)(this.boundWidth / 2)) {
                Log.d((String)TAG, (String)"Goooo 1");
                newX = -buttonSize / 2;
            } else {
                Log.d((String)TAG, (String)"Goooo 2");
                newX = buttonSize / 2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Log.d((String)TAG, (String)("newX 2: " + newX));
        return newX;
    }

    public void fadeIn(boolean isAnimated) {
        try {
            this.idleHandler.removeCallbacksAndMessages(null);
            int newX = this.updateFloatButtonNotf();
            if (isAnimated) {
                this.animationLayout.animate().setDuration(200L).setInterpolator((TimeInterpolator)new OvershootInterpolator(1.0f)).x((float)newX).alpha(1.0f);
                this.timerLayoutBottom.setAlpha(1.0f);
                floatButtonNtf.setAlpha(1.0f);
            } else {
                this.animationLayout.setAlpha(1.0f);
                this.timerLayoutBottom.setAlpha(1.0f);
                floatButtonNtf.setAlpha(1.0f);
            }
            Log.d((String)TAG, (String)("fadeIn :" + GameConfigManager.getInstance().getUserInfo().isEnableTimer()));
            if (GameConfigManager.getInstance().getUserInfo().isEnableTimer()) {
                long now;
                TimerData timerData = FloatButtonTimerHelper.getFloatButtonTimerData((Context)activity);
                boolean doShowTimer = this.conditionShowTimer(timerData, now = Calendar.getInstance().getTimeInMillis());
                if (doShowTimer) {
                    this.startTimer();
                    this.timerLayoutBottom.setVisibility(0);
                } else {
                    this.timerLayoutBottom.setVisibility(8);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void fadeOut2(boolean isAnimated) {
        Log.d((String)TAG, (String)"fadeOut 2");
        try {
            if (!this.isHideFloatButton) {
                int newX = this.updateFloatButtonNotf2();
                if (isAnimated) {
                    this.animationLayout.animate().setDuration(300L).setInterpolator((TimeInterpolator)new OvershootInterpolator(1.0f)).x((float)newX).alpha(0.5f);
                    this.timerLayoutBottom.setAlpha(0.5f);
                    floatButtonNtf.setAlpha(0.5f);
                } else {
                    this.animationLayout.setAlpha(0.5f);
                    this.timerLayoutBottom.setAlpha(0.5f);
                    floatButtonNtf.setAlpha(0.5f);
                }
                if (this.layoutFloat.getVisibility() != 8 && GameConfigManager.getInstance().getUserInfo().isEnableTimer()) {
                    long now;
                    TimerData timerData = FloatButtonTimerHelper.getFloatButtonTimerData((Context)activity);
                    boolean doShowTimer = this.conditionShowTimer(timerData, now = Calendar.getInstance().getTimeInMillis());
                    if (doShowTimer) {
                        if (this.floatArea.isLeft()) {
                            Log.d((String)TAG, (String)"Go here left");
                            this.floatArea.fadeOutLeft();
                        } else {
                            Log.d((String)TAG, (String)"Go here 2");
                            this.floatArea.fadeOutRight();
                        }
                    } else {
                        this.timerLayoutBottom.setVisibility(8);
                    }
                }
                this.timerLayoutBottom.setVisibility(8);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void handlerFadeOut() {
        Log.d((String)TAG, (String)"handlerFadeOut: ");
        if (this.idleHandler == null) {
            this.idleHandler = new Handler();
        }
        this.idleHandler.removeCallbacksAndMessages(null);
        this.updateFloatButtonNotf();
        this.idleHandler.postDelayed(this.mIdleRunnable, 3000L);
    }

    public void showDashboard() {
        try {
            this.dialogDashboard = new MobGameDashboardDialog();
            FragmentManager fm = activity.getFragmentManager();
            Bundle bundle = new Bundle();
            ArrayList<MobMenuItem> listMenuItem = new ArrayList();
            listMenuItem = GameConfigManager.getInstance().getMobMenu().getMenuItems();
            String data = "";
            MobMenuItem menuItem = new MobMenuItem();
            menuItem = this.getItemByPriority(listMenuItem);
            switch (menuItem.getId()) {
                case 1: {
                    Gson gson1 = new Gson();
                    data = gson1.toJson(menuItem.getSubMenu());
                    break;
                }
                case 4: {
                    Gson gson4 = new Gson();
                    data = gson4.toJson(menuItem.getSubMenu());
                    break;
                }
                case 6: {
                    Gson gson6 = new Gson();
                    data = gson6.toJson(menuItem.getSubMenu());
                    break;
                }
                case 8: {
                    Gson gson8 = new Gson();
                    data = gson8.toJson(menuItem.getSubMenu());
                }
            }
            Log.d((String)TAG, (String)("data : " + data));
            bundle.putString(MobGameDashboardDialog.KEY_DATA, data);
            bundle.putInt(MobGameDashboardDialog.KEY_ID, menuItem.getId());
            if (this.endTime != 0L) {
                bundle.putLong(MobGameDashboardDialog.KEY_TIMER, this.endTime);
            }
            this.dialogDashboard.setArguments(bundle);
            fm.beginTransaction().addToBackStack("stack").commitAllowingStateLoss();
            this.dialogDashboard.show(fm, "Dashboard Fragment");
            this.isShowingDashboard = true;
            Log.d((String)TAG, (String)("onclick floatbutton: isShowingDashboard=" + this.isShowingDashboard));
            this.dialogDashboard.setEventListener(new MobGameDashboardDialog.EventListener(){

                @Override
                public void onDismissDashboard() {
                    MobGameOverlayView.this.isShowingDashboard = false;
                    Log.d((String)TAG, (String)("onDismiss: isShowingDashboard=" + MobGameOverlayView.this.isShowingDashboard));
                }
            });
            MobGameSDK.getInstance().unRegisterSensor();
            MobGameHelper.hideFloatButton();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void hideDashboard() {
        try {
            if (this.dialogDashboard != null) {
                this.dialogDashboard.dismiss();
                this.isShowingDashboard = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.isShowingDashboard = false;
        }
    }

    @SuppressLint(value={"NewApi"})
    private void showCountdownTimer(int visibility) {
        try {
            if (this.countdownTimer == null) {
                return;
            }
            if (!this.countdownTimer.isRunning()) {
                if (this.countdownTimer.getVisibility() == 0) {
                    this.countdownTimer.setVisibility(8);
                    this.timerLayoutBottom.setVisibility(8);
                }
                return;
            }
            TimerData timerData = FloatButtonTimerHelper.getFloatButtonTimerData((Context)activity);
            if (timerData.getListTimerObject().isEmpty()) {
                return;
            }
            this.countdownTimer.setVisibility(visibility);
            this.timerLayoutBottom.setVisibility(visibility);
            if (this.rootView != null) {
                this.rootView.postInvalidateOnAnimation();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private MobMenuItem getItemByPriority(ArrayList<MobMenuItem> mobMenuItems) {
        try {
            int i;
            int min = 0;
            MobMenuItem menuItem = new MobMenuItem();
            for (i = 0; i < mobMenuItems.size(); ++i) {
                if (!mobMenuItems.get(i).isShow()) continue;
                min = mobMenuItems.get(i).getPriority();
                menuItem = mobMenuItems.get(i);
                break;
            }
            for (i = 0; i < mobMenuItems.size(); ++i) {
                if (!mobMenuItems.get(i).isShow() || mobMenuItems.get(i).getPriority() >= min) continue;
                min = mobMenuItems.get(i).getPriority();
                menuItem = mobMenuItems.get(i);
            }
            return menuItem;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void setNtf(boolean isHide) {
        try {
            if (!FloatButtonTimerHelper.isRuningTimer() && NotificationUtils.hasNtf((Context)activity)) {
                floatButtonNtf.setVisibility(0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean isInBottomArea(float left, float top) {
        try {
            int dY = (int)((float)this.boundHeight - 150.0f * this.density);
            return top >= (float)dY || this.isInDismissArea(left, top);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean isInDismissArea(float left, float top) {
        try {
            int dX = this.boundWidth / 2;
            int dY = (int)((float)this.boundHeight - 30.0f * this.density);
            double distance = Math.sqrt(Math.pow(left - (float)dX, 2.0) + Math.pow(top - (float)dY, 2.0));
            double maxDistance = Math.min(120.0f * this.density, (float)(this.boundWidth / 5));
            return distance <= maxDistance || top >= (float)dY && (double)left >= (double)dX - maxDistance && (double)left <= (double)dX + maxDistance;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private void showLayoutBottom() {
        try {
            this.layoutBottom.setVisibility(0);
            if (this.relativePositionOnScreen != 0) {
                this.layoutBottom.animate().setDuration(200L).y((float)(this.boundHeight + this.statusBarHeight - this.relativePositionOnScreen) - 100.0f * this.density);
            } else {
                this.layoutBottom.animate().setDuration(200L).y((float)(this.boundHeight + this.statusBarHeight - this.relativePositionOnScreen) - 125.0f * this.density);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void hideLayoutBottom() {
        try {
            this.layoutBottom.animate().setDuration(200L).y((float)(this.boundHeight + this.statusBarHeight - this.relativePositionOnScreen));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void showConfirmDialog(final int x, final int y) {
        try {
            Preference.save((Context)activity, "shared_pref_show_confirm_dialog_hide_float", true);
            this.dialog = new MobGameFloatConfirmDialog(activity, new MobGameFloatConfirmDialog.EventListener(){

                @Override
                public void onConfirmClick(View v) {
                    Preference.save((Context)activity, "shared_pref_hide_float_button", false);
                    MobGameOverlayView.this.layoutFloat.setVisibility(8);
                    MobGameOverlayView.this.floatArea.hide();
                    MobGameOverlayView.this.hideConfirmDialog();
                    Preference.save((Context)activity, "shared_pref_show_confirm_dialog_hide_float", false);
                    Preference.remove((Context)activity, "shared_pref_show_dashboard");
                }

                @Override
                public void onCancelClick(View v) {
                    MobGameOverlayView.this.hideConfirmDialog();
                    MobGameOverlayView.this.floatArea.moveTo(x, y);
                    MobGameHelper.showFloatButton();
                    Preference.save((Context)activity, "shared_pref_show_confirm_dialog_hide_float", false);
                    Preference.remove((Context)activity, "shared_pref_show_dashboard");
                }
            });
            MobGameSDK.getInstance().registerSensor();
            this.dialog.show(activity.getFragmentManager(), "tag_fragment_confirm");
        }
        catch (Exception e) {
            this.hideConfirmDialog();
        }
    }

    public void hideConfirmDialog() {
        try {
            if (this.dialog != null && this.dialog.isAdded()) {
                this.dialog.dismiss();
                this.dialog = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void show(boolean isShowTimer) {
        try {
            this.isHideFloatButton = false;
            this.layoutFloat.setVisibility(0);
            this.layoutBottom.setVisibility(8);
            this.floatArea.show();
            Preference.remove((Context)activity, "shared_pref_show_dashboard");
            this.floatArea.moveToEdge(true);
            this.hideConfirmDialog();
            this.idleHandler.removeCallbacksAndMessages(null);
            this.fadeIn(false);
            if (NotificationUtils.getListNtfFromAfterAuth().size() > 0) {
                this.haveShowNotification = true;
                this.sizeListNtf = NotificationUtils.getListNtfFromAfterAuth().size();
            } else {
                this.haveShowNotification = false;
                this.sizeListNtf = 1;
            }
            if (this.haveNotiGCM) {
                this.haveShowNotification = true;
            }
            if (this.haveShowNotification) {
                Log.e((String)TAG, (String)"HAVAHVAHVAHVAH 3");
                this.handlerFadeOut();
                this.haveShowNotification = false;
                this.haveNotiGCM = false;
                this.sizeListNtf = 1;
            } else {
                Log.e((String)TAG, (String)"HAVAHVAHVAHVAH 4");
                this.handlerFadeOut();
            }
            MobGameSDK.getInstance().unRegisterSensor();
            if (NotificationUtils.hasNtf((Context)activity)) {
                Log.d((String)TAG, (String)"Vao day 5");
                floatButtonNtf.setVisibility(0);
                return;
            }
            Log.d((String)TAG, (String)"Vao day 4");
            floatButtonNtf.setVisibility(8);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void showFloatButtonToCenter() {
        try {
            this.floatArea.moveTo(0, this.boundHeight / 2 - 50);
            MobGameHelper.showFloatButton();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void hide() {
        try {
            this.idleHandler.removeCallbacksAndMessages(null);
            this.layoutFloat.setVisibility(8);
            this.layoutBottom.setVisibility(8);
            this.floatArea.hide();
            this.isHideFloatButton = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized void viberateGCM(ArrayList<NtfModel> listNtf) {
        try {
            this.haveShowNotification = true;
            this.sizeListNtf = listNtf.size();
            this.haveNotiGCM = true;
            this.viberate(listNtf);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized void viberate(final ArrayList<NtfModel> listNtf) {
        try {
            if (!Preference.getBoolean((Context)activity, "shared_pref_hide_float_button", false)) {
                Log.d((String)TAG, (String)"GOOOOOOO HEREEEEE");
                this.timerLayoutBottom.setAlpha(1.0f);
                floatButtonNtf.setAlpha(1.0f);
                this.show(FloatButtonTimerHelper.isRuningTimer());
            }
            Animation viberate = AnimationUtils.loadAnimation((Context)activity, (int)R.anim.viberate);
            viberate.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                    MobGameOverlayView.this.timerLayoutBottom.setAlpha(1.0f);
                    floatButtonNtf.setAlpha(1.0f);
                }

                public void onAnimationEnd(Animation animation) {
                    if (listNtf != null && listNtf.size() > 0) {
                        Log.d((String)TAG, (String)("GOOOOOOO HEREEEEE  " + !doTouchDown));
                        if (!doTouchDown) {
                            MobGameOverlayView.this.floatArea.showMsg(listNtf);
                        }
                        MobGameOverlayView.this.isScrolling = true;
                        MobGameOverlayView.this.floatArea.setOnScrollFinishedListener(new MobGameFloatGestureView.OnScrollFinishedListener(){

                            @Override
                            public void onScrollFinished() {
                                MobGameOverlayView.this.isScrolling = false;
                                MobGameOverlayView.this.idleHandler.removeCallbacksAndMessages(null);
                                MobGameOverlayView.this.idleHandler.postDelayed(MobGameOverlayView.this.mIdleRunnable, 300L);
                            }
                        });
                        MobGameOverlayView.this.haveShowNotification = true;
                        MobGameOverlayView.this.sizeListNtf = listNtf.size();
                    }
                }

                public void onAnimationRepeat(Animation animation) {
                }
            });
            this.floatButton.startAnimation(viberate);
            if (NotificationUtils.hasNtf((Context)activity)) {
                floatButtonNtf.startAnimation(viberate);
            }
            if (GameConfigManager.getInstance().getUserInfo().isEnableTimer()) {
                long now;
                TimerData timerData = FloatButtonTimerHelper.getFloatButtonTimerData((Context)activity);
                boolean doShowTimer = this.conditionShowTimer(timerData, now = Calendar.getInstance().getTimeInMillis());
                if (doShowTimer) {
                    this.timerLayoutBottom.startAnimation(viberate);
                } else {
                    this.timerLayoutBottom.setVisibility(8);
                }
            } else {
                this.timerLayoutBottom.setVisibility(8);
            }
            GameConfigManager.getInstance().setHasUnreadNotifications(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isShowing() {
        try {
            return this.layoutFloat.getVisibility() == 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isShowingConfirmDialog() {
        try {
            return this.dialog != null && this.dialog.isVisible();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void dismiss() {
        try {
            this.rootView.setVisibility(8);
            WindowManager windowManager = (WindowManager)activity.getApplicationContext().getSystemService("window");
            windowManager.removeView(this.rootView);
            if (this.floatArea != null) {
                this.floatArea.dismiss();
            }
            this.rootView = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void startTimer() {
        block10: {
            Log.d((String)TAG, (String)"startTimer");
            try {
                long now = Calendar.getInstance().getTimeInMillis();
                TimerData timerData = FloatButtonTimerHelper.getFloatButtonTimerData((Context)activity);
                if (timerData == null) break block10;
                this.listTimers = timerData.getListTimerObject();
                Log.i((String)TAG, (String)"Now: ");
                if (this.listTimers.isEmpty()) {
                    Log.d((String)TAG, (String)"Queue timer is empty!");
                    return;
                }
                if (this.countdownTimer != null) {
                    this.countdownTimer.setVisibility(this.countdownTimer.isRunning() ? 0 : 8);
                }
                this.startTime = this.listTimers.get(0).getStartTime();
                this.endTime = this.listTimers.get(0).getEndTime();
                this.id = this.listTimers.get(0).getId();
                Log.i((String)TAG, (String)("start: " + this.startTime));
                for (int i = 0; i < this.listTimers.size(); ++i) {
                    if (this.listTimers.get(i).getStartTime() >= now) continue;
                    this.startTime = this.listTimers.get(i).getStartTime();
                    this.endTime = this.listTimers.get(i).getEndTime();
                    this.id = this.listTimers.get(i).getId();
                    break;
                }
                if (this.endTime < now) {
                    Log.d((String)TAG, (String)("End time < Now, restart timer :endTime " + this.endTime + " , now:" + now));
                    try {
                        TimerObject timerObject = new TimerObject(this.id, this.startTime, this.endTime);
                        timerData.removeData(activity, timerObject, this.listTimers);
                        if (this.listTimers.isEmpty()) {
                            return;
                        }
                        this.startTimer();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return;
                }
                Log.i((String)TAG, (String)("Countdown time: " + this.startTime + " ," + this.endTime));
                if (this.startTime <= now && this.endTime > now) {
                    long countDownTime = this.endTime - now;
                    FloatButtonTimerHelper.setisRuningTimer(true);
                    this.countdownTimer.setVisibility(0);
                    this.floatArea.setEndTimer(this.endTime);
                    this.countdownTimer.setBase(Calendar.getInstance().getTime().getTime() + countDownTime);
                    Log.d((String)TAG, (String)("can loi : " + (Calendar.getInstance().getTime().getTime() + countDownTime)));
                    this.countdownTimer.setCountdownListener(new CountdownChronometer.CountdownListener(){

                        @Override
                        public void done() {
                            Log.d((String)TAG, (String)"Countdown done!");
                            try {
                                if (MobGameOverlayView.this.countdownTimer != null) {
                                    MobGameOverlayView.this.countdownTimer.setVisibility(8);
                                    FloatButtonTimerHelper.setcanRunTimer(false);
                                    FloatButtonTimerHelper.setisRuningTimer(false);
                                    MobGameOverlayView.this.countdownTimer.clearComposingText();
                                    MobGameOverlayView.this.countdownTimer.clearFocus();
                                }
                                if (NotificationUtils.hasNtf((Context)activity)) {
                                    floatButtonNtf.setVisibility(0);
                                }
                                new Handler().postDelayed(new Runnable(){

                                    @Override
                                    public void run() {
                                        MobGameOverlayView.this.startTimer();
                                    }
                                }, 1500L);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
                    this.countdownTimer.start();
                    Log.d((String)TAG, (String)"Start countdown");
                    return;
                }
                Log.d((String)TAG, (String)"Events have not started yet!");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private boolean conditionShowTimer(TimerData timerData, long now) {
        try {
            ArrayList<Object> listTimers = new ArrayList();
            if (timerData != null) {
                listTimers = timerData.getListTimerObject();
            }
            Log.i((String)TAG, (String)"Now: ");
            if (listTimers.isEmpty()) {
                Log.d((String)TAG, (String)"Queue timer is empty!");
                return false;
            }
            if (this.countdownTimer != null) {
                this.countdownTimer.setVisibility(this.countdownTimer.isRunning() ? 0 : 8);
            }
            long startTime = ((TimerObject)listTimers.get(0)).getStartTime();
            long endTime = ((TimerObject)listTimers.get(0)).getEndTime();
            this.id = ((TimerObject)listTimers.get(0)).getId();
            Log.i((String)TAG, (String)("start: " + startTime));
            for (int i = 0; i < listTimers.size(); ++i) {
                if (((TimerObject)listTimers.get(i)).getStartTime() >= now) continue;
                startTime = ((TimerObject)listTimers.get(i)).getStartTime();
                endTime = ((TimerObject)listTimers.get(i)).getEndTime();
                this.id = ((TimerObject)listTimers.get(i)).getId();
                break;
            }
            if (endTime < now) {
                Log.d((String)TAG, (String)("End time < Now, restart timer :endTime " + endTime + " , now:" + now));
                try {
                    TimerObject timerObject = new TimerObject(this.id, startTime, endTime);
                    timerData.removeData(activity, timerObject, listTimers);
                    if (listTimers.isEmpty()) {
                        return false;
                    }
                    this.startTimer();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return false;
            }
            return startTime <= now && endTime > now;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isShowingDashboard() {
        return this.isShowingDashboard;
    }

    static {
        doTouchDown = false;
    }
}

