/*
 * Decompiled with CFR 0.152.
 */
package com.mobgame.gui;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentManager;
import android.app.FragmentTransaction;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Bitmap;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.support.v4.content.LocalBroadcastManager;
import android.support.v4.widget.DrawerLayout;
import android.support.v7.app.AppCompatActivity;
import android.util.Log;
import android.view.View;
import android.webkit.WebView;
import android.widget.ImageButton;
import android.widget.ProgressBar;
import android.widget.Toast;
import com.facebook.FacebookSdk;
import com.mobgame.MobGameSDK;
import com.mobgame.R;
import com.mobgame.gui.MobGameWebFragment;
import com.mobgame.utils.Constants;
import com.mobgame.utils.DeviceUtils;
import com.mobgame.utils.Utils;
import org.json.JSONArray;
import org.json.JSONObject;

public class MobGameActivity
extends AppCompatActivity {
    private static String TAG = MobGameActivity.class.getSimpleName();
    public static String KEY_DATA = "data";
    public static boolean shouldReload = false;
    private boolean isFormLogin = false;
    private DrawerLayout layoutRoot;
    private View layoutMain;
    private View layoutContent;
    private ImageButton btnBack;
    private ImageButton btnClose;
    private ProgressBar prgBar;
    private MobGameWebFragment fragmentWeb;
    private float density;
    private String TAG_FRAGMENT = "fragment_web";
    private MobGameWebFragment.EventListener mWebEventListener = new MobGameWebFragment.EventListener(){

        @Override
        @SuppressLint(value={"JavascriptInterface"})
        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            try {
                view.addJavascriptInterface((Object)MobGameActivity.this, "android");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void onProgressChanged(WebView view, int progress) {
            try {
                MobGameActivity.this.updateHeaderBar();
                progress = Math.max(1, progress);
                MobGameActivity.this.prgBar.setProgress(progress);
                if (progress == 100) {
                    MobGameActivity.this.hideProgressBar();
                } else {
                    MobGameActivity.this.showProgressBar();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void onPageFinished(WebView view, String url) {
            try {
                MobGameActivity.this.updateHeaderBar();
                MobGameActivity.this.hideProgressBar();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void onScrollChanged(WebView view, int l, int t, int oldl, int oldt) {
        }

        @Override
        public void onSizeChanged(WebView view, int w, int h, int oldw, int oldh) {
        }
    };
    private boolean isShowingOfferWall;
    private BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            try {
                String category = intent.getStringExtra("category");
                Log.d((String)TAG, (String)("mBroadcastReceiver category: " + category));
                if ("mobOpenOfferWall".equalsIgnoreCase(category)) {
                    MobGameActivity.this.isShowingOfferWall = true;
                } else if (!"float_button".equalsIgnoreCase(category)) {
                    MobGameActivity.this.isShowingOfferWall = false;
                }
                if (!("gcm".equalsIgnoreCase(category) || "dashboard".equalsIgnoreCase(category) || "finish_facebook_upgrade".equalsIgnoreCase(category))) {
                    if ("dashboard_close".equalsIgnoreCase(category)) {
                        MobGameActivity.this.finish();
                    } else if ("mobOpenOfferWall".equalsIgnoreCase(category)) {
                        if (!Utils.isOnline(MobGameActivity.this.getApplicationContext())) {
                            Toast.makeText((Context)MobGameActivity.this.getApplicationContext(), (CharSequence)MobGameActivity.this.getResources().getString(R.string.error_network), (int)1).show();
                        }
                    } else if ("reload".equalsIgnoreCase(category)) {
                        MobGameActivity.this.reload();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_mob);
        FacebookSdk.sdkInitialize((Context)this.getApplicationContext());
        this.layoutRoot = (DrawerLayout)this.findViewById(R.id.layout_root);
        this.layoutMain = this.findViewById(R.id.layout_main);
        this.layoutContent = this.findViewById(R.id.layout_content);
        this.prgBar = (ProgressBar)this.findViewById(R.id.progress_bar);
        this.btnBack = (ImageButton)this.findViewById(R.id.btn_back);
        this.btnClose = (ImageButton)this.findViewById(R.id.btn_close);
        try {
            this.density = DeviceUtils.getDensity((Context)this);
            this.initComponentTop();
            String data = "";
            String url = "";
            this.isFormLogin = false;
            try {
                data = this.getIntent().getExtras().getString(KEY_DATA);
                if (data.contains("[")) {
                    JSONArray item = new JSONArray(data);
                    JSONObject chilItem = new JSONObject();
                    chilItem = item.getJSONObject(0);
                    url = chilItem.getString("action");
                } else {
                    JSONObject chilItem = new JSONObject(data);
                    url = chilItem.getString("action");
                    this.isFormLogin = true;
                }
                Log.d((String)TAG, (String)("url : " + url));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.fragmentWeb = new MobGameWebFragment(url);
            this.fragmentWeb.setEventListener(this.mWebEventListener);
            FragmentManager fm = this.getFragmentManager();
            FragmentTransaction ft = fm.beginTransaction();
            ft.add(this.layoutContent.getId(), (Fragment)this.fragmentWeb, this.TAG_FRAGMENT);
            ft.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initComponentTop() {
        try {
            this.btnClose.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (MobGameActivity.this.isFormLogin) {
                        MobGameSDK.getInstance().closeFormLogin();
                        MobGameSDK.getInstance().customizeTracking((Activity)MobGameActivity.this, "ft_login_closed", null);
                    } else {
                        MobGameSDK.getInstance().customizeTracking((Activity)MobGameActivity.this, "ft_payment_closed", null);
                        MobGameSDK.getInstance().close();
                    }
                }
            });
            this.btnBack.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    MobGameActivity.this.onBackPressed();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void onResume() {
        super.onResume();
        try {
            LocalBroadcastManager.getInstance((Context)this).registerReceiver(this.mBroadcastReceiver, new IntentFilter("com.mobgame.broadcast"));
            Intent intent = new Intent("com.mobgame.broadcast");
            intent.putExtra("category", "float_button");
            intent.putExtra("message", "hide");
            LocalBroadcastManager.getInstance((Context)this).sendBroadcast(intent);
            if (shouldReload) {
                this.reload();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void onPause() {
        try {
            LocalBroadcastManager.getInstance((Context)this).unregisterReceiver(this.mBroadcastReceiver);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        super.onPause();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        try {
            MobGameSDK.getInstance().onActivityResult(requestCode, resultCode, data);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @TargetApi(value=19)
    public void onWindowFocusChanged(boolean hasFocus) {
        try {
            if (Build.VERSION.SDK_INT >= 19 && hasFocus) {
                this.getWindow().getDecorView().setSystemUiVisibility(5126);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onBackPressed() {
        try {
            Log.i((String)TAG, (String)"onBackPressed:");
            MobGameWebFragment fragWeb = this.fragmentWeb;
            if (fragWeb.canGoBack()) {
                fragWeb.goBack();
            } else if (this.isFormLogin) {
                MobGameSDK.getInstance().closeFormLogin();
                MobGameSDK.getInstance().customizeTracking((Activity)this, "ft_login_closed", null);
            } else {
                MobGameSDK.getInstance().customizeTracking((Activity)this, "ft_payment_closed", null);
                MobGameSDK.getInstance().close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void reload() {
        try {
            shouldReload = false;
            this.fragmentWeb.reload();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateHeaderBar() {
        try {
            final MobGameWebFragment fragWeb = this.fragmentWeb;
            if (fragWeb != null && fragWeb.isAdded()) {
                this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        String title = fragWeb.getTitle();
                        if (title.contains(Constants.DOMAIN_NAME) || title.equalsIgnoreCase("about:blank") || title.equalsIgnoreCase("website not available") || title.contains("data:text/html") || title.startsWith("http://") || title.startsWith("https://")) {
                            title = "";
                        }
                        if (!Utils.isOnline(MobGameActivity.this.getApplicationContext())) {
                            title = "Website not available";
                        }
                        Log.d((String)TAG, (String)("title : " + title));
                        if (fragWeb.canGoBack()) {
                            MobGameActivity.this.btnBack.setVisibility(0);
                        } else {
                            MobGameActivity.this.btnBack.setVisibility(8);
                        }
                    }
                });
                String inject = "if (typeof getShareUrl === 'function') {\t\t\t\t\t\t\t\ttry {\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\twindow.android.onGetShareUrl(getShareUrl());\t\t\t\t\t} catch (err) {\t\t\t\t\t\t\t\t\t\t\t\t\t\t\twindow.android.onGetShareUrl('');\t\t\t\t\t\t\t\t\tconsole.log(err);\t\t\t\t\t\t\t\t\t\t\t\t}\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t} else {\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\twindow.android.onGetShareUrl('');\t\t\t\t\t\t\t\t}\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t";
                fragWeb.invokeJavascript(inject);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void showProgressBar() {
        try {
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        MobGameActivity.this.prgBar.setVisibility(0);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void hideProgressBar() {
        try {
            new Handler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    MobGameActivity.this.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                MobGameActivity.this.prgBar.setVisibility(8);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
                }
            }, 500L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

