/*
 * Decompiled with CFR 0.152.
 */
package com.mobgame;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Vibrator;
import android.support.v4.content.LocalBroadcastManager;
import android.text.TextUtils;
import android.util.Log;
import com.bumptech.glide.Glide;
import com.google.android.gcm.GCMBaseIntentService;
import com.google.android.gcm.GCMRegistrar;
import com.mobgame.R;
import com.mobgame.api.SaveGCMTask;
import com.mobgame.component.GameConfigManager;
import com.mobgame.model.NtfModel;
import com.mobgame.model.TimerData;
import com.mobgame.model.TimerObject;
import com.mobgame.utils.FloatButtonTimerHelper;
import com.mobgame.utils.NotificationUtils;
import com.mobgame.utils.Preference;
import com.mobgame.utils.Res;
import com.mobgame.utils.TimeUtils;
import java.util.ArrayList;
import java.util.Calendar;
import org.json.JSONArray;
import org.json.JSONObject;

public class MobGameGCMIntentService
extends GCMBaseIntentService {
    private static final String TAG = MobGameGCMIntentService.class.getSimpleName();
    private static final String GCM_SENDER_ID = "461098885975";
    private static Class<?> mainClass;
    private static Handler registerHandler;
    public static int NOTIFICATION_ID;

    public MobGameGCMIntentService() {
        super(new String[]{GCM_SENDER_ID});
    }

    protected int getDrawableSmall(Context c) {
        return Res.drawableResource(c, R.drawable.ic_stat_mob);
    }

    protected void onRegistered(Context c, String registrationId) {
        Log.i((String)TAG, (String)("onRegistered:" + registrationId));
        MobGameGCMIntentService.registerToServer(c, registrationId);
    }

    protected void onUnregistered(Context context, String regId) {
        Log.i((String)TAG, (String)("onUnregistered:" + regId));
    }

    protected void onError(Context context, String errorId) {
        Log.i((String)TAG, (String)("onError: " + errorId));
    }

    protected boolean onRecoverableError(Context context, String errorId) {
        Log.i((String)TAG, (String)("onRecoverableError: " + errorId));
        return super.onRecoverableError(context, errorId);
    }

    protected void onMessage(Context context, Intent messageIntent) {
        try {
            Log.i((String)TAG, (String)("onMessage: " + messageIntent));
            Vibrator v = (Vibrator)context.getSystemService("vibrator");
            v.vibrate(30L);
            Bundle extras = messageIntent.getExtras();
            String title = extras.getString("title");
            String message = extras.getString("message");
            String noti = extras.getString("noti");
            String id = extras.getString("id");
            String url = extras.getString("url");
            String timer = extras.getString("timer");
            Log.i((String)TAG, (String)("id: " + id));
            Log.i((String)TAG, (String)("title: " + title));
            Log.i((String)TAG, (String)("message: " + message));
            Log.i((String)TAG, (String)("url: " + url));
            Log.i((String)TAG, (String)("timer: " + timer));
            if (url != null) {
                Glide.with((Context)context.getApplicationContext()).load(url).downloadOnly(512, 256);
            }
            Intent intent = new Intent("com.mobgame.broadcast");
            intent.putExtra("category", "gcm");
            intent.putExtra("id", id);
            intent.putExtra("title", title);
            intent.putExtra("noti", noti);
            intent.putExtra("mesage", message);
            if (timer != null || timer == "") {
                Log.d((String)TAG, (String)"VAO DAY");
                this.parseTimerData(context, timer, intent);
            }
            LocalBroadcastManager.getInstance((Context)context).sendBroadcast(intent);
            GameConfigManager.getInstance().setHasUnreadNotifications(true);
            if (!TextUtils.isEmpty((CharSequence)id)) {
                NtfModel ntfModel = new NtfModel();
                ntfModel.setId(Integer.parseInt(id));
                ntfModel.setTitle(title);
                ntfModel.setNoti(Boolean.parseBoolean(message));
                NotificationUtils.addNtf(context, ntfModel);
            }
            if (!TextUtils.isEmpty((CharSequence)title) || !TextUtils.isEmpty((CharSequence)message)) {
                if (url != null) {
                    NotificationUtils.getInstance(context).setMainClass(mainClass).setMessage(message).setTitle(title).setImageUrl(url).showNotificationWithImage();
                } else {
                    NotificationUtils.getInstance(context).setMainClass(mainClass).setMessage(message).setTitle(title).showNotification();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void parseTimerData(Context context, String timer, Intent intent) {
        if (!TextUtils.isEmpty((CharSequence)timer)) {
            try {
                Log.d((String)TAG, (String)("Timer : " + timer));
                JSONArray timerJsonArray = new JSONArray(timer);
                for (int i = 0; i < timerJsonArray.length(); ++i) {
                    JSONObject timerJsonObj = timerJsonArray.getJSONObject(i);
                    long startTime = TimeUtils.getMilisecondByTimestamp(timerJsonObj.optLong("start"));
                    long endTime = TimeUtils.getMilisecondByTimestamp(timerJsonObj.optLong("end"));
                    int id = timerJsonObj.getInt("id");
                    long now = Calendar.getInstance().getTimeInMillis();
                    TimerData timerData = FloatButtonTimerHelper.getFloatButtonTimerData(context);
                    if (timerData == null) {
                        Log.d((String)TAG, (String)"vao null");
                        ArrayList<TimerObject> listTimerObject = new ArrayList<TimerObject>();
                        TimerObject timerObject = new TimerObject();
                        timerObject.setId(id);
                        timerObject.setStartTime(startTime);
                        timerObject.setEndTime(endTime);
                        listTimerObject.add(timerObject);
                        timerData = new TimerData();
                        timerData.setListTimerObject(listTimerObject);
                        timerData.saveData(context, timerData);
                        if (startTime <= now && now < endTime) {
                            FloatButtonTimerHelper.setcanRunTimer(true);
                            FloatButtonTimerHelper.setisRuningTimer(true);
                        }
                    } else {
                        Log.d((String)TAG, (String)"Vao khong null");
                        ArrayList<Object> listTimer = new ArrayList();
                        listTimer = timerData.getListTimerObject();
                        TimerObject timerObj = new TimerObject();
                        timerObj.setId(id);
                        timerObj.setStartTime(startTime);
                        timerObj.setEndTime(endTime);
                        listTimer.add(timerObj);
                        timerData.setListTimerObject(listTimer);
                        timerData.saveData(context, timerData);
                        if (FloatButtonTimerHelper.isRuningTimer()) {
                            FloatButtonTimerHelper.setcanRunTimer(false);
                        } else if (startTime <= now && now < endTime) {
                            FloatButtonTimerHelper.setcanRunTimer(true);
                            FloatButtonTimerHelper.setisRuningTimer(true);
                        } else {
                            FloatButtonTimerHelper.setcanRunTimer(false);
                        }
                    }
                    intent.putExtra("show-timer", true);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    static void register(Context context) {
        Log.i((String)TAG, (String)"register");
        try {
            if (context instanceof Activity) {
                Activity activity = (Activity)context;
                mainClass = activity.getClass();
                Preference.save(context, "shared_pref_main_activity", mainClass.getName());
                Log.i((String)TAG, (String)("mainClass:" + mainClass.getName()));
            }
            Context appContext = context.getApplicationContext();
            GCMRegistrar.checkDevice((Context)appContext);
            GCMRegistrar.checkManifest((Context)appContext);
            String regId = GCMRegistrar.getRegistrationId((Context)appContext);
            Log.i((String)TAG, (String)("regId:" + regId));
            if (TextUtils.isEmpty((CharSequence)regId)) {
                Log.i((String)TAG, (String)"Automatically registers application on startup");
                GCMRegistrar.register((Context)appContext, (String[])new String[]{GCM_SENDER_ID});
            } else {
                MobGameGCMIntentService.registerToServer(appContext, regId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static void destroy(Context context) {
        try {
            if (registerHandler != null) {
                registerHandler.removeCallbacksAndMessages(null);
            }
            GCMRegistrar.onDestroy((Context)context.getApplicationContext());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void registerToServer(Context context, String regId) {
        try {
            Log.i((String)TAG, (String)"register");
            if (!TextUtils.isEmpty((CharSequence)regId)) {
                new SaveGCMTask(regId).execute(new Void[0]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        registerHandler = new Handler();
        NOTIFICATION_ID = 1110;
    }
}

