/*
 * Decompiled with CFR 0.152.
 */
package com.zing.zalo.zalosdk.oauth;

import android.app.AlertDialog;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageInfo;
import android.os.AsyncTask;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import com.zing.zalo.zalosdk.common.UtilsCore;
import com.zing.zalo.zalosdk.core.helper.AppInfo;
import com.zing.zalo.zalosdk.core.helper.Utils;
import com.zing.zalo.zalosdk.core.http.HttpClientRequest;
import com.zing.zalo.zalosdk.oauth.FeedData;
import com.zing.zalo.zalosdk.oauth.LoginChannel;
import com.zing.zalo.zalosdk.oauth.OauthStorage;
import com.zing.zalo.zalosdk.oauth.OpenAPIActivity;
import com.zing.zalo.zalosdk.oauth.ShareVia;
import com.zing.zalo.zalosdk.oauth.Utilities;
import com.zing.zalo.zalosdk.oauth.WebDialog;
import com.zing.zalo.zalosdk.oauth.ZaloOpenAPICallback;
import com.zing.zalo.zalosdk.oauth.ZaloPluginCallback;
import com.zing.zalo.zalosdk.oauth.ZaloSDK;
import java.lang.ref.WeakReference;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class OpenAPIService {
    private WeakReference<ZaloOpenAPICallback> mOpenAPICallack;
    private OauthStorage mStorage = null;
    private String mUrl = "http://openapi.zaloapp.com/query";
    private static final String ZALO_PARAM_BACK_TO_SOURCE = "backToSource";
    private static final String ZALO_PARAM_POST_FEED = "postFeed";
    private boolean unableShareWebView = false;
    protected WeakReference<ZaloPluginCallback> mCallback;
    protected WeakReference<Context> mWeakContext;
    protected FeedData mFeedOb;
    private String _shareTo = "";
    private String tokenShareZalo = "";
    private BroadcastReceiver feedCallbackReceiver;
    private boolean isRegister = false;
    private WeakReference<ZaloPluginCallback> mCallbackZaloClient;
    private static final String UTF8 = "UTF-8";
    private ShareVia shareVia = ShareVia.AppThenWeb;
    private boolean shareMessageChatOnly = false;
    private static OpenAPIService Instance;

    OpenAPIService() {
        this.mStorage = ZaloSDK.Instance.getOauthStorage();
    }

    public static OpenAPIService getInstance() {
        if (Instance == null) {
            Instance = new OpenAPIService();
        }
        return Instance;
    }

    private JSONObject getAccessToken(Context ctx) {
        JSONObject accessToken = null;
        try {
            accessToken = new JSONObject(this.mStorage.getAccessToken());
            if (accessToken.getLong("expires_in") < System.currentTimeMillis()) {
                accessToken = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (accessToken == null) {
                HttpClientRequest request = new HttpClientRequest(HttpClientRequest.Type.POST, "https://oauth.zaloapp.com/v2/mobile/access_token");
                request.addParams("code", ZaloSDK.Instance.getOAuthCode());
                request.addParams("pkg_name", AppInfo.getPackageName((Context)ctx));
                request.addParams("sign_key", AppInfo.getApplicationHashKey((Context)ctx));
                request.addParams("app_id", ZaloSDK.Instance.getAppID() + "");
                request.addParams("version", ZaloSDK.Instance.getVersion());
                accessToken = request.getJSON();
                if (accessToken != null && accessToken.optInt("error", -1) >= 0) {
                    accessToken = accessToken.optJSONObject("data");
                    accessToken.put("error", 0);
                    if (accessToken != null) {
                        long time = System.currentTimeMillis() + 1800000L;
                        accessToken.put("expires_in", time);
                        this.mStorage.setAccessToken(accessToken.toString());
                    }
                }
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return accessToken;
    }

    public void getProfile(Context ctx, ZaloOpenAPICallback callback) {
        this.mOpenAPICallack = new WeakReference<ZaloOpenAPICallback>(callback);
        HttpClientRequest request = new HttpClientRequest(HttpClientRequest.Type.GET, this.mUrl);
        request.addParams("act", "profile");
        new UserTask(ctx).execute(new HttpClientRequest[]{request});
    }

    public void getFriendList(Context ctx, int position, int count, ZaloOpenAPICallback callback) {
        this.mOpenAPICallack = new WeakReference<ZaloOpenAPICallback>(callback);
        HttpClientRequest request = new HttpClientRequest(HttpClientRequest.Type.GET, this.mUrl);
        request.addParams("act", "lstfri");
        request.addParams("pos", position + "");
        request.addParams("count", count + "");
        new UserTask(ctx).execute(new HttpClientRequest[]{request});
    }

    private String getRegistrationId(Context context) {
        int currentVersion;
        String registrationId = this.mStorage.getGCMToken();
        if (TextUtils.isEmpty((CharSequence)registrationId)) {
            return "";
        }
        int registeredVersion = this.mStorage.getAppVersion();
        if (registeredVersion != (currentVersion = UtilsCore.getAppVersion((Context)context))) {
            return "";
        }
        return registrationId;
    }

    public void setShareZaloUsing(ShareVia _shareVia) {
        this.shareVia = _shareVia;
    }

    public void setShareZaloChatOnly(boolean chatOnly) {
        this.shareMessageChatOnly = chatOnly;
    }

    public ShareVia getShareZaloUsing() {
        return this.shareVia;
    }

    public void shareFeed(Context context, FeedData feedOb, ZaloPluginCallback callback) {
        this.loginThenShare(context, feedOb, callback, "feed");
    }

    public void shareMessage(Context context, FeedData feedOb, ZaloPluginCallback callback) {
        this.loginThenShare(context, feedOb, callback, "message");
    }

    public void share(Context context, FeedData feedOb, ZaloPluginCallback callback) {
        this.loginThenShare(context, feedOb, callback, null);
    }

    private void showOptionShare(final Context context, final FeedData feedOb, final ZaloPluginCallback callback) {
        CharSequence[] colors = new CharSequence[]{"G\u1eedi tin nh\u1eafn Zalo", "\u0110\u0103ng l\u00ean Zalo"};
        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        builder.setTitle((CharSequence)"Ch\u1ecdn");
        builder.setItems(colors, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                if (which == 0) {
                    OpenAPIService.this.doShare(context, feedOb, callback, "message");
                } else {
                    OpenAPIService.this.doShare(context, feedOb, callback, "feed");
                }
            }
        });
        builder.show();
    }

    private void shareWebView(final Context context, final FeedData feedOb, final ZaloPluginCallback callback, final String shareTo) {
        try {
            StringBuffer sb = new StringBuffer();
            sb.append("msg=").append(URLEncoder.encode(feedOb.getMsg(), UTF8)).append("&");
            sb.append("link=").append(URLEncoder.encode(feedOb.getLink(), UTF8)).append("&");
            sb.append("app_name=").append(URLEncoder.encode(feedOb.getAppName(), UTF8)).append("&");
            sb.append("app_id=").append(String.valueOf(ZaloSDK.Instance.getAppID())).append("&");
            if (!TextUtils.isEmpty((CharSequence)shareTo)) {
                sb.append("share_to=").append(shareTo).append("&");
            }
            sb.append("code=").append(URLEncoder.encode(this.mStorage.getZaloPluginOAuthCode(), UTF8)).append("&");
            PackageInfo pInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            String version = pInfo.versionName;
            sb.append("app_version=").append(version).append("&");
            sb.append("sdk_version=").append(String.valueOf(ZaloSDK.Instance.getVersion())).append("&");
            sb.append("device_id=").append(ZaloSDK.Instance.getDeviceId()).append("&");
            StringBuffer extraBody = new StringBuffer();
            extraBody.append("link_title=").append(URLEncoder.encode(feedOb.getLinkTitle(), UTF8)).append("&");
            extraBody.append("link_desc=").append(URLEncoder.encode(feedOb.getLinkDesc(), UTF8)).append("&");
            extraBody.append("link_source=").append(URLEncoder.encode(feedOb.getLinkSource(), UTF8)).append("&");
            if (feedOb.getLinkThumb() != null) {
                int length = feedOb.getLinkThumb().length;
                for (int i = 0; i < length; ++i) {
                    extraBody.append("link_thumb=").append(URLEncoder.encode(feedOb.getLinkThumb()[i], UTF8)).append("&");
                }
            }
            if (feedOb.getParams() != null) {
                for (Map.Entry<String, String> entry : feedOb.getParams().entrySet()) {
                    String key = entry.getKey();
                    String value = entry.getValue();
                    sb.append(key + "=").append(URLEncoder.encode(value, UTF8)).append("&");
                }
            }
            Bundle bundle = new Bundle();
            bundle.putString("querystring", sb.toString());
            bundle.putString("bodyrequest", extraBody.toString());
            final WebDialog feedDialog = new WebDialog.FeedDialogBuilder(context, bundle).build();
            feedDialog.setFeedCallBackListener(new ZaloPluginCallback(){

                public void onResult(boolean arg0, int errorCode, String arg2, String arg3) {
                    feedDialog.dismiss();
                    HashMap<String, String> params = new HashMap<String, String>();
                    params.put("type", shareTo);
                    params.put("url", feedOb.getLink());
                    params.put("message", feedOb.getMsg());
                    params.put("appName", feedOb.getAppName());
                    int sent = 1;
                    if (errorCode != 0) {
                        sent = -1;
                    }
                    params.put("sent", String.valueOf(sent));
                    params.put("error_code", String.valueOf(errorCode));
                    Utils.addEventZingAnalytics((String)"plugin_share", params);
                    if (errorCode == -10) {
                        OpenAPIService.this.unableShareWebView = true;
                        OpenAPIService.this.doShare(context, feedOb, callback, shareTo);
                    } else if (errorCode == -1) {
                        OpenAPIService.this.loginZalo(context, feedOb, callback, shareTo);
                    } else {
                        OpenAPIService.this.unableShareWebView = false;
                        if (callback != null) {
                            callback.onResult(arg0, errorCode, arg2, arg3);
                        }
                    }
                }
            });
            feedDialog.show();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void loginThenShare(Context context, FeedData feedOb, ZaloPluginCallback callback, String shareTo) {
        if (ZaloSDK.Instance.isAuthenticate(this.mStorage.getZaloPluginOAuthCode(), null)) {
            this.doShare(context, feedOb, callback, shareTo);
        } else {
            if (LoginChannel.ZALO.toString().equalsIgnoreCase(this.mStorage.getLastestLoginChannel()) && ZaloSDK.Instance.isAuthenticate(null)) {
                this.mStorage.setZaloPluginOAuthCode(this.mStorage.getOAuthCode());
                this.mStorage.setZaloPluginUserId(this.mStorage.getZaloId());
                this.doShare(context, feedOb, callback, shareTo);
                return;
            }
            this.loginZalo(context, feedOb, callback, shareTo);
        }
    }

    protected void doShare(Context context, FeedData feedOb, ZaloPluginCallback callback, String shareTo) {
        this.mFeedOb = feedOb;
        this._shareTo = shareTo;
        if (this.unableShareWebView) {
            this.shareZalo(context, feedOb, callback, shareTo);
            return;
        }
        if (this.shareVia == ShareVia.AppThenWeb) {
            if (Utilities.isZaloInstalled((Context)context)) {
                this.shareZalo(context, feedOb, callback, shareTo);
            } else {
                this.shareWebView(context, feedOb, callback, shareTo);
            }
        } else {
            this.shareWebView(context, feedOb, callback, shareTo);
        }
    }

    private void shareZalo(Context context, FeedData feedOb, ZaloPluginCallback callback, String shareTo) {
        if (TextUtils.isEmpty((CharSequence)shareTo)) {
            this.showOptionShare(context, feedOb, callback);
        } else {
            boolean ableCalled;
            Intent intent = this.getShareIntentZalo(context, feedOb, shareTo);
            boolean bl = ableCalled = intent.resolveActivityInfo(context.getPackageManager(), 0) != null;
            if (ableCalled) {
                this.registerBroadCast(context);
                this.mCallbackZaloClient = new WeakReference<ZaloPluginCallback>(callback);
                context.startActivity(intent);
            } else {
                Utilities.invokeMarketApp((Context)context, (String)"com.zing.zalo");
            }
        }
    }

    private Intent newIntent(Context context) {
        return new Intent(context, OpenAPIActivity.class);
    }

    private Intent newShareFeedLoginIntent(Context context, String shareTo) {
        Intent intent = this.newIntent(context);
        intent.addFlags(0x10000000);
        intent.putExtra("login_from_share_feed", true);
        intent.putExtra("share_to", shareTo);
        return intent;
    }

    private void loginZalo(Context context, FeedData feedOb, ZaloPluginCallback callback, String shareTo) {
        this.mFeedOb = feedOb;
        this.mCallback = new WeakReference<ZaloPluginCallback>(callback);
        this.mWeakContext = new WeakReference<Context>(context);
        Intent intent = this.newShareFeedLoginIntent(context, shareTo);
        context.startActivity(intent);
    }

    private Intent getShareIntentZalo(Context context, FeedData feedOb, String shareTo) {
        Intent intent = new Intent("android.intent.action.SEND");
        intent.setType("text/plain");
        intent.setComponent(new ComponentName("com.zing.zalo", "com.zing.zalo.ui.TempShareViaActivity"));
        intent.putExtra("android.intent.extra.SUBJECT", feedOb.getMsg());
        intent.putExtra("android.intent.extra.TEXT", feedOb.getLink());
        this.tokenShareZalo = String.valueOf(System.currentTimeMillis());
        intent.putExtra("token", this.tokenShareZalo);
        if (!TextUtils.isEmpty((CharSequence)shareTo)) {
            if (shareTo.equals("feed")) {
                intent.putExtra(ZALO_PARAM_POST_FEED, true);
            } else if (shareTo.equals("message") && this.shareMessageChatOnly) {
                intent.putExtra("hidePostFeed", true);
            }
        }
        intent.putExtra(ZALO_PARAM_BACK_TO_SOURCE, true);
        return intent;
    }

    private void registerBroadCast(Context mContext) {
        ZaloPluginCallback callback;
        if (Utilities.isZaloSupportCallBack((Context)mContext)) {
            if (!this.isRegister) {
                IntentFilter filter = new IntentFilter();
                filter.addAction("com.zing.zalo.shareFeedResultInfo");
                this.feedCallbackReceiver = new BroadcastReceiver(){

                    public void onReceive(Context context, Intent intent) {
                        String json = intent.getExtras().getString("result");
                        JSONObject jOb = null;
                        try {
                            jOb = new JSONObject(json);
                            int errorCode = 0;
                            boolean isSucc = false;
                            String token = null;
                            if (jOb != null && jOb.has("token") && (token = jOb.getString("token")) != null && token.equals(OpenAPIService.this.tokenShareZalo)) {
                                HashMap<String, String> params = new HashMap<String, String>();
                                params.put("type", OpenAPIService.this._shareTo);
                                params.put("url", OpenAPIService.this.mFeedOb.getLink());
                                params.put("message", OpenAPIService.this.mFeedOb.getMsg());
                                params.put("appName", OpenAPIService.this.mFeedOb.getAppName());
                                params.put("sent", String.valueOf(jOb.getInt("send_action")));
                                errorCode = jOb.getInt("error_code");
                                params.put("error_code", String.valueOf(errorCode));
                                Utils.addEventZingAnalytics((String)"plugin_share", params);
                                OpenAPIService.this.unRegisterReceiver(context);
                                if (OpenAPIService.this.mCallbackZaloClient != null) {
                                    ZaloPluginCallback callback = (ZaloPluginCallback)OpenAPIService.this.mCallbackZaloClient.get();
                                    if (errorCode == 0) {
                                        isSucc = true;
                                    }
                                    if (callback != null) {
                                        callback.onResult(isSucc, jOb.getInt("error_code"), null, null);
                                    }
                                }
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                };
                mContext.registerReceiver(this.feedCallbackReceiver, filter);
                this.isRegister = true;
                Log.i((String)"debuglog", (String)"register broadcast receiver=====");
            }
        } else if (this.mCallbackZaloClient != null && (callback = (ZaloPluginCallback)this.mCallbackZaloClient.get()) != null) {
            callback.onResult(true, 0, null, null);
        }
    }

    private void unRegisterReceiver(Context mContext) {
        if (this.feedCallbackReceiver != null) {
            mContext.unregisterReceiver(this.feedCallbackReceiver);
            this.isRegister = false;
            Log.i((String)"debuglog", (String)"unregister ----- broadcast receiver=====");
        }
    }

    public void submitEventCancelDialog() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("type", this._shareTo);
        params.put("url", this.mFeedOb.getLink());
        params.put("message", this.mFeedOb.getMsg());
        params.put("appName", this.mFeedOb.getAppName());
        params.put("sent", "0");
        params.put("error_code", "0");
        Utils.addEventZingAnalytics((String)"plugin_share", params);
    }

    private class UserTask
    extends AsyncTask<HttpClientRequest, Void, JSONObject> {
        Context ctx;

        UserTask(Context ctx) {
            this.ctx = ctx;
        }

        protected void onPreExecute() {
            super.onPreExecute();
        }

        protected JSONObject doInBackground(HttpClientRequest ... requests) {
            HttpClientRequest request = requests[0];
            if (ZaloSDK.Instance.getOAuthCode() == null || ZaloSDK.Instance.getOAuthCode().equals("")) {
                try {
                    return new JSONObject("{\"error\":-1004}");
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            JSONObject accessToken = OpenAPIService.this.getAccessToken(this.ctx);
            if (accessToken == null) {
                try {
                    return new JSONObject("{\"error\":-1008}");
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            if (accessToken.optInt("error", -1) >= 0) {
                request.addParams("appid", ZaloSDK.Instance.getAppID() + "");
                request.addParams("accessTok", accessToken.optString("access_token"));
                request.addParams("version", "3");
                return request.getJSON();
            }
            return accessToken;
        }

        protected void onPostExecute(JSONObject object) {
            try {
                if (object != null) {
                    if (OpenAPIService.this.mOpenAPICallack != null && OpenAPIService.this.mOpenAPICallack.get() != null) {
                        ((ZaloOpenAPICallback)OpenAPIService.this.mOpenAPICallack.get()).onResult(object);
                    } else if (OpenAPIService.this.mOpenAPICallack != null && OpenAPIService.this.mOpenAPICallack.get() != null) {
                        ((ZaloOpenAPICallback)OpenAPIService.this.mOpenAPICallack.get()).onResult(new JSONObject("{\"error\":-1112}"));
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

