/*
 * Decompiled with CFR 0.152.
 */
package com.zing.zalo.zalosdk.oauth;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import com.zing.zalo.zalosdk.oauth.OAuthCompleteListener;
import com.zing.zalo.zalosdk.oauth.OauthResponse;
import com.zing.zalo.zalosdk.oauth.OpenAPIService;
import com.zing.zalo.zalosdk.oauth.ZaloPluginCallback;
import com.zing.zalo.zalosdk.oauth.ZaloSDK;

public class OpenAPIActivity
extends Activity {
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        boolean login_from_share_feed = this.getIntent().getBooleanExtra("login_from_share_feed", false);
        String shareTo = this.getIntent().getStringExtra("share_to");
        if (login_from_share_feed) {
            LoginListener listener = new LoginListener(shareTo);
            ZaloSDK.Instance.authenticateZaloPlugin((Activity)this, (OAuthCompleteListener)listener);
            return;
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        ZaloSDK.Instance.onActivityResult((Activity)this, requestCode, resultCode, data);
    }

    private class LoginListener
    extends OAuthCompleteListener {
        String shareTo;

        public LoginListener(String shareTo) {
            this.shareTo = shareTo;
        }

        public void onAuthenError(int errorCode, String message) {
            ZaloPluginCallback callback;
            super.onAuthenError(errorCode, message);
            if (OpenAPIService.getInstance().mCallback != null && (callback = (ZaloPluginCallback)OpenAPIService.getInstance().mCallback.get()) != null) {
                callback.onResult(false, errorCode, message, "");
            }
            OpenAPIActivity.this.finish();
        }

        public void onGetOAuthComplete(OauthResponse response) {
            super.onGetOAuthComplete(response);
            OpenAPIService op = OpenAPIService.getInstance();
            if (op.mCallback != null) {
                ZaloPluginCallback callback = (ZaloPluginCallback)op.mCallback.get();
                Context context = (Context)op.mWeakContext.get();
                if (callback != null && context != null) {
                    op.doShare(context, op.mFeedOb, callback, this.shareTo);
                }
            }
            OpenAPIActivity.this.finish();
        }
    }
}

