/*
 * Decompiled with CFR 0.152.
 */
package com.zing.zalo.zalosdk.oauth.register;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.DatePickerDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.Parcelable;
import android.provider.MediaStore;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.DialogFragment;
import android.support.v4.content.ContextCompat;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.DatePicker;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.RadioButton;
import android.widget.TextView;
import com.zing.zalo.zalosdk.R;
import com.zing.zalo.zalosdk.core.helper.BitmapHelper;
import com.zing.zalo.zalosdk.core.helper.Utils;
import com.zing.zalo.zalosdk.core.log.Log;
import com.zing.zalo.zalosdk.oauth.register.UpdateProfileAsyncTask;
import com.zing.zalo.zalosdk.oauth.register.ZaloWebLoginBaseFragment;
import com.zing.zalo.zalosdk.oauth.register.ZaloWebLoginFragment;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

@TargetApi(value=10)
public class ZaloWebUpdateProfileFragment
extends ZaloWebLoginBaseFragment
implements View.OnClickListener,
View.OnTouchListener {
    static final int SELECT_PICTURE = 1;
    static final int REQUEST_IMAGE_CAPTURE = 2;
    static final int REQUEST_CROP = 3;
    static final int REQUEST_PERMISSION_READ = 11;
    static final int REQUEST_PERMISSION_READ_FOR_CAMERA = 13;
    static final int REQUEST_PERMISSION_CAMERA = 12;
    protected ZaloWebUpdateProfileFragmentListener listener;
    private EditText nameInput;
    private RadioButton maleButton;
    private RadioButton femaleButton;
    private View edit_day;
    private View update;
    private View next;
    private ImageView update_avatar;
    private TextView birthday;
    private LayoutInflater inflater;
    private String phoneNumber;
    private String countryCode;
    private String oauthCode;
    private String displayName;
    private String gender;
    private String dob;
    private String token;
    private long uid;
    private int zprotect;
    private Bitmap avatarBitmap;
    private Uri mImageCaptureUri;

    public static ZaloWebUpdateProfileFragment newIstance(String phoneNumber, String countryCode, long uid, String oauthCode, String displayName, String gender, String dob, int zprotect, String socialId, String token) {
        ZaloWebUpdateProfileFragment fragment = new ZaloWebUpdateProfileFragment();
        Bundle bundle = new Bundle();
        bundle.putString("phoneNumber", phoneNumber);
        bundle.putString("countryCode", countryCode);
        bundle.putLong("uid", uid);
        bundle.putString("oauthCode", oauthCode);
        bundle.putString("displayName", displayName);
        bundle.putString("gender", gender);
        bundle.putString("dob", dob);
        bundle.putInt("zprotect", zprotect);
        bundle.putString("token", token);
        fragment.setArguments(bundle);
        return fragment;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        int buttonId = 0;
        int layoutId = Utils.getResourceId((Context)this.getContext(), (String)"zalosdk_fragment_zalo_web_update_profile", (String)"layout");
        Bundle bundle = this.getArguments();
        this.phoneNumber = bundle.getString("phoneNumber");
        this.countryCode = bundle.getString("countryCode");
        this.uid = bundle.getLong("uid");
        this.oauthCode = bundle.getString("oauthCode");
        this.displayName = bundle.getString("displayName");
        this.gender = bundle.getString("gender");
        this.dob = bundle.getString("dob");
        this.zprotect = bundle.getInt("zprotect");
        this.token = bundle.getString("token");
        this.inflater = inflater;
        View view = inflater.inflate(layoutId, container, false);
        buttonId = Utils.getResourceId((Context)this.getContext(), (String)"name", (String)"id");
        this.nameInput = (EditText)view.findViewById(buttonId);
        this.nameInput.setOnTouchListener((View.OnTouchListener)this);
        this.nameInput.requestFocus();
        if (TextUtils.isEmpty((CharSequence)this.displayName)) {
            this.nameInput.setText((CharSequence)this.displayName);
        }
        boolean isFemale = this.gender.equals("2") || this.gender.equals("female");
        buttonId = Utils.getResourceId((Context)this.getContext(), (String)"gender_male", (String)"id");
        this.maleButton = (RadioButton)view.findViewById(buttonId);
        this.maleButton.setOnClickListener((View.OnClickListener)this);
        this.maleButton.setChecked(!isFemale);
        buttonId = Utils.getResourceId((Context)this.getContext(), (String)"gender_female", (String)"id");
        this.femaleButton = (RadioButton)view.findViewById(buttonId);
        this.femaleButton.setOnClickListener((View.OnClickListener)this);
        this.femaleButton.setChecked(isFemale);
        buttonId = Utils.getResourceId((Context)this.getContext(), (String)"edit_day", (String)"id");
        this.edit_day = view.findViewById(buttonId);
        this.edit_day.setOnClickListener((View.OnClickListener)this);
        buttonId = Utils.getResourceId((Context)this.getContext(), (String)"update", (String)"id");
        this.update = view.findViewById(buttonId);
        this.update.setOnClickListener((View.OnClickListener)this);
        buttonId = Utils.getResourceId((Context)this.getContext(), (String)"update_avatar", (String)"id");
        this.update_avatar = (ImageView)view.findViewById(buttonId);
        this.update_avatar.setOnClickListener((View.OnClickListener)this);
        buttonId = Utils.getResourceId((Context)this.getContext(), (String)"birthday", (String)"id");
        this.birthday = (TextView)view.findViewById(buttonId);
        if (TextUtils.isEmpty((CharSequence)this.dob)) {
            this.birthday.setText((CharSequence)"01/01/1970");
        } else {
            SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy");
            try {
                Date date = format.parse(this.dob);
                this.birthday.setText((CharSequence)new SimpleDateFormat("dd/MM/yyyy").format(date));
            }
            catch (Exception e) {
                e.printStackTrace();
                this.birthday.setText((CharSequence)"01/01/1970");
            }
        }
        this.birthday.setOnClickListener((View.OnClickListener)this);
        buttonId = Utils.getResourceId((Context)this.getContext(), (String)"next", (String)"id");
        this.next = view.findViewById(buttonId);
        this.next.setOnClickListener((View.OnClickListener)this);
        this.nameInput.addTextChangedListener(new TextWatcher(){

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void afterTextChanged(Editable s) {
                if (s.toString().length() > 2) {
                    ZaloWebUpdateProfileFragment.this.displayClearImage();
                    ZaloWebUpdateProfileFragment.this.enableBtnContinue();
                } else {
                    ZaloWebUpdateProfileFragment.this.hideClearImage();
                    ZaloWebUpdateProfileFragment.this.disableBtnContinue();
                }
            }
        });
        this.hideClearImage();
        this.disableBtnContinue();
        this.setTouchHide(view, "parent0");
        this.getActivity().getWindow().setSoftInputMode(34);
        return view;
    }

    private void disableBtnContinue() {
        this.update.setEnabled(false);
        this.update.getBackground().setAlpha(51);
    }

    private void enableBtnContinue() {
        this.update.setEnabled(true);
        this.update.getBackground().setAlpha(255);
    }

    private void displayClearImage() {
        this.nameInput.setCompoundDrawablesWithIntrinsicBounds(0, 0, Utils.getResourceId((Context)this.getActivity(), (String)"zalosdk_icon_x", (String)"drawable"), 0);
    }

    private void hideClearImage() {
        this.nameInput.setCompoundDrawablesWithIntrinsicBounds(0, 0, 0, 0);
    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        try {
            this.listener = (ZaloWebUpdateProfileFragmentListener)((ZaloWebLoginBaseFragment)this).listener;
        }
        catch (ClassCastException ex) {
            Log.e((String)(context.getClass().getSimpleName() + " must implement " + ZaloWebLoginFragment.ZaloWebLoginFragmentListener.class.getSimpleName()));
        }
    }

    @Override
    public void onDetach() {
        super.onDetach();
        this.listener = null;
    }

    public void onResume() {
        super.onResume();
        this.setTitle(this.getString(Utils.getResourceId((Context)this.getActivity(), (String)"txt_update_info", (String)"string")));
        this.hideBackButton();
    }

    private void hideKeyboard() {
        InputMethodManager imm = (InputMethodManager)this.getActivity().getSystemService("input_method");
        imm.hideSoftInputFromWindow(this.nameInput.getWindowToken(), 0);
    }

    public void onClick(View v) {
        if (this.maleButton == v) {
            this.hideKeyboard();
            this.femaleButton.setChecked(false);
        } else if (this.femaleButton == v) {
            this.hideKeyboard();
            this.maleButton.setChecked(false);
        } else if (this.edit_day == v || this.birthday == v) {
            this.hideKeyboard();
            this.edit_day.setEnabled(false);
            this.openDatePicker();
        } else if (this.update == v) {
            this.updateProfile();
        } else if (this.update_avatar == v) {
            this.hideKeyboard();
            this.getPhoToAction();
        } else if (this.next == v) {
            this.skipUpdateProfile();
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (resultCode != -1) {
            return;
        }
        Uri uri = data == null || data.getData() == null ? this.mImageCaptureUri : data.getData();
        try {
            this.avatarBitmap = BitmapHelper.handleSamplingAndRotationBitmap((Context)this.getContext(), (Uri)uri, (int)512, (int)512);
            this.update_avatar.setImageBitmap(this.avatarBitmap);
            File f = new File(uri.getPath());
            if (f.exists()) {
                f.delete();
            }
        }
        catch (Exception ex) {
            Log.e((Exception)ex);
        }
    }

    private void getPhoToAction() {
        int layoutId = Utils.getResourceId((Context)this.getContext(), (String)"custom_photo_action_dialog", (String)"layout");
        View dialoglayout = this.inflater.inflate(layoutId, null);
        final Dialog dialog = new Dialog(this.getContext());
        dialog.requestWindowFeature(1);
        dialog.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
        dialog.setContentView(dialoglayout);
        int id2 = Utils.getResourceId((Context)this.getContext(), (String)"open_photo", (String)"id");
        View open_photo = dialog.findViewById(id2);
        open_photo.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ZaloWebUpdateProfileFragment.this.checkOpenPhotoPermission(11);
                dialog.dismiss();
            }
        });
        id2 = Utils.getResourceId((Context)this.getContext(), (String)"take_camera", (String)"id");
        View take_camera = dialog.findViewById(id2);
        take_camera.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ZaloWebUpdateProfileFragment.this.checkOpenCameraPermission();
                dialog.dismiss();
            }
        });
        dialog.show();
    }

    private void checkOpenPhotoPermission(int reqCode) {
        int hasPermissionOpenPhoto = ContextCompat.checkSelfPermission((Context)this.getContext(), (String)"android.permission.READ_EXTERNAL_STORAGE");
        if (hasPermissionOpenPhoto != 0) {
            if (ActivityCompat.shouldShowRequestPermissionRationale((Activity)this.getActivity(), (String)"android.permission.READ_EXTERNAL_STORAGE")) {
                String message = reqCode == 11 ? "You need to allow access to Photo Gallery" : "Camera need to store photo to your sd card.";
                this.showMessageOKCancel(message, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        ZaloWebUpdateProfileFragment.this.gotoSettings();
                    }
                });
            } else {
                this.requestPermissions(new String[]{"android.permission.READ_EXTERNAL_STORAGE"}, reqCode);
            }
        } else if (reqCode == 11) {
            this.openImageIntentPicker();
        } else {
            this.openCameraCapture();
        }
    }

    private void showMessageOKCancel(String message, DialogInterface.OnClickListener okListener) {
        new AlertDialog.Builder(this.getContext()).setMessage((CharSequence)message).setPositiveButton((CharSequence)"Go Settings", okListener).setNegativeButton((CharSequence)"Cancel", null).create().show();
    }

    private void gotoSettings() {
        Intent intent = new Intent();
        intent.setAction("android.settings.APPLICATION_DETAILS_SETTINGS");
        Uri uri = Uri.fromParts((String)"package", (String)this.getContext().getPackageName(), null);
        intent.setData(uri);
        this.getContext().startActivity(intent);
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (requestCode == 13) {
            if (grantResults.length > 0 && grantResults[0] == 0) {
                this.openCameraCapture();
            }
            return;
        }
        if (requestCode == 11) {
            if (grantResults.length > 0 && grantResults[0] == 0) {
                this.openImageIntentPicker();
            }
            return;
        }
        if (requestCode == 12) {
            if (grantResults.length > 0 && grantResults[0] == 0) {
                this.checkOpenPhotoPermission(13);
            }
            return;
        }
    }

    private void openImageIntentPicker() {
        Intent galleryIntent = new Intent("android.intent.action.PICK", MediaStore.Images.Media.EXTERNAL_CONTENT_URI);
        this.mImageCaptureUri = Uri.fromFile((File)new File(Environment.getExternalStorageDirectory(), "tmp_avatar_" + String.valueOf(System.currentTimeMillis()) + ".jpg"));
        galleryIntent.putExtra("output", (Parcelable)this.mImageCaptureUri);
        this.startActivityForResult(galleryIntent, 1);
    }

    private void openCameraCapture() {
        Intent takePictureIntent = new Intent("android.media.action.IMAGE_CAPTURE");
        if (takePictureIntent.resolveActivity(this.getContext().getPackageManager()) != null) {
            this.mImageCaptureUri = Uri.fromFile((File)new File(Environment.getExternalStorageDirectory(), "tmp_avatar_" + String.valueOf(System.currentTimeMillis()) + ".jpg"));
            takePictureIntent.putExtra("output", (Parcelable)this.mImageCaptureUri);
            takePictureIntent.putExtra("return-data", true);
            this.startActivityForResult(takePictureIntent, 2);
        }
    }

    private boolean validate() {
        String name = this.nameInput.getText().toString().trim();
        if (name.length() == 0) {
            this.showMessageDialog(this.getString(R.string.txt_thong_bao_upper), this.getString(R.string.txt_input_name));
            return false;
        }
        return true;
    }

    private void checkOpenCameraPermission() {
        boolean hasPermissionOpenCamera = ContextCompat.checkSelfPermission((Context)this.getContext(), (String)"android.permission.CAMERA") != 0;
        boolean hasPermissionCameraDeclared = Utils.hasPermissionInManifest((Context)this.getContext(), (String)"android.permission.CAMERA");
        if (hasPermissionCameraDeclared && hasPermissionOpenCamera) {
            if (ActivityCompat.shouldShowRequestPermissionRationale((Activity)this.getActivity(), (String)"android.permission.CAMERA")) {
                this.showMessageOKCancel("You need to allow access to Camera", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        ZaloWebUpdateProfileFragment.this.gotoSettings();
                    }
                });
            } else {
                this.requestPermissions(new String[]{"android.permission.CAMERA"}, 12);
            }
        } else {
            this.openCameraCapture();
        }
    }

    private void updateProfile() {
        if (!this.validate()) {
            return;
        }
        UpdateProfileAsyncTask.Request request = new UpdateProfileAsyncTask.Request();
        this.displayName = this.nameInput.getText().toString().trim();
        request.token = this.token;
        request.phone = this.phoneNumber;
        request.uid = this.uid;
        request.displayName = this.displayName;
        request.gender = this.maleButton.isChecked() ? 1 : 2;
        request.avatar = BitmapHelper.toByteArray((Bitmap)this.avatarBitmap);
        request.countryCode = this.countryCode;
        String day = this.birthday.getText().toString();
        SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy");
        try {
            Date date = format.parse(day);
            request.dob = new SimpleDateFormat("yyyy-MM-dd").format(date);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.showLoading();
        UpdateProfileAsyncTask task = new UpdateProfileAsyncTask(this.getContext(), new UpdateProfileAsyncTask.Callback(){

            @Override
            public void onCompleted(UpdateProfileAsyncTask.Response response) {
                ZaloWebUpdateProfileFragment.this.hideLoading();
                if (ZaloWebUpdateProfileFragment.this.listener == null) {
                    return;
                }
                if (response.code != 0) {
                    ZaloWebUpdateProfileFragment.this.showMessageDialog(ZaloWebUpdateProfileFragment.this.getString(Utils.getResourceId((Context)ZaloWebUpdateProfileFragment.this.getActivity(), (String)"txt_thong_bao_upper", (String)"string")), response.message);
                    return;
                }
                ZaloWebUpdateProfileFragment.this.onLoginCompleted(0, ZaloWebUpdateProfileFragment.this.uid, ZaloWebUpdateProfileFragment.this.oauthCode, ZaloWebUpdateProfileFragment.this.zprotect, ZaloWebUpdateProfileFragment.this.displayName, true);
            }
        });
        task.execute(new UpdateProfileAsyncTask.Request[]{request});
    }

    private void skipUpdateProfile() {
        if ("0999666666".equalsIgnoreCase(this.phoneNumber)) {
            this.onLoginCompleted(-1, 0L, "", 0, "", true);
            return;
        }
        this.onLoginCompleted(0, this.uid, this.oauthCode, this.zprotect, this.displayName, true);
    }

    private void clearNameInput() {
        this.nameInput.setText((CharSequence)"");
    }

    private void openDatePicker() {
        Date date;
        SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy");
        try {
            date = format.parse(this.birthday.getText().toString());
        }
        catch (Exception e) {
            date = new Date();
        }
        DatePickerFragment newFragment = new DatePickerFragment(date, new DatePickerFragment.DatePickerListener(){

            @Override
            public void onDateSet(DatePicker view, int year, int month, int day) {
                String sMonth;
                String sDay = String.valueOf(day);
                if (sDay.length() == 1) {
                    sDay = "0" + sDay;
                }
                if ((sMonth = String.valueOf(month + 1)).length() == 1) {
                    sMonth = "0" + sMonth;
                }
                String sYear = String.valueOf(year);
                ZaloWebUpdateProfileFragment.this.birthday.setText((CharSequence)(sDay + "/" + sMonth + "/" + sYear));
                ZaloWebUpdateProfileFragment.this.edit_day.setEnabled(true);
            }

            @Override
            public void onDismiss() {
                ZaloWebUpdateProfileFragment.this.edit_day.setEnabled(true);
            }
        });
        newFragment.show(this.getActivity().getSupportFragmentManager(), "datePicker");
    }

    public boolean onTouch(View v, MotionEvent event) {
        if (v == this.nameInput) {
            int DRAWABLE_RIGHT = 2;
            if (event.getAction() == 1 && this.nameInput.getCompoundDrawables() != null && this.nameInput.getCompoundDrawables()[2] != null && event.getRawX() >= (float)(this.nameInput.getRight() - this.nameInput.getCompoundDrawables()[2].getBounds().width())) {
                this.clearNameInput();
            }
        }
        return false;
    }

    public static class DatePickerFragment
    extends DialogFragment
    implements DatePickerDialog.OnDateSetListener,
    DialogInterface.OnDismissListener,
    DialogInterface.OnCancelListener {
        Date defaultDate;
        DatePickerListener listener;

        public DatePickerFragment(Date defaultDate, DatePickerListener listener) {
            this.listener = listener;
            this.defaultDate = defaultDate;
        }

        public Dialog onCreateDialog(Bundle savedInstanceState) {
            Calendar c = Calendar.getInstance();
            c.setTime(this.defaultDate);
            int year = c.get(1);
            int month = c.get(2);
            int day = c.get(5);
            DatePickerDialog datepickerdialog = new DatePickerDialog((Context)this.getActivity(), 1, (DatePickerDialog.OnDateSetListener)this, year, month, day);
            if (Build.VERSION.SDK_INT >= 21) {
                datepickerdialog = new DatePickerDialog((Context)this.getActivity(), 16974394, (DatePickerDialog.OnDateSetListener)this, year, month, day);
            } else if (Build.VERSION.SDK_INT >= 14) {
                datepickerdialog = new DatePickerDialog((Context)this.getActivity(), 3, (DatePickerDialog.OnDateSetListener)this, year, month, day);
            }
            datepickerdialog.getDatePicker().setMaxDate(new Date().getTime());
            datepickerdialog.setOnCancelListener((DialogInterface.OnCancelListener)this);
            datepickerdialog.setOnDismissListener((DialogInterface.OnDismissListener)this);
            return datepickerdialog;
        }

        public void onDateSet(DatePicker view, int year, int month, int day) {
            if (this.listener != null) {
                this.listener.onDateSet(view, year, month, day);
            }
        }

        public void onDismiss(DialogInterface dialog) {
            super.onDismiss(dialog);
            if (this.listener != null) {
                this.listener.onDismiss();
            }
        }

        public void onCancel(DialogInterface dialog) {
            super.onCancel(dialog);
            if (this.listener != null) {
                this.listener.onDismiss();
            }
        }

        static interface DatePickerListener {
            public void onDateSet(DatePicker var1, int var2, int var3, int var4);

            public void onDismiss();
        }
    }

    public static interface ZaloWebUpdateProfileFragmentListener
    extends ZaloWebLoginBaseFragment.ZaloWebLoginBaseFragmentListener {
    }
}

