/*
 * Decompiled with CFR 0.152.
 */
package com.zing.zalo.zalosdk.oauth.register;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.text.Editable;
import android.text.Html;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.text.method.LinkMovementMethod;
import android.text.style.ClickableSpan;
import android.text.style.URLSpan;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.TextView;
import com.zing.zalo.zalosdk.R;
import com.zing.zalo.zalosdk.core.helper.Utils;
import com.zing.zalo.zalosdk.core.log.Log;
import com.zing.zalo.zalosdk.oauth.WebLoginActivity;
import com.zing.zalo.zalosdk.oauth.register.RequestActivationCodeAsyncTask;
import com.zing.zalo.zalosdk.oauth.register.ValidatePhoneNumberAsyncTask;
import com.zing.zalo.zalosdk.oauth.register.ZaloWebLoginBaseFragment;

public class ZaloWebRegisterFragment
extends ZaloWebLoginBaseFragment {
    private ZaloWebRegisterFragmentListener listener;
    private EditText phoneNumber;
    private TextView countryCode;
    private TextView btn_continue;
    private TextView term;
    String countryCodeText = "";
    boolean isForgotPassword;
    String forgotPhoneNumber;

    public static ZaloWebRegisterFragment newIstance(boolean isForgotPassword, String forgotPhoneNumber) {
        ZaloWebRegisterFragment fragment = new ZaloWebRegisterFragment();
        Bundle args = new Bundle();
        args.putBoolean("isForgotPassword", isForgotPassword);
        args.putString("forgotPhoneNumber", forgotPhoneNumber);
        fragment.setArguments(args);
        return fragment;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle args = this.getArguments();
        this.isForgotPassword = args.getBoolean("isForgotPassword");
        this.forgotPhoneNumber = args.getString("forgotPhoneNumber");
        this.countryCodeText = this.getString(Utils.getResourceId((Context)this.getActivity(), (String)"txt_default_select_country", (String)"string"));
    }

    protected void makeLinkClickable(SpannableStringBuilder strBuilder, URLSpan span) {
        int start = strBuilder.getSpanStart((Object)span);
        int end = strBuilder.getSpanEnd((Object)span);
        int flags = strBuilder.getSpanFlags((Object)span);
        ClickableSpan clickable = new ClickableSpan(){

            public void onClick(View view) {
                if (ZaloWebRegisterFragment.this.listener != null) {
                    Utils.hideSoftKeyboard((Activity)ZaloWebRegisterFragment.this.getActivity());
                    ZaloWebRegisterFragment.this.listener.onClickTerm();
                }
            }

            public void updateDrawState(TextPaint ds) {
                ds.setColor(-16777216);
            }
        };
        strBuilder.setSpan((Object)clickable, start, end, flags);
        strBuilder.removeSpan((Object)span);
    }

    protected void setTextViewHTML(TextView text, String html) {
        URLSpan[] urls;
        Spanned sequence = Html.fromHtml((String)html);
        SpannableStringBuilder strBuilder = new SpannableStringBuilder((CharSequence)sequence);
        for (URLSpan span : urls = (URLSpan[])strBuilder.getSpans(0, sequence.length(), URLSpan.class)) {
            this.makeLinkClickable(strBuilder, span);
        }
        text.setText((CharSequence)strBuilder);
        text.setMovementMethod(LinkMovementMethod.getInstance());
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View rootView = inflater.inflate(R.layout.zalo_web_regis_input_phone, container, false);
        this.phoneNumber = (EditText)rootView.findViewById(R.id.edti_phonenumber);
        this.countryCode = (TextView)rootView.findViewById(R.id.popup_select_country);
        this.btn_continue = (TextView)rootView.findViewById(R.id.btn_continue);
        this.term = (TextView)rootView.findViewById(R.id.term);
        String buildText = this.getString(Utils.getResourceId((Context)this.getActivity(), (String)"txt_condition", (String)"string"));
        this.setTextViewHTML(this.term, buildText);
        Bundle bundle = this.getArguments();
        if (bundle != null) {
            this.countryCodeText = bundle.getString("regioncode");
            if (TextUtils.isEmpty((CharSequence)this.countryCodeText)) {
                this.countryCodeText = this.getString(Utils.getResourceId((Context)this.getActivity(), (String)"txt_default_select_country", (String)"string"));
            }
            this.updateCountry(this.countryCodeText);
        }
        this.phoneNumber.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                int DRAWABLE_RIGHT = 2;
                if (event.getAction() == 1 && ZaloWebRegisterFragment.this.phoneNumber.getCompoundDrawables() != null && ZaloWebRegisterFragment.this.phoneNumber.getCompoundDrawables()[2] != null && event.getRawX() >= (float)(ZaloWebRegisterFragment.this.phoneNumber.getRight() - ZaloWebRegisterFragment.this.phoneNumber.getCompoundDrawables()[2].getBounds().width() * 3)) {
                    ZaloWebRegisterFragment.this.clearNameInput();
                }
                return false;
            }
        });
        this.btn_continue.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Utils.hideSoftKeyboard((Activity)ZaloWebRegisterFragment.this.getActivity());
                ZaloWebRegisterFragment.this.validatePhoneNumber(ZaloWebRegisterFragment.this.getPhoneNumber(), ZaloWebRegisterFragment.this.getSelectedContryCode());
            }
        });
        this.countryCode.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Utils.hideSoftKeyboard((Activity)ZaloWebRegisterFragment.this.getActivity());
                ZaloWebRegisterFragment.this.listener.onClickSelectCountry();
            }
        });
        this.phoneNumber.addTextChangedListener(new TextWatcher(){

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void afterTextChanged(Editable s) {
                if (s.toString().length() > 5) {
                    ZaloWebRegisterFragment.this.enableBtnContinue();
                } else {
                    ZaloWebRegisterFragment.this.disableBtnContinue();
                }
                if (s.toString().length() > 2) {
                    ZaloWebRegisterFragment.this.displayClearImage();
                } else {
                    ZaloWebRegisterFragment.this.hideClearImage();
                }
            }
        });
        this.disableBtnContinue();
        this.hideClearImage();
        this.setTouchHide(rootView, "parent0");
        this.setTouchHide(rootView, "parent1");
        this.getActivity().getWindow().setSoftInputMode(34);
        return rootView;
    }

    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        if (!TextUtils.isEmpty((CharSequence)this.forgotPhoneNumber)) {
            this.phoneNumber.setText((CharSequence)this.forgotPhoneNumber);
            this.showDialogConfirm(this.getPhoneNumber(), this.getSelectedContryCode());
            this.forgotPhoneNumber = "";
        }
    }

    private void displayClearImage() {
        this.phoneNumber.setCompoundDrawablesWithIntrinsicBounds(0, 0, Utils.getResourceId((Context)this.getActivity(), (String)"zalosdk_icon_x", (String)"drawable"), 0);
    }

    private void hideClearImage() {
        this.phoneNumber.setCompoundDrawablesWithIntrinsicBounds(0, 0, 0, 0);
    }

    private String getPhoneNumber() {
        if (this.phoneNumber == null || this.phoneNumber.getText() == null) {
            return "";
        }
        String pn = this.phoneNumber.getText().toString();
        pn = pn.replaceAll("\\D", "");
        return pn;
    }

    private String getSelectedContryCode() {
        int second;
        String input = this.countryCodeText;
        int index = input.indexOf("(");
        if (index > -1 && (second = input.lastIndexOf(")")) > -1 && second > index) {
            return input.substring(index + 2, second);
        }
        return "";
    }

    private void disableBtnContinue() {
        this.btn_continue.setEnabled(false);
        this.btn_continue.getBackground().setAlpha(51);
    }

    private void enableBtnContinue() {
        this.btn_continue.setEnabled(true);
        this.btn_continue.getBackground().setAlpha(255);
    }

    public void updateCountry(String country) {
        this.countryCodeText = country;
        this.countryCode.setText((CharSequence)country);
    }

    public void onResume() {
        super.onResume();
        this.setTitle(this.getTitle());
        this.showBackButton();
    }

    private boolean validate() {
        String pn = this.phoneNumber.getText().toString().trim();
        if (pn.length() == 0) {
            this.showMessageDialog(this.getString(R.string.txt_thong_bao_upper), this.getString(R.string.txt_input_phone_number));
            return false;
        }
        return true;
    }

    private void validatePhoneNumber(final String phone, final String countryCode) {
        if (!this.validate()) {
            return;
        }
        Context ctx = this.getContext();
        ValidatePhoneNumberAsyncTask.Request params = new ValidatePhoneNumberAsyncTask.Request();
        params.phone = phone;
        params.contryCode = countryCode;
        params.isForgotPwd = this.isForgotPassword;
        ValidatePhoneNumberAsyncTask.Callback cb = new ValidatePhoneNumberAsyncTask.Callback(){

            @Override
            public void onCompleted(ValidatePhoneNumberAsyncTask.Response response) {
                ZaloWebRegisterFragment.this.hideLoading();
                if (ZaloWebRegisterFragment.this.listener == null) {
                    return;
                }
                if (response.code == -1030) {
                    if (ZaloWebRegisterFragment.this.listener != null) {
                        ZaloWebRegisterFragment.this.listener.onRegisterRelogin(response.raw);
                    }
                    return;
                }
                if (response.code != 0) {
                    ZaloWebRegisterFragment.this.showMessageDialog(ZaloWebRegisterFragment.this.getString(R.string.txt_thong_bao_upper), response.message);
                    return;
                }
                ZaloWebRegisterFragment.this.showDialogConfirm(phone, countryCode);
            }
        };
        this.showLoading();
        ValidatePhoneNumberAsyncTask task = new ValidatePhoneNumberAsyncTask(ctx, cb);
        task.execute(new ValidatePhoneNumberAsyncTask.Request[]{params});
    }

    private void showDialogConfirm(final String phone, final String countryCode) {
        String strPhone = "(+" + this.getSelectedContryCode() + ") " + Utils.getFormatStringPhoneNumber((String)phone, (String)this.getSelectedContryCode());
        this.listener.showConfirmDialog((Activity)this.getActivity(), new WebLoginActivity.OnDialogClickListener(){

            @Override
            public void onClickOk() {
                if (ZaloWebRegisterFragment.this.listener != null) {
                    ZaloWebRegisterFragment.this.requestActivationCode(phone, countryCode);
                }
            }

            @Override
            public void onCancel() {
            }
        }, this.getString(Utils.getResourceId((Context)this.getActivity(), (String)"txt_confirm_upper", (String)"string")), strPhone, this.getString(R.string.confirm_regis), this.getString(Utils.getResourceId((Context)this.getActivity(), (String)"txt_confirm_change", (String)"string")), this.getString(Utils.getResourceId((Context)this.getActivity(), (String)"txt_confirm_upper", (String)"string")));
    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        try {
            this.listener = (ZaloWebRegisterFragmentListener)((ZaloWebLoginBaseFragment)this).listener;
        }
        catch (ClassCastException ex) {
            Log.e((String)(context.getClass().getSimpleName() + " must implement " + ZaloWebRegisterFragmentListener.class.getSimpleName()));
        }
    }

    @Override
    public void onDetach() {
        super.onDetach();
        this.listener = null;
        Utils.hideSoftKeyboard((Activity)this.getActivity());
    }

    private void requestActivationCode(final String phone, final String countryCode) {
        Context ctx = this.getContext();
        RequestActivationCodeAsyncTask.Request params = new RequestActivationCodeAsyncTask.Request();
        params.phone = phone;
        params.contryCode = countryCode;
        params.isForgotPwd = this.isForgotPassword;
        RequestActivationCodeAsyncTask.Callback cb = new RequestActivationCodeAsyncTask.Callback(){

            @Override
            public void onCompleted(RequestActivationCodeAsyncTask.Response response) {
                ZaloWebRegisterFragment.this.hideLoading();
                if (ZaloWebRegisterFragment.this.listener == null) {
                    return;
                }
                if (response.code == -1030) {
                    if (ZaloWebRegisterFragment.this.listener != null) {
                        ZaloWebRegisterFragment.this.listener.onRegisterRelogin(response.raw);
                    }
                    return;
                }
                if (response.code == -1031) {
                    if (ZaloWebRegisterFragment.this.listener != null) {
                        ZaloWebRegisterFragment.this.listener.onActivePhone(phone, countryCode, response.token, ZaloWebRegisterFragment.this.isForgotPassword, response.message);
                    }
                    return;
                }
                if (response.code != 0) {
                    ZaloWebRegisterFragment.this.showMessageDialog(ZaloWebRegisterFragment.this.getString(Utils.getResourceId((Context)ZaloWebRegisterFragment.this.getActivity(), (String)"txt_thong_bao_upper", (String)"string")), response.message);
                    return;
                }
                ZaloWebRegisterFragment.this.listener.onActivePhone(phone, countryCode, response.token, ZaloWebRegisterFragment.this.isForgotPassword, null);
            }
        };
        this.showLoading();
        RequestActivationCodeAsyncTask task = new RequestActivationCodeAsyncTask(ctx, cb);
        task.execute(new RequestActivationCodeAsyncTask.Request[]{params});
    }

    private void clearNameInput() {
        this.phoneNumber.setText((CharSequence)"");
    }

    private String getTitle() {
        return this.isForgotPassword ? this.getString(Utils.getResourceId((Context)this.getActivity(), (String)"txt_lost_pass", (String)"string")) : this.getString(Utils.getResourceId((Context)this.getActivity(), (String)"txt_regis_acc", (String)"string"));
    }

    public static interface ZaloWebRegisterFragmentListener
    extends ZaloWebLoginBaseFragment.ZaloWebLoginBaseFragmentListener {
        public void onActivePhone(String var1, String var2, String var3, boolean var4, String var5);

        public void onRegisterRelogin(String var1);

        public void onClickTerm();

        public void onClickSelectCountry();
    }
}

