/*
 * Decompiled with CFR 0.152.
 */
package com.zing.zalo.zalosdk.oauth.register;

import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.CookieManager;
import android.webkit.JavascriptInterface;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ProgressBar;
import com.zing.zalo.zalosdk.core.helper.AppInfo;
import com.zing.zalo.zalosdk.core.helper.Base64;
import com.zing.zalo.zalosdk.core.helper.Utils;
import com.zing.zalo.zalosdk.core.http.HttpClientRequest;
import com.zing.zalo.zalosdk.core.log.Log;
import com.zing.zalo.zalosdk.oauth.ZaloSDK;
import com.zing.zalo.zalosdk.oauth.register.ZaloWebLoginBaseFragment;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.net.URLEncoder;

public class ZaloWebLoginFragment
extends ZaloWebLoginBaseFragment {
    private static final String WEB_LOGIN_URL = "https://oauth.zaloapp.com/v2/auth?app_id=";
    protected ZaloWebLoginFragmentListener listener;
    WebView webView;
    ProgressBar progressBar;
    private String callbackUrl;
    private String zalert;

    public static ZaloWebLoginFragment newIstance(String zalert) {
        ZaloWebLoginFragment fragment = new ZaloWebLoginFragment();
        Bundle args = new Bundle();
        args.putString("zalert", zalert);
        fragment.setArguments(args);
        return fragment;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        String str = this.getArguments().getString("zalert");
        this.reloadWithZAlert(str);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        int layoutId = Utils.getResourceId((Context)this.getContext(), (String)"zalosdk_fragment_zalo_web_login", (String)"layout");
        View view = inflater.inflate(layoutId, container, false);
        this.setupWebView(view);
        int id2 = Utils.getResourceId((Context)this.getContext(), (String)"zalosdk_progress", (String)"id");
        this.progressBar = (ProgressBar)view.findViewById(id2);
        this.progressBar.setVisibility(8);
        this.getActivity().getWindow().setSoftInputMode(34);
        return view;
    }

    private void setupWebView(View parentView) {
        Context context = this.getContext();
        int id2 = Utils.getResourceId((Context)context, (String)"zalosdk_login_webview", (String)"id");
        this.webView = (WebView)parentView.findViewById(id2);
        this.callbackUrl = "http://" + AppInfo.getPackageName((Context)context);
        CheckResponseCode task = new CheckResponseCode();
        task.url = this.generateLoginUrl(context);
        task.execute(null);
        this.webView.getSettings().setJavaScriptEnabled(true);
        this.webView.getSettings().setJavaScriptCanOpenWindowsAutomatically(false);
        this.webView.getSettings().setAllowFileAccess(true);
        this.webView.getSettings().setCacheMode(2);
        this.webView.getSettings().setAppCacheEnabled(false);
        if (Build.VERSION.SDK_INT > 10) {
            this.webView.getSettings().setAllowContentAccess(true);
        }
        LoginEventDispacher webClient = new LoginEventDispacher(new WeakReference<ZaloWebLoginFragment>(this), this.callbackUrl);
        this.webView.setWebViewClient((WebViewClient)webClient);
        JSInteface jsInterface = new JSInteface(new WeakReference<ZaloWebLoginFragmentListener>(this.listener));
        this.webView.addJavascriptInterface((Object)jsInterface, "zdk");
        if (!TextUtils.isEmpty((CharSequence)this.zalert)) {
            this.zalert = "";
        }
        if (Build.VERSION.SDK_INT >= 19) {
            this.webView.setLayerType(2, null);
        } else {
            this.webView.setLayerType(1, null);
        }
    }

    private String generateLoginUrl(Context ctx) {
        StringBuilder url = new StringBuilder();
        url.append(WEB_LOGIN_URL);
        try {
            url.append(ZaloSDK.Instance.getAppID());
            url.append("&sign_key=");
            url.append(URLEncoder.encode(AppInfo.getApplicationHashKey((Context)ctx), "UTF-8"));
            url.append("&pkg_name=");
            url.append(URLEncoder.encode(AppInfo.getPackageName((Context)ctx), "UTF-8"));
            url.append("&orientation=");
            url.append(ctx.getResources().getConfiguration().orientation);
            url.append("&zregister=true");
            url.append("&ts=" + System.currentTimeMillis());
            if (!TextUtils.isEmpty((CharSequence)this.zalert)) {
                url.append("&zalert=" + this.zalert);
            }
            url.append("&lang=" + com.zing.zalo.zalosdk.payment.direct.Utils.getLanguage(ctx));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return url.toString();
    }

    public void reloadWithZAlert(String rawJson) {
        try {
            this.zalert = URLEncoder.encode(Base64.encode((byte[])rawJson.getBytes("UTF-8")), "UTF-8");
        }
        catch (Exception ex) {
            this.zalert = null;
        }
    }

    public void onResume() {
        super.onResume();
        this.setTitle(this.getString(Utils.getResourceId((Context)this.getActivity(), (String)"txt_title_login_zalo", (String)"string")));
        this.showBackButton();
    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        try {
            this.listener = (ZaloWebLoginFragmentListener)((ZaloWebLoginBaseFragment)this).listener;
        }
        catch (ClassCastException ex) {
            Log.e((String)(context.getClass().getSimpleName() + " must implement " + ZaloWebLoginFragmentListener.class.getSimpleName()));
        }
    }

    @Override
    public void onDetach() {
        super.onDetach();
        this.listener = null;
    }

    private class CheckResponseCode
    extends AsyncTask<Void, Void, Integer> {
        String url;

        private CheckResponseCode() {
        }

        protected Integer doInBackground(Void ... params) {
            HttpClientRequest request = new HttpClientRequest(HttpClientRequest.Type.GET, this.url);
            return request.getResponseCode();
        }

        protected void onPostExecute(Integer result) {
            if (result == 203) {
                ZaloWebLoginFragment.this.onLoginCompleted(203, 0L, "", 0, "", false);
            } else {
                ZaloWebLoginFragment.this.webView.loadUrl(this.url);
            }
        }
    }

    private static class LoginEventDispacher
    extends WebViewClient {
        private String callbackUrl;
        private WeakReference<ZaloWebLoginFragment> that;

        public LoginEventDispacher(WeakReference<ZaloWebLoginFragment> that, String callbackUrl) {
            this.that = that;
            this.callbackUrl = callbackUrl;
        }

        public void onPageFinished(WebView view, String url) {
            super.onPageFinished(view, url);
            if (this.that.get() != null) {
                ((ZaloWebLoginFragment)((Object)this.that.get())).progressBar.setVisibility(8);
            }
        }

        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            if (this.that.get() != null) {
                ((ZaloWebLoginFragment)((Object)this.that.get())).progressBar.setVisibility(0);
            }
            if (Build.VERSION.SDK_INT >= 11 || url.indexOf(this.callbackUrl) != 0) {
                super.onPageStarted(view, url, favicon);
                return;
            }
            this.processCallbackUrl(url);
        }

        public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
            super.onReceivedError(view, errorCode, description, failingUrl);
            if (this.that.get() != null) {
                ((ZaloWebLoginFragment)((Object)this.that.get())).progressBar.setVisibility(8);
            }
            if (this.that.get() != null) {
                ((ZaloWebLoginFragment)((Object)this.that.get())).onLoginCompleted(-1, 0L, "", 0, "", false);
            }
        }

        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            if (this.processCallbackUrl(url)) {
                return true;
            }
            return super.shouldOverrideUrlLoading(view, url);
        }

        private boolean processCallbackUrl(String url) {
            if (url.indexOf(this.callbackUrl) != 0) {
                return false;
            }
            CookieManager cookieManager = CookieManager.getInstance();
            cookieManager.removeAllCookie();
            Uri uri = Uri.parse((String)url);
            int error = 0;
            long uid = 0L;
            String code = "";
            String name = "";
            int zprotect = 0;
            try {
                if (uri.getQueryParameter("error") != null) {
                    error = Integer.parseInt(uri.getQueryParameter("error"));
                } else {
                    uid = Long.parseLong(uri.getQueryParameter("uid"));
                    code = uri.getQueryParameter("code");
                    name = uri.getQueryParameter("display_name");
                    String tmp = uri.getQueryParameter("zprotect");
                    if (tmp != null) {
                        zprotect = Integer.parseInt(tmp);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (this.that.get() != null) {
                ((ZaloWebLoginFragment)((Object)this.that.get())).onLoginCompleted(error, uid, code, zprotect, name, false);
            }
            return true;
        }
    }

    public static class JSInteface {
        private WeakReference<ZaloWebLoginFragmentListener> listener;

        public JSInteface(WeakReference<ZaloWebLoginFragmentListener> weakReference) {
            this.listener = weakReference;
        }

        @JavascriptInterface
        public void register() {
            if (this.listener.get() != null) {
                ((ZaloWebLoginFragmentListener)this.listener.get()).onRegister();
            }
        }

        @JavascriptInterface
        public void forgotPassword(String params) {
            if (this.listener.get() != null) {
                ((ZaloWebLoginFragmentListener)this.listener.get()).onForgotPassword(params);
            }
        }
    }

    public static interface ZaloWebLoginFragmentListener
    extends ZaloWebLoginBaseFragment.ZaloWebLoginBaseFragmentListener {
        public void onRegister();

        public void onForgotPassword(String var1);
    }
}

