/*
 * Decompiled with CFR 0.152.
 */
package com.zing.zalo.zalosdk.oauth.register;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import com.zing.zalo.zalosdk.core.helper.Utils;
import com.zing.zalo.zalosdk.core.log.Log;
import com.zing.zalo.zalosdk.oauth.register.CreatePasswordAsyncTask;
import com.zing.zalo.zalosdk.oauth.register.ZaloWebLoginBaseFragment;

public class ZaloWebCreatePasswordFragment
extends ZaloWebLoginBaseFragment
implements View.OnClickListener {
    protected ZaloWebCreatePasswordFragmentListener listener;
    private EditText acc_password;
    private EditText acc_password_confirm;
    private View update;
    private String phoneNumber;
    private String countryCode;
    private String token;
    private long uid;
    private boolean isForgotPassword;

    public static ZaloWebCreatePasswordFragment newIstance(String phoneNumber, String countryCode, long uid, String token, boolean isForgotPassword) {
        ZaloWebCreatePasswordFragment fragment = new ZaloWebCreatePasswordFragment();
        Bundle args = new Bundle();
        args.putString("phoneNumber", phoneNumber);
        args.putString("countryCode", countryCode);
        args.putLong("uid", uid);
        args.putString("token", token);
        args.putBoolean("isForgotPassword", isForgotPassword);
        fragment.setArguments(args);
        return fragment;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        int buttonId = 0;
        int layoutId = Utils.getResourceId((Context)this.getContext(), (String)"zalosdk_fragment_zalo_web_create_password", (String)"layout");
        Bundle args = this.getArguments();
        this.phoneNumber = args.getString("phoneNumber");
        this.countryCode = args.getString("countryCode");
        this.uid = args.getLong("uid");
        this.token = args.getString("token");
        this.isForgotPassword = args.getBoolean("isForgotPassword", false);
        View view = inflater.inflate(layoutId, container, false);
        buttonId = Utils.getResourceId((Context)this.getContext(), (String)"acc_password", (String)"id");
        this.acc_password = (EditText)view.findViewById(buttonId);
        this.acc_password.requestFocus();
        buttonId = Utils.getResourceId((Context)this.getContext(), (String)"acc_password_confirm", (String)"id");
        this.acc_password_confirm = (EditText)view.findViewById(buttonId);
        buttonId = Utils.getResourceId((Context)this.getContext(), (String)"update", (String)"id");
        this.update = view.findViewById(buttonId);
        this.update.setOnClickListener((View.OnClickListener)this);
        this.setTouchHide(view, "parent0");
        this.acc_password.addTextChangedListener((TextWatcher)new MyTextWatcher());
        this.acc_password_confirm.addTextChangedListener((TextWatcher)new MyTextWatcher());
        this.checkButtonEnabled();
        this.getActivity().getWindow().setSoftInputMode(34);
        return view;
    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        try {
            this.listener = (ZaloWebCreatePasswordFragmentListener)((ZaloWebLoginBaseFragment)this).listener;
        }
        catch (ClassCastException ex) {
            Log.e((String)(context.getClass().getSimpleName() + " must implement " + ZaloWebCreatePasswordFragmentListener.class.getSimpleName()));
        }
    }

    @Override
    public void onDetach() {
        super.onDetach();
        this.listener = null;
    }

    public void onResume() {
        super.onResume();
        this.setTitle(this.getString(Utils.getResourceId((Context)this.getActivity(), (String)"txt_create_pass", (String)"string")));
        this.hideBackButton();
    }

    private void updatePassword() {
        String pass = this.acc_password.getText().toString();
        if (!pass.equals(this.acc_password_confirm.getText().toString())) {
            this.acc_password.setText((CharSequence)"");
            this.acc_password_confirm.setText((CharSequence)"");
            this.showMessageDialog(this.getString(Utils.getResourceId((Context)this.getActivity(), (String)"txt_create_pass", (String)"string")), this.getString(Utils.getResourceId((Context)this.getActivity(), (String)"txt_confirm_pass", (String)"string")));
            return;
        }
        CreatePasswordAsyncTask.Request request = new CreatePasswordAsyncTask.Request();
        request.phone = this.phoneNumber;
        request.countryCode = this.countryCode;
        request.passwd = pass;
        request.token = this.token;
        request.uid = this.uid;
        this.showLoading();
        CreatePasswordAsyncTask task = new CreatePasswordAsyncTask(this.getContext(), new CreatePasswordAsyncTask.Callback(){

            @Override
            public void onCompleted(CreatePasswordAsyncTask.Response response) {
                ZaloWebCreatePasswordFragment.this.hideLoading();
                if (ZaloWebCreatePasswordFragment.this.listener == null) {
                    return;
                }
                if (response.code != 0) {
                    ZaloWebCreatePasswordFragment.this.showMessageDialog(ZaloWebCreatePasswordFragment.this.getString(Utils.getResourceId((Context)ZaloWebCreatePasswordFragment.this.getActivity(), (String)"txt_thong_bao_upper", (String)"string")), response.message);
                    return;
                }
                if (ZaloWebCreatePasswordFragment.this.isForgotPassword) {
                    if ("0999666666".equalsIgnoreCase(ZaloWebCreatePasswordFragment.this.phoneNumber)) {
                        ZaloWebCreatePasswordFragment.this.onLoginCompleted(-1, 0L, "", 0, "", false);
                        return;
                    }
                    ZaloWebCreatePasswordFragment.this.onLoginCompleted(0, response.uid, response.oathCode, response.zprotect, response.displayName, false);
                    return;
                }
                ZaloWebCreatePasswordFragment.this.listener.onUpdateProfile(ZaloWebCreatePasswordFragment.this.phoneNumber, ZaloWebCreatePasswordFragment.this.countryCode, response.uid, response.oathCode, response.displayName, response.gender, response.dob, response.zprotect, response.socialId, ZaloWebCreatePasswordFragment.this.token);
            }
        });
        task.execute(new CreatePasswordAsyncTask.Request[]{request});
    }

    public void onClick(View v) {
        if (this.update == v) {
            Utils.hideSoftKeyboard((Activity)this.getActivity());
            this.updatePassword();
        }
    }

    private void checkButtonEnabled() {
        if (this.acc_password.getText().toString().length() >= 6 && this.acc_password_confirm.getText().toString().length() >= 6) {
            this.update.setEnabled(true);
            this.update.getBackground().setAlpha(255);
        } else {
            this.update.setEnabled(false);
            this.update.getBackground().setAlpha(51);
        }
    }

    private class MyTextWatcher
    implements TextWatcher {
        private MyTextWatcher() {
        }

        public void afterTextChanged(Editable arg0) {
        }

        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
        }

        public void onTextChanged(CharSequence s, int start, int before, int count) {
            ZaloWebCreatePasswordFragment.this.checkButtonEnabled();
        }
    }

    public static interface ZaloWebCreatePasswordFragmentListener
    extends ZaloWebLoginBaseFragment.ZaloWebLoginBaseFragmentListener {
        public void onUpdateProfile(String var1, String var2, long var3, String var5, String var6, String var7, String var8, int var9, String var10, String var11);
    }
}

