/*
 * Decompiled with CFR 0.152.
 */
package com.zing.zalo.zalosdk.oauth.register;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.CountDownTimer;
import android.text.Editable;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.text.style.UnderlineSpan;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.TextView;
import com.zing.zalo.zalosdk.R;
import com.zing.zalo.zalosdk.core.helper.Utils;
import com.zing.zalo.zalosdk.core.log.Log;
import com.zing.zalo.zalosdk.oauth.register.RequestActivationCodeAsyncTask;
import com.zing.zalo.zalosdk.oauth.register.SubmitActivationCodeAsyncTask;
import com.zing.zalo.zalosdk.oauth.register.ZaloWebLoginBaseFragment;
import java.util.Locale;

public class ZaloWebActivePhoneFragment
extends ZaloWebLoginBaseFragment {
    ZaloWebActivePhoneFragmentListener listener;
    TextView phone_number;
    TextView btn_continue;
    TextView currentCountDownText;
    TextView btnSendActiveAgain;
    CountDownTimer countDownTimer;
    public static final long MAX_COUNTDOWN = 30000L;
    long currentCountDown = 30000L;
    private String phoneNumber;
    private String countryCode;
    private String token;
    private String message;
    private boolean isForgotPassword;
    EditText activeCodeEditText;

    public static ZaloWebActivePhoneFragment newIstance(String phoneNumber, String countryCode, String token, boolean isForgotPassword, String message) {
        ZaloWebActivePhoneFragment fragment = new ZaloWebActivePhoneFragment();
        Bundle bundle = new Bundle();
        bundle.putString("phoneNumber", phoneNumber);
        bundle.putString("countryCode", countryCode);
        bundle.putString("token", token);
        bundle.putBoolean("isForgotPassword", isForgotPassword);
        bundle.putString("message", message);
        fragment.setArguments(bundle);
        return fragment;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle bundle = this.getArguments();
        this.phoneNumber = bundle.getString("phoneNumber");
        this.countryCode = bundle.getString("countryCode");
        this.token = bundle.getString("token");
        this.isForgotPassword = bundle.getBoolean("isForgotPassword");
        this.message = bundle.getString("message");
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        int layoutId = Utils.getResourceId((Context)this.getContext(), (String)"zalo_web_regis_active_code", (String)"layout");
        View view = inflater.inflate(layoutId, container, false);
        this.phone_number = (TextView)view.findViewById(Utils.getResourceId((Context)this.getContext(), (String)"phone_number", (String)"id"));
        this.btn_continue = (TextView)view.findViewById(Utils.getResourceId((Context)this.getContext(), (String)"btn_continue", (String)"id"));
        this.currentCountDownText = (TextView)view.findViewById(Utils.getResourceId((Context)this.getContext(), (String)"countresend", (String)"id"));
        this.btnSendActiveAgain = (TextView)view.findViewById(Utils.getResourceId((Context)this.getContext(), (String)"btn_send_again", (String)"id"));
        this.activeCodeEditText = (EditText)view.findViewById(Utils.getResourceId((Context)this.getContext(), (String)"edti_activecode", (String)"id"));
        this.btnSendActiveAgain.setVisibility(8);
        this.phone_number.setText((CharSequence)("(+" + this.countryCode + ") " + Utils.getFormatStringPhoneNumber((String)this.phoneNumber, (String)this.countryCode)));
        SpannableString content = new SpannableString((CharSequence)this.getString(Utils.getResourceId((Context)this.getContext(), (String)"regis_send", (String)"string")));
        content.setSpan((Object)new UnderlineSpan(), 0, content.length(), 0);
        this.btnSendActiveAgain.setText((CharSequence)content);
        this.btn_continue.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Utils.hideSoftKeyboard((Activity)ZaloWebActivePhoneFragment.this.getActivity());
                ZaloWebActivePhoneFragment.this.submitActivationCode(ZaloWebActivePhoneFragment.this.activeCodeEditText.getText().toString().trim(), ZaloWebActivePhoneFragment.this.phoneNumber, ZaloWebActivePhoneFragment.this.countryCode);
            }
        });
        this.btnSendActiveAgain.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ZaloWebActivePhoneFragment.this.resendActivationCode();
            }
        });
        this.activeCodeEditText.addTextChangedListener(new TextWatcher(){

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void afterTextChanged(Editable s) {
                if (s.toString().length() > 3) {
                    ZaloWebActivePhoneFragment.this.enableBtnContinue();
                } else {
                    ZaloWebActivePhoneFragment.this.disableBtnContinue();
                }
            }
        });
        this.disableBtnContinue();
        this.waitingActiveCode();
        this.setTouchHide(view, "parent0");
        this.setTouchHide(view, "parent1");
        this.getActivity().getWindow().setSoftInputMode(34);
        return view;
    }

    private boolean validate() {
        String code = this.activeCodeEditText.getText().toString().trim();
        if (code.length() == 0) {
            this.showMessageDialog(this.getString(R.string.txt_thong_bao_upper), this.getString(R.string.txt_enter_activecode));
            return false;
        }
        return true;
    }

    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        if (!TextUtils.isEmpty((CharSequence)this.message)) {
            this.showMessageDialog(this.getString(Utils.getResourceId((Context)this.getActivity(), (String)"txt_thong_bao_upper", (String)"string")), this.message);
            this.message = null;
        }
    }

    private void stopTimer() {
        if (this.countDownTimer != null) {
            this.countDownTimer.cancel();
        }
    }

    private void timesUpWaitingActiveCode() {
        this.currentCountDownText.setVisibility(4);
        this.btnSendActiveAgain.setVisibility(0);
    }

    private void waitingActiveCode() {
        this.currentCountDownText.setVisibility(0);
        this.restartTimer();
    }

    private void restartTimer() {
        this.stopTimer();
        this.currentCountDown = 30000L;
        this.countDownTimer = new CountDownTimer(30000L, 1000L){

            public void onTick(long millisUntilFinished) {
                ZaloWebActivePhoneFragment.this.currentCountDown -= 1000L;
                if (Locale.getDefault().getLanguage().equalsIgnoreCase("my")) {
                    ZaloWebActivePhoneFragment.this.currentCountDownText.setText((CharSequence)ZaloWebActivePhoneFragment.this.getActivity().getString(Utils.getResourceId((Context)ZaloWebActivePhoneFragment.this.getContext(), (String)"count_activecode", (String)"string")));
                } else {
                    ZaloWebActivePhoneFragment.this.currentCountDownText.setText((CharSequence)String.format(ZaloWebActivePhoneFragment.this.getActivity().getString(Utils.getResourceId((Context)ZaloWebActivePhoneFragment.this.getContext(), (String)"count_activecode", (String)"string")), ZaloWebActivePhoneFragment.this.currentCountDown / 1000L));
                }
            }

            public void onFinish() {
                ZaloWebActivePhoneFragment.this.timesUpWaitingActiveCode();
            }
        }.start();
    }

    private void disableBtnContinue() {
        this.btn_continue.setEnabled(false);
        this.btn_continue.getBackground().setAlpha(51);
    }

    private void enableBtnContinue() {
        this.btn_continue.setEnabled(true);
        this.btn_continue.getBackground().setAlpha(255);
    }

    public void onResume() {
        super.onResume();
        this.setTitle(this.getString(Utils.getResourceId((Context)this.getActivity(), (String)"hint_nhap_ma_kick_hoat", (String)"string")));
        this.showBackButton();
        Utils.hideSoftKeyboard((Activity)this.getActivity());
    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        try {
            this.listener = (ZaloWebActivePhoneFragmentListener)((ZaloWebLoginBaseFragment)this).listener;
        }
        catch (ClassCastException ex) {
            Log.e((String)(context.getClass().getSimpleName() + " must implement " + ZaloWebActivePhoneFragmentListener.class.getSimpleName()));
        }
    }

    @Override
    public void onDetach() {
        super.onDetach();
        this.stopTimer();
        this.listener = null;
    }

    private void resendActivationCode() {
        Context ctx = this.getContext();
        RequestActivationCodeAsyncTask.Request params = new RequestActivationCodeAsyncTask.Request();
        params.phone = this.phoneNumber;
        params.contryCode = this.countryCode;
        params.isForgotPwd = this.isForgotPassword;
        RequestActivationCodeAsyncTask.Callback cb = new RequestActivationCodeAsyncTask.Callback(){

            @Override
            public void onCompleted(RequestActivationCodeAsyncTask.Response response) {
                ZaloWebActivePhoneFragment.this.hideLoading();
                if (ZaloWebActivePhoneFragment.this.listener == null) {
                    return;
                }
                if (response.code != 0) {
                    ZaloWebActivePhoneFragment.this.showMessageDialog(ZaloWebActivePhoneFragment.this.getString(Utils.getResourceId((Context)ZaloWebActivePhoneFragment.this.getActivity(), (String)"txt_thong_bao_upper", (String)"string")), response.message);
                    return;
                }
                ZaloWebActivePhoneFragment.this.token = response.token;
                ZaloWebActivePhoneFragment.this.btnSendActiveAgain.setVisibility(8);
                ZaloWebActivePhoneFragment.this.waitingActiveCode();
            }
        };
        this.showLoading();
        RequestActivationCodeAsyncTask task = new RequestActivationCodeAsyncTask(ctx, cb);
        task.execute(new RequestActivationCodeAsyncTask.Request[]{params});
    }

    private void submitActivationCode(String code, final String phoneNumber, final String countryCode) {
        if (!this.validate()) {
            return;
        }
        SubmitActivationCodeAsyncTask.Request request = new SubmitActivationCodeAsyncTask.Request();
        request.countryCode = countryCode;
        request.phoneNumber = phoneNumber;
        request.activationCode = code;
        request.token = this.token;
        SubmitActivationCodeAsyncTask.Callback callback = new SubmitActivationCodeAsyncTask.Callback(){

            @Override
            public void onCompleted(SubmitActivationCodeAsyncTask.Response response) {
                ZaloWebActivePhoneFragment.this.hideLoading();
                if (ZaloWebActivePhoneFragment.this.listener == null) {
                    return;
                }
                if (response.code != 0) {
                    ZaloWebActivePhoneFragment.this.showMessageDialog(ZaloWebActivePhoneFragment.this.getString(Utils.getResourceId((Context)ZaloWebActivePhoneFragment.this.getActivity(), (String)"txt_thong_bao_upper", (String)"string")), response.message);
                    return;
                }
                ZaloWebActivePhoneFragment.this.listener.onCreatePassword(phoneNumber, countryCode, response.uid, response.token, ZaloWebActivePhoneFragment.this.isForgotPassword);
            }
        };
        this.showLoading();
        SubmitActivationCodeAsyncTask task = new SubmitActivationCodeAsyncTask(this.getContext(), callback);
        task.execute(new SubmitActivationCodeAsyncTask.Request[]{request});
    }

    public static interface ZaloWebActivePhoneFragmentListener
    extends ZaloWebLoginBaseFragment.ZaloWebLoginBaseFragmentListener {
        public void onCreatePassword(String var1, String var2, long var3, String var5, boolean var6);
    }
}

