/*
 * Decompiled with CFR 0.152.
 */
package com.zing.zalo.zalosdk.oauth.register;

import android.content.Context;
import android.os.AsyncTask;
import com.zing.zalo.zalosdk.core.helper.AppInfo;
import com.zing.zalo.zalosdk.core.helper.Utils;
import com.zing.zalo.zalosdk.core.http.HttpClientRequest;
import com.zing.zalo.zalosdk.core.log.Log;
import com.zing.zalo.zalosdk.oauth.ZaloSDK;
import org.json.JSONObject;

class UpdateProfileAsyncTask
extends AsyncTask<Request, Void, Response> {
    private static final String API_URL = "https://oauth.zaloapp.com/v2/mobile/register/update-profile";
    Callback callback;
    Context ctx;

    UpdateProfileAsyncTask(Context context, Callback callback) {
        this.ctx = context;
        this.callback = callback;
    }

    protected Response doInBackground(Request ... params) {
        Response response = new Response(){
            {
                this.code = -1;
                this.message = UpdateProfileAsyncTask.this.ctx.getString(Utils.getResourceId((Context)UpdateProfileAsyncTask.this.ctx, (String)"txt_retry_error", (String)"string"));
            }
        };
        if (params.length == 0) {
            return response;
        }
        Request param = params[0];
        if ("0999666666".equalsIgnoreCase(param.phone)) {
            try {
                Thread.sleep(1000L);
                return new Response(){
                    {
                        this.code = -1;
                        this.message = "\u0110\u00e2y l\u00e0 s\u1ed1 \u0111i\u1ec7n tho\u1ea1i \u0111\u1ec3 test \u0111\u0103ng k\u00fd t\u00e0i kho\u1ea3n Zalo, kh\u00f4ng th\u1ec3 ti\u1ebfp t\u1ee5c.";
                    }
                };
            }
            catch (InterruptedException e) {
                return response;
            }
        }
        try {
            HttpClientRequest request = new HttpClientRequest(HttpClientRequest.Type.POST_MULIIPART, API_URL);
            request.addParams("app_id", ZaloSDK.Instance.getAppID() + "");
            request.addParams("pkg_name", this.ctx.getPackageName());
            request.addParams("sign_key", AppInfo.getApplicationHashKey((Context)this.ctx));
            request.addParams("zdId", ZaloSDK.Instance.getDeviceId());
            request.addParams("sdkId", ZaloSDK.Instance.getSDKId());
            request.addParams("conn", Utils.getConnectionType((Context)this.ctx));
            request.addParams("mod", Utils.getDeviceModel());
            request.addParams("heap", Utils.getHeapSize());
            request.addParams("deviceWidth", String.valueOf(Utils.getScreenWidth((Context)this.ctx)));
            request.addParams("deviceHeight", String.valueOf(Utils.getScreenHeight((Context)this.ctx)));
            request.addParams("imei", Utils.getIMEI((Context)this.ctx));
            request.addParams("localTime", String.valueOf(System.currentTimeMillis()));
            request.addParams("timeZone", Utils.getTimeZoneString());
            request.addParams("cpuProcessor", Utils.getCPUInfo());
            request.addParams("battery", Utils.getBatteryInfo());
            request.addParams("token", param.token);
            request.addParams("phone", param.phone);
            request.addParams("uid", String.valueOf(param.uid));
            request.addParams("displayName", param.displayName);
            request.addParams("gender", String.valueOf(param.gender));
            request.addParams("dob", param.dob);
            request.addParams("lang", com.zing.zalo.zalosdk.payment.direct.Utils.getLanguage(this.ctx));
            request.setMultipartFile("avatar.jpg", "avatar", param.avatar);
            JSONObject json = request.getJSON();
            response.code = json.optInt("error", -1);
            response.message = json.optString("errorMsg", response.message);
        }
        catch (Exception e) {
            Log.e((Exception)e);
        }
        return response;
    }

    protected void onPostExecute(Response result) {
        super.onPostExecute((Object)result);
        if (this.callback != null) {
            this.callback.onCompleted(result);
        }
        this.callback = null;
    }

    static interface Callback {
        public void onCompleted(Response var1);
    }

    static class Response {
        int code;
        String message;

        Response() {
        }
    }

    static class Request {
        String token;
        String phone;
        long uid;
        String displayName;
        int gender;
        String dob;
        byte[] avatar;
        String countryCode;

        Request() {
        }
    }
}

