/*
 * Decompiled with CFR 0.152.
 */
package com.zing.zalo.zalosdk.oauth.register;

import android.content.Context;
import android.os.AsyncTask;
import com.zing.zalo.zalosdk.core.helper.AppInfo;
import com.zing.zalo.zalosdk.core.helper.Base64;
import com.zing.zalo.zalosdk.core.helper.Utils;
import com.zing.zalo.zalosdk.core.http.HttpClientRequest;
import com.zing.zalo.zalosdk.core.log.Log;
import com.zing.zalo.zalosdk.oauth.ZaloSDK;
import org.json.JSONObject;

class SubmitActivationCodeAsyncTask
extends AsyncTask<Request, Void, Response> {
    private static final String API_URL = "https://oauth.zaloapp.com/v2/mobile/register/confirm-code";
    Callback callback;
    Context ctx;

    SubmitActivationCodeAsyncTask(Context context, Callback callback) {
        this.ctx = context;
        this.callback = callback;
    }

    protected Response doInBackground(Request ... params) {
        Response response = new Response(){
            {
                this.code = -1;
                this.message = SubmitActivationCodeAsyncTask.this.ctx.getString(Utils.getResourceId((Context)SubmitActivationCodeAsyncTask.this.ctx, (String)"txt_retry_error", (String)"string"));
            }
        };
        if (params.length == 0) {
            return response;
        }
        Request param = params[0];
        if ("0999666666".equalsIgnoreCase(param.phoneNumber)) {
            try {
                Thread.sleep(1000L);
                if ("6666".equalsIgnoreCase(param.activationCode)) {
                    return new Response(){
                        {
                            this.code = 0;
                            this.message = "";
                            this.token = "1234567890";
                            this.uid = 1234567890L;
                            this.displayName = "first last";
                            this.gender = "1";
                        }
                    };
                }
                return new Response(){
                    {
                        this.code = -1;
                        this.message = "M\u00e3 k\u00edch ho\u1ea1t kh\u00f4ng ch\u00ednh x\u00e1c.";
                    }
                };
            }
            catch (InterruptedException e) {
                return response;
            }
        }
        try {
            HttpClientRequest request = new HttpClientRequest(HttpClientRequest.Type.POST, API_URL);
            request.addParams("app_id", ZaloSDK.Instance.getAppID() + "");
            request.addParams("pkg_name", this.ctx.getPackageName());
            request.addParams("sign_key", AppInfo.getApplicationHashKey((Context)this.ctx));
            request.addParams("zdId", ZaloSDK.Instance.getDeviceId());
            request.addParams("sdkId", ZaloSDK.Instance.getSDKId());
            request.addParams("conn", Utils.getConnectionType((Context)this.ctx));
            request.addParams("mod", Utils.getDeviceModel());
            request.addParams("heap", Utils.getHeapSize());
            request.addParams("deviceWidth", String.valueOf(Utils.getScreenWidth((Context)this.ctx)));
            request.addParams("deviceHeight", String.valueOf(Utils.getScreenHeight((Context)this.ctx)));
            request.addParams("imei", Utils.getIMEI((Context)this.ctx));
            request.addParams("localTime", String.valueOf(System.currentTimeMillis()));
            request.addParams("timeZone", Utils.getTimeZoneString());
            request.addParams("cpuProcessor", Utils.getCPUInfo());
            request.addParams("battery", Utils.getBatteryInfo());
            request.addParams("phone", param.phoneNumber);
            request.addParams("regionCode", param.countryCode);
            request.addParams("token", param.token);
            request.addParams("lang", com.zing.zalo.zalosdk.payment.direct.Utils.getLanguage(this.ctx));
            byte[] encodeData = Utils.encrypt((String)ZaloSDK.Instance.getPrivateKey(), (String)param.activationCode);
            request.addParams("activeCode", Base64.encode((byte[])encodeData));
            JSONObject json = request.getJSON();
            response.code = json.optInt("error", -1);
            response.message = json.optString("errorMsg", response.message);
            JSONObject data = json.optJSONObject("data");
            if (response.code == 0 && data != null) {
                response.token = data.optString("token", "");
                response.uid = data.optLong("uid", 0L);
                response.displayName = data.optString("display_name", "");
                response.gender = data.optString("gender", "");
            }
        }
        catch (Exception e) {
            Log.e((Exception)e);
        }
        return response;
    }

    protected void onPostExecute(Response result) {
        super.onPostExecute((Object)result);
        if (this.callback != null) {
            this.callback.onCompleted(result);
        }
        this.callback = null;
    }

    static interface Callback {
        public void onCompleted(Response var1);
    }

    static class Response {
        int code;
        String message;
        String token;
        long uid;
        String displayName;
        String gender;

        Response() {
        }
    }

    static class Request {
        String countryCode;
        String phoneNumber;
        String activationCode;
        String token;

        Request() {
        }
    }
}

