/*
 * Decompiled with CFR 0.152.
 */
package com.zing.zalo.zalosdk.oauth.register;

import android.content.Context;
import android.os.AsyncTask;
import com.zing.zalo.zalosdk.core.helper.AppInfo;
import com.zing.zalo.zalosdk.core.helper.Utils;
import com.zing.zalo.zalosdk.core.http.HttpClientRequest;
import com.zing.zalo.zalosdk.core.log.Log;
import com.zing.zalo.zalosdk.oauth.ZaloSDK;
import org.json.JSONObject;

class RequestActivationCodeAsyncTask
extends AsyncTask<Request, Void, Response> {
    private static final String API_URL = "https://oauth.zaloapp.com/v2/mobile/register/req-active-code";
    Callback callback;
    Context ctx;

    RequestActivationCodeAsyncTask(Context ctx, Callback callback) {
        this.ctx = ctx;
        this.callback = callback;
    }

    protected Response doInBackground(Request ... params) {
        Response response = new Response(){
            {
                this.code = -1;
                this.message = RequestActivationCodeAsyncTask.this.ctx.getString(Utils.getResourceId((Context)RequestActivationCodeAsyncTask.this.ctx, (String)"txt_retry_error", (String)"string"));
            }
        };
        if (params.length == 0) {
            return response;
        }
        Request param = params[0];
        if ("0999666666".equalsIgnoreCase(param.phone)) {
            try {
                Thread.sleep(1000L);
                return new Response(){
                    {
                        this.code = 0;
                        this.message = "";
                        this.token = "1234567890";
                    }
                };
            }
            catch (InterruptedException e) {
                return response;
            }
        }
        try {
            HttpClientRequest request = new HttpClientRequest(HttpClientRequest.Type.POST, API_URL);
            request.addParams("app_id", ZaloSDK.Instance.getAppID() + "");
            request.addParams("pkg_name", this.ctx.getPackageName());
            request.addParams("sign_key", AppInfo.getApplicationHashKey((Context)this.ctx));
            request.addParams("zdId", ZaloSDK.Instance.getDeviceId());
            request.addParams("sdkId", ZaloSDK.Instance.getSDKId());
            request.addParams("conn", Utils.getConnectionType((Context)this.ctx));
            request.addParams("mod", Utils.getDeviceModel());
            request.addParams("heap", Utils.getHeapSize());
            request.addParams("deviceWidth", String.valueOf(Utils.getScreenWidth((Context)this.ctx)));
            request.addParams("deviceHeight", String.valueOf(Utils.getScreenHeight((Context)this.ctx)));
            request.addParams("imei", Utils.getIMEI((Context)this.ctx));
            request.addParams("localTime", String.valueOf(System.currentTimeMillis()));
            request.addParams("timeZone", Utils.getTimeZoneString());
            request.addParams("cpuProcessor", Utils.getCPUInfo());
            request.addParams("battery", Utils.getBatteryInfo());
            request.addParams("phone", param.phone);
            request.addParams("regionCode", param.contryCode);
            request.addParams("isForgotPwd", param.isForgotPwd ? "1" : "0");
            request.addParams("lang", com.zing.zalo.zalosdk.payment.direct.Utils.getLanguage(this.ctx));
            Log.i((String)"debuglog", (String)("lang submit to server: " + com.zing.zalo.zalosdk.payment.direct.Utils.getLanguage(this.ctx)));
            String str = request.getText();
            JSONObject json = new JSONObject(str);
            response.code = json.optInt("error", -1);
            response.message = json.optString("errorMsg", response.message);
            response.raw = str;
            JSONObject data = json.optJSONObject("data");
            if ((response.code == 0 || response.code == -1031) && data != null) {
                response.token = data.optString("token", "");
            }
        }
        catch (Exception e) {
            Log.e((Exception)e);
        }
        return response;
    }

    protected void onPostExecute(Response result) {
        super.onPostExecute((Object)result);
        if (this.callback != null) {
            this.callback.onCompleted(result);
        }
        this.callback = null;
    }

    static interface Callback {
        public void onCompleted(Response var1);
    }

    static class Response {
        int code;
        String message;
        String token;
        String raw;

        Response() {
        }
    }

    static class Request {
        boolean isForgotPwd;
        String phone;
        String contryCode;

        Request() {
        }
    }
}

