/*
 * Decompiled with CFR 0.152.
 */
package com.zing.zalo.zalosdk.oauth.register;

import android.content.Context;
import android.os.AsyncTask;
import com.zing.zalo.zalosdk.core.helper.AppInfo;
import com.zing.zalo.zalosdk.core.helper.Utils;
import com.zing.zalo.zalosdk.core.http.HttpClientRequest;
import com.zing.zalo.zalosdk.core.log.Log;
import com.zing.zalo.zalosdk.oauth.ZaloSDK;
import org.json.JSONObject;

class CreatePasswordAsyncTask
extends AsyncTask<Request, Void, Response> {
    private static final String API_URL = "https://oauth.zaloapp.com/v2/mobile/register/reset-pwd";
    Callback callback;
    Context ctx;

    CreatePasswordAsyncTask(Context context, Callback callback) {
        this.ctx = context;
        this.callback = callback;
    }

    protected Response doInBackground(Request ... params) {
        Response response = new Response(){
            {
                this.code = -1;
                this.message = CreatePasswordAsyncTask.this.ctx.getString(Utils.getResourceId((Context)CreatePasswordAsyncTask.this.ctx, (String)"txt_retry_error", (String)"string"));
            }
        };
        if (params.length == 0) {
            return response;
        }
        Request param = params[0];
        if ("0999666666".equalsIgnoreCase(param.phone)) {
            try {
                Thread.sleep(1000L);
                return new Response(){
                    {
                        this.code = 0;
                        this.message = "";
                        this.uid = 1234567890L;
                        this.displayName = "first last";
                        this.gender = "1";
                        this.dob = "01/01/1970";
                        this.oathCode = "abcdef";
                        this.zprotect = 0;
                        this.socialId = "";
                    }
                };
            }
            catch (InterruptedException e) {
                return response;
            }
        }
        try {
            HttpClientRequest request = new HttpClientRequest(HttpClientRequest.Type.POST, API_URL);
            request.addParams("app_id", ZaloSDK.Instance.getAppID() + "");
            request.addParams("pkg_name", this.ctx.getPackageName());
            request.addParams("sign_key", AppInfo.getApplicationHashKey((Context)this.ctx));
            request.addParams("zdId", ZaloSDK.Instance.getDeviceId());
            request.addParams("sdkId", ZaloSDK.Instance.getSDKId());
            request.addParams("phone", param.phone);
            request.addParams("regionCode", param.countryCode);
            request.addParams("uid", String.valueOf(param.uid));
            request.addParams("passwd", param.passwd);
            request.addParams("token", param.token);
            request.addParams("lang", com.zing.zalo.zalosdk.payment.direct.Utils.getLanguage(this.ctx));
            JSONObject json = request.getJSON();
            response.code = json.optInt("error", -1);
            response.message = json.optString("errorMsg", response.message);
            JSONObject data = json.optJSONObject("data");
            if (response.code == 0 && data != null) {
                response.uid = data.optLong("uid");
                response.displayName = data.optString("display_name");
                response.phone = data.optString("phone");
                response.dob = data.optString("dob");
                response.gender = data.optString("gender");
                response.oathCode = data.optString("code");
                response.zprotect = data.optInt("zprotect", 0);
                response.socialId = data.optString("socialId");
            }
        }
        catch (Exception e) {
            Log.e((Exception)e);
        }
        return response;
    }

    protected void onPostExecute(Response result) {
        super.onPostExecute((Object)result);
        if (this.callback != null) {
            this.callback.onCompleted(result);
        }
        this.callback = null;
    }

    static interface Callback {
        public void onCompleted(Response var1);
    }

    static class Response {
        int code;
        String message;
        long uid;
        String displayName;
        String phone;
        String dob;
        String gender;
        String oathCode;
        int zprotect;
        String socialId;

        Response() {
        }
    }

    static class Request {
        String phone;
        String countryCode;
        long uid;
        String passwd;
        String token;

        Request() {
        }
    }
}

