/*
 * Decompiled with CFR 0.152.
 */
package com.zing.zalo.zalosdk.oauth.dialog;

import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.os.Handler;
import android.widget.ImageView;
import android.widget.TextView;
import com.zing.zalo.zalosdk.R;
import com.zing.zalo.zalosdk.core.log.Log;
import com.zing.zalo.zalosdk.oauth.dialog.PaymentDialog;
import com.zing.zalo.zalosdk.resource.StringResource;

public class PaymentProcessingDialog
extends PaymentDialog
implements DialogInterface.OnDismissListener {
    String LOG_TAG = PaymentProcessingDialog.class.getSimpleName();
    String zalosdk_processing;
    String zalosdk_success;
    String zalosdk_unsuccess;
    String zalosdk_atm_processing;
    String zalosdk_atm_processing_waiting;
    String zalosdk_timeout_message;
    long timeOut;
    long atmWaitingTimeOut;
    long zingCoinTimeOut;
    public boolean isShow = false;
    boolean isTimeOut = false;
    int viewIndex = 0;
    Handler handler;
    Runnable runnable = new Runnable(){

        @Override
        public void run() {
            if (PaymentProcessingDialog.this.viewIndex > 0 && PaymentProcessingDialog.this.isShowing()) {
                PaymentProcessingDialog.this.hideView();
                if (PaymentProcessingDialog.this.listener != null) {
                    PaymentProcessingDialog.this.listener.onClose();
                }
            }
        }
    };
    Runnable runnableATMWaiting = new Runnable(){

        @Override
        public void run() {
            if (PaymentProcessingDialog.this.isShow) {
                PaymentProcessingDialog.this.updateProcessingTransactionView(PaymentProcessingDialog.this.zalosdk_atm_processing_waiting);
            }
        }
    };
    Runnable runnableTimeOut = new Runnable(){

        @Override
        public void run() {
            Log.i((String)"THREAD START", (String)("time out " + PaymentProcessingDialog.this.isShow + " " + PaymentProcessingDialog.this.viewIndex));
            if (PaymentProcessingDialog.this.isShow && PaymentProcessingDialog.this.viewIndex == 0) {
                PaymentProcessingDialog.this.hideView();
                PaymentProcessingDialog.this.showView(Status.TIMEOUT);
            }
        }
    };
    OnCloseListener listener;

    public boolean isTimeOut() {
        return this.isTimeOut;
    }

    public void setTimeOut(boolean isTimeOut) {
        this.isTimeOut = isTimeOut;
    }

    public PaymentProcessingDialog(Context context, OnCloseListener listener) {
        super(context);
        this.handler = new Handler();
        this.listener = listener;
        this.setOnDismissListener(this);
        this.zalosdk_processing = StringResource.getString("zalosdk_processing");
        this.zalosdk_success = StringResource.getString("zalosdk_success");
        this.zalosdk_unsuccess = StringResource.getString("zalosdk_unsuccess");
        this.zalosdk_atm_processing = StringResource.getString("zalosdk_atm_processing");
        this.zalosdk_atm_processing_waiting = StringResource.getString("zalosdk_atm_processing_waiting");
        this.timeOut = Long.parseLong(StringResource.getString("zalosdk_otp_timeout"));
        this.zingCoinTimeOut = Long.parseLong(StringResource.getString("zalosdk_zing_coin_timeout"));
        this.atmWaitingTimeOut = Long.parseLong(StringResource.getString("zalosdk_atm_waiting_timeout"));
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.zalosdk_activity_processing);
    }

    public void updateProcessingTransactionView(String text) {
        ((TextView)this.findViewById(R.id.zalosdk_message_ctl)).setText((CharSequence)text);
    }

    public void showProcessingTransactionView(String text) {
        this.show();
        this.isShow = true;
        ((TextView)this.findViewById(R.id.zalosdk_message_ctl)).setText((CharSequence)text);
        this.findViewById(R.id.zalosdk_status_ctl).setVisibility(8);
        this.findViewById(R.id.zalosdk_indicator_ctl).setVisibility(0);
        this.setCancelable(false);
        this.viewIndex = 0;
    }

    private void showATMProcessingView() {
        Log.i((String)"debuglog", (String)("timeOut::: " + this.timeOut));
        Log.i((String)"debuglog", (String)("atmWaitingTimeOut::: " + this.atmWaitingTimeOut));
        this.setContentView(R.layout.zalosdk_activity_processing);
        try {
            this.handler.removeCallbacks(this.runnableATMWaiting);
            this.handler.removeCallbacks(this.runnableTimeOut);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((TextView)this.findViewById(R.id.zalosdk_message_ctl)).setText((CharSequence)this.zalosdk_atm_processing);
        this.findViewById(R.id.zalosdk_status_ctl).setVisibility(8);
        this.findViewById(R.id.zalosdk_indicator_ctl).setVisibility(0);
        this.setCancelable(false);
        this.viewIndex = 0;
        this.zalosdk_timeout_message = StringResource.getString("zalosdk_channels_opt_timeout");
        this.handler.postDelayed(this.runnableATMWaiting, this.atmWaitingTimeOut);
        this.handler.postDelayed(this.runnableTimeOut, this.timeOut);
    }

    private void showProcessingView() {
        Log.i((String)"THREAD BEGIN", (String)"PROCESSING!!");
        ((TextView)this.findViewById(R.id.zalosdk_message_ctl)).setText((CharSequence)this.zalosdk_processing);
        this.findViewById(R.id.zalosdk_status_ctl).setVisibility(8);
        this.findViewById(R.id.zalosdk_indicator_ctl).setVisibility(0);
        this.setCancelable(false);
        this.viewIndex = 0;
    }

    private void showZingCoinProcessingView() {
        try {
            this.handler.removeCallbacks(this.runnable);
            this.handler.removeCallbacks(this.runnableTimeOut);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Log.i((String)"THREAD showZingCoinProcessingView", (String)"time out");
        this.showProcessingView();
        this.zalosdk_timeout_message = StringResource.getString("zalosdk_zingcoin_timeout_msg");
        this.handler.postDelayed(this.runnableTimeOut, this.zingCoinTimeOut);
    }

    private void showSuccessView() {
        Log.i((String)this.LOG_TAG, (String)"Show success dialog");
        ((TextView)this.findViewById(R.id.zalosdk_message_ctl)).setText((CharSequence)this.zalosdk_success);
        this.findViewById(R.id.zalosdk_indicator_ctl).setVisibility(8);
        ImageView status = (ImageView)this.findViewById(R.id.zalosdk_status_ctl);
        status.setImageResource(R.drawable.zalosdk_ic_success);
        status.setVisibility(0);
        this.setCancelable(true);
        this.viewIndex = 1;
        this.autoClose();
    }

    private void showUnSuccessView() {
        ((TextView)this.findViewById(R.id.zalosdk_message_ctl)).setText((CharSequence)this.zalosdk_unsuccess);
        this.findViewById(R.id.zalosdk_indicator_ctl).setVisibility(8);
        ImageView status = (ImageView)this.findViewById(R.id.zalosdk_status_ctl);
        status.setImageResource(R.drawable.zalosdk_ic_fail);
        status.setVisibility(0);
        this.setCancelable(true);
        this.viewIndex = 1;
        this.autoClose();
    }

    private void showTimeOutView() {
        Log.i((String)"debuglog", (String)"time out showview");
        this.findViewById(R.id.zalosdk_process_dialog_ctl).setVisibility(8);
        this.setCancelable(true);
        this.viewIndex = 1;
        this.handler.postDelayed(this.runnable, 1L);
        this.isTimeOut = true;
    }

    private void autoClose() {
        this.handler.postDelayed(this.runnable, 3000L);
    }

    public void showViewError(String msg) {
        this.show();
        this.isShow = true;
        ((TextView)this.findViewById(R.id.zalosdk_message_ctl)).setText((CharSequence)msg);
        this.findViewById(R.id.zalosdk_indicator_ctl).setVisibility(8);
        ImageView status = (ImageView)this.findViewById(R.id.zalosdk_status_ctl);
        status.setImageResource(R.drawable.zalosdk_ic_fail);
        status.setVisibility(0);
        this.setCancelable(true);
        this.viewIndex = 1;
        this.autoClose();
    }

    public void showView(Status status) {
        this.show();
        this.isShow = true;
        switch (status) {
            case PROCESSING: {
                this.showProcessingView();
                break;
            }
            case SUCCESS: {
                this.showSuccessView();
                break;
            }
            case FAILED: {
                this.showUnSuccessView();
                break;
            }
            case TIMEOUT: {
                this.showTimeOutView();
                break;
            }
            case OTPROCESSING: 
            case ATMPROCESSING: {
                this.showATMProcessingView();
                break;
            }
            case ZINGCOINPROCESSING: {
                this.showZingCoinProcessingView();
            }
        }
    }

    public void showUnSuccessView(String message) {
        ((TextView)this.findViewById(R.id.zalosdk_message_ctl)).setText((CharSequence)message);
        this.findViewById(R.id.zalosdk_indicator_ctl).setVisibility(8);
        ImageView status = (ImageView)this.findViewById(R.id.zalosdk_status_ctl);
        status.setImageResource(R.drawable.zalosdk_ic_fail);
        status.setVisibility(0);
        this.setCancelable(true);
        if (!this.isShowing()) {
            this.show();
        }
        this.viewIndex = 1;
        this.autoClose();
    }

    public void onDismiss(DialogInterface dialog) {
        if (this.listener != null) {
            Log.i((String)((Object)((Object)this)).getClass().getName(), (String)"cancel");
            this.listener.onClose();
        }
    }

    public void onBackPressed() {
    }

    public void hideView() {
        this.isShow = false;
        this.hide();
    }

    public void removeAllCallBack() {
        try {
            this.handler.removeCallbacks(this.runnable);
            this.handler.removeCallbacks(this.runnableATMWaiting);
            this.handler.removeCallbacks(this.runnableTimeOut);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void closeView() {
        this.viewIndex = 1;
        this.autoClose();
    }

    public void closeViewImmediately() {
        this.viewIndex = 1;
        this.handler.postDelayed(this.runnable, 0L);
    }

    public void finishProcessingWithoutShowDialog() {
        if (this.listener != null) {
            Log.i((String)((Object)((Object)this)).getClass().getName(), (String)"cancel");
            this.listener.onClose();
        }
    }

    public void show() {
        Log.i((String)this.LOG_TAG, (String)"show loading..");
        try {
            super.show();
        }
        catch (Exception ex) {
            Log.i((String)this.LOG_TAG, (String)"error can not show loading");
        }
    }

    public void hide() {
        Log.i((String)this.LOG_TAG, (String)"hide loading!");
        super.hide();
    }

    public static interface OnCloseListener {
        public void onClose();
    }

    public static enum Status {
        PROCESSING,
        SUCCESS,
        FAILED,
        TIMEOUT,
        OTPROCESSING,
        ATMPROCESSING,
        ZINGCOINPROCESSING;

    }
}

