/*
 * Decompiled with CFR 0.152.
 */
package com.zing.zalo.zalosdk.oauth;

import android.app.Application;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import com.zing.zalo.sdk.userqos.TestManager;
import com.zing.zalo.sdk.userqos.util.Log;
import com.zing.zalo.zalosdk.core.helper.Utils;
import com.zing.zalo.zalosdk.oauth.ZaloOAuth;
import com.zing.zalo.zalosdk.oauth.ZaloSDK;

public class ZaloSDKApplication
extends Application {
    protected static long appID;
    protected static String facebookAppID;
    private static boolean configOffSuccessDialog;
    private static boolean configFullScreen;
    private static String sender_id;
    private static boolean zuqEnabled;

    public static boolean isConfigOffSuccessDialog() {
        return configOffSuccessDialog;
    }

    public static boolean isConfigFullScreen() {
        return configFullScreen;
    }

    protected void attachBaseContext(Context context) {
        super.attachBaseContext(context);
    }

    public void onCreate() {
        super.onCreate();
        ZaloSDKApplication.init(this);
    }

    public static void wrap(Application app) {
        ZaloSDKApplication.init(app);
    }

    private static void init(Application app) {
        ZaloOAuth.Instance = ZaloSDK.Instance;
        com.zing.zalo.zalosdk.core.log.Log.initLogger();
        ZaloSDKApplication.loadConfiguration(app);
        Utils.initZingAnalytics((Application)app, (String)String.valueOf(appID));
        Utils.setSDKVersionZingAnalytics((String)ZaloSDK.Instance.getVersion());
        ZaloSDK.Instance.initialize(app);
        try {
            if (Build.VERSION.SDK_INT < 16) {
                Class.forName("android.os.AsyncTask");
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        if (zuqEnabled) {
            try {
                Log.setLogLevel((int)com.zing.zalo.zalosdk.core.log.Log.getLogLevel());
                TestManager testMgr = TestManager.shareInstance();
                testMgr.init((Context)app, String.valueOf(appID));
                testMgr.setDeviceId(ZaloSDK.Instance.getDeviceId());
                testMgr.setSdkId(ZaloSDK.Instance.getSDKId());
                testMgr.setOauthCode(ZaloSDK.Instance.getOAuthCode());
                testMgr.setUser(String.valueOf(ZaloSDK.Instance.getZaloId()));
                testMgr.start();
            }
            catch (NoClassDefFoundError error) {
                com.zing.zalo.zalosdk.core.log.Log.w((String)"UserQOS not found.");
            }
        }
    }

    private static void loadConfiguration(Application app) {
        try {
            Bundle bundle = app.getPackageManager().getApplicationInfo((String)app.getPackageName(), (int)128).metaData;
            appID = bundle.containsKey("com.zing.zalo.zalosdk.appID") ? Long.parseLong((String)bundle.get("com.zing.zalo.zalosdk.appID")) : Long.parseLong((String)bundle.get("appID"));
            if (bundle.containsKey("configOffSuccessDialog")) {
                configOffSuccessDialog = (Boolean)bundle.get("configOffSuccessDialog");
            }
            if (bundle.containsKey("configFullScreen")) {
                configFullScreen = (Boolean)bundle.get("configFullScreen");
            }
            if (bundle.containsKey("com.facebook.sdk.ApplicationId")) {
                facebookAppID = bundle.getString("com.facebook.sdk.ApplicationId");
            }
            if (bundle.containsKey("senderId")) {
                sender_id = bundle.getString("senderId");
            }
            if (bundle.containsKey("zuqEnabled")) {
                zuqEnabled = bundle.getBoolean("zuqEnabled", true);
            }
        }
        catch (PackageManager.NameNotFoundException bundle) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        facebookAppID = "";
        configOffSuccessDialog = false;
        configFullScreen = true;
        sender_id = "";
        zuqEnabled = true;
    }
}

