/*
 * Decompiled with CFR 0.152.
 */
package com.zing.zalo.zalosdk.oauth;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import com.zing.zalo.devicetrackingsdk.AppUserDataCallback;
import com.zing.zalo.devicetrackingsdk.BaseAppInfo;
import com.zing.zalo.devicetrackingsdk.BaseAppInfoStorage;
import com.zing.zalo.zalosdk.core.exception.InitializedException;
import com.zing.zalo.zalosdk.core.log.Log;
import com.zing.zalo.zalosdk.oauth.Authenticator;
import com.zing.zalo.zalosdk.oauth.LocalizedString;
import com.zing.zalo.zalosdk.oauth.LoginVia;
import com.zing.zalo.zalosdk.oauth.OAuthCompleteListener;
import com.zing.zalo.zalosdk.oauth.OauthStorage;
import com.zing.zalo.zalosdk.oauth.Permissions;
import com.zing.zalo.zalosdk.oauth.ValidateOAuthCodeCallback;
import com.zing.zalo.zalosdk.oauth.ZaloAPIService;
import com.zing.zalo.zalosdk.oauth.ZaloOAuth;
import com.zing.zalo.zalosdk.oauth.ZaloOpenAPICallback;
import com.zing.zalo.zalosdk.oauth.ZaloSDKApplication;
import com.zing.zalo.zalosdk.payment.direct.Utils;

public class ZaloSDK
extends ZaloOAuth {
    private boolean bIsInitialized = false;
    private Authenticator mAuthenticator;
    private LocalizedString mLocalizedString = new LocalizedString();
    private OauthStorage mStorage;
    public static ZaloSDK Instance = new ZaloSDK();
    private ZaloAPIService zaloAPIService;
    private BaseAppInfo info;

    ZaloSDK() {
    }

    @Override
    protected synchronized void initialize(Application app) {
        if (this.bIsInitialized) {
            return;
        }
        Context context = app.getApplicationContext();
        this.mStorage = new OauthStorage(context);
        this.mAuthenticator = new Authenticator(context, this.mStorage, this.mLocalizedString);
        this.bIsInitialized = true;
        this.zaloAPIService = new ZaloAPIService(this.mStorage);
        this.info = new BaseAppInfo(context, new BaseAppInfoStorage(context), String.valueOf(this.getAppID()));
    }

    public Authenticator getAuthenticator() {
        return this.mAuthenticator;
    }

    @Override
    public LocalizedString getLocalizedString() {
        return this.mLocalizedString;
    }

    @Override
    public void setLocalizedString(LocalizedString localizedString) {
        this.mLocalizedString = localizedString;
    }

    @Override
    public void authenticate(Activity activity, OAuthCompleteListener listener) {
        this.authenticate(activity, LoginVia.APP, listener);
    }

    @Override
    public void authenticate(Activity activity, LoginVia loginVia, OAuthCompleteListener listener) {
        this.checkInitialize();
        this.mAuthenticator.authenticate(activity, loginVia, false, listener);
    }

    protected void authenticateZaloPlugin(Activity activity, OAuthCompleteListener listener) {
        this.checkInitialize();
        this.mAuthenticator.authenticate(activity, LoginVia.APP_OR_WEB, true, listener);
    }

    public void setOauthCompletedListener(OAuthCompleteListener listener) {
        this.checkInitialize();
        this.mAuthenticator.setOAuthCompleteListener(listener);
    }

    @Override
    public void unauthenticate() {
        this.checkInitialize();
        this.mAuthenticator.unauthenticate();
    }

    @Override
    public boolean isAuthenticate(ValidateOAuthCodeCallback callback) {
        return this.isAuthenticate(this.mStorage.getOAuthCode(), callback);
    }

    protected boolean isAuthenticate(String oauthCode, ValidateOAuthCodeCallback callback) {
        this.checkInitialize();
        return this.mAuthenticator.isAuthenticate(oauthCode, callback);
    }

    @Override
    public final boolean onActivityResult(Activity activity, int requestCode, int resultCode, Intent data) {
        return this.mAuthenticator.onActivityResult(activity, requestCode, resultCode, data);
    }

    @Override
    public void requestPermissions(Activity activity, Enum<Permissions> permission2, OAuthCompleteListener listener) {
        this.checkInitialize();
        this.mAuthenticator.requestPermissions(activity, permission2, listener);
    }

    @Override
    public String getOAuthCode() {
        this.checkInitialize();
        return this.mStorage.getOAuthCode();
    }

    @Override
    public String getLastestLoginChannel() {
        return this.mStorage.getLastestLoginChannel();
    }

    @Override
    public long getAppID() {
        return ZaloSDKApplication.appID;
    }

    @Override
    public long getZaloId() {
        this.checkInitialize();
        return this.mStorage.getZaloId();
    }

    @Override
    public String getZaloDisplayname() {
        this.checkInitialize();
        return this.mStorage.getZaloDisplayName();
    }

    public String getSocialId() {
        this.checkInitialize();
        return this.mStorage.getSocialId();
    }

    @Override
    public void getProfile(Context ctx, ZaloOpenAPICallback callback) {
        this.checkInitialize();
        this.zaloAPIService.getProfile(ctx, callback);
    }

    @Override
    public void getFriendList(Context ctx, int position, int count, ZaloOpenAPICallback callback) {
        this.checkInitialize();
        this.zaloAPIService.getFriendList(ctx, position, count, callback);
    }

    public void checkInitialize() {
        if (!this.bIsInitialized) {
            throw new InitializedException();
        }
    }

    @Override
    public String getVersion() {
        return "2.2.0814";
    }

    @Override
    public void setLogLevel(int logLevel) {
        Log.setLogLevel((int)logLevel);
    }

    @Override
    public String getDeviceId() {
        return this.info.getDeviceId();
    }

    public String getGuestDeviceId() {
        return this.info.getGuestDeviceId();
    }

    @Override
    public String getSDKId() {
        return this.info.getSDKId();
    }

    @Override
    public String getPrivateKey() {
        return this.info.getPrivateKey();
    }

    public void submitAppUserData(String appUser, String loginChannel, String distributionSource, String appUTMSource, AppUserDataCallback callback) {
        this.checkInitialize();
        this.info.submitAppUserData(appUser, loginChannel, distributionSource, appUTMSource, callback);
    }

    public BaseAppInfo getBaseAppInfo() {
        return this.info;
    }

    public String getDistributionSource() {
        if (this.info != null) {
            return this.info.getDistributionSource();
        }
        return null;
    }

    public String getAppUser() {
        if (this.info != null) {
            return this.info.getAppUser();
        }
        return null;
    }

    public String getLoginChannel() {
        if (this.info != null) {
            return this.info.getLoginChannel();
        }
        return null;
    }

    public OauthStorage getOauthStorage() {
        return this.mStorage;
    }

    public void setLanguageSDK(Context context, String language) {
        Utils.setLanguage(context, language);
    }

    public void registerZalo(Activity activity, OAuthCompleteListener listener) {
        this.checkInitialize();
        this.mAuthenticator.registerZalo(activity, listener);
    }
}

