/*
 * Decompiled with CFR 0.152.
 */
package com.zing.zalo.zalosdk.oauth;

import android.content.Context;
import android.os.AsyncTask;
import com.zing.zalo.zalosdk.core.helper.AppInfo;
import com.zing.zalo.zalosdk.core.http.HttpClientRequest;
import com.zing.zalo.zalosdk.oauth.OauthStorage;
import com.zing.zalo.zalosdk.oauth.ZaloOpenAPICallback;
import com.zing.zalo.zalosdk.oauth.ZaloPluginCallback;
import com.zing.zalo.zalosdk.oauth.ZaloSDK;
import java.lang.ref.WeakReference;
import org.json.JSONException;
import org.json.JSONObject;

class ZaloAPIService {
    private WeakReference<ZaloOpenAPICallback> mOpenAPICallack;
    private OauthStorage mStorage = null;
    private String mUrl = "http://openapi.zaloapp.com/query";
    protected WeakReference<ZaloPluginCallback> mCallback;
    protected WeakReference<Context> mWeakContext;
    public static final String UTF8 = "UTF-8";

    ZaloAPIService(OauthStorage storage) {
        this.mStorage = storage;
    }

    private JSONObject getAccessToken(Context ctx) {
        JSONObject accessToken = null;
        try {
            accessToken = new JSONObject(this.mStorage.getAccessToken());
            if (accessToken.getLong("expires_in") < System.currentTimeMillis()) {
                accessToken = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (accessToken == null) {
                HttpClientRequest request = new HttpClientRequest(HttpClientRequest.Type.POST, "https://oauth.zaloapp.com/v2/mobile/access_token");
                request.addParams("code", ZaloSDK.Instance.getOAuthCode());
                request.addParams("pkg_name", AppInfo.getPackageName((Context)ctx));
                request.addParams("sign_key", AppInfo.getApplicationHashKey((Context)ctx));
                request.addParams("app_id", ZaloSDK.Instance.getAppID() + "");
                request.addParams("version", ZaloSDK.Instance.getVersion());
                accessToken = request.getJSON();
                if (accessToken != null && accessToken.optInt("error", -1) >= 0) {
                    accessToken = accessToken.optJSONObject("data");
                    accessToken.put("error", 0);
                    if (accessToken != null) {
                        long time = System.currentTimeMillis() + 1800000L;
                        accessToken.put("expires_in", time);
                        this.mStorage.setAccessToken(accessToken.toString());
                    }
                }
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return accessToken;
    }

    void getProfile(Context ctx, ZaloOpenAPICallback callback) {
        this.mOpenAPICallack = new WeakReference<ZaloOpenAPICallback>(callback);
        HttpClientRequest request = new HttpClientRequest(HttpClientRequest.Type.GET, this.mUrl);
        request.addParams("act", "profile");
        new UserTask(ctx).execute(new HttpClientRequest[]{request});
    }

    void getFriendList(Context ctx, int position, int count, ZaloOpenAPICallback callback) {
        this.mOpenAPICallack = new WeakReference<ZaloOpenAPICallback>(callback);
        HttpClientRequest request = new HttpClientRequest(HttpClientRequest.Type.GET, this.mUrl);
        request.addParams("act", "lstfri");
        request.addParams("pos", position + "");
        request.addParams("count", count + "");
        new UserTask(ctx).execute(new HttpClientRequest[]{request});
    }

    private class UserTask
    extends AsyncTask<HttpClientRequest, Void, JSONObject> {
        Context ctx;

        UserTask(Context ctx) {
            this.ctx = ctx;
        }

        protected void onPreExecute() {
            super.onPreExecute();
        }

        protected JSONObject doInBackground(HttpClientRequest ... requests) {
            HttpClientRequest request = requests[0];
            if (ZaloSDK.Instance.getOAuthCode() == null || ZaloSDK.Instance.getOAuthCode().equals("")) {
                try {
                    return new JSONObject("{\"error\":-1004}");
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            JSONObject accessToken = ZaloAPIService.this.getAccessToken(this.ctx);
            if (accessToken == null) {
                try {
                    return new JSONObject("{\"error\":-1008}");
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            if (accessToken.optInt("error", -1) >= 0) {
                request.addParams("appid", ZaloSDK.Instance.getAppID() + "");
                request.addParams("accessTok", accessToken.optString("access_token"));
                request.addParams("version", "3");
                return request.getJSON();
            }
            return accessToken;
        }

        protected void onPostExecute(JSONObject object) {
            try {
                if (object != null) {
                    if (ZaloAPIService.this.mOpenAPICallack != null && ZaloAPIService.this.mOpenAPICallack.get() != null) {
                        ((ZaloOpenAPICallback)ZaloAPIService.this.mOpenAPICallack.get()).onResult(object);
                    } else if (ZaloAPIService.this.mOpenAPICallack != null && ZaloAPIService.this.mOpenAPICallack.get() != null) {
                        ((ZaloOpenAPICallback)ZaloAPIService.this.mOpenAPICallack.get()).onResult(new JSONObject("{\"error\":-1112}"));
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

