/*
 * Decompiled with CFR 0.152.
 */
package com.zing.zalo.zalosdk.oauth;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.text.TextUtils;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import com.zing.zalo.zalosdk.R;
import com.zing.zalo.zalosdk.common.UtilsCore;
import com.zing.zalo.zalosdk.core.helper.Utils;
import com.zing.zalo.zalosdk.oauth.ZaloSDK;
import com.zing.zalo.zalosdk.oauth.register.ZaloWebActivePhoneFragment;
import com.zing.zalo.zalosdk.oauth.register.ZaloWebCreatePasswordFragment;
import com.zing.zalo.zalosdk.oauth.register.ZaloWebLoginFragment;
import com.zing.zalo.zalosdk.oauth.register.ZaloWebRegisterFragment;
import com.zing.zalo.zalosdk.oauth.register.ZaloWebSelectCountryFragment;
import com.zing.zalo.zalosdk.oauth.register.ZaloWebTermConditionFragment;
import com.zing.zalo.zalosdk.oauth.register.ZaloWebUpdateProfileFragment;
import com.zing.zalo.zalosdk.payment.direct.PaymentProcessingDialog;
import org.json.JSONException;
import org.json.JSONObject;

@SuppressLint(value={"NewApi"})
public class WebLoginActivity
extends FragmentActivity
implements ZaloWebLoginFragment.ZaloWebLoginFragmentListener,
ZaloWebRegisterFragment.ZaloWebRegisterFragmentListener,
ZaloWebUpdateProfileFragment.ZaloWebUpdateProfileFragmentListener,
ZaloWebActivePhoneFragment.ZaloWebActivePhoneFragmentListener,
ZaloWebSelectCountryFragment.ZaloWebSelectCountryFragmentListener,
ZaloWebCreatePasswordFragment.ZaloWebCreatePasswordFragmentListener,
View.OnClickListener {
    ZaloWebLoginFragment loginFragment;
    ZaloWebRegisterFragment registerFragment;
    ZaloWebUpdateProfileFragment updateProfileFragment;
    ZaloWebActivePhoneFragment activePhoneFragment;
    ZaloWebTermConditionFragment conditionFragment;
    ZaloWebCreatePasswordFragment createPasswordFragment;
    ZaloWebSelectCountryFragment countryFragment;
    FrameLayout frameLayout;
    int frameLayoutId;
    PaymentProcessingDialog progressDialog;
    TextView titleView;
    ImageView backButton;
    boolean registerOnly;

    public static Intent newIntent(Context context, boolean registerOnly) {
        Intent intent = new Intent(context, WebLoginActivity.class);
        intent.putExtra("registerOnly", registerOnly);
        return intent;
    }

    public static Intent newShareFeedLoginIntent(Context context, String shareTo) {
        Intent intent = WebLoginActivity.newIntent(context, false);
        intent.addFlags(0x10000000);
        intent.putExtra("login_from_share_feed", true);
        intent.putExtra("share_to", shareTo);
        return intent;
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        ZaloSDK.Instance.onActivityResult((Activity)this, requestCode, resultCode, data);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.registerOnly = this.getIntent().getBooleanExtra("registerOnly", false);
        this.setContentView(UtilsCore.getResourceId((Context)this, (String)"zalosdk_activity_zalo_web_login", (String)"layout"));
        this.frameLayoutId = UtilsCore.getResourceId((Context)this, (String)"zalosdk_weblogin_container", (String)"id");
        this.frameLayout = (FrameLayout)this.findViewById(this.frameLayoutId);
        int id2 = UtilsCore.getResourceId((Context)this, (String)"zalosdk_txt_title", (String)"id");
        this.titleView = (TextView)this.findViewById(id2);
        id2 = UtilsCore.getResourceId((Context)this, (String)"zalosdk_back_control", (String)"id");
        this.backButton = (ImageView)this.findViewById(id2);
        this.backButton.setOnClickListener((View.OnClickListener)this);
        if (savedInstanceState == null) {
            if (this.registerOnly) {
                this.registerFragment = ZaloWebRegisterFragment.newIstance(false, null);
                FragmentManager fragmentManager = this.getSupportFragmentManager();
                FragmentTransaction transaction = fragmentManager.beginTransaction();
                transaction.replace(this.frameLayoutId, (Fragment)this.registerFragment, "register-fragment");
                transaction.commit();
            } else {
                this.showWebLoginFragment(null);
            }
        }
    }

    public void onClick(View v) {
        if (v == this.backButton) {
            UtilsCore.hideSoftKeyboard((Activity)this);
            this.onBackPressed();
        }
    }

    public void onBackPressed() {
        if (this.backButton != null && this.backButton.getVisibility() == 0) {
            super.onBackPressed();
        }
    }

    private void showFragment(Fragment fragment, boolean addBackStack) {
        FragmentManager fragmentManager = this.getSupportFragmentManager();
        FragmentTransaction transaction = fragmentManager.beginTransaction();
        transaction.replace(this.frameLayoutId, fragment, fragment.getClass().getSimpleName());
        transaction.setTransition(4097);
        if (addBackStack) {
            transaction.addToBackStack(fragment.getClass().getSimpleName());
        }
        transaction.commit();
    }

    @Override
    public void onRegister() {
        this.registerFragment = ZaloWebRegisterFragment.newIstance(false, null);
        this.showFragment(this.registerFragment, true);
    }

    @Override
    public void onForgotPassword(String phoneNumber) {
        this.registerFragment = ZaloWebRegisterFragment.newIstance(true, phoneNumber);
        this.showFragment(this.registerFragment, true);
    }

    @Override
    public void onRegisterRelogin(String rawJson) {
        if (this.loginFragment == null) {
            this.popToRoot();
            this.showWebLoginFragment(rawJson);
        } else {
            this.loginFragment.reloadWithZAlert(rawJson);
            this.popToRoot();
        }
    }

    public void onDestroy() {
        super.onDestroy();
        Utils.clearTextLineCache();
    }

    private void showWebLoginFragment(String zalert) {
        this.loginFragment = ZaloWebLoginFragment.newIstance(zalert);
        FragmentManager fragmentManager = this.getSupportFragmentManager();
        FragmentTransaction transaction = fragmentManager.beginTransaction();
        transaction.replace(this.frameLayoutId, (Fragment)this.loginFragment, "login-fragment");
        transaction.commit();
    }

    @Override
    public void onActivePhone(String phoneNumber, String countryCode, String token, boolean isForgotPassword, String message) {
        ZaloWebActivePhoneFragment activePhoneFragment = ZaloWebActivePhoneFragment.newIstance(phoneNumber, countryCode, token, isForgotPassword, message);
        this.showFragment(activePhoneFragment, true);
    }

    private void popToRoot() {
        FragmentManager fm = this.getSupportFragmentManager();
        for (int i = fm.getBackStackEntryCount(); i > 0; --i) {
            fm.popBackStackImmediate();
        }
    }

    @Override
    public void showLoading() {
        if (this.progressDialog == null) {
            this.progressDialog = new PaymentProcessingDialog((Context)this, new PaymentProcessingDialog.OnCloseListener(){

                @Override
                public void onClose() {
                }
            });
        }
        if (!this.progressDialog.isShowing()) {
            this.progressDialog.show();
        }
    }

    @Override
    public void hideLoading() {
        if (this.progressDialog != null && this.progressDialog.isShowing()) {
            this.progressDialog.dismiss();
            this.progressDialog = null;
        }
    }

    @Override
    public void showMessageDialog(String title, String message) {
        this.showDialog((Activity)this, null, title, message, this.getString(Utils.getResourceId((Context)this, (String)"txt_close", (String)"string")));
    }

    @Override
    public void setTitle(String title) {
        if (this.titleView != null) {
            this.titleView.setText((CharSequence)title);
        }
    }

    @Override
    public void showBackButton() {
        if (this.backButton != null) {
            this.backButton.setVisibility(0);
        }
    }

    @Override
    public void hideBackButton() {
        if (this.backButton != null) {
            this.backButton.setVisibility(4);
        }
    }

    @Override
    public void onLoginCompleted(int error, long uid, String oauth, int zprotect, String name, boolean isRegister) {
        Intent data = new Intent();
        data.putExtra("error", error);
        data.putExtra("uid", uid);
        data.putExtra("code", oauth);
        data.putExtra("isRegister", isRegister);
        JSONObject extra = new JSONObject();
        JSONObject extraData = new JSONObject();
        try {
            extraData.put("display_name", (Object)name);
            extraData.put("zprotect", zprotect);
            extra.put("data", (Object)extraData);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        data.putExtra("data", extra.toString());
        this.setResult(-1, data);
        this.finish();
    }

    @Override
    public void onClickTerm() {
        ZaloWebTermConditionFragment conditionFragment = ZaloWebTermConditionFragment.newIstance();
        this.showFragment(conditionFragment, true);
    }

    @Override
    public void showDialog(Activity activity, OnDialogClickListener listener, String title, String msg, String command) {
        this.showConfirmDialog(activity, listener, title, null, msg, null, command);
    }

    @Override
    public void showConfirmDialog(Activity activity, final OnDialogClickListener listener, String tile, String phoneNumber, String content, String leftCommand, String rightCommand) {
        final Dialog layout2 = new Dialog((Context)activity);
        layout2.requestWindowFeature(1);
        layout2.setContentView(R.layout.zalo_web_regis_dialog_confirm);
        layout2.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
        if (!TextUtils.isEmpty((CharSequence)content)) {
            ((TextView)layout2.findViewById(R.id.content)).setText((CharSequence)content);
        }
        if (TextUtils.isEmpty((CharSequence)tile)) {
            layout2.findViewById(UtilsCore.getResourceId((Context)activity, (String)"line", (String)"id")).setVisibility(8);
            layout2.findViewById(UtilsCore.getResourceId((Context)activity, (String)"txt_title", (String)"id")).setVisibility(8);
        } else {
            ((TextView)layout2.findViewById(UtilsCore.getResourceId((Context)activity, (String)"txt_title", (String)"id"))).setText((CharSequence)tile);
        }
        if (TextUtils.isEmpty((CharSequence)phoneNumber)) {
            ((TextView)layout2.findViewById(R.id.phoneNumber)).setVisibility(8);
        } else {
            ((TextView)layout2.findViewById(R.id.phoneNumber)).setVisibility(0);
            ((TextView)layout2.findViewById(R.id.phoneNumber)).setText((CharSequence)phoneNumber);
        }
        if (TextUtils.isEmpty((CharSequence)rightCommand)) {
            layout2.findViewById(R.id.btn_add).setVisibility(8);
        } else {
            ((TextView)layout2.findViewById(R.id.btn_add)).setText((CharSequence)rightCommand);
            layout2.findViewById(R.id.btn_add).setVisibility(0);
            layout2.findViewById(R.id.btn_add).setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    layout2.dismiss();
                    if (listener != null) {
                        listener.onClickOk();
                    }
                }
            });
        }
        if (TextUtils.isEmpty((CharSequence)leftCommand)) {
            layout2.findViewById(R.id.btn_cancel).setVisibility(8);
        } else {
            ((TextView)layout2.findViewById(R.id.btn_cancel)).setText((CharSequence)leftCommand);
            layout2.findViewById(R.id.btn_cancel).setVisibility(0);
            layout2.findViewById(R.id.btn_cancel).setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    layout2.dismiss();
                    if (listener != null) {
                        listener.onCancel();
                    }
                }
            });
        }
        if (!TextUtils.isEmpty((CharSequence)leftCommand) && TextUtils.isEmpty((CharSequence)rightCommand) || TextUtils.isEmpty((CharSequence)leftCommand) && !TextUtils.isEmpty((CharSequence)rightCommand)) {
            String text = !TextUtils.isEmpty((CharSequence)leftCommand) ? leftCommand : rightCommand;
            layout2.findViewById(R.id.btn_cancel).setVisibility(8);
            layout2.findViewById(R.id.btn_add).setVisibility(8);
            TextView centerButton = (TextView)layout2.findViewById(UtilsCore.getResourceId((Context)activity, (String)"centerbtn", (String)"id"));
            centerButton.setVisibility(0);
            centerButton.setText((CharSequence)text);
            centerButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    layout2.dismiss();
                    if (listener != null) {
                        listener.onCancel();
                        listener.onClickOk();
                    }
                }
            });
        }
        layout2.show();
    }

    @Override
    public void onClickSelectCountry() {
        if (this.countryFragment == null) {
            this.countryFragment = ZaloWebSelectCountryFragment.newIstance();
        }
        this.showFragment(this.countryFragment, true);
    }

    @Override
    public void onSelectCountry(String region) {
        if (this.registerFragment != null) {
            Bundle bundle = this.registerFragment.getArguments();
            bundle.putString("regioncode", region);
            this.registerFragment.updateCountry(region);
        }
    }

    @Override
    public void onCreatePassword(String phoneNumber, String countryCode, long uid, String token, boolean isForgotPassword) {
        this.popToRoot();
        this.createPasswordFragment = ZaloWebCreatePasswordFragment.newIstance(phoneNumber, countryCode, uid, token, isForgotPassword);
        this.showFragment(this.createPasswordFragment, true);
    }

    @Override
    public void onUpdateProfile(String phone, String countryCode, long uid, String oauthCode, String displayName, String gender, String dob, int zprotect, String socialId, String token) {
        this.popToRoot();
        this.updateProfileFragment = ZaloWebUpdateProfileFragment.newIstance(phone, countryCode, uid, oauthCode, displayName, gender, dob, zprotect, socialId, token);
        this.showFragment(this.updateProfileFragment, true);
    }

    public static interface OnDialogClickListener {
        public void onCancel();

        public void onClickOk();
    }
}

