/*
 * Decompiled with CFR 0.152.
 */
package com.zing.zalo.zalosdk.oauth;

import android.annotation.SuppressLint;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.net.http.SslError;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.OrientationEventListener;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.webkit.SslErrorHandler;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.zing.zalo.zalosdk.R;
import com.zing.zalo.zalosdk.oauth.Utilities;
import com.zing.zalo.zalosdk.oauth.ZaloPluginCallback;
import com.zing.zalo.zalosdk.oauth.dialog.PaymentProcessingDialog;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;

public class WebDialog
extends Dialog {
    public static final String EXTRA_QUERY = "querystring";
    public static final String EXTRA_REQUEST_BODY = "bodyrequest";
    private static final String UTF8 = "UTF-8";
    private static final String LOG_TAG = "WebDialog";
    private static final String DISPLAY_TOUCH = "touch";
    private static final int API_EC_DIALOG_CANCEL = 4201;
    static final boolean DISABLE_SSL_CHECK_FOR_TESTING = false;
    private static final int NO_PADDING_SCREEN_WIDTH = 480;
    private static final int MAX_PADDING_SCREEN_WIDTH = 800;
    private static final int NO_PADDING_SCREEN_HEIGHT = 800;
    private static final int MAX_PADDING_SCREEN_HEIGHT = 1280;
    private static final double MIN_SCALE_FACTOR = 0.5;
    private static final int BACKGROUND_GRAY = -872415232;
    private static final int BACKGROUND_WHITE = 0xFFFFFF;
    public static final int DEFAULT_THEME = 0x1030010;
    private String url;
    private String query;
    private String queryBody;
    private OnCompleteListener onCompleteListener;
    ZaloPluginCallback zFeedCallback;
    private WebView webView;
    private PaymentProcessingDialog spinner;
    private ImageView crossImageView;
    private FrameLayout contentFrameLayout;
    private boolean listenerCalled = false;
    private boolean isDetached = false;
    private boolean isDismissed = false;
    int oldWidth = 0;
    OrientationEventListener myOrientationEventListener;

    public WebDialog(Context context, String url) {
        this(context, url, 0x1030010);
    }

    public WebDialog(Context context, String url, int theme) {
        super(context, theme);
        this.url = url;
    }

    public WebDialog(Context context, String action, Bundle parameters, int theme, OnCompleteListener listener) {
        super(context, theme);
        if (parameters == null) {
            parameters = new Bundle();
        }
        this.query = parameters.getString(EXTRA_QUERY);
        this.queryBody = parameters.getString(EXTRA_REQUEST_BODY);
        this.query = this.query == null ? "" : this.query;
        this.url = "http://plugin.zaloapp.com/mobile-sharing?" + this.query;
        this.onCompleteListener = listener;
    }

    public void setFeedCallBackListener(ZaloPluginCallback callback) {
        this.zFeedCallback = callback;
    }

    public OnCompleteListener getOnCompleteListener() {
        return this.onCompleteListener;
    }

    public void dismiss() {
        if (this.isDismissed) {
            return;
        }
        this.isDismissed = true;
        if (this.myOrientationEventListener != null) {
            this.myOrientationEventListener.disable();
        }
        if (!this.listenerCalled) {
            this.sendCancelToListener();
        }
        if (this.webView != null) {
            this.webView.stopLoading();
        }
        if (!this.isDetached) {
            if (this.spinner.isShowing()) {
                this.spinner.dismiss();
            }
            super.dismiss();
        }
    }

    public void onDetachedFromWindow() {
        this.isDetached = true;
        super.onDetachedFromWindow();
    }

    public void onAttachedToWindow() {
        this.isDetached = false;
        super.onAttachedToWindow();
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.spinner = new PaymentProcessingDialog(this.getContext(), new PaymentProcessingDialog.OnCloseListener(){

            @Override
            public void onClose() {
            }
        });
        this.spinner.requestWindowFeature(1);
        this.spinner.setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialogInterface) {
                WebDialog.this.dismiss();
            }
        });
        this.requestWindowFeature(1);
        this.contentFrameLayout = new FrameLayout(this.getContext());
        this.calculateSize();
        this.getWindow().setGravity(17);
        this.getWindow().setSoftInputMode(16);
        this.createCrossImage();
        int crossWidth = this.crossImageView.getDrawable().getIntrinsicWidth();
        this.setUpWebView(0);
        ViewGroup.LayoutParams param = new ViewGroup.LayoutParams(-2, -2);
        this.contentFrameLayout.addView((View)this.crossImageView, param);
        this.setContentView((View)this.contentFrameLayout);
        this.crossImageView.bringToFront();
        this.myOrientationEventListener = new OrientationEventListener(this.getContext(), 3){

            public void onOrientationChanged(int arg0) {
                if (arg0 > 350 || arg0 < 10) {
                    WebDialog.this.updateLayout();
                } else if (arg0 < 100 && arg0 > 80) {
                    WebDialog.this.updateLayout();
                } else if (arg0 > 170 && arg0 < 190) {
                    WebDialog.this.updateLayout();
                } else if (arg0 > 260 && arg0 < 280) {
                    WebDialog.this.updateLayout();
                }
            }
        };
        if (this.myOrientationEventListener.canDetectOrientation()) {
            this.myOrientationEventListener.enable();
        } else {
            this.myOrientationEventListener = null;
        }
        this.setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
            }
        });
        this.getWindow().addFlags(2);
        WindowManager.LayoutParams lp = this.getWindow().getAttributes();
        lp.dimAmount = 0.7f;
    }

    private void updateLayout() {
        if (this.oldWidth != this.getScreenWidth()) {
            this.calculateSize();
            this.oldWidth = this.getScreenWidth();
        }
    }

    protected boolean isListenerCalled() {
        return this.listenerCalled;
    }

    protected WebView getWebView() {
        return this.webView;
    }

    private int getScreenWidth() {
        WindowManager wm = (WindowManager)this.getContext().getSystemService("window");
        Display display = wm.getDefaultDisplay();
        DisplayMetrics metrics = new DisplayMetrics();
        display.getMetrics(metrics);
        return metrics.widthPixels;
    }

    private void calculateSize() {
        WindowManager wm = (WindowManager)this.getContext().getSystemService("window");
        Display display = wm.getDefaultDisplay();
        DisplayMetrics metrics = new DisplayMetrics();
        display.getMetrics(metrics);
        int width = metrics.widthPixels;
        int height = metrics.heightPixels;
        int dialogWidth = width;
        int dialogHeight = height;
        if (Utilities.isTablet(this.getContext())) {
            dialogHeight = dialogHeight * 2 / 3;
            if (Utilities.isPortait(this.getContext())) {
                if ((dialogWidth = dialogWidth * 2 / 3) < 300) {
                    dialogWidth = 300;
                }
                if (dialogHeight < 400) {
                    dialogHeight = 400;
                }
            } else {
                if ((dialogWidth = dialogWidth * 1 / 2) < 400) {
                    dialogWidth = 400;
                }
                if (dialogHeight < 300) {
                    dialogHeight = 300;
                }
            }
            this.getWindow().setLayout(dialogWidth, dialogHeight);
        } else {
            this.getWindow().setFlags(1024, 1024);
        }
    }

    private int getScaledSize(int screenSize, float density, int noPaddingSize, int maxPaddingSize) {
        int scaledSize = (int)((float)screenSize / density);
        double scaleFactor = scaledSize <= noPaddingSize ? 1.0 : (scaledSize >= maxPaddingSize ? 0.5 : 0.5 + (double)(maxPaddingSize - scaledSize) / (double)(maxPaddingSize - noPaddingSize) * 0.5);
        return (int)((double)screenSize * scaleFactor);
    }

    protected void sendSuccessToListener(Bundle values) {
        if (this.onCompleteListener != null && !this.listenerCalled) {
            this.listenerCalled = true;
            this.onCompleteListener.onComplete(values);
            this.dismiss();
        }
    }

    protected void sendErrorToListener(Throwable error) {
        if (this.onCompleteListener != null && !this.listenerCalled) {
            this.listenerCalled = true;
            this.onCompleteListener.onComplete(null);
            this.dismiss();
        }
    }

    protected void sendCancelToListener() {
        this.sendErrorToListener(null);
    }

    private void createCrossImage() {
        this.crossImageView = new ImageView(this.getContext());
        this.crossImageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                WebDialog.this.dismiss();
            }
        });
        Drawable crossDrawable = this.getContext().getResources().getDrawable(R.drawable.ic_close_web);
        this.crossImageView.setImageDrawable(crossDrawable);
        this.crossImageView.setVisibility(4);
        this.crossImageView.setPadding(WebDialog.convertDpToPixel(7.0f, this.getContext()), WebDialog.convertDpToPixel(7.0f, this.getContext()), 0, 0);
    }

    public static int convertDpToPixel(float dp, Context context) {
        Resources resources = context.getResources();
        DisplayMetrics metrics = resources.getDisplayMetrics();
        float px = dp * ((float)metrics.densityDpi / 160.0f);
        return (int)px;
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private void setUpWebView(int margin) {
        LinearLayout webViewContainer = new LinearLayout(this.getContext());
        this.webView = new WebView(this.getContext()){

            public void onWindowFocusChanged(boolean hasWindowFocus) {
                try {
                    super.onWindowFocusChanged(hasWindowFocus);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        };
        this.webView.setVerticalScrollBarEnabled(false);
        this.webView.setHorizontalScrollBarEnabled(false);
        this.webView.setWebViewClient((WebViewClient)new DialogWebViewClient());
        this.webView.getSettings().setJavaScriptEnabled(true);
        this.webView.postUrl(this.url, this.queryBody.getBytes());
        Log.i((String)"debuglog", (String)("query:" + this.query));
        Log.i((String)"debuglog", (String)("queryBody:" + this.queryBody));
        this.webView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.webView.setVisibility(4);
        this.webView.getSettings().setSavePassword(false);
        this.webView.getSettings().setSaveFormData(false);
        this.webView.getSettings().setDomStorageEnabled(true);
        this.webView.getSettings().setDatabaseEnabled(true);
        if (Build.VERSION.SDK_INT < 19) {
            String databasePath = this.getContext().getDir("database", 0).getPath();
            this.webView.getSettings().setDatabasePath(databasePath);
        }
        webViewContainer.setPadding(margin, margin, margin, margin);
        webViewContainer.addView((View)this.webView);
        webViewContainer.setBackgroundColor(0xFFFFFF);
        this.contentFrameLayout.addView((View)webViewContainer);
    }

    public static class RequestsDialogBuilder
    extends BuilderBase<RequestsDialogBuilder> {
        private static final String APPREQUESTS_DIALOG = "apprequests";
        private static final String MESSAGE_PARAM = "message";
        private static final String TO_PARAM = "to";
        private static final String DATA_PARAM = "data";
        private static final String TITLE_PARAM = "title";

        public RequestsDialogBuilder(Context context) {
            super(context, APPREQUESTS_DIALOG);
        }

        public RequestsDialogBuilder(Context context, String applicationId, Bundle parameters) {
            super(context, applicationId, APPREQUESTS_DIALOG, parameters);
        }

        public RequestsDialogBuilder setMessage(String message) {
            this.getParameters().putString(MESSAGE_PARAM, message);
            return this;
        }

        public RequestsDialogBuilder setTo(String id2) {
            this.getParameters().putString(TO_PARAM, id2);
            return this;
        }

        public RequestsDialogBuilder setData(String data) {
            this.getParameters().putString(DATA_PARAM, data);
            return this;
        }

        public RequestsDialogBuilder setTitle(String title) {
            this.getParameters().putString(TITLE_PARAM, title);
            return this;
        }
    }

    public static class FeedDialogBuilder
    extends BuilderBase<FeedDialogBuilder> {
        private static final String FEED_DIALOG = "feed";
        private static final String FROM_PARAM = "from";
        private static final String TO_PARAM = "to";
        private static final String LINK_PARAM = "link";
        private static final String PICTURE_PARAM = "picture";
        private static final String SOURCE_PARAM = "source";
        private static final String NAME_PARAM = "name";
        private static final String CAPTION_PARAM = "caption";
        private static final String DESCRIPTION_PARAM = "description";

        public FeedDialogBuilder(Context context) {
            super(context, FEED_DIALOG);
        }

        public FeedDialogBuilder(Context context, Bundle parameters) {
            super(context, FEED_DIALOG, parameters);
        }

        public FeedDialogBuilder(Context context, String applicationId, Bundle parameters) {
            super(context, applicationId, FEED_DIALOG, parameters);
        }

        public FeedDialogBuilder setFrom(String id2) {
            this.getParameters().putString(FROM_PARAM, id2);
            return this;
        }

        public FeedDialogBuilder setTo(String id2) {
            this.getParameters().putString(TO_PARAM, id2);
            return this;
        }

        public FeedDialogBuilder setLink(String link) {
            this.getParameters().putString(LINK_PARAM, link);
            return this;
        }

        public FeedDialogBuilder setPicture(String picture) {
            this.getParameters().putString(PICTURE_PARAM, picture);
            return this;
        }

        public FeedDialogBuilder setSource(String source) {
            this.getParameters().putString(SOURCE_PARAM, source);
            return this;
        }

        public FeedDialogBuilder setName(String name) {
            this.getParameters().putString(NAME_PARAM, name);
            return this;
        }

        public FeedDialogBuilder setCaption(String caption) {
            this.getParameters().putString(CAPTION_PARAM, caption);
            return this;
        }

        public FeedDialogBuilder setDescription(String description) {
            this.getParameters().putString(DESCRIPTION_PARAM, description);
            return this;
        }
    }

    public static class Builder
    extends BuilderBase<Builder> {
        public Builder(Context context, String action) {
            super(context, action);
        }

        public Builder(Context context, String action, Bundle parameters) {
            super(context, action, parameters);
        }

        public Builder(Context context, String applicationId, String action, Bundle parameters) {
            super(context, applicationId, action, parameters);
        }
    }

    private static class BuilderBase<CONCRETE extends BuilderBase<?>> {
        private Context context;
        private String applicationId;
        private String action;
        private int theme = 0x1030010;
        private OnCompleteListener listener;
        private Bundle parameters;

        protected BuilderBase(Context context, String action) {
            this.finishInit(context, action, null);
        }

        protected BuilderBase(Context context, String action, Bundle parameters) {
            this.finishInit(context, action, parameters);
        }

        protected BuilderBase(Context context, String applicationId, String action, Bundle parameters) {
            this.finishInit(context, action, parameters);
        }

        public CONCRETE setTheme(int theme) {
            this.theme = theme;
            BuilderBase result = this;
            return (CONCRETE)result;
        }

        public CONCRETE setOnCompleteListener(OnCompleteListener listener) {
            this.listener = listener;
            BuilderBase result = this;
            return (CONCRETE)result;
        }

        public WebDialog build() {
            return new WebDialog(this.context, this.action, this.parameters, this.theme, this.listener);
        }

        protected String getApplicationId() {
            return this.applicationId;
        }

        protected Context getContext() {
            return this.context;
        }

        protected int getTheme() {
            return this.theme;
        }

        protected Bundle getParameters() {
            return this.parameters;
        }

        protected OnCompleteListener getListener() {
            return this.listener;
        }

        private void finishInit(Context context, String action, Bundle parameters) {
            this.context = context;
            this.action = action;
            this.parameters = parameters != null ? parameters : new Bundle();
        }
    }

    private class DialogWebViewClient
    extends WebViewClient {
        private DialogWebViewClient() {
        }

        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            return super.shouldOverrideUrlLoading(view, url);
        }

        public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
            super.onReceivedError(view, errorCode, description, failingUrl);
            WebDialog.this.sendErrorToListener(null);
        }

        public void onReceivedSslError(WebView view, SslErrorHandler handler, SslError error) {
            super.onReceivedSslError(view, handler, error);
            handler.cancel();
            WebDialog.this.sendErrorToListener(null);
        }

        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            super.onPageStarted(view, url, favicon);
            if (!WebDialog.this.isDetached) {
                WebDialog.this.spinner.show();
            }
            if (url.contains("http://plugin.zaloapp.com/webview/callback")) {
                view.stopLoading();
                Log.i((String)"debuglog", (String)"00000");
                if (WebDialog.this.zFeedCallback != null) {
                    Log.i((String)"debuglog", (String)"11111");
                    Uri u = Uri.parse((String)url);
                    Bundle b = this.parseUrlQueryString(u.getQuery());
                    boolean isSuccess = false;
                    int error_code = 0;
                    String error_msg = "";
                    String strErrorCode = b.getString("error_code");
                    if (!TextUtils.isEmpty((CharSequence)strErrorCode)) {
                        try {
                            error_code = Integer.parseInt(strErrorCode);
                        }
                        catch (Exception ex) {
                            error_code = 0;
                        }
                    }
                    if (error_code == 0) {
                        isSuccess = true;
                    }
                    error_msg = b.getString("error_message");
                    String data = b.getString("result_data");
                    Log.i((String)"debuglog", (String)"222222");
                    WebDialog.this.zFeedCallback.onResult(isSuccess, error_code, error_msg, data);
                }
            }
        }

        public Bundle parseUrlQueryString(String queryString) {
            Bundle params = new Bundle();
            if (!TextUtils.isEmpty((CharSequence)queryString)) {
                String[] array2;
                for (String parameter : array2 = queryString.split("&")) {
                    String[] keyValuePair = parameter.split("=");
                    try {
                        if (keyValuePair.length == 2) {
                            params.putString(URLDecoder.decode(keyValuePair[0], WebDialog.UTF8), URLDecoder.decode(keyValuePair[1], WebDialog.UTF8));
                            continue;
                        }
                        if (keyValuePair.length != 1) continue;
                        params.putString(URLDecoder.decode(keyValuePair[0], WebDialog.UTF8), "");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                }
            }
            return params;
        }

        public void onPageFinished(WebView view, String url) {
            super.onPageFinished(view, url);
            Log.i((String)"debuglog", (String)("---onPageFinished : " + url));
            if (!WebDialog.this.isDetached) {
                WebDialog.this.spinner.dismiss();
            }
            WebDialog.this.contentFrameLayout.setBackgroundColor(0);
            WebDialog.this.webView.setVisibility(0);
            WebDialog.this.crossImageView.setVisibility(0);
        }
    }

    public static interface OnCompleteListener {
        public void onComplete(Bundle var1);
    }
}

