/*
 * Decompiled with CFR 0.152.
 */
package com.zing.zalo.zalosdk.oauth;

import android.content.ActivityNotFoundException;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import com.zing.zalo.zalosdk.R;
import com.zing.zalo.zalosdk.core.helper.Utils;

class Utilities {
    Utilities() {
    }

    static boolean isOnline(Context ctx) {
        if (!Utils.isPermissionGranted((Context)ctx, (String)"android.permission.ACCESS_NETWORK_STATE")) {
            return true;
        }
        ConnectivityManager cm = (ConnectivityManager)ctx.getSystemService("connectivity");
        NetworkInfo netInfo = cm.getActiveNetworkInfo();
        return netInfo != null && netInfo.isConnectedOrConnecting();
    }

    static int getOrientation(Context ctx) {
        return ctx.getResources().getConfiguration().orientation;
    }

    public static void invokeMarketApp(Context context, String packageId) {
        try {
            context.startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)("market://details?id=" + packageId))));
        }
        catch (ActivityNotFoundException anfe) {
            context.startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)("https://play.google.com/store/apps/details?id=" + packageId))));
        }
    }

    public static int getVersionCode(Context oContext, String packageId) {
        try {
            PackageInfo pInfo = oContext.getPackageManager().getPackageInfo(packageId, 0);
            if (pInfo != null) {
                return pInfo.versionCode;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1;
    }

    public static boolean isZaloSupportCallBack(Context context) {
        return Utilities.getVersionCode(context, "com.zing.zalo") > 1100123;
    }

    public static boolean isZaloInstalled(Context context) {
        Intent intent = new Intent("android.intent.action.SEND");
        intent.setComponent(new ComponentName("com.zing.zalo", "com.zing.zalo.ui.TempShareViaActivity"));
        boolean ableCalled = intent.resolveActivityInfo(context.getPackageManager(), 0) != null;
        return ableCalled;
    }

    public static boolean isTablet(Context ctx) {
        return ctx.getResources().getBoolean(R.bool.isTablet);
    }

    public static boolean isPortait(Context context) {
        WindowManager wm = (WindowManager)context.getSystemService("window");
        Display display = wm.getDefaultDisplay();
        DisplayMetrics metrics = new DisplayMetrics();
        display.getMetrics(metrics);
        int width = metrics.widthPixels;
        int height = metrics.heightPixels;
        return height > width;
    }
}

