/*
 * Decompiled with CFR 0.152.
 */
package com.zing.zalo.zalosdk.oauth;

import android.app.Activity;
import android.app.Application;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.AsyncTask;
import android.os.Bundle;
import android.text.TextUtils;
import android.widget.Toast;
import com.zing.zalo.zalosdk.core.helper.AppInfo;
import com.zing.zalo.zalosdk.core.helper.Utils;
import com.zing.zalo.zalosdk.core.http.HttpClientRequest;
import com.zing.zalo.zalosdk.core.log.Log;
import com.zing.zalo.zalosdk.oauth.LocalizedString;
import com.zing.zalo.zalosdk.oauth.LoginChannel;
import com.zing.zalo.zalosdk.oauth.LoginVia;
import com.zing.zalo.zalosdk.oauth.OAuthCompleteListener;
import com.zing.zalo.zalosdk.oauth.OauthResponse;
import com.zing.zalo.zalosdk.oauth.OauthStorage;
import com.zing.zalo.zalosdk.oauth.Permissions;
import com.zing.zalo.zalosdk.oauth.Utilities;
import com.zing.zalo.zalosdk.oauth.ValidateOAuthCodeCallback;
import com.zing.zalo.zalosdk.oauth.WebLoginActivity;
import com.zing.zalo.zalosdk.oauth.ZaloOAuthResultCode;
import com.zing.zalo.zalosdk.oauth.ZaloSDK;
import com.zing.zalo.zalosdk.oauth.ZaloSDKApplication;
import java.lang.ref.WeakReference;
import org.json.JSONException;
import org.json.JSONObject;

class Authenticator {
    private WeakReference<OAuthCompleteListener> wListener;
    private WeakReference<OAuthCompleteListener> wLoginFormListener;
    static boolean isGetZaloOAuth = false;
    private boolean bIsZaloLoginSuccessful = false;
    private boolean bIsZaloOutOfDate = false;
    private boolean zaloPluginLogin = false;
    private String nameActivtyAuthenticate = "";
    private CallBackLifeCycle callbackAppLifeCycle;
    private boolean isRegisBroadcastReceiver = false;
    public String nameActivtyCheckAuthen = "";
    public BroadcastReceiver receiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if ("com.zing.zalo.action.ZALO_LOGIN_SUCCESSFUL_FOR_AUTHORIZATION_APP".equals(intent.getAction())) {
                Authenticator.this.bIsZaloLoginSuccessful = intent.getBooleanExtra("loginSuccessful", false);
            }
        }
    };
    private OauthStorage mStorage;
    private LocalizedString mLocalizedString;
    protected Context mContext;

    Authenticator(Context ctx, OauthStorage storage, LocalizedString localizedString) {
        this.mContext = ctx;
        this.mStorage = storage;
        this.mLocalizedString = localizedString;
    }

    public OAuthCompleteListener getOAuthCompleteListener() {
        if (this.wListener != null && this.wListener.get() != null) {
            return (OAuthCompleteListener)this.wListener.get();
        }
        return new OAuthCompleteListener();
    }

    public void setOAuthCompleteListener(OAuthCompleteListener listener) {
        this.wListener = new WeakReference<OAuthCompleteListener>(listener);
    }

    protected OAuthCompleteListener getLoginFormOAuthCompleteListener() {
        if (this.wLoginFormListener != null && this.wLoginFormListener.get() != null) {
            return (OAuthCompleteListener)this.wLoginFormListener.get();
        }
        return new OAuthCompleteListener();
    }

    protected void setLoginFormOAuthCompleteListener(OAuthCompleteListener listener) {
        this.wLoginFormListener = new WeakReference<OAuthCompleteListener>(listener);
    }

    void authenticate(Activity activity, LoginVia loginVia, boolean zaloPluginLogin, OAuthCompleteListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("OAuthCompleteListener must be set.");
        }
        this.nameActivtyAuthenticate = activity.getClass().getSimpleName();
        this.nameActivtyCheckAuthen = activity.getClass().getSimpleName();
        this.setOAuthCompleteListener(listener);
        this.zaloPluginLogin = zaloPluginLogin;
        this.sendOAuthRequest(activity, loginVia);
    }

    void registerZalo(Activity activity, OAuthCompleteListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("OAuthCompleteListener must be set.");
        }
        Intent intent = WebLoginActivity.newIntent((Context)activity, true);
        activity.startActivityForResult(intent, 64725);
    }

    private void sendOAuthRequest(Activity activity, LoginVia loginVia) {
        boolean needLoginViaWeb;
        boolean bl = needLoginViaWeb = loginVia != LoginVia.APP && loginVia != LoginVia.APP_OR_WEB;
        if (!needLoginViaWeb) {
            if (AppInfo.isPackageExists((Context)activity, (String)"com.zing.zalo")) {
                try {
                    isGetZaloOAuth = true;
                    try {
                        this.isRegisBroadcastReceiver = false;
                        activity.unregisterReceiver(this.receiver);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.isRegisBroadcastReceiver = true;
                    IntentFilter intentFilter = new IntentFilter("com.zing.zalo.action.ZALO_LOGIN_SUCCESSFUL_FOR_AUTHORIZATION_APP");
                    activity.registerReceiver(this.receiver, intentFilter);
                    Intent i = new Intent("com.zing.zalo.intent.action.THIRD_PARTY_APP_AUTHORIZATION");
                    i.putExtra("android.intent.extra.UID", ZaloSDKApplication.appID);
                    activity.startActivityForResult(i, 64725);
                }
                catch (ActivityNotFoundException ex) {
                    isGetZaloOAuth = false;
                    this.bIsZaloOutOfDate = true;
                    this.getOAuthCompleteListener().onZaloOutOfDate((Context)activity);
                }
                catch (SecurityException ex) {
                    isGetZaloOAuth = false;
                    this.bIsZaloOutOfDate = true;
                    this.getOAuthCompleteListener().onZaloOutOfDate((Context)activity);
                }
            } else if (loginVia == LoginVia.APP) {
                isGetZaloOAuth = false;
                this.getOAuthCompleteListener().onZaloNotInstalled((Context)activity);
            } else {
                needLoginViaWeb = true;
            }
        }
        if (needLoginViaWeb) {
            if (Utilities.isOnline((Context)activity)) {
                Intent intent = WebLoginActivity.newIntent((Context)activity, false);
                activity.startActivityForResult(intent, 64725);
            } else {
                Toast.makeText((Context)activity, (CharSequence)this.mLocalizedString.getNoNetworkMessage(), (int)0).show();
            }
        }
    }

    protected void unauthenticate() {
        try {
            UnauthenticateTask task = new UnauthenticateTask();
            task.oauthCode = this.mStorage.getOAuthCode();
            if (!TextUtils.isEmpty((CharSequence)task.oauthCode)) {
                task.execute(null);
            }
            long uid = ZaloSDK.Instance.getZaloId();
            this.mContext.getSharedPreferences("zacPref", 0).edit().remove("MAX_PAGING" + uid).remove("GIFTCODE_EXPIRED_TIME" + uid).remove("CACHE_CODE_LIST" + uid).remove("CURRENT_PAGE" + uid).commit();
            this.mStorage.setAccessToken("");
            this.mStorage.setOAuthCode("", "");
            this.mStorage.setZaloId(0L);
            this.mStorage.setZaloDisplayName("");
            this.mStorage.setZaloPluginOAuthCode("");
            this.mStorage.setSocialId("");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    boolean isAuthenticate(String code, ValidateOAuthCodeCallback callback) {
        if (code == null || code.length() == 0) {
            if (callback != null) {
                callback.onValidateComplete(false, -1019, -1L, null);
            }
            return false;
        }
        if (callback != null) {
            ValidateOAuthCodeTask task = new ValidateOAuthCodeTask(code, callback);
            task.execute(new Void[0]);
        }
        return true;
    }

    protected boolean onActivityResult(Activity activity, int requestCode, int resultCode, Intent data) {
        Context ctx = activity.getApplicationContext();
        if (requestCode == 64725) {
            this.receiveOAuthData(activity, data);
            return true;
        }
        if (requestCode == 64726) {
            this.receivePermissionData(activity, data);
            return true;
        }
        return false;
    }

    void receiveOAuthData(Activity activity, Intent data) {
        isGetZaloOAuth = false;
        try {
            this.isRegisBroadcastReceiver = false;
            activity.unregisterReceiver(this.receiver);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.bIsZaloOutOfDate) {
            return;
        }
        this.mStorage.setAccessToken("");
        if (data == null) {
            this.getOAuthCompleteListener().onAuthenError(-1111, "");
            return;
        }
        int error = data.getIntExtra("error", 0);
        if (error == 203) {
            this.getOAuthCompleteListener().onAuthenError(-1118, "Kh\u00f4ng th\u1ec3 \u0111\u0103ng nh\u1eadp Zalo.");
        } else if (error == 0) {
            long id2 = data.getLongExtra("uid", 0L);
            String oauth = data.getStringExtra("code");
            boolean isRegister = data.getBooleanExtra("isRegister", false);
            if (this.zaloPluginLogin) {
                this.mStorage.setZaloPluginOAuthCode(oauth);
                this.mStorage.setZaloPluginUserId(id2);
            }
            if (this.zaloPluginLogin && TextUtils.isEmpty((CharSequence)this.mStorage.getOAuthCode()) || !this.zaloPluginLogin) {
                this.mStorage.setOAuthCode(LoginChannel.ZALO.toString(), oauth);
                this.mStorage.setZaloId(id2);
                try {
                    String jsData = data.getStringExtra("data");
                    JSONObject exData = new JSONObject(jsData).getJSONObject("data");
                    String displayname = exData.getString("display_name");
                    int zprotect = exData.optInt("zprotect");
                    this.mStorage.setIsProtected(zprotect);
                    this.mStorage.setZaloDisplayName(displayname);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            OauthResponse resp = new OauthResponse(id2, oauth, LoginChannel.ZALO);
            resp.setRegister(isRegister);
            this.getOAuthCompleteListener().onGetOAuthComplete(resp);
        } else if (error == 4) {
            if (this.bIsZaloLoginSuccessful) {
                this.authenticate(activity, LoginVia.APP, this.zaloPluginLogin, this.getOAuthCompleteListener());
            } else {
                this.getOAuthCompleteListener().onAuthenError(-1111, "");
            }
        } else {
            int e = ZaloOAuthResultCode.findById(error);
            String errorMsg = "Kh\u00f4ng th\u1ec3 \u0111\u0103ng nh\u1eadp Zalo.";
            try {
                JSONObject exData;
                String msg;
                String jsData = data.getStringExtra("data");
                if (!TextUtils.isEmpty((CharSequence)jsData) && (msg = (exData = new JSONObject(jsData)).getString("errorMsg")) != null && msg.length() > 0) {
                    errorMsg = msg;
                }
            }
            catch (Exception ex) {
                Log.v((String)"zalo return empty message");
            }
            this.getOAuthCompleteListener().onAuthenError(e, errorMsg);
        }
    }

    private boolean checkZaloVersionSupport(Context ctx, int versionCode) {
        try {
            PackageInfo manager = ctx.getPackageManager().getPackageInfo("com.zing.zalo", 0);
            if (manager.versionCode < versionCode) {
                isGetZaloOAuth = false;
                this.bIsZaloOutOfDate = true;
                this.getOAuthCompleteListener().onZaloOutOfDate(ctx);
                return false;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            isGetZaloOAuth = false;
            this.bIsZaloOutOfDate = true;
            this.getOAuthCompleteListener().onZaloOutOfDate(ctx);
            return false;
        }
        return true;
    }

    void requestPermissions(Activity activity, Enum<Permissions> permission2, OAuthCompleteListener listener) {
        if (!this.checkZaloVersionSupport((Context)activity, 90)) {
            return;
        }
        if (listener == null) {
            throw new IllegalArgumentException("OAuthCompleteListener must be set.");
        }
        this.setOAuthCompleteListener(listener);
        Context ctx = activity.getApplicationContext();
        Intent i = new Intent("com.zing.zalo.intent.action.THIRD_PARTY_REQ_PERM");
        i.putExtra("app_id", ZaloSDK.Instance.getAppID() + "");
        i.putExtra("oauth", ZaloSDK.Instance.getOAuthCode());
        i.putExtra("pkg_name", AppInfo.getPackageName((Context)ctx));
        i.putExtra("sign_key", AppInfo.getApplicationHashKey((Context)ctx));
        i.putExtra("sdk_version", ZaloSDK.Instance.getVersion());
        i.putExtra("permission", permission2.toString());
        activity.startActivityForResult(i, 64726);
    }

    void receivePermissionData(Activity activity, Intent data) {
        if (data != null) {
            int error = data.getIntExtra("error", 0);
            int e = ZaloOAuthResultCode.findById(error);
            this.getOAuthCompleteListener().onGetPermissionData(e);
        } else {
            this.getOAuthCompleteListener().onGetPermissionData(-1111);
        }
    }

    protected String getActivityNameAuthenticate() {
        return this.nameActivtyAuthenticate;
    }

    public void unregisterBroadcastReceiver(Activity activity) {
        try {
            if (this.isRegisBroadcastReceiver) {
                activity.unregisterReceiver(this.receiver);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void registerAppLifeCycle(Application application) {
        if (!Utils.belowSandwich() && this.callbackAppLifeCycle == null) {
            this.callbackAppLifeCycle = new CallBackLifeCycle();
            application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.callbackAppLifeCycle);
        }
    }

    public void unregisterAppLifeCycle(Application application) {
        if (!Utils.belowSandwich() && this.callbackAppLifeCycle != null) {
            try {
                application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.callbackAppLifeCycle);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public OauthStorage getStorage() {
        return this.mStorage;
    }

    public void resetListener() {
        this.wListener = null;
    }

    class CallBackLifeCycle
    implements Application.ActivityLifecycleCallbacks {
        CallBackLifeCycle() {
        }

        public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        }

        public void onActivityStarted(Activity activity) {
        }

        public void onActivityResumed(Activity activity) {
        }

        public void onActivityPaused(Activity activity) {
        }

        public void onActivityStopped(Activity activity) {
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
        }

        public void onActivityDestroyed(Activity activity) {
            String nameActivity = activity.getClass().getSimpleName();
            if (Authenticator.this.nameActivtyAuthenticate != null && Authenticator.this.nameActivtyAuthenticate.length() > 0 && Authenticator.this.nameActivtyAuthenticate.equals(nameActivity)) {
                Log.i((String)"debuglog", (String)"unregister--------------------------------");
                Authenticator.this.unregisterBroadcastReceiver(activity);
            }
            if (Authenticator.this.nameActivtyCheckAuthen == null || Authenticator.this.nameActivtyCheckAuthen.length() <= 0 || Authenticator.this.nameActivtyCheckAuthen.equals(nameActivity)) {
                // empty if block
            }
        }
    }

    private class UnauthenticateTask
    extends AsyncTask<Void, Void, String> {
        String oauthCode;

        private UnauthenticateTask() {
        }

        protected String doInBackground(Void ... arg0) {
            HttpClientRequest request = new HttpClientRequest(HttpClientRequest.Type.POST, "https://oauth.zaloapp.com/v2/zalo/oauth_logout");
            request.addParams("appId", String.valueOf(ZaloSDKApplication.appID));
            request.addParams("oauthCode", this.oauthCode);
            request.addParams("frm", "sdk");
            JSONObject dataJsonObject = new JSONObject();
            try {
                dataJsonObject.put("pl", (Object)"android");
                dataJsonObject.put("sdkv", (Object)ZaloSDK.Instance.getVersion());
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            request.addParams("data", dataJsonObject.toString());
            return request.getText();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected void onPostExecute(String result) {
            super.onPostExecute((Object)result);
            try {
                JSONObject object = new JSONObject(result);
                int errorCode = object.getInt("error");
                if (errorCode != 0) return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class ValidateOAuthCodeTask
    extends AsyncTask<Void, Void, String> {
        ValidateOAuthCodeCallback callback;
        String code;

        ValidateOAuthCodeTask(String code, ValidateOAuthCodeCallback callback) {
            if (callback == null) {
                throw new IllegalArgumentException("callback can't be null");
            }
            this.callback = callback;
            this.code = code;
        }

        protected String doInBackground(Void ... arg0) {
            HttpClientRequest request = new HttpClientRequest(HttpClientRequest.Type.POST, "https://oauth.zaloapp.com/v2/mobile/validate_oauth_code");
            request.addParams("app_id", String.valueOf(ZaloSDKApplication.appID));
            request.addParams("code", this.code);
            request.addParams("version", ZaloSDK.Instance.getVersion());
            request.addParams("frm", "sdk");
            return request.getText();
        }

        protected void onPostExecute(String result) {
            super.onPostExecute((Object)result);
            try {
                JSONObject object = new JSONObject(result);
                int errorCode = object.getInt("error");
                if (errorCode == 0) {
                    JSONObject data = object.getJSONObject("data");
                    long id = data.getLong("uid");
                    if (id == Authenticator.this.mStorage.getZaloId()) {
                        int zcert = data.optInt("zcert");
                        int zprotect = data.optInt("zprotect");
                        Authenticator.this.mStorage.setIsGuestCertificated(zcert);
                        Authenticator.this.mStorage.setIsProtected(zprotect);
                    }
                    this.callback.onValidateComplete(true, 0, id, this.code);
                } else {
                    this.callback.onValidateComplete(false, errorCode, -1L, null);
                }
            }
            catch (Exception ex) {
                this.callback.onValidateComplete(false, -1000, -1L, null);
            }
        }
    }
}

