package com.mobgame.model;

import android.util.Log;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;


public class ZaloResponse {
    @SerializedName("result")
    private Result result;

    public static ZaloResponse parse(String json) {
        Gson gson = new GsonBuilder().create();
        ZaloResponse response = gson.fromJson(json.trim(), ZaloResponse.class);
        return response;
    }
    public Result getResult() {
        return result;
    }

    public void setResult(Result result) {
        this.result = result;
    }

    public class Result{
        @SerializedName("maccess_token")
        private String maccessToken;
        @SerializedName("token_expire")
        private String tokenExpire;
        @SerializedName("User")
        private Users users;

        public String getMaccessToken() {
            return maccessToken;
        }

        public void setMaccessToken(String maccessToken) {
            this.maccessToken = maccessToken;
        }

        public String getTokenExpire() {
            return tokenExpire;
        }

        public void setTokenExpire(String tokenExpire) {
            this.tokenExpire = tokenExpire;
        }

        public Users getUsers() {
            return users;
        }

        public void setUsers(Users users) {
            this.users = users;
        }
    }

    public class Users{
        @SerializedName("email")
        private String email;
        @SerializedName("name")
        private String name ;
        @SerializedName("role")
        private String role;
        @SerializedName("username")
        private String userName;

        public String getEmail() {
            return email;
        }

        public void setEmail(String email) {
            this.email = email;
        }

        public String getName() {
            return name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getRole() {
            return role;
        }

        public void setRole(String role) {
            this.role = role;
        }

        public String getUserName() {
            return userName;
        }

        public void setUserName(String userName) {
            this.userName = userName;
        }
    }

    public String getData(){
        Gson gson = new GsonBuilder().serializeNulls().create();
        String str = gson.toJson(result);
        Log.d("TAG" ,  "response str : " + str);
        return str;
    }
}
