package com.mobgame.model;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;

public class Game {

	@SerializedName("title")
	private String title;
	@SerializedName("appstore_link")
	private String appstoreLink;

	@SerializedName("paypal")
	private PaypalConfig paypal;

	@SerializedName("fb_appid")
	private String facebookId;

	@SerializedName("language_default")
	private String lang;

	@SerializedName("google")
	private GoogleIABConfig googleIAB;

	@SerializedName("ads")
	private AdsConfig adsConfig;

	@SerializedName("i_s")
	private boolean sShowHello;

	@SerializedName("p_m")
	private PayForm payForm;

	@SerializedName("zalo_app_id")
	private String zaloAppId;

	@SerializedName("logout_bt")
	private LogoutBt logoutBt;

	public LogoutBt getLogoutBt() {
		return logoutBt;
	}

	public void setLogoutBt(LogoutBt logoutBt) {
		this.logoutBt = logoutBt;
	}

	public String getZaloAppId() {
		return zaloAppId;
	}

	public void setZaloAppId(String zaloAppId) {
		this.zaloAppId = zaloAppId;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public String getAppstoreLink() {
		return appstoreLink;
	}

	public void setAppstoreLink(String appstoreLink) {
		this.appstoreLink = appstoreLink;
	}

	public boolean issShowHello() {
		return sShowHello;
	}

	public void setsShowHello(boolean sShowHello) {
		this.sShowHello = sShowHello;
	}

	public PayForm getPayForm() {
		return payForm;
	}

	public void setPayForm(PayForm payForm) {
		this.payForm = payForm;
	}

	public static Game parse(String json) {
		Gson gson = new GsonBuilder().create();
		Game game = gson.fromJson(json.trim(), Game.class);
		return game;
	}

	public String getFacebookId() {
		return facebookId;
	}

	public void setFacebookId(String facebookId) {
		this.facebookId = facebookId;
	}

	public PaypalConfig getPaypal() {
		return paypal;
	}

	public void setPaypal(PaypalConfig paypal) {
		this.paypal = paypal;
	}

	public GoogleIABConfig getGoogleIAB() {
		return googleIAB;
	}

	public void setGoogleIAB(GoogleIABConfig googleIAB) {
		this.googleIAB = googleIAB;
	}

	public String getLang() {
		return lang;
	}

	public void setLang(String lang) {
		this.lang = lang;
	}
	
	public AdsConfig getAdsConfig() {
		return adsConfig;
	}

	public void setAdsConfig(AdsConfig adsApiKey) {
		this.adsConfig = adsApiKey;
	}

	public class GoogleIABConfig {
		
		@SerializedName("hashkey")
		private String hashkey;
		@SerializedName("client_id")
		private String clientId;

		public String getClientId() {
			return clientId;
		}

		public void setClientId(String clientId) {
			this.clientId = clientId;
		}

		public String getHashkey() {
			return hashkey;
		}

		public void setHashkey(String hashkey) {
			this.hashkey = hashkey;
		}
		
	}
	public class LogoutBt{
		@SerializedName("url")
		private String urlBeforeLogout;
		@SerializedName("flag")
		private boolean flag;
		@SerializedName("image")
		private String urlBannerImage;
		@SerializedName("fp_id")
		private String idFanpage;

		public String getUrlBeforeLogout() {
			return urlBeforeLogout;
		}

		public void setUrlBeforeLogout(String urlBeforeLogout) {
			this.urlBeforeLogout = urlBeforeLogout;
		}

		public boolean isFlag() {
			return flag;
		}

		public void setFlag(boolean flag) {
			this.flag = flag;
		}

		public String getIdFanpage() {
			return idFanpage;
		}

		public void setIdFanpage(String idFanpage) {
			this.idFanpage = idFanpage;
		}

		public String getUrlBannerImage() {
			return urlBannerImage;
		}

		public void setUrlBannerImage(String urlBannerImage) {
			this.urlBannerImage = urlBannerImage;
		}
	}
	public class PayForm{
		@SerializedName("p_d")
		private PaymentDesign paymentDesign;
		@SerializedName("b_g")
		private String backGround;

		public PaymentDesign getPaymentDesign() {
			return paymentDesign;
		}

		public void setPaymentDesign(PaymentDesign paymentDesign) {
			this.paymentDesign = paymentDesign;
		}

		public String getBackGround() {
			return backGround;
		}

		public void setBackGround(String backGround) {
			this.backGround = backGround;
		}
	}
	public class PaymentDesign{
		@SerializedName("scroll")
		private String scroll;
		@SerializedName("row")
		private String row;
		@SerializedName("col")
		private String col;

		public String getScroll() {
			return scroll;
		}

		public void setScroll(String scroll) {
			this.scroll = scroll;
		}

		public String getRow() {
			return row;
		}

		public void setRow(String row) {
			this.row = row;
		}

		public String getCol() {
			return col;
		}

		public void setCol(String col) {
			this.col = col;
		}
	}
	public class AppsFlyerConfig {

		@SerializedName("appsflyer_dev_key")
		private String devKey;
		
		@SerializedName("is_use_http")
		private boolean isUseHttp;
		
		@SerializedName("currency")
		private String currency;

		public String getDevKey() {
			return devKey;
		}

		public void setDevKey(String devKey) {
			this.devKey = devKey;
		}

		public boolean isUseHttp() {
			return isUseHttp;
		}

		public void setUseHttp(boolean isUseHttp) {
			this.isUseHttp = isUseHttp;
		}

		public String getCurrency() {
			return currency;
		}

		public void setCurrency(String currency) {
			this.currency = currency;
		}

	}
	
	public class AdwordsConfig {
		
		@SerializedName("conversion_id")
		private String conversionId;

		public String getConversionId() {
			return conversionId;
		}

		public void setConversionId(String conversionId) {
			this.conversionId = conversionId;
		}
		
	}
	
	public class AdsConfig {
		
		@SerializedName("api_key")
		private String apiKey;

		public String getApiKey() {
			return apiKey;
		}

		public void setApiKey(String apiKey) {
			this.apiKey = apiKey;
		}
		
	}
	
	public class PaypalConfig {
		
		@SerializedName("client_id_production")
		private String clientId;

		@SerializedName("privacy_url")
		private String privacyUrl;
		
		@SerializedName("user_agreement_url")
		private String userAgreementUrl;
		
		@SerializedName("accept_credit_cards")
		private boolean acceptCreditCard;
		
		@SerializedName("client_id_sandbox")
		private String clientIdSnadbox;
		
		@SerializedName("merchant_name")
		private String merchantName;

		public String getClientId() {
			return clientId;
		}

		public void setClientId(String clientId) {
			this.clientId = clientId;
		}

		public String getPrivacyUrl() {
			return privacyUrl;
		}

		public void setPrivacyUrl(String privacyUrl) {
			this.privacyUrl = privacyUrl;
		}

		public String getUserAgreementUrl() {
			return userAgreementUrl;
		}

		public void setUserAgreementUrl(String userAgreementUrl) {
			this.userAgreementUrl = userAgreementUrl;
		}

		public boolean isAcceptCreditCard() {
			return acceptCreditCard;
		}

		public void setAcceptCreditCard(boolean acceptCreditCard) {
			this.acceptCreditCard = acceptCreditCard;
		}

		public String getClientIdSnadbox() {
			return clientIdSnadbox;
		}

		public void setClientIdSnadbox(String clientIdSnadbox) {
			this.clientIdSnadbox = clientIdSnadbox;
		}

		public String getMerchantName() {
			return merchantName;
		}

		public void setMerchantName(String merchantName) {
			this.merchantName = merchantName;
		}
		
	}
	
}
