package com.mobgame.js;

import android.Manifest;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.graphics.PixelFormat;
import android.net.Uri;
import android.os.Bundle;
import android.support.v4.content.LocalBroadcastManager;
import android.text.Html;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.animation.AnimationUtils;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.Toast;

import com.facebook.share.widget.GameRequestDialog.Result;
import com.google.firebase.analytics.FirebaseAnalytics;
import com.mobgame.MobGameHelper;
import com.mobgame.MobGameSDK;
import com.mobgame.R;
import com.mobgame.api.PostTask;
import com.mobgame.api.UploadListBitmapTask;
import com.mobgame.component.FacebookManager;
import com.mobgame.component.FacebookManager.InviteGameCallback;
import com.mobgame.component.FacebookManager.InviteGameContent;
import com.mobgame.component.GameConfigManager;
import com.mobgame.gui.MobGameImageGaleryActivity;
import com.mobgame.gui.MobGameWebFragment;
import com.mobgame.gui.dialog.MobGameDashboardDialog;
import com.mobgame.gui.dialog.MobGameDialogWebviewFragment;
import com.mobgame.model.ListGiftCode;
import com.mobgame.utils.Constants;
import com.mobgame.utils.DeviceUtils;
import com.mobgame.utils.PermissionUtils;
import com.mobgame.utils.Res;
import com.mobgame.utils.Utils;
import com.zing.zalo.zalosdk.oauth.FeedData;
import com.zing.zalo.zalosdk.oauth.OpenAPIService;
import com.zing.zalo.zalosdk.oauth.ZaloPluginCallback;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map.Entry;

public final class CmdDashboard {

    private static final String TAG = CmdDashboard.class.getSimpleName();
    private static CmdDashboard INSTANCE;
    private static View giftCodeView;
    private static View giftCodeViewAll;
    private WindowManager windowManager;
    private ViewGroup rootView;
    private boolean isNullGiftcode = true;
    private FirebaseAnalytics mFirebaseAnalytics;

    private CmdDashboard() {
    }

    public static CmdDashboard getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CmdDashboard();
        }
        return INSTANCE;
    }

    public void handleResult(Activity activity, int requestCode,
                             int resultCode, Intent data) {
        try {
            switch (requestCode) {
                case Constants.REQUEST_CODE_PICKER:
                    if(data.getStringExtra("data")!=null){
                        String[] imagesPath = data.getStringExtra("data").split("\\|");
                        for (int i=0;i<imagesPath.length;i++){
                            Log.d(TAG, "handleResult: "+imagesPath[i]);
                            handleIssuePhoto(activity, imagesPath[i]);
                        }
                    }
                    break;

            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    private void handleIssuePhoto(Activity activity, String imagePath){
        try{
            Bitmap bitmap = getCompressedBitmapFromPath(activity, imagePath);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            bitmap.compress(Bitmap.CompressFormat.JPEG, 70,
                    byteArrayOutputStream);
            byte[] byteArray = byteArrayOutputStream.toByteArray();
            String encoded = Base64.encodeToString(byteArray, Base64.DEFAULT);
            String key = "img" + Calendar.getInstance().getTimeInMillis();
            String jsFunction = String.format("getImageData('%s', '%s');",
                    encoded, key);
            Log.d(TAG, "js function: " + jsFunction);
            webFragment.invokeJavascript(jsFunction);
            if (issuePhotos == null) {
                issuePhotos = new HashMap<String, Bitmap>();
            }
            issuePhotos.put(key, bitmap);
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    private Bitmap getCompressedBitmapFromPath(Activity activity, String imagePath) {
        Bitmap bitmap = null;
        try {
            BitmapFactory.Options o = new BitmapFactory.Options();
            o.inJustDecodeBounds = true;
            o.inSampleSize = 6;
            BitmapFactory.decodeFile(imagePath, o);
            final int REQUIRED_SIZE = 75;
            int scale = 1;
            while (o.outWidth / scale / 2 >= REQUIRED_SIZE
                    && o.outHeight / scale / 2 >= REQUIRED_SIZE) {
                scale *= 2;
            }
            BitmapFactory.Options o2 = new BitmapFactory.Options();
            o2.inSampleSize = scale;
            bitmap = BitmapFactory.decodeFile(imagePath, o2);
        } catch (Exception e) {
            e.printStackTrace();
            bitmap = Bitmap.createBitmap(100, 100, Bitmap.Config.ARGB_8888);
            bitmap.eraseColor(Color.WHITE);
        }

        return bitmap;
    }

    void mobOpenContact(Activity activity, String params) {
        Log.i(TAG, "mobOpenContact:" + params);
        try {
            JSONObject obj = new JSONObject(params);
            String support_email = obj.getString("support_email");
            Intent intent = new Intent(Intent.ACTION_VIEW, Uri.parse("mailto:"
                    + support_email));
            activity.startActivity(intent);
        } catch (Exception e) {
            Toast.makeText(activity,
                    Res.string(activity, R.string.something_went_wrong),
                    Toast.LENGTH_LONG).show();
        }
    }

    void mobSendSMS(Activity activity, String params) {
        Log.i(TAG, "mobSendSMS:" + params);
        try {
            JSONObject obj = new JSONObject(params);
            String body = obj.getString("body");
            Intent smsVIntent = new Intent(Intent.ACTION_VIEW);
            // prompts only sms-mms clients
            smsVIntent.setType("vnd.android-dir/mms-sms");
            // extra fields for number and message respectively
            smsVIntent.putExtra("sms_body", body);
            activity.startActivity(smsVIntent);
        } catch (Exception e) {
            Toast.makeText(activity,
                    Res.string(activity, R.string.something_went_wrong),
                    Toast.LENGTH_LONG).show();
        }
    }

    public void mobSendEmail(Activity activity, String params) {
        Log.i(TAG, "mobSendEmail:" + params);
        try {
            JSONObject obj = new JSONObject(params);
            String subject = obj.getString("subject");
            String body = obj.getString("body");
            Intent email = new Intent(Intent.ACTION_SEND, Uri.parse("mailto:"));
            email.setType("text/plain");
            email.putExtra(Intent.EXTRA_EMAIL, "");
            email.putExtra(Intent.EXTRA_SUBJECT, subject);
            email.putExtra(Intent.EXTRA_TEXT, Html.fromHtml(body));
            activity.startActivity(Intent.createChooser(email,
                    "Choose an email client from..."));
        } catch (Exception e) {
            Toast.makeText(activity,
                    Res.string(activity, R.string.something_went_wrong),
                    Toast.LENGTH_LONG).show();
        }
    }

    void mobAppInvite(Activity activity, String params) {
        Log.i(TAG, "mobAppInvite:" + params);
        try {

            JSONObject obj = new JSONObject(params);
            String callbackUrl = null;

            if (obj.has("callbackUrl")) {
                callbackUrl = obj.getString("callbackUrl");
            }

            final Activity a = activity;
            final String url = callbackUrl;

            FacebookManager.InviteContent content = new FacebookManager.InviteContent();
            if (obj.has("applinkurl")) {
                content.setApplinkUrl(obj.getString("applinkurl"));
            }
            if (obj.has("previewimageurl")) {
                content.setPreviewImageUrl(obj.getString("previewimageurl"));
            }

            FacebookManager.getInstance().invite(activity, content,
                    new FacebookManager.InviteCallback() {

                        @Override
                        public void onSuccess(Bundle data) {
                            if (!TextUtils.isEmpty(url)) {
                                new PostTask(url, null, false,
                                        new PostTask.Callback() {

                                            @Override
                                            public void onSuccess(
                                                    final String response) {

                                                Intent intent = new Intent(
                                                        Constants.INTENT_FILTER);
                                                intent.putExtra("category",
                                                        "reload");
                                                LocalBroadcastManager
                                                        .getInstance(a)
                                                        .sendBroadcast(intent);
                                            }

                                            @Override
                                            public void onFailure(Throwable e) {
                                            }
                                        }).execute();
                            }
                        }

                        @Override
                        public void onError(Throwable t) {
                            Toast.makeText(
                                    a,
                                    Res.string(a, R.string.something_went_wrong),
                                    Toast.LENGTH_LONG).show();
                        }

                        @Override
                        public void onCancel() {

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
            Toast.makeText(activity,
                    Res.string(activity, R.string.something_went_wrong),
                    Toast.LENGTH_LONG).show();
        }
    }

    void mobAppShare(Activity activity, String params) {
        Log.i(TAG, "mobAppShare:" + params);
        try {

            JSONObject obj = new JSONObject(params);
            String callbackUrl = null;
            boolean isSocial = false;
            if (obj.has("callbackUrl")) {
                callbackUrl = obj.getString("callbackUrl");
            }
            if (obj.has("isSocial")) {
                isSocial = obj.getBoolean("isSocial");
            }
            final Activity a = activity;
            final String url = callbackUrl;

            FacebookManager.ShareContent shareContent = new FacebookManager.ShareContent();
            if (obj.has("url")) {
                shareContent.setContentUrl(obj.getString("url"));
            }
            if (obj.has("content_title")) {
                shareContent.setContentTitle(obj.getString("content_title"));
            }
            if (obj.has("content")) {
                shareContent.setContentDescription(obj.getString("content"));
            }
            final boolean hasSocial = isSocial;
            FacebookManager.getInstance().shareLink(activity, shareContent,
                    new FacebookManager.ShareCallback() {

                        @Override
                        public void onSuccess(String postId) {
                            if (!TextUtils.isEmpty(url)) {
                                new PostTask(url, null, false,
                                        new PostTask.Callback() {

                                            @Override
                                            public void onSuccess(
                                                    final String response) {
                                                if (!hasSocial) {
                                                    Intent intent = new Intent(
                                                            Constants.INTENT_FILTER);
                                                    intent.putExtra("category",
                                                            "reload");
                                                    LocalBroadcastManager
                                                            .getInstance(a)
                                                            .sendBroadcast(intent);
                                                }
                                            }

                                            @Override
                                            public void onFailure(Throwable e) {
                                            }
                                        }).execute();
                            }
                        }

                        @Override
                        public void onError(Throwable t) {
                            Toast.makeText(
                                    a,
                                    Res.string(a, R.string.something_went_wrong),
                                    Toast.LENGTH_LONG).show();
                        }

                        @Override
                        public void onCancel() {
                            Toast.makeText(a, "Cancel", Toast.LENGTH_SHORT).show();
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
            Toast.makeText(activity,
                    Res.string(activity, R.string.something_went_wrong),
                    Toast.LENGTH_LONG).show();
        }
    }

    public void mobOpenBrowser(Activity activity, String params) {
        Log.i(TAG, "mobOpenBrowser:" + params);
        try {
            JSONObject obj = new JSONObject(params);
            String url = obj.getString("url");
            mobOpenBrowser(activity, Uri.parse(url));
        } catch (Exception e) {
            Toast.makeText(activity,
                    Res.string(activity, R.string.something_went_wrong),
                    Toast.LENGTH_LONG).show();
        }
    }

    public void mobOpenDialogWebView(Activity activity, String params) {
        Log.i(TAG, "mobOpenDialogWebView:" + params);
        try {
            JSONObject obj = new JSONObject(params);
            String url = obj.getString("link");
            String title = obj.getString("title");
            //thu show dialog webview
            MobGameDialogWebviewFragment dialogWebviewFragment = new MobGameDialogWebviewFragment(activity, title, url);
            dialogWebviewFragment.show(activity.getFragmentManager(), "dialog webview");
            //hide FloatButton
            MobGameHelper.hideFloatButton();

            //Hide process bar
            Intent intent = new Intent(Constants.INTENT_FILTER);
            intent.putExtra(MobGameDashboardDialog.CLOSE_PROGRESS_BAR, true);
            LocalBroadcastManager.getInstance(activity).sendBroadcast(intent);
        } catch (Exception e) {
            Toast.makeText(activity,
                    Res.string(activity, R.string.something_went_wrong),
                    Toast.LENGTH_LONG).show();
        }
    }

    private void mobOpenBrowser(Activity activity, Uri uri) {
        Log.i(TAG, "mobOpenBrowser:" + uri);
        try {
            Intent intent = new Intent(Intent.ACTION_VIEW, uri);
            activity.startActivity(intent);
        } catch (Exception e) {
            Toast.makeText(activity,
                    Res.string(activity, R.string.something_went_wrong),
                    Toast.LENGTH_LONG).show();
        }
    }

    public void mobOpenFBFanpage(Activity activity, String params) {
        Log.i(TAG, "mobOpenFanPage:" + params);
        try {
            JSONObject obj = new JSONObject(params);
            String pageid = obj.getString("pageid");
            String callbackUrl = null;
            boolean isSocial = false;
            if (obj.has("callbackUrl")) {
                callbackUrl = obj.getString("callbackUrl");
            }
            if (obj.has("isSocial")) {
                isSocial = obj.getBoolean("isSocial");
            }
            try {
                activity.getPackageManager().getPackageInfo(
                        "com.facebook.katana", 0);
                Intent intent = new Intent(Intent.ACTION_VIEW,
                        Uri.parse("fb://page/" + pageid));
                activity.startActivity(intent);
            } catch (Exception e) {
                mobOpenBrowser(
                        activity,
                        Uri.parse("https://m.facebook.com/profile.php?id="
                                + pageid));
            }
            if (!TextUtils.isEmpty(callbackUrl)) {
                final Activity a = activity;
                if (!Utils.hasDomain(callbackUrl)) {
                    callbackUrl = Constants.BASE_URL_DOMAIN + callbackUrl;
                }
                final boolean hasSocial = isSocial;
                new PostTask(callbackUrl, null, false, new PostTask.Callback() {

                    @Override
                    public void onSuccess(final String response) {
                        if (!hasSocial) {
                            Intent intent = new Intent(Constants.INTENT_FILTER);
                            intent.putExtra("category", "reload");
                            LocalBroadcastManager.getInstance(a).sendBroadcast(
                                    intent);
                        }
                    }

                    @Override
                    public void onFailure(Throwable e) {
                    }
                }).execute();
            }

        } catch (Exception e) {
            Toast.makeText(activity,
                    Res.string(activity, R.string.something_went_wrong),
                    Toast.LENGTH_LONG).show();
        }
    }

    public void mobOpenFBGroup(Activity activity, String params) {
        Log.i(TAG, "mobOpenGroup:" + params);
        try {
            JSONObject obj = new JSONObject(params);
            String groupid = obj.getString("groupid");
            try {
                activity.getPackageManager().getPackageInfo(
                        "com.facebook.katana", 0);
                Intent intent = new Intent(Intent.ACTION_VIEW,
                        Uri.parse("fb://group/" + groupid));
                activity.startActivity(intent);
            } catch (Exception e) {
                mobOpenBrowser(activity,
                        Uri.parse("https://facebook.com/groups/" + groupid));
            }
        } catch (Exception e) {
            Toast.makeText(activity,
                    Res.string(activity, R.string.something_went_wrong),
                    Toast.LENGTH_LONG).show();
        }
    }

    public void mobOpenModal(Activity activity, String params) {
        Log.i(TAG, "mobOpenModal:" + params);
        try {
            JSONObject obj = new JSONObject(params);
            Intent intent = new Intent(Constants.INTENT_FILTER);
            intent.putExtra("category", "dashboard");
            intent.putExtra("urls", "[{'action':'" + obj.getString("url")
                    + "'}]");
            LocalBroadcastManager.getInstance(activity.getApplicationContext())
                    .sendBroadcast(intent);
        } catch (Exception e) {
            Toast.makeText(activity,
                    Res.string(activity, R.string.something_went_wrong),
                    Toast.LENGTH_LONG).show();
        }
    }

    void mobOpenOfferWall(Activity activity, String params) {
        try {
            Log.i(TAG, "mobOpenOfferWall");
            Intent intent = new Intent(Constants.INTENT_FILTER);
            intent.putExtra("category", "mobOpenOfferWall");
            LocalBroadcastManager.getInstance(activity.getApplicationContext())
                    .sendBroadcast(intent);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    void mobMakePhoneCall(Activity activity, String params) {
        Log.i(TAG, "mobMakePhoneCall:" + params);
        try {
            JSONObject obj = new JSONObject(params);
            Intent intent = new Intent(Intent.ACTION_DIAL);
            intent.setData(Uri.parse("tel:" + obj.getString("number")));
            activity.startActivity(intent);
        } catch (Exception e) {
            Toast.makeText(activity,
                    Res.string(activity, R.string.something_went_wrong),
                    Toast.LENGTH_LONG).show();
        }
    }

    ArrayList<ListGiftCode> listGiftCodes = new ArrayList();
//    ArrayList<ListGiftCode> listGiftCodesAll = new ArrayList();

    void showFormGiftCode(final Activity activity, final String params) {
        try {
            activity.runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    try {
                        JSONObject json = new JSONObject(params);
                        final String data = json.getString("value");
                        Log.d(TAG, "value :" + data + " , " + params);

                        ListGiftCode ld = new ListGiftCode();
                        Log.e("myList", "vào null" + listGiftCodes.size());
                        if (listGiftCodes.size() == 0) {
                            ld.setGiftcode(data);
                            listGiftCodes.add(ld);
//                            listGiftCodesAll.add(ld);
                        } else {
                            for (int i = 0; i < listGiftCodes.size(); i++) {
                                if (data.equals(listGiftCodes.get(i).getGiftcode())) {
                                    listGiftCodes.remove(i);
//                                    listGiftCodesAll.remove(i);
                                }
                            }
                            Log.e(TAG, "value :" + " , " + ld.getGiftcode());
                            ld.setGiftcode(data);
                            listGiftCodes.add(ld);
                            Collections.reverse(listGiftCodes);
//                            listGiftCodesAll.add(ld);
                        }
                        if (android.os.Build.VERSION.SDK_INT <= 19) {
                            ShowGiftcode(activity, listGiftCodes);
                        } else {
                            ShowGiftcodeAllActivity(activity, listGiftCodes);
                        }
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            });

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void ShowGiftcode(Activity activity, ArrayList<ListGiftCode> listGC) {
        rootView = (ViewGroup) activity.findViewById(android.R.id.content);
        if (giftCodeView != null && isNullGiftcode ) {
            rootView.removeView(giftCodeView);
        }
        giftCodeView = LayoutInflater.from(activity).inflate(R.layout.list_show_giftcode, null);
        giftCodeView.startAnimation(AnimationUtils.loadAnimation(activity, R.anim.top_in));
        ListView lvGiftcode = (ListView) giftCodeView.findViewById(R.id.listGC);
        GiftCodeAdapter giftCodeAdapter = new GiftCodeAdapter(activity, listGC);
        lvGiftcode.setAdapter(giftCodeAdapter);
        giftCodeAdapter.notifyDataSetChanged();
        isNullGiftcode = true;
        rootView.addView(giftCodeView);
    }

    public void ShowGiftcodeAllActivity(Activity activity, ArrayList<ListGiftCode> listGC) {
        windowManager = (WindowManager) activity
                .getSystemService(Activity.WINDOW_SERVICE);
        WindowManager.LayoutParams params = new WindowManager.LayoutParams(
                WindowManager.LayoutParams.WRAP_CONTENT,
                WindowManager.LayoutParams.WRAP_CONTENT,
                WindowManager.LayoutParams.TYPE_PHONE,
                WindowManager.LayoutParams.FLAG_NOT_FOCUSABLE,
                PixelFormat.TRANSLUCENT);


        params.gravity = Gravity.TOP;

        if (giftCodeViewAll != null && isNullGiftcode) {
            windowManager.removeView(giftCodeViewAll);
        }

        giftCodeViewAll = LayoutInflater.from(activity).inflate(R.layout.list_show_giftcode, null);
        giftCodeViewAll.startAnimation(AnimationUtils.loadAnimation(activity, R.anim.top_in));
        giftCodeViewAll.requestLayout();
        ListView lvGiftcode = (ListView) giftCodeViewAll.findViewById(R.id.listGC);
        GiftCodeAdapter giftCodeAdapter = new GiftCodeAdapter(activity, listGC);
        lvGiftcode.setAdapter(giftCodeAdapter);
        giftCodeAdapter.notifyDataSetChanged();
        isNullGiftcode = true;
        windowManager.addView(giftCodeViewAll, params);
    }

    public class GiftCodeAdapter extends BaseAdapter {

        ArrayList myList = new ArrayList();
        LayoutInflater inflater;
        Activity activity;


        public GiftCodeAdapter(Activity ac, ArrayList myList) {
            this.myList = myList;
            this.activity = ac;
            inflater = LayoutInflater.from(this.activity);
        }

        @Override
        public int getCount() {
            return myList.size();
        }

        @Override
        public ListGiftCode getItem(int position) {
            return (ListGiftCode) myList.get(position);
        }

        @Override
        public long getItemId(int position) {
            return 0;
        }

        @Override
        public View getView(final int position, View convertView, ViewGroup parent) {
            MyViewHolder mViewHolder;

            if (convertView == null) {
                convertView = inflater.inflate(R.layout.layout_show_giftcode, parent, false);
                mViewHolder = new MyViewHolder(convertView);
                convertView.setTag(mViewHolder);
            } else {
                mViewHolder = (MyViewHolder) convertView.getTag();
            }

            final ListGiftCode currentListData = getItem(position);

            mViewHolder.txt_giftcode.setText("Code : " + currentListData.getGiftcode());
            mViewHolder.btnCopy.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    try {
                        JSONObject object = new JSONObject();
                        object.put("data", currentListData.getGiftcode());
                        mobCopyToClipboard(activity, object.toString());
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }

                }
            });

            mViewHolder.btnHide.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    try {
                        myList.remove(position);
                        notifyDataSetChanged();
                        if (myList.size() == 0) {
                            isNullGiftcode = false;
                            if (android.os.Build.VERSION.SDK_INT <= 19) {
                                if (giftCodeView != null) {
                                    rootView.removeView(giftCodeView);
                                } else {
                                    isNullGiftcode = true;
                                }
                            } else {
                                if (giftCodeViewAll != null) {
                                    windowManager.removeView(giftCodeViewAll);
                                } else {
                                    isNullGiftcode = true;
                                }
                            }
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });

            return convertView;
        }

        private class MyViewHolder {
            TextView txt_giftcode;
            Button btnHide;
            Button btnCopy;

            public MyViewHolder(View item) {
                txt_giftcode = (TextView) item.findViewById(R.id.txt_giftcode);
                btnHide = (Button) item.findViewById(R.id.btn_close_giftcode);
                btnCopy = (Button) item.findViewById(R.id.btn_copy_giftcode);
                btnHide.setText(Res.string(activity , R.string.close));
                btnCopy.setText(Res.string(activity , R.string.copy));
            }
        }
    }

    public void showGiftCode() {
        if (giftCodeView != null) {
            giftCodeView.setVisibility(View.VISIBLE);
        }
        if (giftCodeViewAll != null) {
            giftCodeViewAll.setVisibility(View.VISIBLE);
        }
    }

    public void hideGiftCode() {
        if (giftCodeView != null) {
            giftCodeView.setVisibility(View.GONE);
        }
        if (giftCodeViewAll != null) {
            giftCodeViewAll.setVisibility(View.GONE);
        }
    }
    public void removeGC(){
        if (giftCodeView != null) {
            rootView.removeView(giftCodeView);
            isNullGiftcode = false;
        }
        if (giftCodeViewAll != null) {
            windowManager.removeView(giftCodeViewAll);
            isNullGiftcode = false;
        }
        if (listGiftCodes.size() != 0) {
            Log.e("listGiftCodes.size()",""+listGiftCodes.size());
            listGiftCodes.clear();
        }
    }

    @SuppressWarnings("deprecation")
    public static void mobCopyToClipboard(Activity activity, String params) {
        try {
            int sdk = android.os.Build.VERSION.SDK_INT;
            JSONObject obj = new JSONObject(params);
            String data = obj.getString("data").trim();
            if (sdk < android.os.Build.VERSION_CODES.HONEYCOMB) {
                android.text.ClipboardManager clipboard = (android.text.ClipboardManager) activity
                        .getSystemService(Context.CLIPBOARD_SERVICE);
                clipboard.setText(data);
            } else {
                android.content.ClipboardManager clipboard = (android.content.ClipboardManager) activity
                        .getSystemService(Context.CLIPBOARD_SERVICE);
                android.content.ClipData clip = android.content.ClipData
                        .newPlainText("clipboard", data);
                clipboard.setPrimaryClip(clip);
            }
            Toast.makeText(activity, Res.string(activity, R.string.copied),
                    Toast.LENGTH_LONG).show();
        } catch (Exception e) {
            Toast.makeText(activity,
                    Res.string(activity, R.string.something_went_wrong),
                    Toast.LENGTH_LONG).show();
        }
    }

    private MobGameDialogWebviewFragment webFragment;
    private HashMap<String, Bitmap> issuePhotos;

    public void mobGetIssue(Activity activity, MobGameDialogWebviewFragment webFragment,
                            String params) {
        Log.i(TAG, "mobGetIssue:" + params);
        try {
            JSONObject obj = new JSONObject(params);
            long issueId = Long.parseLong(obj.getString("id"));
            if (issueId != 0) {
                //Code cũ up từng ảnh
//                if (issuePhotos != null) {
//                    for (Entry<String, Bitmap> entry : issuePhotos.entrySet()) {
//                        String key = entry.getKey();
//                        Bitmap bitmap = entry.getValue();
//                        new UploadBitmapTask(activity, Constants.URL_UPLOAD_ISSUE_IMAGE
//                                + "?id=" + issueId, bitmap).execute();
//                    }
//                }
                if (issuePhotos != null) {
                    ArrayList<Bitmap> listBitmap = new ArrayList<>();
                    for (Entry<String, Bitmap> entry : issuePhotos.entrySet()) {
                        String key = entry.getKey();
                        Bitmap bitmap = entry.getValue();
                        listBitmap.add(bitmap);
                    }
                    if(listBitmap.size()>0){
                        new UploadListBitmapTask(activity, Constants.URL_UPLOAD_ISSUE_IMAGE
                                + "?id=" + issueId, listBitmap).execute();
                    }
                }
                issuePhotos = null;
            }
        } catch (Exception e) {
            Toast.makeText(activity,
                    Res.string(activity, R.string.something_went_wrong),
                    Toast.LENGTH_LONG).show();
        }
    }

    public void deleteImageData(Activity activity,
                                MobGameWebFragment webFragment, String params) {
        Log.i(TAG, "deleteImageData:" + params);
        if (issuePhotos == null) {
            return;
        }
        if (issuePhotos.isEmpty()) {
            return;
        }

        try {
            JSONObject obj = new JSONObject(params);
            String index = obj.optString("index");

            if (issuePhotos.containsKey(index)) {
                issuePhotos.remove(index);
            }
            Log.d(TAG, "issue photo size:" + issuePhotos.size());
        } catch (Exception e) {
            e.printStackTrace();
            Toast.makeText(activity,
                    Res.string(activity, R.string.something_went_wrong),
                    Toast.LENGTH_LONG).show();
        }
    }

    // clear all photo if user exit report view or submit data error
    public void clearImageData(Activity activity) {
        Log.d(TAG, "clearImageData");
        if (issuePhotos == null) {
            return;
        }

        if (issuePhotos.isEmpty()) {
            return;
        }
        issuePhotos.clear();
    }

    // TODO file choose
    public void mobSelectImage(Activity activity, MobGameDialogWebviewFragment webFragment, String params) {
        try {
            Log.d(TAG, "mobSelectImage: " + params);
            if (issuePhotos != null) {
                if (issuePhotos.size() > 2) {
                    AlertDialog.Builder alert = new AlertDialog.Builder(activity);
                    alert.setMessage(Res.string(activity , R.string.alert_image_validate));
                    alert.setNegativeButton("Ok",
                            new DialogInterface.OnClickListener() {
                                @Override
                                public void onClick(DialogInterface dialog,
                                                    int which) {
                                    dialog.dismiss();
                                }
                            });
                    Dialog dialog = alert.create();
                    dialog.setCancelable(false);
                    dialog.show();

                    return;

                }
            }
            this.webFragment = webFragment;

            boolean grantedReadStorage = PermissionUtils
                    .hasPermission(Manifest.permission.READ_EXTERNAL_STORAGE);

            if (!grantedReadStorage) {
                PermissionUtils.requestPermission(MobGameSDK.currentActivity,
                        Manifest.permission.READ_EXTERNAL_STORAGE);
            }

            if (grantedReadStorage) {
                Intent intent = new Intent(
                        Intent.ACTION_PICK,
                        android.provider.MediaStore.Images.Media.EXTERNAL_CONTENT_URI);
                intent.setType("image/*");
                activity.startActivityForResult(
                        Intent.createChooser(intent, "Choose photo"),
                        Constants.REQUEST_CODE_PICKER);

            }
        } catch (Exception e) {
            e.printStackTrace();
        }

    }
    public void mobSelectImage2(Activity activity, MobGameDialogWebviewFragment webFragment, String params) {
        try {
            Log.d(TAG, "mobSelectImage 2: " + params);
            if (issuePhotos != null) {
                if (issuePhotos.size() > 3) {
                    AlertDialog.Builder alert = new AlertDialog.Builder(activity);
                    alert.setMessage(Res.string(activity,R.string.alert_image_validate));
                    alert.setNegativeButton("Ok",
                            new DialogInterface.OnClickListener() {
                                @Override
                                public void onClick(DialogInterface dialog,
                                                    int which) {
                                    dialog.dismiss();
                                }
                            });
                    Dialog dialog = alert.create();
                    dialog.setCancelable(false);
                    dialog.show();

                    return;

                }
            }
            this.webFragment = webFragment;

            boolean grantedReadStorage = PermissionUtils
                    .hasPermission(Manifest.permission.READ_EXTERNAL_STORAGE);

            if (!grantedReadStorage) {
                PermissionUtils.requestPermission(MobGameSDK.currentActivity,
                        Manifest.permission.READ_EXTERNAL_STORAGE);
            }

            if (grantedReadStorage) {
                Bundle bundle = new Bundle();
                int limit = 3;
                if(issuePhotos!=null){
                    limit = 3-issuePhotos.size();
                }
                bundle.putInt("limit", limit);
                Intent intent = new Intent(activity,MobGameImageGaleryActivity.class);
                intent.putExtra("bundle", bundle);
                activity.startActivityForResult(intent,Constants.REQUEST_CODE_PICKER);

            }
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    public void mobChooseFriend(final Activity activity, String params) {
        // TODO Auto-generated method stub
        try {
            JSONObject obj = new JSONObject(params);
            String callbackUrl = null;
            if (obj.has("callbackUrl")) {
                callbackUrl = obj.getString("callbackUrl");
            }
            final String url = callbackUrl;
            InviteGameContent parameter = new InviteGameContent();
            parameter.setTitle("Invite friend play game");
            parameter.setMessage("Play game with me");
            FacebookManager.getInstance().inviteGameRequest(activity, parameter, new InviteGameCallback() {

                @Override
                public void onSuccess(Result data) {
                    // TODO Auto-generated method stub
                    Log.i(TAG, "invite onSuccess");
                    List<String> list = data.getRequestRecipients();
                    HashMap<String, String> maps = new HashMap<>();
                    String str = "";

                    for (int i = 0; i < list.size(); i++) {
                        str = str + list.get(i) + ",";
                    }
                    Log.d("STR", "str:" + str);
                    String id = GameConfigManager.getInstance().getUserInfo().getUser().getAccountId();
                    maps.put("account_id", id);
                    maps.put("fbid_friends", str);
                    new PostTask(url, maps, true, true, id, new PostTask.Callback() {
                        @Override
                        public void onSuccess(String response) {
                            // TODO Auto-generated method stub

                        }

                        @Override
                        public void onFailure(Throwable e) {
                            // TODO Auto-generated method stub
                        }
                    }).execute();
                }

                @Override
                public void onError(Throwable t) {
                    // TODO Auto-generated method stub
                    Log.i(TAG, "invite onError");
                }

                @Override
                public void onCancel() {
                    // TODO Auto-generated method stub
                    Log.i(TAG, "invite onCancel");
                }
            });
        } catch (Exception e) {
            // TODO: handle exception
        }
    }

    public void trackingDetailWeb(Activity activity, String params) {
        try {
            Log.d(TAG, "params : " + params);
            mFirebaseAnalytics = FirebaseAnalytics.getInstance(activity);
            JSONObject json = new JSONObject(params);
            String typeEvent = json.getString("type");
            String title = json.getString("title");
            Bundle bundle = new Bundle();
            bundle.putString("type", typeEvent);
            bundle.putString("title", title);
            mFirebaseAnalytics.logEvent(Constants.STR_EVENT_TRACK_DETAIL_WEB, bundle);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void zaloShareFeed(final Activity activity, final String params) {
        try {
            if (DeviceUtils.isAppInstalled(activity, "com.zing.zalo")) {
                final ZaloPluginCallback mCallBackFeed = new ZaloPluginCallback() {
                    @Override
                    public void onResult(boolean isSuccess, int errorCode, String msg, String data) {
                        try {
                            if (isSuccess) {
                                Log.i(TAG, "ZaloPluginCallback: isSuccess: " + isSuccess + " errorCode: " + errorCode);
//							Toast.makeText(activity, activity.getString(R.string.zalo_share_message_success),Toast.LENGTH_LONG).show();
                            } else {
                                Log.i(TAG, "ZaloPluginCallback: isSuccess: " + isSuccess + " errorCode: " + errorCode);
//							Toast.makeText(activity, activity.getString(R.string.zalo_share_message_fail),Toast.LENGTH_LONG).show();
                            }
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                };
                activity.runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        try {
                            OpenAPIService.getInstance().shareFeed(activity, getFeedData(params), mCallBackFeed);
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
            } else {
                Toast.makeText(activity, Res.string(activity , R.string.zalo_require_install), Toast.LENGTH_SHORT).show();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void zaloShareMessage(final Activity activity, final String params) {
        try {
            if (DeviceUtils.isAppInstalled(activity, "com.zing.zalo")) {
                final ZaloPluginCallback mCallBackMessage = new ZaloPluginCallback() {
                    @Override
                    public void onResult(boolean isSuccess, int errorCode, String msg, String data) {
                        try {
                            if (isSuccess) {
                                Log.i(TAG, "ZaloPluginCallback: isSuccess: " + isSuccess + " errorCode: " + errorCode);
                                Toast.makeText(activity, Res.string(activity , R.string.zalo_share_feed_success), Toast.LENGTH_LONG).show();
                            } else {
                                Log.i(TAG, "ZaloPluginCallback: isSuccess: " + isSuccess + " errorCode: " + errorCode);
                                Toast.makeText(activity, Res.string(activity , R.string.zalo_share_feed_fail), Toast.LENGTH_LONG).show();
                            }
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                };
                activity.runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        try {
                            OpenAPIService.getInstance().shareMessage(activity, getFeedData(params), mCallBackMessage);
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
            } else {
                Toast.makeText(activity, Res.string(activity , R.string.zalo_require_install), Toast.LENGTH_SHORT).show();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private FeedData getFeedData(String data) {
        FeedData feedData = new FeedData();
        try {
            JSONObject obj = new JSONObject(data);
            if (obj.has("message")) {
                feedData.setMsg(obj.getString("message"));
            }
            if (obj.has("appName")) {
                feedData.setAppName(obj.getString("appName"));
            }
            if (obj.has("link")) {
                feedData.setLink(obj.getString("link"));
            }
        } catch (JSONException e) {
            e.printStackTrace();
        }
        return feedData;
    }
}
