package com.mobgame.component;

import android.app.Activity;
import android.util.Log;

import com.appsflyer.AppsFlyerLib;
import com.google.ads.conversiontracking.AdWordsAutomatedUsageReporter;
import com.mobgame.MobGameSDK;
import com.mobgame.ads.AdsManager;
import com.mobgame.model.CharacterInfo;
import com.mobgame.model.Game;
import com.mobgame.model.Game.AdsConfig;
import com.mobgame.model.Game.AdwordsConfig;
import com.mobgame.model.Game.AppsFlyerConfig;
import com.mobgame.model.MobAds;
import com.mobgame.model.MobMenu;
import com.mobgame.model.UserInfo;
import com.mobgame.utils.Constants;
import com.mobgame.utils.Preference;

public final class GameConfigManager {
	
	private static final String TAG = GameConfigManager.class.getSimpleName();
	public static final String SHARED_PREF_MACCESS_TOKEN = "shared_pref_maccess_token";
	private static GameConfigManager INSTANCE;

	private String appkey;
	private Game gameConfig;
	private UserInfo userInfo;
	private CharacterInfo characterInfo;
	private MobMenu mobMenu;
	private MobAds mobAds;
//	private MobAccessToken accessToken;
	private String accessToken;
	private boolean hasUnreadNotifications;
    private String appsflyerId;
	private boolean appsflyerStarted;
	private String appsflyerDevKey;

	public static GameConfigManager getInstance() {
		if (INSTANCE == null) {
			INSTANCE = new GameConfigManager();
		}
		return INSTANCE;
	}
	
	public String getAppKey() {
		return appkey;
	}

	public void setAppKey(String appkey) {
		this.appkey = appkey;
	}

	public boolean isAppsflyerStarted() {
		return appsflyerStarted;
	}

	public void setAppsflyerStarted(boolean appsflyerStarted) {
		this.appsflyerStarted = appsflyerStarted;
	}

	public String getAppsflyerDevKey() {
		return appsflyerDevKey;
	}

	public void setAppsflyerDevKey(String appsflyerDevKey) {
		this.appsflyerDevKey = appsflyerDevKey;
	}

	public Game getGameConfig() {
		return gameConfig;
	}

	public void setGameConfig(Game gameConfig) {
		try {
			this.gameConfig = gameConfig;

			initLang(gameConfig.getLang());
			initGoogleAuth();
			initFacebook(gameConfig.getFacebookId());
			initAds(gameConfig.getAdsConfig());
		}catch (Exception e){
			e.printStackTrace();
		}
	}

	public UserInfo getUserInfo() {
		return userInfo;
	}

	public void setUserInfo(UserInfo userInfo) {
		this.userInfo = userInfo;
	}
	
	public void clearUserInfo() {
		this.userInfo = null;
	}
	
	public CharacterInfo getCharacterInfo() {
		if (characterInfo == null) {
			characterInfo = new CharacterInfo();
		}
		return characterInfo;
	}

	public void setCharacterInfo(CharacterInfo characterInfo) {
		this.characterInfo = characterInfo;
	}
	
	public void clearCharacterInfo() {
		this.characterInfo = null;
	}
	
	public String getAccessToken() {
		if (accessToken == null) {
			accessToken = "";
			try {
				Activity a = MobGameSDK.activity;
				if(a!=null){
					accessToken = Preference.getString(a, SHARED_PREF_MACCESS_TOKEN);
				}else {
					accessToken = Preference.getString(MobGameSDK.getApplicationContext(), SHARED_PREF_MACCESS_TOKEN);
				}
			}catch (Exception e){
				e.printStackTrace();
			}
		}
		return accessToken;
	}

	public void setAccessToken(String accessToken) {
		Activity a = MobGameSDK.activity;
		try {
			if(a != null){
				Preference.save(a, SHARED_PREF_MACCESS_TOKEN, accessToken);
			}else{
				Preference.save(MobGameSDK.getApplicationContext(), SHARED_PREF_MACCESS_TOKEN, accessToken);
			}
		}catch (Exception e){
			e.printStackTrace();
		}
		this.accessToken = accessToken;
	}

    public String getAppsFlyerId() {
        return appsflyerId;
    }

    public void setAppsFlyerId(String appsflyerId) {
        this.appsflyerId = appsflyerId;
    }

    public void clearAccessToken() {
		try {
			Activity a = MobGameSDK.activity;
			if(a != null){
				Preference.remove(a, SHARED_PREF_MACCESS_TOKEN);
			}else{
				Preference.remove(MobGameSDK.getApplicationContext(), SHARED_PREF_MACCESS_TOKEN);
			}
		}catch (Exception e){
			e.printStackTrace();
		}
		this.accessToken = null;
	}
	
	public MobMenu getMobMenu() {
		if (mobMenu == null) {
			mobMenu = new MobMenu();
		}
		return mobMenu;
	}

	public void setMobMenu(MobMenu mobMenu) {
		this.mobMenu = mobMenu;
	}

	public MobAds getMobAds(){
		if (mobAds == null){
			mobAds = new MobAds();
		}
		return mobAds;
	}

	public void setMobAds(MobAds mobAds){
		this.mobAds = mobAds;
	}
	
	public void clearMobMenu() {
		this.mobMenu = null;
	}
	
	public void clearLogin() {
		clearMobMenu();
		clearUserInfo();
		clearCharacterInfo();
		clearAccessToken();
	}	

	public boolean isHasUnreadNotifications() {
		return hasUnreadNotifications;
	}

	public void setHasUnreadNotifications(boolean hasUnreadNotifications) {
		this.hasUnreadNotifications = hasUnreadNotifications;
	}
	
	public void clearUnreadNotifications() {
		hasUnreadNotifications = false;
	}
	
	public String getFacebookId() {
		return gameConfig.getFacebookId();
	}
	
	private void initFacebook(String facebookAppId) {
		try {
			Log.i(TAG, "initFacebook");
			Activity a = MobGameSDK.activity;
			FacebookManager.getInstance().init(a.getApplicationContext(), facebookAppId);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	private void initGoogleAuth() {
		try {
			Activity a = MobGameSDK.activity;
			GoogleAuthManager.getInstance().init(a);
		}catch (Exception e){
			e.printStackTrace();
		}
	}

	private void initAppsFlyer(AppsFlyerConfig config) {
		try {
			Log.i(TAG, "initAppsFlyer");
			Activity a = MobGameSDK.activity;
//			AppsFlyerLib.getInstance().setUseHTTPFalback(config.isUseHttp());
			AppsFlyerLib.getInstance().setCurrencyCode(config.getCurrency());
			AppsFlyerLib.getInstance().startTracking(a.getApplication(), config.getDevKey());
            appsflyerId = AppsFlyerLib.getInstance().getAppsFlyerUID(a);
			if(appsflyerDevKey.isEmpty()){
				Log.d(TAG, "initAppsFlyer: không truyền appsflyer dev key từ MobgameSDK");
			}else{
				if(!appsflyerDevKey.equalsIgnoreCase(config.getDevKey())){
					Log.d(TAG, "initAppsFlyer: key từ config BeforeAuthen khác key từ MobgameSDK");
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	private void updateAppsFlyerConfig(AppsFlyerConfig config) {
		try {
			Log.i(TAG, "updateAppsFlyerConfig");
			Activity a = MobGameSDK.activity;
			AppsFlyerLib.getInstance().setCurrencyCode(config.getCurrency());
			appsflyerId = AppsFlyerLib.getInstance().getAppsFlyerUID(a);
			if(appsflyerDevKey.isEmpty()){
				Log.d(TAG, "updateAppsFlyerConfig: không truyền appsflyer dev key từ MobgameSDK");
			}else{
				if(!appsflyerDevKey.equalsIgnoreCase(config.getDevKey())){
					Log.d(TAG, "updateAppsFlyerConfig: key từ config BeforeAuthen khác key từ MobgameSDK");
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	//Init Firebase Analytics


	private void initAdwords(AdwordsConfig config) {
		try {
			Activity a = MobGameSDK.activity;
			String conversionId = config.getConversionId();
			if(a!=null){
				AdWordsAutomatedUsageReporter.enableAutomatedUsageReporting(a.getApplicationContext(), conversionId);
			}else{
				AdWordsAutomatedUsageReporter.enableAutomatedUsageReporting(MobGameSDK.getApplicationContext(), conversionId);
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	private void initAds(AdsConfig config) {
		try {
			Activity a = MobGameSDK.activity;
			AdsManager.setApiKey(config.getApiKey());
			if(a!=null){
				AdsManager.startTracking(a.getApplicationContext());
			}else{
				AdsManager.startTracking(MobGameSDK.getApplicationContext());
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	private void initLang(String lang) {
		try {
			if (
					"vie".equalsIgnoreCase(lang)
							||	"vi".equalsIgnoreCase(lang)) {
				gameConfig.setLang(Constants.LANG_VI);
			} else if (
					"eng".equalsIgnoreCase(lang)
							||	"en".equalsIgnoreCase(lang)) {
				gameConfig.setLang(Constants.LANG_EN);
			} else if (
					"es_es".equalsIgnoreCase(lang)) {
				gameConfig.setLang(Constants.LANG_ES);
			} else if (
					"zh".equalsIgnoreCase(lang)
							||	"zh_cn".equalsIgnoreCase(lang)
							||	"zh_tw".equalsIgnoreCase(lang)) {
				gameConfig.setLang(Constants.LANG_CN);
			} else if (
					"th".equalsIgnoreCase(lang)
							||	"tha".equalsIgnoreCase(lang)) {
				gameConfig.setLang(Constants.LANG_TH);
			} else if (
					"ind".equalsIgnoreCase(lang)
							||	"id".equalsIgnoreCase(lang)) {
				gameConfig.setLang(Constants.LANG_ID);
			}
		}catch (Exception e){
			e.printStackTrace();
		}
	}
}
