package com.mobgame.component;
import android.content.Context;
import android.content.res.Resources;
import android.util.Log;

import com.appsflyer.AppsFlyerLib;
import com.mobgame.api.SaveEventClientTask;
import com.mobgame.utils.DeviceUtils;
import com.mobgame.utils.Preference;
import com.mobgame.utils.TimeUtils;
import com.mobgame.utils.Utils;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
/**
 * Created by khaitran on 9/13/17.
 */

public class EventClientManager {
    private static EventClientManager INSTANCE;
    private static final String TAG = EventClientManager.class.getSimpleName();

    public static final String SAVE_EVENT_START_SESSION = "start";
    public static final String SAVE_EVENT_END_SESSION = "end";
    public static final String SAVE_EVENT_NORMAL = "normal";


    private static String userId;
    private static Date startSessionTime;

    private String mobgameAppkey;
    private String mobgameToken;
    private String mobgameOs;
    private String mobgameResolution;
    private String mobgameAppVersion;
    private String mobgameAppVersionCode;
    private String mobgameNetwork;
    private String mobgameDevice;
    private String mobgameSdkVersion;
    private String mobgameRoleId;
    private String mobgameAreaId;
    private String mobgameRoleName;
    private String mobgameAreaName;
    private String mobgameAdvertisingId;
    private String mobgameOrientation;
    private String mobgameDistributor;
    private String mobgameLang;
    private String mobgameAppsflyerId;

    public EventClientManager(Context context) {
        try {
            Log.d(TAG, "initHeaderRequest: DeviceUtils.getDevice():"+ DeviceUtils.getDevice());
            setMobgameDevice(DeviceUtils.getDevice());
            Log.d(TAG, "initHeaderRequest: DeviceUtils.getOSInfo():"+DeviceUtils.getOSInfo());
            setMobgameOs(DeviceUtils.getOSInfo());
            Log.d(TAG, "initHeaderRequest: DeviceUtils.getResolution(context):"+DeviceUtils.getResolution(context));
            setMobgameResolution(DeviceUtils.getResolution(context));
            Log.d(TAG, "initHeaderRequest: Utils.getSDKVersion(context):"+ Utils.getSDKVersion(context));
            setMobgameSdkVersion(Utils.getSDKVersion(context));
            Log.d(TAG, "initHeaderRequest: GameConfigManager.getInstance().getAppKey():"+GameConfigManager.getInstance().getAppKey());
            setMobgameAppkey(GameConfigManager.getInstance().getAppKey());
            Log.d(TAG, "initHeaderRequest: Utils.getGameVersion(context):"+Utils.getGameVersion(context));
            setMobgameAppVersion(Utils.getGameVersion(context));
            Log.d(TAG, "initHeaderRequest: Utils.getGameVersionCode(context):"+Utils.getGameVersionCode(context));
            setMobgameAppVersionCode(Utils.getGameVersionCode(context));
            Log.d(TAG, "initHeaderRequest: Utils.getNetwork(context):"+Utils.getNetwork(context));
            setMobgameNetwork(Utils.getNetwork(context));
            Log.d(TAG, "initHeaderRequest: DeviceUtils.getScreenOrientation(context):"+DeviceUtils.getScreenOrientation(context));
            setMobgameOrientation(DeviceUtils.getScreenOrientation(context) + "");
            Log.d(TAG, "initHeaderRequest: Utils.getReferrer(context):"+Utils.getReferrer(context));
            setMobgameRefererDistributor(Utils.getReferrer(context));
            Log.d(TAG, "initHeaderRequest: DeviceUtils.getLanguage():"+DeviceUtils.getLanguage());
            setMobgameLang(DeviceUtils.getLanguage());
            Log.d(TAG, "initHeaderRequest: DeviceUtils.getAdvertisingID(context):"+DeviceUtils.getAdvertisingID(context));
            setMobgameAdvertisingId(DeviceUtils.getAdvertisingID(context));
            Log.d(TAG, "EventClientManager: GameConfigManager.getInstance().getAccessToken()"+ Preference.getString(context, GameConfigManager.SHARED_PREF_MACCESS_TOKEN));
            setMobgameToken(Preference.getString(context, GameConfigManager.SHARED_PREF_MACCESS_TOKEN));
            Log.d(TAG, "initHeaderRequest: AppsFlyerLib.getInstance().getAppsFlyerUID(context):"+ AppsFlyerLib.getInstance().getAppsFlyerUID(context));
            setMobgameAppsflyerId(AppsFlyerLib.getInstance().getAppsFlyerUID(context));
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    public void saveEventClient(String type, String eventName, HashMap<String, Object> eventValue){
        String data="{}";
        JSONObject objData = new JSONObject();
        try {
            objData.put("user_id", userId);

            JSONObject objSession = new JSONObject();
            JSONObject objSubSession = new JSONObject();
            String eventType = "";
            if(type.equalsIgnoreCase(SAVE_EVENT_START_SESSION)){
                setStartSessionTime(new Date());
                eventType= "_session.start";
                long timeStamp = startSessionTime.getTime()/1000;
                objSubSession.put("id", ""+userId+timeStamp);
                objSubSession.put("startTimestamp", TimeUtils.getTimeIso(startSessionTime));
            }else if(type.equalsIgnoreCase(SAVE_EVENT_END_SESSION)){
                eventType= "_session.stop";
                long timeStamp = (new Date()).getTime()/1000;
                Date endSessionTime = new Date();
                long startTime = startSessionTime.getTime()/1000;
                objSubSession.put("id", ""+userId+timeStamp);
                objSubSession.put("startTimestamp", TimeUtils.getTimeIso(startSessionTime));
                objSubSession.put("stopTimestamp", TimeUtils.getTimeIso(endSessionTime));
                objSubSession.put("duration", ""+(timeStamp - startTime));
            }
            objSession.put("eventType", eventType);
            objSession.put("timestamp", TimeUtils.getTimeIso(new Date()));
            objSession.put("session", objSubSession);
            objData.put("session", objSession);

            JSONObject objEvent = new JSONObject();
            if(eventName!=null && !eventName.isEmpty()){
                objEvent.put("eventName", eventName);
                if(eventValue!=null){
                    objEvent.put("attributes", new JSONObject(eventValue));
                }
            }
            objData.put("event", objEvent);

            objData.put("header", new JSONObject(toStringJsonRequestHeader()));

            data = objData.toString();
            Log.d(TAG, "saveEventClient: data:"+data);
            if(getMobgameAppkey()!=null && !getMobgameAppkey().isEmpty()){
                (new SaveEventClientTask(data)).execute();
            }
        } catch (JSONException e) {
            e.printStackTrace();
        } catch (Exception e){
            e.printStackTrace();
        }
    }

    public static EventClientManager getInstance(Context context){
        if(INSTANCE == null){
            INSTANCE = new EventClientManager(context);
        }
        return INSTANCE;
    }

    public String toStringJsonRequestHeader(){
        JSONObject jsonObject= new JSONObject();
        Locale defaultLocale = Resources.getSystem().getConfiguration().locale;
        try {
            jsonObject.put("mobgame-appkey", getMobgameAppkey());
            jsonObject.put("mobgame-token", getMobgameToken());
            jsonObject.put("mobgame-os", getMobgameOs());
            jsonObject.put("mobgame-resolution", getMobgameResolution());
            jsonObject.put("mobgame-app-version", getMobgameAppVersion());
            jsonObject.put("mobgame-app-version-code", getMobgameAppVersionCode());
            jsonObject.put("mobgame-network", getMobgameNetwork());
            jsonObject.put("mobgame-device", getMobgameDevice());
            jsonObject.put("mobgame-sdk-version", getMobgameSdkVersion());
            jsonObject.put("mobgame-role-id", getMobgameRoleId());
            jsonObject.put("mobgame-area-id", getMobgameAreaId());
            jsonObject.put("mobgame-role-name", getMobgameRoleName());
            jsonObject.put("mobgame-area-name", getMobgameAreaName());
            jsonObject.put("mobgame-advertising-id", getMobgameAdvertisingId());
            jsonObject.put("mobgame-orientation", getMobgameOrientation());
            jsonObject.put("mobgame-distributor", getMobgameRefererDistributor());
            jsonObject.put("mobgame_lang", getMobgameLang());
            jsonObject.put("mobgame-appsflyer-id", getMobgameAppsflyerId());
            return jsonObject.toString();
        } catch (JSONException e) {
            e.printStackTrace();
            return "";
        }
    }

    public String getMobgameAppkey() {
        return mobgameAppkey;
    }

    public void setMobgameAppkey(String mobgameAppkey) {
        this.mobgameAppkey = mobgameAppkey;
    }

    public String getMobgameToken() {
        return mobgameToken;
    }

    public void setMobgameToken(String mobgameToken) {
        this.mobgameToken = mobgameToken;
    }

    public String getMobgameOs() {
        return mobgameOs;
    }

    public void setMobgameOs(String mobgameOs) {
        this.mobgameOs = mobgameOs;
    }

    public String getMobgameResolution() {
        return mobgameResolution;
    }

    public void setMobgameResolution(String mobgameResolution) {
        this.mobgameResolution = mobgameResolution;
    }

    public String getMobgameAppVersion() {
        return mobgameAppVersion;
    }

    public void setMobgameAppVersion(String mobgameAppVersion) {
        this.mobgameAppVersion = mobgameAppVersion;
    }

    public String getMobgameAppVersionCode() {
        return mobgameAppVersionCode;
    }

    public void setMobgameAppVersionCode(String mobgameAppVersionCode) {
        this.mobgameAppVersionCode = mobgameAppVersionCode;
    }

    public String getMobgameNetwork() {
        return mobgameNetwork;
    }

    public void setMobgameNetwork(String mobgameNetwork) {
        this.mobgameNetwork = mobgameNetwork;
    }

    public String getMobgameDevice() {
        return mobgameDevice;
    }

    public void setMobgameDevice(String mobgameDevice) {
        this.mobgameDevice = mobgameDevice;
    }

    public String getMobgameSdkVersion() {
        return mobgameSdkVersion;
    }

    public void setMobgameSdkVersion(String mobgameSdkVersion) {
        this.mobgameSdkVersion = mobgameSdkVersion;
    }

    public String getMobgameRoleId() {
        return mobgameRoleId;
    }

    public void setMobgameRoleId(String mobgameRoleId) {
        this.mobgameRoleId = mobgameRoleId;
    }

    public String getMobgameAreaId() {
        return mobgameAreaId;
    }

    public void setMobgameAreaId(String mobgameAreaId) {
        this.mobgameAreaId = mobgameAreaId;
    }

    public String getMobgameRoleName() {
        return mobgameRoleName;
    }

    public void setMobgameRoleName(String mobgameRoleName) {
        this.mobgameRoleName = mobgameRoleName;
    }

    public String getMobgameAreaName() {
        return mobgameAreaName;
    }

    public void setMobgameAreaName(String mobgameAreaName) {
        this.mobgameAreaName = mobgameAreaName;
    }

    public String getMobgameAdvertisingId() {
        return mobgameAdvertisingId;
    }

    public void setMobgameAdvertisingId(String mobgameAdvertisingId) {
        this.mobgameAdvertisingId = mobgameAdvertisingId;
    }

    public String getMobgameOrientation() {
        return mobgameOrientation;
    }

    public void setMobgameOrientation(String mobgameOrientation) {
        this.mobgameOrientation = mobgameOrientation;
    }

    public String getMobgameRefererDistributor() {
        return mobgameDistributor;
    }

    public void setMobgameRefererDistributor(String mobgameDistributor) {
        this.mobgameDistributor = mobgameDistributor;
    }

    public String getMobgameLang() {
        return mobgameLang;
    }

    public void setMobgameLang(String mobgameLang) {
        this.mobgameLang = mobgameLang;
    }

    public String getMobgameAppsflyerId() {
        return mobgameAppsflyerId;
    }

    public void setMobgameAppsflyerId(String mobgameAppsflyerId) {
        this.mobgameAppsflyerId = mobgameAppsflyerId;
    }

    public static String getUserId() {
        return userId;
    }

    public static void setUserId(String userId) {
        EventClientManager.userId = userId;
    }

    public static Date getStartSessionTime() {
        return startSessionTime;
    }

    public static void setStartSessionTime(Date startSessionTime) {
        EventClientManager.startSessionTime = startSessionTime;
    }
}
