/*
 * Decompiled with CFR 0.152.
 */
package com.mobgame.gui.floatbutton;

import android.animation.Animator;
import android.animation.ArgbEvaluator;
import android.animation.TimeInterpolator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.DialogFragment;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.os.Build;
import android.os.Handler;
import android.support.v4.content.LocalBroadcastManager;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.OvershootInterpolator;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.mobgame.R;
import com.mobgame.component.GameConfigManager;
import com.mobgame.component.GoogleAnalyticsManager;
import com.mobgame.gui.CountdownChronometer;
import com.mobgame.gui.floatbutton.MobGameFloatConfirmDialog;
import com.mobgame.gui.floatbutton.MobGameFloatGestureView;
import com.mobgame.gui.floatbutton.MobGameFloatMenuView;
import com.mobgame.model.MobMenuItem;
import com.mobgame.model.TimerData;
import com.mobgame.model.TimerObject;
import com.mobgame.utils.DeviceUtils;
import com.mobgame.utils.FloatButtonTimerHelper;
import com.mobgame.utils.NotificationUtils;
import com.mobgame.utils.Preference;
import com.mobgame.utils.Res;
import java.util.ArrayList;
import java.util.Calendar;

@SuppressLint(value={"InflateParams", "ClickableViewAccessibility"})
public class MobGameOverlayView {
    private static final int ANIMAION_TIME_ROTATE = 800;
    private static final int ANIMAION_TIME_FADE_OUT = 400;
    private static final int ANIMAION_TIME_FADE_IN = 400;
    private static final int IDLE_TIME = 6000;
    private static final int IDLE_TIME2 = 2000;
    private static final String TAG = MobGameOverlayView.class.getSimpleName();
    private static Activity activity;
    private View rootView;
    private View layoutBottom;
    private View layoutFloat;
    private TextView txtDismiss;
    private Handler idleHandler = new Handler();
    private MobGameFloatGestureView floatArea;
    private ImageView floatButton;
    private static ImageView floatButtonNtf;
    private MobGameFloatMenuView floatMenu;
    private CountdownChronometer countdownTimer;
    private View animationLayout;
    private View timerLayout;
    private boolean isInit;
    private static boolean isShowingMenu;
    private static boolean startShowMenu;
    private boolean isOutsideBottomArea;
    private int boundWidth;
    private int boundHeight;
    private int relativePositionOnScreen;
    private int statusBarHeight;
    private float density;
    private boolean isShowDialogAgain;
    private boolean fadeOuted;
    private Runnable mIdleRunnable = new Runnable(){

        @Override
        public void run() {
            try {
                if (!isShowingMenu) {
                    MobGameOverlayView.this.fadeOut(true);
                } else {
                    MobGameOverlayView.this.hideMenu();
                    MobGameOverlayView.this.idleHandler.postDelayed(MobGameOverlayView.this.mIdleRunnable, 6000L);
                }
                MobGameOverlayView.this.showCountdownTimer(0);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };
    private Runnable mIdleRunnable2 = new Runnable(){

        @Override
        public void run() {
            MobGameOverlayView.this.fadeOut2(true);
        }
    };
    private MobGameFloatGestureView.EventListener mButtonEventListener = new MobGameFloatGestureView.EventListener(){

        @Override
        public void onTouchDown(MotionEvent event) {
            MobGameOverlayView.this.isOutsideBottomArea = true;
            MobGameOverlayView.this.updateFloatButtonNotf();
            MobGameOverlayView.this.fadeIn(false);
        }

        @Override
        public void onTouchMove(MotionEvent event) {
            try {
                if (MobGameOverlayView.this.isInBottomArea(event.getRawX(), event.getRawY())) {
                    if (MobGameOverlayView.this.isOutsideBottomArea) {
                        MobGameOverlayView.this.showLayoutBottom();
                    }
                    MobGameOverlayView.this.isOutsideBottomArea = false;
                } else {
                    if (!MobGameOverlayView.this.isOutsideBottomArea) {
                        MobGameOverlayView.this.hideLayoutBottom();
                    }
                    MobGameOverlayView.this.isOutsideBottomArea = true;
                }
                if (MobGameOverlayView.this.isInDismissArea(event.getRawX(), event.getRawY())) {
                    MobGameOverlayView.this.txtDismiss.setCompoundDrawablesWithIntrinsicBounds(0, R.drawable.float_hide_active, 0, 0);
                    MobGameOverlayView.this.txtDismiss.setTextColor(Color.rgb((int)194, (int)39, (int)45));
                } else {
                    MobGameOverlayView.this.txtDismiss.setCompoundDrawablesWithIntrinsicBounds(0, R.drawable.float_hide_normal, 0, 0);
                    MobGameOverlayView.this.txtDismiss.setTextColor(Color.rgb((int)255, (int)255, (int)255));
                }
                MobGameOverlayView.this.hideMenu();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void onTouchUp(MotionEvent event) {
            try {
                MobGameOverlayView.this.updateFloatButtonNotf();
                MobGameOverlayView.this.idleHandler.removeCallbacksAndMessages(null);
                MobGameOverlayView.this.idleHandler.postDelayed(MobGameOverlayView.this.mIdleRunnable, 6000L);
                MobGameOverlayView.this.hideLayoutBottom();
                MobGameOverlayView.this.floatArea.moveToEdge(true);
                if (event != null && MobGameOverlayView.this.isInDismissArea(event.getRawX(), event.getRawY())) {
                    MobGameOverlayView.this.isShowDialogAgain = Preference.getBoolean((Context)activity, "shared_pref_float_button_show_dialog", true);
                    if (MobGameOverlayView.this.isShowDialogAgain) {
                        MobGameOverlayView.this.showConfirmDialog();
                    }
                    MobGameOverlayView.this.layoutFloat.setVisibility(8);
                    MobGameOverlayView.this.floatArea.hide();
                    Preference.save((Context)activity, "shared_pref_hide_float_button", true);
                    MobGameOverlayView.this.hideMenu();
                    long dismissTime = Calendar.getInstance().getTimeInMillis();
                    Preference.save((Context)activity, "shared_pref_float_button_dismiss_time", dismissTime);
                }
                MobGameOverlayView.this.startTimer();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void onClick(MotionEvent event) {
            try {
                MobGameOverlayView.this.animationLayout.setX(0.0f);
                if (isShowingMenu) {
                    MobGameOverlayView.this.hideMenu();
                } else {
                    MobGameOverlayView.this.showMenu();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void onMove(int x, int y) {
            try {
                x = Math.max(0, Math.min(MobGameOverlayView.this.boundWidth - MobGameOverlayView.this.floatArea.getSizeInPixels(), x));
                y = Math.max(0, Math.min(MobGameOverlayView.this.boundHeight - MobGameOverlayView.this.relativePositionOnScreen - MobGameOverlayView.this.floatArea.getSizeInPixels(), y));
                if (MobGameOverlayView.this.countdownTimer != null && MobGameOverlayView.this.countdownTimer.getVisibility() == 0) {
                    y = Math.max(0, Math.min(MobGameOverlayView.this.boundHeight - MobGameOverlayView.this.relativePositionOnScreen - MobGameOverlayView.this.floatArea.getSizeInPixels() - MobGameOverlayView.this.timerLayout.getMeasuredHeight(), y));
                }
                MobGameOverlayView.this.layoutFloat.setX((float)x);
                MobGameOverlayView.this.layoutFloat.setY((float)y);
                if (MobGameOverlayView.this.animationLayout != null && MobGameOverlayView.this.fadeOuted) {
                    MobGameOverlayView.this.animationLayout.setX(0.0f);
                    MobGameOverlayView.this.fadeOuted = false;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };
    private MobGameFloatMenuView.EventListener mMenuEventListener = new MobGameFloatMenuView.EventListener(){

        @Override
        public void onShow() {
            try {
                MobGameOverlayView.this.idleHandler.removeCallbacksAndMessages(null);
                MobGameOverlayView.this.idleHandler.postDelayed(MobGameOverlayView.this.mIdleRunnable, 6000L);
                MobGameOverlayView.this.floatButton.animate().setDuration(800L).setInterpolator((TimeInterpolator)new OvershootInterpolator(1.0f)).rotation(90.0f).setListener(new Animator.AnimatorListener(){

                    public void onAnimationStart(Animator anim2) {
                    }

                    public void onAnimationRepeat(Animator anim2) {
                    }

                    public void onAnimationEnd(Animator anim2) {
                        isShowingMenu = true;
                    }

                    public void onAnimationCancel(Animator anim2) {
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void onHide() {
            try {
                MobGameOverlayView.this.idleHandler.removeCallbacksAndMessages(null);
                MobGameOverlayView.this.idleHandler.postDelayed(MobGameOverlayView.this.mIdleRunnable, 6000L);
                MobGameOverlayView.this.hideLayoutBottom();
                MobGameOverlayView.this.floatArea.moveToEdge(true);
                MobGameOverlayView.this.floatButton.animate().setDuration(800L).setInterpolator((TimeInterpolator)new OvershootInterpolator(1.0f)).rotation(0.0f).setListener(new Animator.AnimatorListener(){

                    public void onAnimationStart(Animator arg0) {
                    }

                    public void onAnimationRepeat(Animator arg0) {
                    }

                    public void onAnimationEnd(Animator arg0) {
                        isShowingMenu = false;
                    }

                    public void onAnimationCancel(Animator arg0) {
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void onClick(View v, MobMenuItem menuItem) {
            try {
                MobGameOverlayView.this.hideMenu();
                GoogleAnalyticsManager.getInstance().trackEvent("Float icon", "button_press", menuItem.getLabel(), 1L);
                Intent intent = new Intent("com.mobgame.broadcast");
                intent.putExtra("category", menuItem.getCommand());
                intent.putExtra("data", menuItem.getParams());
                LocalBroadcastManager.getInstance((Context)activity.getApplicationContext()).sendBroadcast(intent);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };
    DialogFragment dialog = null;
    long startTime;
    long endTime;
    int id;
    ArrayList<TimerObject> listTimers = new ArrayList();

    public MobGameOverlayView(Activity a) {
        activity = a;
        this.enableTimer();
        this.floatMenu = new MobGameFloatMenuView(activity);
        this.floatMenu.setClickOutsideListenter(new MobGameFloatMenuView.OnClickOutsideListener(){

            @Override
            public void onClickOutSide() {
                Log.d((String)TAG, (String)"Float menu click outside");
                MobGameOverlayView.this.showCountdownTimer(0);
            }
        });
        this.floatArea = new MobGameFloatGestureView(activity);
        this.density = DeviceUtils.getDensity((Context)a);
        this.statusBarHeight = DeviceUtils.getStatusBarHeightInPixels((Context)activity);
        this.attachView();
        this.initView();
        this.hide();
    }

    public void enableTimer() {
        TimerData timerData = FloatButtonTimerHelper.getFloatButtonTimerData((Context)activity);
        if (timerData != null) {
            long now = Calendar.getInstance().getTimeInMillis();
            ArrayList<Object> listTimerObj = new ArrayList();
            listTimerObj = timerData.getListTimerObject();
            for (int i = 0; i < listTimerObj.size(); ++i) {
                TimerObject timerObject = new TimerObject();
                timerObject = (TimerObject)listTimerObj.get(i);
                if (timerObject.getStartTime() <= now && timerObject.getEndTime() > now) {
                    FloatButtonTimerHelper.setisRuningTimer(true);
                    break;
                }
                FloatButtonTimerHelper.setisRuningTimer(false);
            }
        } else {
            FloatButtonTimerHelper.setisRuningTimer(false);
        }
    }

    public void attachView() {
        try {
            this.rootView = LayoutInflater.from((Context)activity).inflate(R.layout.float_overlay_view, null);
            WindowManager windowManager = (WindowManager)activity.getApplicationContext().getSystemService("window");
            if (Build.VERSION.SDK_INT >= 26) {
                WindowManager.LayoutParams params = new WindowManager.LayoutParams(-1, -1, 2038, 8, -2);
                params.gravity = 51;
                params.flags = 56;
                windowManager.addView(this.rootView, (ViewGroup.LayoutParams)params);
            } else {
                WindowManager.LayoutParams params = new WindowManager.LayoutParams(-1, -1, 2002, 8, -2);
                params.gravity = 51;
                params.flags = 56;
                windowManager.addView(this.rootView, (ViewGroup.LayoutParams)params);
            }
            this.rootView.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                @SuppressLint(value={"NewApi"})
                public void onGlobalLayout() {
                    if (MobGameOverlayView.this.rootView != null) {
                        MobGameOverlayView.this.boundWidth = MobGameOverlayView.this.rootView.getWidth();
                        MobGameOverlayView.this.boundHeight = MobGameOverlayView.this.rootView.getHeight();
                        MobGameOverlayView.this.floatArea.setMovableWidth(MobGameOverlayView.this.boundWidth);
                        MobGameOverlayView.this.floatArea.setMovableHeight(MobGameOverlayView.this.boundHeight);
                        int[] locations = new int[2];
                        MobGameOverlayView.this.rootView.getLocationOnScreen(locations);
                        MobGameOverlayView.this.relativePositionOnScreen = locations[1];
                        if (!MobGameOverlayView.this.isInit) {
                            MobGameOverlayView.this.isInit = true;
                            MobGameOverlayView.this.floatArea.moveTo(0, MobGameOverlayView.this.boundHeight / 2);
                        }
                        if (Build.VERSION.SDK_INT < 16) {
                            MobGameOverlayView.this.rootView.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                        } else {
                            MobGameOverlayView.this.rootView.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void initView() {
        try {
            this.layoutBottom = this.rootView.findViewById(R.id.layout_bottom);
            this.layoutFloat = this.rootView.findViewById(R.id.layout_float);
            this.txtDismiss = (TextView)this.rootView.findViewById(R.id.txt_dismiss);
            this.floatButton = (ImageView)this.rootView.findViewById(R.id.img_float);
            floatButtonNtf = (ImageView)this.rootView.findViewById(R.id.img_float_ntf);
            this.animationLayout = this.rootView.findViewById(R.id.animation_layout);
            this.timerLayout = this.rootView.findViewById(R.id.timer_layouts);
            int imgRes = Res.drawableResource((Context)activity, R.drawable.float_button);
            this.floatButton.setImageResource(imgRes);
            this.floatMenu.setEventListener(this.mMenuEventListener);
            this.floatArea.setEventListener(this.mButtonEventListener);
            this.floatArea.moveTo(0, this.boundHeight / 2);
            this.txtDismiss.setText((CharSequence)Res.string((Context)activity, R.string.dismiss));
            this.layoutBottom.setY((float)(this.boundHeight + this.statusBarHeight - this.relativePositionOnScreen) - 125.0f * this.density);
            this.countdownTimer = (CountdownChronometer)this.rootView.findViewById(R.id.countdown_timer);
            if (!FloatButtonTimerHelper.isRuningTimer()) {
                this.timerLayout.setVisibility(8);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void fadeOut(boolean isAnimated) {
        try {
            int newX = this.updateFloatButtonNotf();
            Log.d((String)TAG, (String)("boundWidth: " + this.boundWidth + " - new X: " + newX));
            if (isAnimated) {
                Log.d((String)TAG, (String)"GO HERE 1 ");
                this.animationLayout.clearAnimation();
                this.animationLayout.animate().setDuration(400L).setInterpolator((TimeInterpolator)new OvershootInterpolator(1.0f)).x((float)newX).setListener(new Animator.AnimatorListener(){

                    public void onAnimationStart(Animator arg0) {
                    }

                    public void onAnimationRepeat(Animator arg0) {
                    }

                    public void onAnimationEnd(Animator arg0) {
                        Log.d((String)TAG, (String)("AnimationLayout X: " + MobGameOverlayView.this.animationLayout.getX()));
                        Log.d((String)TAG, (String)String.format("float layout: %sx%s - animate: %sx%s", Float.valueOf(MobGameOverlayView.this.layoutFloat.getX()), Float.valueOf(MobGameOverlayView.this.layoutFloat.getY()), Float.valueOf(MobGameOverlayView.this.animationLayout.getX()), Float.valueOf(MobGameOverlayView.this.animationLayout.getY())));
                        MobGameOverlayView.this.layoutFloat.clearAnimation();
                        MobGameOverlayView.this.animationLayout.clearAnimation();
                        MobGameOverlayView.this.layoutFloat.refreshDrawableState();
                    }

                    public void onAnimationCancel(Animator arg0) {
                    }
                });
            } else {
                Log.d((String)TAG, (String)"GO HERE 2 ");
                this.animationLayout.setX((float)newX);
            }
            this.fadeOuted = true;
            this.idleHandler.postDelayed(this.mIdleRunnable2, 2000L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int updateFloatButtonNotf() {
        int newX = 0;
        try {
            int buttonSize = this.floatArea.getSizeInPixels();
            newX = this.boundWidth - buttonSize / 2;
            float currentX = this.layoutFloat.getX();
            if (currentX <= (float)(this.boundWidth / 2)) {
                RelativeLayout.LayoutParams lp = (RelativeLayout.LayoutParams)floatButtonNtf.getLayoutParams();
                lp.addRule(9, 0);
                lp.addRule(11, -1);
                floatButtonNtf.setLayoutParams((ViewGroup.LayoutParams)lp);
                newX = -buttonSize / 2;
            } else {
                RelativeLayout.LayoutParams lp = (RelativeLayout.LayoutParams)floatButtonNtf.getLayoutParams();
                lp.addRule(9, -1);
                lp.addRule(11, 0);
                floatButtonNtf.setLayoutParams((ViewGroup.LayoutParams)lp);
                newX = 0 + buttonSize / 2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return newX;
    }

    public void fadeOut2(boolean isAnimated) {
        try {
            if (isAnimated) {
                this.animationLayout.animate().setDuration(400L).setInterpolator((TimeInterpolator)new OvershootInterpolator(1.0f)).alpha(0.5f);
            } else {
                this.animationLayout.setAlpha(0.5f);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void fadeIn(boolean isAnimated) {
        try {
            this.idleHandler.removeCallbacksAndMessages(null);
            if (isAnimated) {
                this.animationLayout.animate().setDuration(400L).setInterpolator((TimeInterpolator)new OvershootInterpolator(1.0f)).alpha(1.0f);
            } else {
                this.animationLayout.setAlpha(1.0f);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SuppressLint(value={"NewApi"})
    private void showCountdownTimer(int visibility) {
        try {
            if (this.countdownTimer == null) {
                return;
            }
            if (!this.countdownTimer.isRunning()) {
                if (this.countdownTimer.getVisibility() == 0) {
                    this.countdownTimer.setVisibility(8);
                    this.timerLayout.setVisibility(8);
                }
                return;
            }
            TimerData timerData = FloatButtonTimerHelper.getFloatButtonTimerData((Context)activity);
            if (timerData != null && timerData.getListTimerObject().isEmpty()) {
                return;
            }
            this.countdownTimer.setVisibility(visibility);
            this.timerLayout.setVisibility(visibility);
            if (this.rootView != null) {
                this.rootView.postInvalidateOnAnimation();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void showMenu() {
        try {
            startShowMenu = true;
            int countdownTimerHeight = 0;
            if (this.countdownTimer != null && this.countdownTimer.getVisibility() == 0) {
                countdownTimerHeight = this.countdownTimer.getMeasuredHeight();
            }
            this.showCountdownTimer(4);
            if (!FloatButtonTimerHelper.isRuningTimer()) {
                floatButtonNtf.setVisibility(8);
            }
            this.fadeIn(true);
            int floatY = this.floatArea.getY() - this.relativePositionOnScreen;
            if (floatY < 0) {
                floatY = 0;
            }
            if (floatY > 0) {
                floatY += countdownTimerHeight;
            }
            int x = this.floatArea.getSizeInPixels();
            int y = Math.min(this.boundHeight - this.relativePositionOnScreen - this.floatArea.getSizeInPixels(), floatY);
            if (this.floatMenu == null) {
                this.floatMenu = new MobGameFloatMenuView(activity);
            }
            if (this.floatArea.getX() > this.boundWidth / 2) {
                this.floatMenu.showInReverse(x, y, true);
            } else {
                this.floatMenu.show(x, y, true);
            }
            if (!FloatButtonTimerHelper.isEnableFloatButtonTimer((Context)activity)) {
                return;
            }
            if (this.countdownTimer != null) {
                this.floatMenu.updateCountdownTimer(this.countdownTimer.getRunningTime());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void hideMenu() {
        try {
            startShowMenu = false;
            if (this.floatMenu != null) {
                this.floatMenu.hide();
            }
            this.showCountdownTimer(0);
            if (!FloatButtonTimerHelper.isRuningTimer() && NotificationUtils.hasNtf((Context)activity)) {
                floatButtonNtf.setVisibility(0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setNtf(boolean isHide) {
        try {
            if (!FloatButtonTimerHelper.isRuningTimer() && NotificationUtils.hasNtf((Context)activity) && !isShowingMenu) {
                floatButtonNtf.setVisibility(0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateMenu() {
        try {
            if (this.floatMenu != null) {
                this.floatMenu.updateMenu();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean isInBottomArea(float left, float top) {
        try {
            int dY = (int)((float)this.boundHeight - 150.0f * this.density);
            return top >= (float)dY || this.isInDismissArea(left, top);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean isInDismissArea(float left, float top) {
        try {
            int dX = this.boundWidth / 2;
            int dY = (int)((float)this.boundHeight - 100.0f * this.density);
            double distance = Math.sqrt(Math.pow(left - (float)dX, 2.0) + Math.pow(top - (float)dY, 2.0));
            double maxDistance = Math.min(120.0f * this.density, (float)(this.boundWidth / 5));
            return distance <= maxDistance || top >= (float)dY && (double)left >= (double)dX - maxDistance && (double)left <= (double)dX + maxDistance;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private void showLayoutBottom() {
        try {
            this.layoutBottom.setVisibility(0);
            this.layoutBottom.animate().setDuration(200L).y((float)(this.boundHeight + this.statusBarHeight - this.relativePositionOnScreen) - 125.0f * this.density);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void hideLayoutBottom() {
        try {
            this.layoutBottom.animate().setDuration(200L).y((float)(this.boundHeight + this.statusBarHeight - this.relativePositionOnScreen));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void showConfirmDialog() {
        try {
            this.dialog = new MobGameFloatConfirmDialog(activity, new MobGameFloatConfirmDialog.EventListener(){

                @Override
                public void onConfirmClick(View v) {
                    try {
                        Preference.save((Context)activity, "shared_pref_float_button_show_dialog", MobGameOverlayView.this.isShowDialogAgain);
                        Preference.save((Context)activity, "shared_pref_hide_float_button", true);
                        MobGameOverlayView.this.layoutFloat.setVisibility(8);
                        MobGameOverlayView.this.floatArea.hide();
                        MobGameOverlayView.this.hideMenu();
                        MobGameOverlayView.this.hideConfirmDialog();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }

                @Override
                public void onCancelClick(View v) {
                    try {
                        Preference.save((Context)activity, "shared_pref_hide_float_button", true);
                        MobGameOverlayView.this.layoutFloat.setVisibility(8);
                        MobGameOverlayView.this.floatArea.hide();
                        MobGameOverlayView.this.hideMenu();
                        MobGameOverlayView.this.hideConfirmDialog();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }

                @Override
                public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                    MobGameOverlayView.this.isShowDialogAgain = !isChecked;
                }
            });
            this.dialog.show(activity.getFragmentManager(), "tag_fragment_confirm");
        }
        catch (Exception e) {
            this.hideConfirmDialog();
        }
    }

    public void hideConfirmDialog() {
        try {
            if (this.dialog != null && this.dialog.isAdded()) {
                this.dialog.dismiss();
                this.dialog = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void show(boolean isShowTimer, boolean isMoveToCenterVertical) {
        try {
            this.layoutFloat.setVisibility(0);
            this.layoutBottom.setVisibility(8);
            this.floatArea.show();
            if (isMoveToCenterVertical) {
                this.floatArea.moveTo(0, this.boundHeight / 2);
            }
            this.hideConfirmDialog();
            this.fadeIn(false);
            this.idleHandler.removeCallbacksAndMessages(null);
            this.idleHandler.postDelayed(this.mIdleRunnable, 6000L);
            if (NotificationUtils.hasNtf((Context)activity)) {
                if (isShowTimer || isShowingMenu) {
                    Log.d((String)TAG, (String)"Vao day 1");
                    floatButtonNtf.setVisibility(8);
                    return;
                }
                Log.d((String)TAG, (String)"Vao day 5");
                floatButtonNtf.setVisibility(0);
                this.updateFloatButtonNotf();
                return;
            }
            Log.d((String)TAG, (String)"Vao day 4");
            floatButtonNtf.setVisibility(8);
            Preference.save((Context)activity, "shared_pref_hide_float_button", false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void hide() {
        try {
            this.hideMenu();
            this.layoutFloat.setVisibility(8);
            this.layoutBottom.setVisibility(8);
            this.floatArea.hide();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void viberate() {
        try {
            if (!Preference.getBoolean((Context)activity, "shared_pref_hide_float_button", false)) {
                Log.d((String)TAG, (String)("AAA : " + FloatButtonTimerHelper.isRuningTimer()));
                this.show(FloatButtonTimerHelper.isRuningTimer(), !this.isShowing());
                this.floatMenu.refreshFloatMenu();
            }
            Animation viberate = AnimationUtils.loadAnimation((Context)activity, (int)R.anim.viberate);
            this.floatButton.startAnimation(viberate);
            GameConfigManager.getInstance().setHasUnreadNotifications(false);
            this.animationLayout.setX(0.0f);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isShowing() {
        try {
            return this.layoutFloat.getVisibility() == 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isShowingConfirmDialog() {
        try {
            return this.dialog != null && this.dialog.isVisible();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void dismiss() {
        try {
            this.rootView.setVisibility(8);
            WindowManager windowManager = (WindowManager)activity.getApplicationContext().getSystemService("window");
            windowManager.removeView(this.rootView);
            if (this.floatMenu != null) {
                this.floatMenu.dismiss();
            }
            if (this.floatArea != null) {
                this.floatArea.dismiss();
            }
            this.rootView = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getFloatButtonX() {
        try {
            return this.floatArea.getX();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public int getFloatButtonY() {
        try {
            return this.floatArea.getY();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public void startTimer() {
        block11: {
            Log.d((String)TAG, (String)"startTimer");
            try {
                long now = Calendar.getInstance().getTimeInMillis();
                TimerData timerData = FloatButtonTimerHelper.getFloatButtonTimerData((Context)activity);
                if (timerData == null) break block11;
                this.listTimers = timerData.getListTimerObject();
                Log.i((String)TAG, (String)"Now: ");
                if (this.listTimers.isEmpty()) {
                    Log.d((String)TAG, (String)"Queue timer is empty!");
                    return;
                }
                if (this.countdownTimer != null) {
                    this.countdownTimer.setVisibility(this.countdownTimer.isRunning() ? 0 : 8);
                }
                this.startTime = this.listTimers.get(0).getStartTime();
                this.endTime = this.listTimers.get(0).getEndTime();
                this.id = this.listTimers.get(0).getId();
                Log.i((String)TAG, (String)("start: " + this.startTime + " , end :" + this.endTime + " , " + now));
                for (int i = 0; i < this.listTimers.size(); ++i) {
                    if (this.listTimers.get(i).getStartTime() >= now) continue;
                    this.startTime = this.listTimers.get(i).getStartTime();
                    this.endTime = this.listTimers.get(i).getEndTime();
                    this.id = this.listTimers.get(i).getId();
                    break;
                }
                if (this.endTime < now) {
                    Log.d((String)TAG, (String)("End time < Now, restart timer :endTime " + this.endTime + " , now:" + now));
                    try {
                        TimerObject timerObject = new TimerObject(this.id, this.startTime, this.endTime);
                        timerData.removeData(activity, timerObject, this.listTimers);
                        if (this.listTimers.isEmpty()) {
                            return;
                        }
                        this.startTimer();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return;
                }
                Log.i((String)TAG, (String)("Countdown time: " + this.startTime + " ," + this.endTime));
                if (this.startTime <= now && this.endTime > now) {
                    floatButtonNtf.setVisibility(4);
                    long countDownTime = this.endTime - now;
                    FloatButtonTimerHelper.setisRuningTimer(true);
                    Log.i((String)TAG, (String)("Countdown time: " + countDownTime / 1000L + "s"));
                    int countTime2 = (int)countDownTime / 1000;
                    ValueAnimator anim2 = new ValueAnimator();
                    anim2.setIntValues(new int[]{Color.parseColor((String)"#ee4242"), Color.parseColor((String)"#ad2020")});
                    anim2.setEvaluator((TypeEvaluator)new ArgbEvaluator());
                    anim2.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                        public void onAnimationUpdate(ValueAnimator valueAnimator) {
                            MobGameOverlayView.this.countdownTimer.setBackgroundColor((Integer)valueAnimator.getAnimatedValue());
                        }
                    });
                    anim2.setRepeatCount(countTime2);
                    anim2.setDuration(2000L);
                    anim2.start();
                    this.countdownTimer.setVisibility(0);
                    if (!isShowingMenu) {
                        this.timerLayout.setVisibility(0);
                    }
                    this.countdownTimer.setBase(Calendar.getInstance().getTime().getTime() + countDownTime);
                    this.countdownTimer.setCountdownListener(new CountdownChronometer.CountdownListener(){

                        @Override
                        public void done() {
                            Log.d((String)TAG, (String)"Countdown done!");
                            try {
                                if (MobGameOverlayView.this.countdownTimer != null) {
                                    MobGameOverlayView.this.countdownTimer.setVisibility(8);
                                    MobGameOverlayView.this.timerLayout.setVisibility(8);
                                    FloatButtonTimerHelper.setcanRunTimer(false);
                                    FloatButtonTimerHelper.setisRuningTimer(false);
                                    MobGameOverlayView.this.floatMenu.refreshFloatMenu();
                                    MobGameOverlayView.this.countdownTimer.clearAnimation();
                                    MobGameOverlayView.this.countdownTimer.clearComposingText();
                                    MobGameOverlayView.this.countdownTimer.clearFocus();
                                }
                                if (NotificationUtils.hasNtf((Context)activity)) {
                                    floatButtonNtf.setVisibility(0);
                                }
                                new Handler().postDelayed(new Runnable(){

                                    @Override
                                    public void run() {
                                        MobGameOverlayView.this.startTimer();
                                    }
                                }, 1500L);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
                    this.countdownTimer.start();
                    Log.d((String)TAG, (String)"Start countdown");
                    return;
                }
                Log.d((String)TAG, (String)"Events have not started yet!");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean isStartShowMenu() {
        return startShowMenu;
    }
}

