package com.mobgame.api;

import android.app.Activity;
import android.content.Context;
import android.util.Base64;
import android.util.Log;

import com.mobgame.MobGameSDK;
import com.mobgame.component.GameConfigManager;
import com.mobgame.model.EncodedResponse;
import com.mobgame.model.LoginResponse;
import com.mobgame.model.ZaloResponse;
import com.mobgame.utils.Constants;
import com.mobgame.utils.DeviceUtils;
import com.mobgame.utils.EncryptionUtils;
import com.mobgame.utils.FunTrackingUtil;
import com.mobgame.utils.Preference;
import com.mobgame.utils.Utils;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.IOException;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.util.HashSet;

import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;
import retrofit2.http.Field;
import retrofit2.http.FormUrlEncoded;
import retrofit2.http.GET;
import retrofit2.http.POST;
import retrofit2.http.Query;

class RestfulApi {

	private static final String API_BASE_URL = "https://a.smobgame.com";
	
	private static RestfulApi INSTANCE;
	
	private PlfRestService restService;
	private static Retrofit retrofit;
		
	public static RestfulApi getInstance() {
		if (INSTANCE == null) {
			INSTANCE = new RestfulApi();
		}
		return INSTANCE;
	}
	
	private RestfulApi() {
		OkHttpClient httpClient = getCommonClient();
		
		retrofit = new Retrofit.Builder()
			.baseUrl(API_BASE_URL)
			.addConverterFactory(GsonConverterFactory.create())
			.client(httpClient)
			.build();

		restService = retrofit.create(PlfRestService.class);
	}
	
	static OkHttpClient getCommonClient() {
		
		CookieManager cookieManager = new CookieManager();
		cookieManager.setCookiePolicy(CookiePolicy.ACCEPT_ALL);

		OkHttpClient httpClient = new OkHttpClient.Builder()
			.addInterceptor(new Interceptor() {
			    @Override
			    public okhttp3.Response intercept(Chain chain) throws IOException {

			    	Context context = MobGameSDK.getApplicationContext();
					Activity activity = MobGameSDK.activity;
			    	GameConfigManager config = GameConfigManager.getInstance();

			    	Request.Builder builder = chain.request()
			        		.newBuilder()
			        		.addHeader(Constants.MOBGAME_DEVICE, Utils.stringNormalize(DeviceUtils.getDevice()))
			        		.addHeader(Constants.MOBGAME_OS, Utils.stringNormalize(DeviceUtils.getOSInfo()))
			        		.addHeader(Constants.MOBGAME_RESOLUTION, Utils.stringNormalize(DeviceUtils.getResolution(context)))
			        		.addHeader(Constants.MOBGAME_SDK_VERSION, Utils.stringNormalize(Utils.getSDKVersion(context)))
			        		.addHeader(Constants.MOBGAME_APP_VERSION, Utils.stringNormalize(Utils.getGameVersion(context)))
			        		.addHeader(Constants.MOBGAME_APP_VERSION_CODE, Utils.stringNormalize(Utils.getGameVersionCode(context)))
			        		.addHeader(Constants.MOBGAME_NETWORK, Utils.stringNormalize(Utils.getNetwork(context)))
			        		.addHeader(Constants.MOBGAME_ORIENTATION, Utils.stringNormalize(DeviceUtils.getScreenOrientation(context) + ""))
			        		.addHeader(Constants.MOBGAME_REFERRER, Utils.stringNormalize(Utils.getReferrer(context)))
							.addHeader(Constants.MOBGAME_LANG , Utils.stringNormalize(DeviceUtils.getLanguage()))
							.addHeader(Constants.MOBGAME_ADVERTISING_ID , Utils.stringNormalize(DeviceUtils.getAdvertisingID(context)));

					if(GameConfigManager.getInstance().getAppKey() != null){
						builder.addHeader(Constants.MOBGAME_APPKEY, Utils.stringNormalize(GameConfigManager.getInstance().getAppKey()));
					}

			    	if (config.getAccessToken() != null) {
			    		builder.addHeader(Constants.MOBGAME_TOKEN, Utils.stringNormalize(config.getAccessToken()));
			    	}

			    	if (config.getCharacterInfo().getRoleId() != null) {
			    		builder.addHeader(Constants.MOBGAME_ROLEID, Utils.stringNormalize(config.getCharacterInfo().getRoleId()));
			    	}

			    	if (config.getCharacterInfo().getAreaId() != null) {
			    		builder.addHeader(Constants.MOBGAME_AREAID, Utils.stringNormalize(config.getCharacterInfo().getAreaId()));
			    	}

			    	if (config.getCharacterInfo().getRoleName() != null) {
			    		builder.addHeader(Constants.MOBGAME_ROLENAME, Utils.stringNormalize(config.getCharacterInfo().getRoleName()));
			    	}

					if (config.getCharacterInfo().getAreaName() != null) {
						builder.addHeader(Constants.MOBGAME_AREANAME, Utils.stringNormalize(config.getCharacterInfo().getAreaName()));
					}

					if (FunTrackingUtil.getInstance().getAppsflyerId(context) != null) {
						builder.addHeader(Constants.MOBGAME_APPSFLYER_ID, Utils.stringNormalize(FunTrackingUtil.getInstance().getAppsflyerId(context)));
					}
			    	
			        Request request = builder.build();
			        return chain.proceed(request);
			    }
			})
			.addInterceptor(new Interceptor() {
				@Override
				public Response intercept(Chain chain) throws IOException {
					Context c = MobGameSDK.getApplicationContext();
					Request.Builder builder = chain.request().newBuilder();
					HashSet<String> preferences = (HashSet<String>) Preference
							.getStringSet(c, Constants.SHARED_PREF_COOKIES,
									new HashSet<String>());
					for (String cookie : preferences) {
						builder.addHeader("Cookie", cookie);
					}

					return chain.proceed(builder.build());
				}
			})
			.addInterceptor(new Interceptor() {
				@Override
				public Response intercept(Chain chain) throws IOException {
					Response originalResponse = chain.proceed(chain.request());

					if (!originalResponse.headers("Set-Cookie").isEmpty()) {
						Context c = MobGameSDK.getApplicationContext();
						HashSet<String> cookies = new HashSet<String>();

						for (String header : originalResponse.headers("Set-Cookie")) {
							cookies.add(header);
						}

						Preference.save(c, Constants.SHARED_PREF_COOKIES, cookies);
					}

					return originalResponse;
				}
			})
			.build();
		return httpClient;
	}
	
	static String decode(String responseBody) {
		try {
			JSONObject objEncode = new JSONObject(responseBody);
			if (objEncode.has("data")) {
				String data = objEncode.getString("data");
				byte[] decodeFromBase64 = Base64.decode(data, Base64.DEFAULT);
				return EncryptionUtils.decryptionDataBlowfish(decodeFromBase64);
			}
		} catch (JSONException e) {
			e.printStackTrace();
		}
		return null;
	}

	public Call<ResponseBody> saveEventClient(String data){
		return restService.saveEventClient(data);
	}

	public Call<EncodedResponse> getInfoBeforeAuthen(String sign) {
		return restService.getInfoBeforeAuthen(sign);
	}
	
	public Call<EncodedResponse> getInfoAfterAuthen(String sign) {
		return restService.getInfoAfterAuthen(sign);
	}
	
	public Call<ResponseBody> saveGCM(String regId) {
		Log.d("TAG" , "sendToken/RegId to server VAO DAY");
		return restService.saveGCM(regId);
	}

	public Call<ResponseBody> saveCharacter(String roleId, String areaId, String roleName, String areaName) {
		return restService.saveCharacter(roleId, areaId, roleName, areaName);
	}
	
	public Call<ResponseBody> processGooglePayment(String receipt) {
		return restService.googleRetrieveReceipt(receipt);
	}

	public Call<ResponseBody> processPaypalPayment(String receipt, String areaId, String roleId) {
		return restService.paypalRetrieveReceipt(receipt, areaId, roleId);
	}
	
	public Call<LoginResponse> upgradeToFacebook(String token) {
		return restService.upgradeToFacebook(token, "true");
	}

	private interface PlfRestService {
		@FormUrlEncoded
		@POST("/plf/Oauthv3/saveEventClient.json")
		Call<ResponseBody> saveEventClient(
			@Field("data") String data
		);
		
		@GET("/plf/Oauthv2/getInfoBeforeAuthenv3.json")
		Call<EncodedResponse> getInfoBeforeAuthen(
			@Query("sign") String sign
		);

		@POST("/plf/Oauthv2/getInfoAfterAuthenv3.json")
		Call<EncodedResponse> getInfoAfterAuthen(
			@Query("sign") String sign
		);

		@FormUrlEncoded
		@POST("/plf/Oauthv2/saveFCM.json")
		Call<ResponseBody> saveGCM(
			@Field("regid") String regId
		);

		@FormUrlEncoded
		@POST("/plf/Oauthv2/saveCharacter.json")
		Call<ResponseBody> saveCharacter(
			@Field("roleid") String roleId, 
			@Field("areaid") String areaId,
			@Field("rolename") String roleName,
			@Field("areaname") String areaName
		);

		@FormUrlEncoded
		@POST("/plf/payments/googleRetrieveReceipt.json")
		Call<ResponseBody> googleRetrieveReceipt(
			@Field("transaction_receipt") String receipt
		);

		@FormUrlEncoded
		@POST("/plf/payments/paypalRetrieveReceipt.json")
		Call<ResponseBody> paypalRetrieveReceipt(
			@Field("transaction_receipt") String receipt,
			@Field("game_area_id") String areaId,
			@Field("game_role_id") String roleId
		);
		
		@FormUrlEncoded
		@POST("/plf/users/updateFromFacebookV2")
		Call<LoginResponse> upgradeToFacebook(
			@Field("token") String token,
			@Field("native") String isJson
		);

	}
	
}
