/*
 * Decompiled with CFR 0.152.
 */
package com.mobgame.notification;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.os.Vibrator;
import android.support.v4.content.LocalBroadcastManager;
import android.text.TextUtils;
import android.util.Log;
import com.bumptech.glide.Glide;
import com.google.firebase.messaging.FirebaseMessagingService;
import com.google.firebase.messaging.RemoteMessage;
import com.mobgame.R;
import com.mobgame.component.GameConfigManager;
import com.mobgame.gui.MobGameActivity;
import com.mobgame.model.TimerData;
import com.mobgame.model.TimerObject;
import com.mobgame.utils.FloatButtonTimerHelper;
import com.mobgame.utils.NotificationUtils;
import com.mobgame.utils.Preference;
import com.mobgame.utils.Res;
import com.mobgame.utils.TimeUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class MobFirebaseMessagingService
extends FirebaseMessagingService {
    private static final String TAG = MobFirebaseMessagingService.class.getSimpleName();

    public int getDrawableSmall(Context c) {
        return Res.drawableResource(c, R.drawable.transparent);
    }

    @SuppressLint(value={"MissingPermission"})
    public void onMessageReceived(RemoteMessage remoteMessage) {
        try {
            Context context = this.getApplicationContext();
            Log.i((String)TAG, (String)("onMessage: " + remoteMessage));
            if (remoteMessage.getData().size() <= 0) {
                return;
            }
            Map map = remoteMessage.getData();
            Log.d((String)TAG, (String)("timer ho ho : " + remoteMessage.toString()));
            String title = (String)map.get("title");
            String message = (String)map.get("message");
            String id2 = (String)map.get("id");
            String url = (String)map.get("url");
            String timer = (String)map.get("timer");
            String link = (String)map.get("link");
            if (link != null) {
                Preference.save(context, "deeplink", link);
            } else if (url != null) {
                Preference.save(context, "deeplink", url);
                Preference.save(context, MobGameActivity.KEY_ENABLE_TITLE, false);
            }
            Log.i((String)TAG, (String)("id: " + id2));
            Log.i((String)TAG, (String)("title: " + title));
            Log.i((String)TAG, (String)("message: " + message));
            Log.i((String)TAG, (String)("url: " + url));
            Log.i((String)TAG, (String)("timer  kk: " + timer));
            if (url != null) {
                Glide.with((Context)context.getApplicationContext()).load((Object)url).downloadOnly(512, 256);
            }
            Intent intent = new Intent("com.mobgame.broadcast");
            intent.putExtra("category", "gcm");
            intent.putExtra("id", id2);
            intent.putExtra("title", title);
            intent.putExtra("mesage", message);
            if (timer != null || timer == "") {
                Log.d((String)TAG, (String)"VAO DAY");
                this.parseTimerData(context, timer, intent);
            }
            LocalBroadcastManager.getInstance((Context)context).sendBroadcast(intent);
            GameConfigManager.getInstance().setHasUnreadNotifications(true);
            if (!TextUtils.isEmpty((CharSequence)id2)) {
                NotificationUtils.addNtf(context, Integer.parseInt(id2));
            }
            if (!TextUtils.isEmpty((CharSequence)title) || !TextUtils.isEmpty((CharSequence)message)) {
                if (url != null) {
                    NotificationUtils.getInstance(context).setMainClass(null).setMessage(message).setTitle(title).setImageUrl(url).setLink(link).setId(id2).setSmallIcon(this.getDrawableSmall(context)).showNotificationWithImage();
                } else {
                    NotificationUtils.getInstance(context).setMainClass(null).setMessage(message).setTitle(title).setLink(link).setId(id2).setSmallIcon(this.getDrawableSmall(context)).showNotification();
                }
                Vibrator v = (Vibrator)context.getSystemService("vibrator");
                if (v != null) {
                    v.vibrate(30L);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void parseTimerData(Context context, String timer, Intent intent) {
        if (!TextUtils.isEmpty((CharSequence)timer)) {
            try {
                Log.d((String)TAG, (String)("Timer : " + timer));
                JSONArray timerArray = new JSONArray(timer);
                for (int i = 0; i < timerArray.length(); ++i) {
                    JSONObject timerJsonObj = timerArray.getJSONObject(i);
                    long startTime = TimeUtils.getMilisecondByTimestamp(timerJsonObj.optLong("start"));
                    long endTime = TimeUtils.getMilisecondByTimestamp(timerJsonObj.optLong("end"));
                    int id2 = timerJsonObj.getInt("id");
                    long now = Calendar.getInstance().getTimeInMillis();
                    TimerData timerData = FloatButtonTimerHelper.getFloatButtonTimerData(context);
                    if (timerData == null) {
                        Log.d((String)TAG, (String)"vao null");
                        ArrayList<TimerObject> listTimerObject = new ArrayList<TimerObject>();
                        TimerObject timerObject = new TimerObject();
                        timerObject.setId(id2);
                        timerObject.setStartTime(startTime);
                        timerObject.setEndTime(endTime);
                        listTimerObject.add(timerObject);
                        timerData = new TimerData();
                        timerData.setListTimerObject(listTimerObject);
                        timerData.saveData(context, timerData);
                        if (startTime <= now && now < endTime) {
                            FloatButtonTimerHelper.setcanRunTimer(true);
                            FloatButtonTimerHelper.setisRuningTimer(true);
                        }
                    } else {
                        Log.d((String)TAG, (String)"Vao khong null");
                        ArrayList<Object> listTimer = new ArrayList();
                        listTimer = timerData.getListTimerObject();
                        TimerObject timerObj = new TimerObject();
                        timerObj.setId(id2);
                        timerObj.setStartTime(startTime);
                        timerObj.setEndTime(endTime);
                        listTimer.add(timerObj);
                        timerData.setListTimerObject(listTimer);
                        timerData.saveData(context, timerData);
                        if (FloatButtonTimerHelper.isRuningTimer()) {
                            FloatButtonTimerHelper.setcanRunTimer(false);
                        } else if (startTime <= now && now < endTime) {
                            FloatButtonTimerHelper.setcanRunTimer(true);
                            FloatButtonTimerHelper.setisRuningTimer(true);
                        } else {
                            FloatButtonTimerHelper.setcanRunTimer(false);
                        }
                    }
                    intent.putExtra("show-timer", true);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

