package com.mobgame.notification;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.os.Vibrator;
import android.support.v4.content.LocalBroadcastManager;
import android.text.TextUtils;
import android.util.Log;

import com.bumptech.glide.Glide;
import com.google.firebase.messaging.FirebaseMessagingService;
import com.google.firebase.messaging.RemoteMessage;
import com.mobgame.R;
import com.mobgame.component.GameConfigManager;
import com.mobgame.gui.MobGameActivity;
import com.mobgame.model.TimerData;
import com.mobgame.model.TimerObject;
import com.mobgame.utils.Constants;
import com.mobgame.utils.FloatButtonTimerHelper;
import com.mobgame.utils.NotificationUtils;
import com.mobgame.utils.Preference;
import com.mobgame.utils.Res;
import com.mobgame.utils.TimeUtils;

import org.json.JSONArray;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Map;

/**
 * Created by khaitran on 3/7/18.
 */

public class MobFirebaseMessagingService extends FirebaseMessagingService {
    private static final String TAG = MobFirebaseMessagingService.class
            .getSimpleName();
    public MobFirebaseMessagingService() {
    }

    public int getDrawableSmall(Context c) {
        return Res.drawableResource(c, R.drawable.transparent);
    }

    @SuppressLint("MissingPermission")
    @Override
    public void onMessageReceived(RemoteMessage remoteMessage) {
        try {
            Context context = getApplicationContext();
            Log.i(TAG, "onMessage: " + remoteMessage);
            if (remoteMessage.getData().size() <= 0) return; // Vibrate for 30 ms
            Map<String, String> map = remoteMessage.getData();
            Log.d(TAG , "timer ho ho : " + remoteMessage.toString());
            String title = map.get("title");
            String message = map.get("message");
            String id = map.get("id");
            String url = map.get("url");
            String timer = map.get("timer");
            String link = map.get("link");


            if (link != null) {
                Preference.save(context, Constants.DEEPLINK, link);
            } else if (url != null) {
                Preference.save(context, Constants.DEEPLINK, url);
                Preference.save(context, MobGameActivity.KEY_ENABLE_TITLE, false);
            }

            Log.i(TAG, "id: " + id);
            Log.i(TAG, "title: " + title);
            Log.i(TAG, "message: " + message);
            Log.i(TAG, "url: " + url);
            Log.i(TAG, "timer  kk: " + timer);

            //hiendv: load url image to cache first
            if (url != null) {
                Glide.with(context.getApplicationContext())
                        .load(url)
                        .downloadOnly(512, 256);
            }

            // Send broadcast
            Intent intent = new Intent(Constants.INTENT_FILTER);
            intent.putExtra("category", "gcm");
            intent.putExtra("id", id);
            intent.putExtra("title", title);
            intent.putExtra("mesage", message);
            if(timer != null || timer == ""){
                Log.d(TAG, "VAO DAY");

                parseTimerData(context, timer, intent);
            }

            LocalBroadcastManager.getInstance(context).sendBroadcast(intent);

            GameConfigManager.getInstance().setHasUnreadNotifications(true);
            if (!TextUtils.isEmpty(id)) {
                NotificationUtils.addNtf(context, Integer.parseInt(id));
            }
            if (!TextUtils.isEmpty(title)
                    || !TextUtils.isEmpty(message)) {
                if (url != null) {
                    NotificationUtils.getInstance(context)
                            .setMainClass(null)
                            .setMessage(message)
                            .setTitle(title)
                            .setImageUrl(url)
                            .setLink(link)
                            .setId(id)
                            .setSmallIcon(getDrawableSmall(context))
                            .showNotificationWithImage();
                } else {
                    NotificationUtils.getInstance(context)
                            .setMainClass(null)
                            .setMessage(message)
                            .setTitle(title)
                            .setLink(link)
                            .setId(id)
                            .setSmallIcon(getDrawableSmall(context))
                            .showNotification();
                }
                Vibrator v = (Vibrator) context
                        .getSystemService(Context.VIBRATOR_SERVICE);
                if (v != null)
                    v.vibrate(30);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void parseTimerData(Context context, String timer, Intent intent) {
        if (!TextUtils.isEmpty(timer)) {
            try {
                Log.d(TAG, "Timer : " +  timer);
                JSONArray timerArray = new JSONArray(timer);
                for(int i = 0 ; i < timerArray.length() ; i++){
                    JSONObject timerJsonObj = timerArray.getJSONObject(i);
                    long startTime = TimeUtils.getMilisecondByTimestamp(timerJsonObj.optLong("start"));
                    long endTime = TimeUtils.getMilisecondByTimestamp(timerJsonObj.optLong("end"));
                    int id = timerJsonObj.getInt("id");
                    final long now = Calendar.getInstance().getTimeInMillis();
                    TimerData timerData = FloatButtonTimerHelper
                            .getFloatButtonTimerData(context);//chua object arrayList timer
                    if(timerData == null){
                        Log.d(TAG, "vao null");
                        ArrayList<TimerObject> listTimerObject = new ArrayList<>();
                        TimerObject timerObject = new TimerObject();
                        timerObject.setId(id);
                        timerObject.setStartTime(startTime);
                        timerObject.setEndTime(endTime);

                        listTimerObject.add(timerObject);
                        timerData = new TimerData();
                        timerData.setListTimerObject(listTimerObject);
                        timerData.saveData(context, timerData);
                        if(startTime <= now && now < endTime){
                            FloatButtonTimerHelper.setcanRunTimer(true);
                            FloatButtonTimerHelper.setisRuningTimer(true);
                        }
                    }else{
                        Log.d(TAG, "Vao khong null");
                        ArrayList<TimerObject> listTimer = new ArrayList<>();
                        listTimer  = timerData.getListTimerObject();

                        TimerObject timerObj = new TimerObject();
                        timerObj.setId(id);
                        timerObj.setStartTime(startTime);
                        timerObj.setEndTime(endTime);

                        listTimer.add(timerObj);
                        timerData.setListTimerObject(listTimer);
                        timerData.saveData(context, timerData);

                        if(FloatButtonTimerHelper.isRuningTimer() == true){
                            FloatButtonTimerHelper.setcanRunTimer(false);
                        }else{
                            if(startTime <= now && now < endTime){
                                FloatButtonTimerHelper.setcanRunTimer(true);
                                FloatButtonTimerHelper.setisRuningTimer(true);
                            }else{
                                FloatButtonTimerHelper.setcanRunTimer(false);
                            }
                        }
                    }
                    intent.putExtra("show-timer", true);
                }


            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}
