package com.mobgame.notification;

/**
 * Created by khaitran on 3/7/18.
 */
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;

import com.appsflyer.AppsFlyerLib;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.FirebaseInstanceIdService;
import com.mobgame.api.RegisterTokenAndTask;


public class MobFirebaseInstanceIDService extends FirebaseInstanceIdService {
    private String TAG = "MobFirebaseInstanceIDService";
    private static MobFirebaseInstanceIDService INSTANCE;

    public static MobFirebaseInstanceIDService getInstance(){
        if(INSTANCE == null) INSTANCE = new MobFirebaseInstanceIDService();
        return INSTANCE;
    }
    @Override
    public void onTokenRefresh() {
        // Get updated InstanceID token.
        String refreshedToken = FirebaseInstanceId.getInstance().getToken();
        Log.d(TAG, "Refreshed token: " + refreshedToken);

        // If you want to send messages to this application instance or
        // manage this apps subscriptions on the server side, send the
        // Instance ID token to your app server.
        sendRegistrationToServer(getApplicationContext() , refreshedToken);
    }

    public void sendRegistrationToServer(Context context , String refreshedToken) {
        Log.d(TAG, "sendToken/RegId to server: " + refreshedToken);
        if (!TextUtils.isEmpty(refreshedToken)) {
            (new RegisterTokenAndTask(refreshedToken)).execute();
        }
        AppsFlyerLib.getInstance().updateServerUninstallToken(getApplicationContext(), refreshedToken);
    }

}
