/*
 * Decompiled with CFR 0.152.
 */
package com.mobgame.utils;

import android.app.Application;
import android.content.Context;
import android.util.Log;
import com.appsflyer.AppsFlyerConversionListener;
import com.appsflyer.AppsFlyerLib;
import com.mobgame.MobGameSDK;
import com.mobgame.component.EventClientManager;
import com.mobgame.component.GameConfigManager;
import com.mobgame.utils.Preference;
import com.mobgame.utils.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class FunAppsFlyerUtil {
    private static FunAppsFlyerUtil instance;
    private String appsflyerDevkey = "cfgYFoj97okaEbzqp8q5w5";
    private String gcmSenderId = "461098885975";
    private String TAG = "FunAppsFlyerUtil";
    private Map<String, Object> conversionDataLoaded;
    private ArrayList<String> listTrackEventQueue = new ArrayList();
    private boolean initted;
    public static final String STR_EVENT_LAUNCHER = "app_launcher";
    private static final String TRACK_FIRST_LAUNCH = "ft_first_launch";
    private static final String TRACK_DOWNLOAD_RES_STARTED = "ft_res_dl_started";
    private static final String TRACK_DOWNLOAD_RES_FAILED = "ft_res_dl_failed";
    private static final String TRACK_DOWNLOAD_RES_FINISHED = "ft_res_dl_completed";
    private static final String TRACK_CHARACTOR_CREATED = "ft_character_created";
    private static final String TRACK_START_TUTORIAL = "af_tutorial_started";
    private static final String TRACK_FINISH_TUTORIAL = "af_tutorial_completed";
    private static final String TRACK_REACH_A_LEVEL = "af_level_achieved";
    private static final String TRACK_LEVEL_PLATFORM = "ft_level_platform";
    public static final String TRACK_LOGIN_CLICKED = "ft_login_clicked";
    public static final String TRACK_LOGIN_CLOSED = "ft_login_closed";
    public static final String TRACK_LOGIN_SUCCESS = "ft_login_success";
    public static final String TRACK_PAYMENT_OPEN = "ft_payment_opened";
    public static final String TRACK_PAYMENT_CLOSE = "ft_payment_closed";
    public static final String TRACK_EVENT_LOGOUT = "ft_logout";

    private FunAppsFlyerUtil() {
    }

    public static synchronized FunAppsFlyerUtil getInstance() {
        if (instance == null) {
            instance = new FunAppsFlyerUtil();
        }
        return instance;
    }

    public void init(final Application context) {
        try {
            Log.i((String)this.TAG, (String)"initAppsFlyer");
            AppsFlyerLib.getInstance().enableUninstallTracking(this.gcmSenderId);
            MobGameSDK.applicationContext = context;
            AppsFlyerLib.getInstance().setDebugLog(true);
            AppsFlyerConversionListener conversionDataListener = new AppsFlyerConversionListener(){

                public void onInstallConversionDataLoaded(Map<String, String> conversionData) {
                    try {
                        FunAppsFlyerUtil.this.initted = true;
                        HashMap<String, Object> map = new HashMap<String, Object>(conversionData);
                        FunAppsFlyerUtil.this.conversionDataLoaded = map;
                        FunAppsFlyerUtil.this.trackEvent((Context)context, FunAppsFlyerUtil.STR_EVENT_LAUNCHER, map);
                        for (String attrName : conversionData.keySet()) {
                            Log.d((String)FunAppsFlyerUtil.this.TAG, (String)("onInstallConversionDataLoaded attribute: " + attrName + " = " + conversionData.get(attrName)));
                            if (!attrName.equals("is_first_launch") || !conversionData.get(attrName).equals("true")) continue;
                            FunAppsFlyerUtil.this.trackEvent((Context)context, FunAppsFlyerUtil.TRACK_FIRST_LAUNCH, map);
                        }
                        if (FunAppsFlyerUtil.this.listTrackEventQueue != null) {
                            map.put("Resend", "when inited");
                            for (String eventName : FunAppsFlyerUtil.this.listTrackEventQueue) {
                                FunAppsFlyerUtil.this.trackEvent((Context)context, eventName, map);
                            }
                            FunAppsFlyerUtil.this.listTrackEventQueue.clear();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }

                public void onInstallConversionFailure(String errorMessage) {
                    FunAppsFlyerUtil.this.initted = false;
                    Log.d((String)FunAppsFlyerUtil.this.TAG, (String)(" onInstallConversionFailure error getting conversion data: " + errorMessage));
                }

                public void onAppOpenAttribution(Map<String, String> conversionData) {
                    for (String attrName : conversionData.keySet()) {
                        Log.d((String)FunAppsFlyerUtil.this.TAG, (String)("onAppOpenAttribution attribute: " + attrName + " = " + conversionData.get(attrName)));
                    }
                }

                public void onAttributionFailure(String errorMessage) {
                    Log.d((String)FunAppsFlyerUtil.this.TAG, (String)(" onAttributionFailure error onAttributionFailure : " + errorMessage));
                }
            };
            AppsFlyerLib.getInstance().init(this.appsflyerDevkey, conversionDataListener, (Context)context);
            AppsFlyerLib.getInstance().startTracking(context);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    if (MobGameSDK.getInstance().isLoggedIn()) {
                        EventClientManager.getInstance((Context)context).saveEventClient("start", FunAppsFlyerUtil.STR_EVENT_LAUNCHER, null);
                    } else {
                        EventClientManager.getInstance((Context)context).saveEventClient("normal", FunAppsFlyerUtil.STR_EVENT_LAUNCHER, null);
                    }
                }
            }).start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackEvent(Context context, String eventName, Map<String, Object> eventValues) {
        try {
            if (this.initted) {
                HashMap<String, Object> map = new HashMap<String, Object>(this.conversionDataLoaded);
                if (eventValues != null) {
                    map.putAll(eventValues);
                }
                AppsFlyerLib.getInstance().trackEvent(context, eventName, map);
                Log.d((String)this.TAG, (String)("trackEvent: " + eventName + " eventValue: " + map));
                if (Preference.getBoolean(context, eventName, true)) {
                    AppsFlyerLib.getInstance().trackEvent(context, eventName + "_first", map);
                    Preference.save(context, eventName, false);
                }
            } else {
                Log.d((String)this.TAG, (String)("trackEvent " + eventName + " fail cause of AppsflyerLib is not inited successful"));
                this.listTrackEventQueue.add(eventName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackDownloadResourceStarted(Context context) {
        try {
            String gameVersionName = Utils.getGameVersion(context);
            String gameVersionCode = Utils.getGameVersionCode(context);
            String versionsave = Preference.getString(context, "GAME_VERSION");
            if (!versionsave.equals(gameVersionCode)) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("version name", gameVersionName);
                map.put("version code", gameVersionCode);
                this.trackEvent(context, TRACK_DOWNLOAD_RES_STARTED, map);
            } else {
                Log.d((String)this.TAG, (String)"trackDownloadResourceStarted dont call because it is same version");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackDownloadResourceFinished(Context context) {
        String gameVersionName = Utils.getGameVersion(context);
        String gameVersionCode = Utils.getGameVersionCode(context);
        String versionsave = Preference.getString(context, "GAME_VERSION");
        if (!versionsave.equals(gameVersionCode)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("version name", gameVersionName);
            map.put("version code", gameVersionCode);
            this.trackEvent(context, TRACK_DOWNLOAD_RES_FINISHED, map);
        } else {
            Log.d((String)this.TAG, (String)"trackDownloadResourceFinished dont call because it is same version");
        }
        Preference.save(context, "GAME_VERSION", gameVersionCode);
    }

    public void trackDownloadResourceFailed(Context context) {
        String gameVersionName = Utils.getGameVersion(context);
        String gameVersionCode = Utils.getGameVersionCode(context);
        String versionsave = Preference.getString(context, "GAME_VERSION");
        if (!versionsave.equals(gameVersionCode)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("version name", gameVersionName);
            map.put("version code", gameVersionCode);
            this.trackEvent(context, TRACK_DOWNLOAD_RES_FAILED, map);
        } else {
            Log.d((String)this.TAG, (String)"trackDownloadResourceFailed dont call because it is same version");
        }
    }

    public void trackStartTutorial(Context context) {
        this.trackEvent(context, TRACK_START_TUTORIAL, null);
    }

    public void trackFinishTutorial(Context context) {
        this.trackEvent(context, TRACK_FINISH_TUTORIAL, null);
    }

    public void trackCreateCharactor(Context context, String roleID, String areaID) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("roleID", roleID);
            map.put("serverID", areaID);
            this.trackEvent(context, TRACK_CHARACTOR_CREATED, map);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackReachALevel(Context context, String roleID, String areaID, String level) {
        Log.d((String)this.TAG, (String)"trackReachALevel: ");
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("roleID", roleID);
            map.put("serverID", areaID);
            map.put("level", level);
            this.trackEvent(context, TRACK_REACH_A_LEVEL, map);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String levelTracking = null;
        try {
            if (GameConfigManager.getInstance() != null && GameConfigManager.getInstance().getGameConfig() != null && GameConfigManager.getInstance().getGameConfig().getLevel() != null) {
                levelTracking = GameConfigManager.getInstance().getGameConfig().getLevel();
            }
            Log.d((String)this.TAG, (String)("trackLevelPlatform: " + levelTracking));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (levelTracking != null) {
            String[] arrLevel;
            for (String anLevel : arrLevel = levelTracking.split(",")) {
                try {
                    if (Preference.getBoolean(context, TRACK_LEVEL_PLATFORM + anLevel, false) || Integer.parseInt(level) < Integer.parseInt(anLevel)) continue;
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("LEVEL", anLevel + "");
                    this.trackEvent(context, TRACK_LEVEL_PLATFORM, map);
                    map.clear();
                    Preference.save(context, TRACK_LEVEL_PLATFORM + anLevel, true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public String getAppsflyerDevkey() {
        return this.appsflyerDevkey;
    }

    public void setAppsflyerDevkey(String appsflyerDevkey) {
        this.appsflyerDevkey = appsflyerDevkey;
    }

    public String getGcmSenderId() {
        return this.gcmSenderId;
    }

    public void setGcmSenderId(String gcmSenderId) {
        this.gcmSenderId = gcmSenderId;
    }
}

